/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePlaceholderType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieTypeConstructor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class BoogieType
implements IBoogieType {
    private static final long serialVersionUID = -1366978000551630241L;
    private static final BoogieType[] EMPTY = new BoogieType[0];
    private static final ArrayList<BoogiePlaceholderType> PLACEHOLDER_TYPES = new ArrayList();
    private static final ArrayList<BoogiePrimitiveType> BITVECTOR_TYPES = new ArrayList();
    private static final UnifyHash<BoogieType> GLOBAL_TYPES = new UnifyHash();
    public static final BoogiePrimitiveType TYPE_INT = new BoogiePrimitiveType(-2);
    public static final BoogiePrimitiveType TYPE_REAL = new BoogiePrimitiveType(-3);
    public static final BoogiePrimitiveType TYPE_BOOL = new BoogiePrimitiveType(-1);
    public static final BoogiePrimitiveType TYPE_ERROR = new BoogiePrimitiveType(-42);

    public static BoogieType createBitvectorType(int n) {
        int n2 = BITVECTOR_TYPES.size();
        while (n2 <= n) {
            BITVECTOR_TYPES.add(new BoogiePrimitiveType(n2));
            ++n2;
        }
        return BITVECTOR_TYPES.get(n);
    }

    public static BoogieType createPlaceholderType(int n) {
        int n2 = PLACEHOLDER_TYPES.size();
        while (n2 <= n) {
            PLACEHOLDER_TYPES.add(new BoogiePlaceholderType(n2));
            ++n2;
        }
        return PLACEHOLDER_TYPES.get(n);
    }

    public static BoogieConstructedType createConstructedType(BoogieTypeConstructor boogieTypeConstructor, BoogieType ... boogieTypeArray) {
        BoogieType boogieType2;
        assert (boogieTypeConstructor.getParamCount() == boogieTypeArray.length);
        int n = boogieTypeConstructor.hashCode();
        BoogieType[] boogieTypeArray2 = boogieTypeArray;
        int n2 = boogieTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            boogieType2 = boogieTypeArray2[n3];
            n = n * 31 + boogieType2.hashCode();
            ++n3;
        }
        block1: for (BoogieType boogieType2 : GLOBAL_TYPES.iterateHashCode(n)) {
            BoogieConstructedType boogieConstructedType;
            if (!(boogieType2 instanceof BoogieConstructedType) || !(boogieConstructedType = (BoogieConstructedType)boogieType2).getConstr().equals(boogieTypeConstructor)) continue;
            int n4 = 0;
            while (n4 != boogieTypeArray.length) {
                if (!boogieTypeArray[n4].equals(boogieConstructedType.getParameter(n4))) continue block1;
                ++n4;
            }
            return boogieConstructedType;
        }
        boogieType2 = new BoogieConstructedType(boogieTypeConstructor, boogieTypeArray);
        GLOBAL_TYPES.put(n, (Object)boogieType2);
        return boogieType2;
    }

    public static BoogieConstructedType createConstructedType(BoogieTypeConstructor boogieTypeConstructor) {
        return BoogieType.createConstructedType(boogieTypeConstructor, EMPTY);
    }

    public static BoogieArrayType createArrayType(int n, BoogieType[] boogieTypeArray, BoogieType boogieType) {
        BoogieType boogieType22;
        int n2 = n;
        BoogieType[] boogieTypeArray2 = boogieTypeArray;
        int n3 = boogieTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            boogieType22 = boogieTypeArray2[n4];
            n2 = n2 * 31 + boogieType22.hashCode();
            ++n4;
        }
        n2 = n2 * 31 + boogieType.hashCode();
        block1: for (BoogieType boogieType22 : GLOBAL_TYPES.iterateHashCode(n2)) {
            BoogieArrayType boogieArrayType;
            if (!(boogieType22 instanceof BoogieArrayType) || (boogieArrayType = (BoogieArrayType)boogieType22).getNumPlaceholders() != n || boogieArrayType.getIndexCount() != boogieTypeArray.length || !boogieArrayType.getValueType().equals(boogieType)) continue;
            int n5 = 0;
            while (n5 != boogieTypeArray.length) {
                if (!boogieTypeArray[n5].equals(boogieArrayType.getIndexType(n5))) continue block1;
                ++n5;
            }
            return boogieArrayType;
        }
        boogieType22 = new BoogieArrayType(n, boogieTypeArray, boogieType);
        GLOBAL_TYPES.put(n2, (Object)boogieType22);
        return boogieType22;
    }

    public static BoogieStructType createStructType(String[] stringArray, BoogieType[] boogieTypeArray) {
        assert (stringArray.length == boogieTypeArray.length);
        int n = 1031;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = n * 31 + boogieTypeArray[n2].hashCode();
            n = n * 31 + stringArray[n2].hashCode();
            ++n2;
        }
        block1: for (BoogieType boogieType : GLOBAL_TYPES.iterateHashCode(n)) {
            BoogieStructType boogieStructType;
            if (!(boogieType instanceof BoogieStructType) || (boogieStructType = (BoogieStructType)boogieType).getFieldCount() != stringArray.length) continue;
            if (!Arrays.equals(stringArray, boogieStructType.getFieldIds())) break;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!boogieTypeArray[n3].equals(boogieStructType.getFieldType(stringArray[n3]))) break block1;
                ++n3;
            }
            return boogieStructType;
        }
        BoogieStructType boogieStructType = new BoogieStructType(stringArray, boogieTypeArray);
        GLOBAL_TYPES.put(n, (Object)boogieStructType);
        return boogieStructType;
    }

    protected abstract BoogieType substitutePlaceholders(int var1, BoogieType[] var2);

    protected abstract BoogieType incrementPlaceholders(int var1, int var2);

    public BoogieType substitutePlaceholders(BoogieType[] boogieTypeArray) {
        return this.substitutePlaceholders(0, boogieTypeArray);
    }

    public abstract BoogieType getUnderlyingType();

    public final boolean equals(Object object) {
        return object instanceof BoogieType && this.getUnderlyingType() == ((BoogieType)object).getUnderlyingType();
    }

    public final int hashCode() {
        BoogieType boogieType = this.getUnderlyingType();
        if (boogieType == this) {
            return super.hashCode();
        }
        return Objects.hashCode(boogieType);
    }

    protected abstract boolean unify(int var1, BoogieType var2, BoogieType[] var3);

    public boolean unify(BoogieType boogieType, BoogieType[] boogieTypeArray) {
        return this.getUnderlyingType().unify(0, boogieType.getUnderlyingType(), boogieTypeArray);
    }

    protected abstract boolean hasPlaceholder(int var1, int var2);

    protected abstract boolean isUnifiableTo(int var1, BoogieType var2, ArrayList<BoogieType> var3);

    public boolean isUnifiableTo(BoogieType boogieType) {
        BoogieType boogieType2 = this.getUnderlyingType();
        BoogieType boogieType3 = boogieType.getUnderlyingType();
        return boogieType2.isUnifiableTo(0, boogieType3, new ArrayList<BoogieType>());
    }

    protected abstract String toString(int var1, boolean var2);

    protected abstract ASTType toASTType(ILocation var1, int var2);

    public String toString() {
        return this.toString(0, false);
    }

    public ASTType toASTType(ILocation iLocation) {
        return this.toASTType(iLocation, 0);
    }

    public abstract boolean isFinite();
}

