/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.HashSet;

public final class Simplifier
extends BaseBlockEncoder<IcfgLocation> {
    private final IcfgEdgeBuilder mEdgeBuilder;

    public Simplifier(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mEdgeBuilder = icfgEdgeBuilder;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        this.mLogger.info((Object)"Simplifying codeblocks");
        ArrayDeque arrayDeque = new ArrayDeque();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        basicIcfg.getProcedureEntryNodes().values().stream().forEach(icfgLocation -> {
            boolean bl = arrayDeque.addAll(icfgLocation.getOutgoingEdges());
        });
        while (!arrayDeque.isEmpty()) {
            IcfgEdge icfgEdge = (IcfgEdge)arrayDeque.removeFirst();
            if (!hashSet.add(icfgEdge) || icfgEdge instanceof IIcfgCallTransition || icfgEdge instanceof IIcfgReturnTransition) continue;
            arrayDeque.addAll(((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges());
            IcfgEdge icfgEdge2 = this.mEdgeBuilder.constructSimplifiedSequentialComposition((IcfgLocation)icfgEdge.getSource(), (IcfgLocation)icfgEdge.getTarget(), icfgEdge);
            this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge2, (IIcfgTransition<?>)icfgEdge);
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
        }
        return basicIcfg;
    }

    @Override
    public boolean isGraphStructureChanged() {
        return false;
    }
}

