/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeTracker;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class HoareTripleCheckerStatisticsGenerator
implements IStatisticsDataProvider {
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSDtfsCounter;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSDsluCounter;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSDsCounter;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSdLazyCounter;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSolverCounterSat;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSolverCounterUnsat;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSolverCounterUnknown;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mSolverCounterNotChecked;
    @ReflectionUtil.Reflected(prettyName="Time")
    @StatisticsAggregator.Statistics(type=KeyType.TT_TIMER)
    private final TimeTracker mTimer;
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mProtectedPredicate = new InCaReCounter();
    @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
    private final InCaReCounter mProtectedAction = new InCaReCounter();
    private boolean mRunning = false;
    private final Map<String, Supplier<Object>> mStats;

    public HoareTripleCheckerStatisticsGenerator() {
        this.mSDtfsCounter = new InCaReCounter();
        this.mSDsluCounter = new InCaReCounter();
        this.mSDsCounter = new InCaReCounter();
        this.mSdLazyCounter = new InCaReCounter();
        this.mSolverCounterSat = new InCaReCounter();
        this.mSolverCounterUnsat = new InCaReCounter();
        this.mSolverCounterUnknown = new InCaReCounter();
        this.mSolverCounterNotChecked = new InCaReCounter();
        this.mTimer = new TimeTracker();
        this.mStats = new LinkedHashMap<String, Supplier<Object>>();
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.ProAct.name(), this::getProtectedActionCounter);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.ProPred.name(), this::getProtectedPredicateCounter);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SDtfs.name(), this::getSDtfsCounter);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SDslu.name(), this::getSDsluCounter);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SDs.name(), this::getSDsCounter);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SdLazy.name(), this::getSdLazyCounter);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverSat.name(), this::getSolverCounterSat);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverUnsat.name(), this::getSolverCounterUnsat);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverUnknown.name(), this::getSolverCounterUnknown);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverNotchecked.name(), this::getSolverCounterNotChecked);
        this.mStats.put(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.Time.name(), this::getEdgeCheckerTime);
    }

    public InCaReCounter getProtectedPredicateCounter() {
        return this.mProtectedPredicate;
    }

    public InCaReCounter getProtectedActionCounter() {
        return this.mProtectedAction;
    }

    public InCaReCounter getSDtfsCounter() {
        return this.mSDtfsCounter;
    }

    public InCaReCounter getSDsluCounter() {
        return this.mSDsluCounter;
    }

    public InCaReCounter getSDsCounter() {
        return this.mSDsCounter;
    }

    public InCaReCounter getSdLazyCounter() {
        return this.mSdLazyCounter;
    }

    public InCaReCounter getSolverCounter(IncrementalPlicationChecker.Validity validity) {
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.INVALID -> this.getSolverCounterSat();
            case IncrementalPlicationChecker.Validity.UNKNOWN -> this.getSolverCounterUnknown();
            case IncrementalPlicationChecker.Validity.VALID -> this.getSolverCounterUnsat();
            case IncrementalPlicationChecker.Validity.NOT_CHECKED -> throw new AssertionError((Object)("unexpected result: " + String.valueOf(validity)));
            default -> throw new MatchException(null, null);
        };
    }

    public InCaReCounter getSolverCounterSat() {
        return this.mSolverCounterSat;
    }

    public InCaReCounter getSolverCounterUnsat() {
        return this.mSolverCounterUnsat;
    }

    public InCaReCounter getSolverCounterUnknown() {
        return this.mSolverCounterUnknown;
    }

    public InCaReCounter getSolverCounterNotChecked() {
        return this.mSolverCounterNotChecked;
    }

    public long getEdgeCheckerTime() {
        return this.mTimer.elapsedTime(TimeUnit.NANOSECONDS);
    }

    public void continueEdgeCheckerTime() {
        assert (!this.mRunning) : "Timing already running";
        this.mRunning = true;
        this.mTimer.start();
    }

    public void stopEdgeCheckerTime() {
        assert (this.mRunning) : "Timing not running";
        this.mRunning = false;
        this.mTimer.stop();
    }

    public Collection<String> getKeys() {
        return HoareTripleCheckerStatisticsType.getInstance().getKeys();
    }

    public Object getValue(String string) {
        Supplier<Object> supplier = this.mStats.get(string);
        if (supplier == null) {
            throw new AssertionError((Object)"unknown key");
        }
        return supplier.get();
    }

    public IStatisticsType getBenchmarkType() {
        return HoareTripleCheckerStatisticsType.getInstance();
    }

    public String toString() {
        return this.getBenchmarkType().prettyprintBenchmarkData((IStatisticsDataProvider)this);
    }
}

