/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.type.StructExpanderUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;

public final class ConstantArrayUtil {
    private ConstantArrayUtil() {
    }

    public static Expression getConstantArray(FunctionDeclarations functionDeclarations, ILocation iLocation, BoogieArrayType boogieArrayType, Expression expression) {
        assert (boogieArrayType.getValueType().equals((Object)expression.getType())) : "constant array of type " + String.valueOf(boogieArrayType) + " cannot have constant value " + String.valueOf(expression);
        FunctionDeclaration functionDeclaration = ConstantArrayUtil.getOrDeclareConstantArrayFunction(functionDeclarations, boogieArrayType);
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)functionDeclaration.getIdentifier(), (Expression[])new Expression[]{expression}, (BoogieType)boogieArrayType);
    }

    public static Expression getZeroArray(FunctionDeclarations functionDeclarations, ILocation iLocation, BoogieArrayType boogieArrayType) {
        FunctionDeclaration functionDeclaration = ConstantArrayUtil.getOrDeclareZeroArrayFunction(functionDeclarations, boogieArrayType);
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)functionDeclaration.getIdentifier(), (Expression[])new Expression[0], (BoogieType)boogieArrayType);
    }

    private static FunctionDeclaration getOrDeclareZeroArrayFunction(FunctionDeclarations functionDeclarations, BoogieArrayType boogieArrayType) {
        return ConstantArrayUtil.getOrDeclareConstantArrayFunction(functionDeclarations, boogieArrayType, "", new BoogieType[0], CTranslationUtil::getSmtZeroStringForBoogieType);
    }

    private static FunctionDeclaration getOrDeclareConstantArrayFunction(FunctionDeclarations functionDeclarations, BoogieArrayType boogieArrayType) {
        return ConstantArrayUtil.getOrDeclareConstantArrayFunction(functionDeclarations, boogieArrayType, "~param", new BoogieType[]{boogieArrayType.getValueType()}, boogieType -> {
            assert (boogieType.equals((Object)boogieArrayType.getValueType())) : "constant value of type " + String.valueOf(boogieArrayType.getValueType()) + " cannot be used for " + String.valueOf(boogieType);
            return FunctionDeclarations.constructNameForFunctionInParam(0);
        });
    }

    private static FunctionDeclaration getOrDeclareConstantArrayFunction(FunctionDeclarations functionDeclarations, BoogieArrayType boogieArrayType, String string, BoogieType[] boogieTypeArray, Function<BoogieType, String> function) {
        String string2 = ConstantArrayUtil.getFunctionName((BoogieType)boogieArrayType, string);
        FunctionDeclaration functionDeclaration = functionDeclarations.getDeclaredFunctions().get(string2);
        if (functionDeclaration != null) {
            assert (ConstantArrayUtil.paramTypesMatch(boogieTypeArray, functionDeclaration));
            return functionDeclaration;
        }
        return ConstantArrayUtil.constructAndRegisterDeclaration(functionDeclarations, boogieArrayType, string2, boogieTypeArray, function);
    }

    private static boolean paramTypesMatch(BoogieType[] boogieTypeArray, FunctionDeclaration functionDeclaration) {
        int n = 0;
        VarList[] varListArray = functionDeclaration.getInParams();
        int n2 = varListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VarList varList = varListArray[n3];
            String[] stringArray = varList.getIdentifiers();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string = stringArray[n5];
                assert (n < boogieTypeArray.length) : "parameter count differs";
                assert (boogieTypeArray[n].equals((Object)varList.getType().getBoogieType())) : "type of parameter " + string + " differs";
                ++n;
                ++n5;
            }
            ++n3;
        }
        return true;
    }

    private static FunctionDeclaration constructAndRegisterDeclaration(FunctionDeclarations functionDeclarations, BoogieArrayType boogieArrayType, String string, BoogieType[] boogieTypeArray, Function<BoogieType, String> function) {
        NamedAttribute namedAttribute;
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ArrayList<NamedAttribute> arrayList = new ArrayList<NamedAttribute>();
        BoogieType boogieType2 = StructExpanderUtil.flattenType((IBoogieType)boogieArrayType, new HashMap(), new HashMap());
        if (boogieType2 instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)boogieType2;
            int n = 0;
            while (n < boogieStructType.getFieldCount()) {
                namedAttribute = new NamedAttribute((ILocation)cACSLLocation, "expand_struct", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)boogieStructType.getFieldIds()[n])});
                arrayList.add(namedAttribute);
                arrayList.add(ConstantArrayUtil.createSmtDefinedAttribute(cACSLLocation, (BoogieArrayType)boogieStructType.getFieldType(n), function));
                ++n;
            }
        } else {
            arrayList.add(ConstantArrayUtil.createSmtDefinedAttribute(cACSLLocation, boogieArrayType, function));
        }
        Attribute[] attributeArray = (Attribute[])arrayList.toArray(Attribute[]::new);
        namedAttribute = (NamedAttribute)Arrays.stream(boogieTypeArray).map(boogieType -> boogieType.toASTType((ILocation)cACSLLocation)).toArray(ASTType[]::new);
        return functionDeclarations.declareFunction((ILocation)cACSLLocation, string, attributeArray, boogieArrayType.toASTType((ILocation)cACSLLocation), (ASTType[])namedAttribute);
    }

    private static NamedAttribute createSmtDefinedAttribute(ILocation iLocation, BoogieArrayType boogieArrayType, Function<BoogieType, String> function) {
        String string = ConstantArrayUtil.getSmtConstantArrayStringForBoogieType(boogieArrayType, function);
        return new NamedAttribute(iLocation, "smtdefined", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
    }

    private static String getSmtConstantArrayStringForBoogieType(BoogieArrayType boogieArrayType, Function<BoogieType, String> function) {
        String string;
        BoogieType boogieType = boogieArrayType.getValueType();
        if (boogieType instanceof BoogieArrayType) {
            BoogieArrayType boogieArrayType2 = (BoogieArrayType)boogieType;
            string = ConstantArrayUtil.getSmtConstantArrayStringForBoogieType(boogieArrayType2, function);
        } else {
            string = function.apply(boogieArrayType.getValueType());
        }
        String string2 = CTranslationUtil.getSmtSortStringForBoogieType(boogieArrayType.getValueType());
        int n = boogieArrayType.getIndexCount() - 1;
        while (n >= 0) {
            string2 = String.format("(Array %s %s)", CTranslationUtil.getSmtSortStringForBoogieType(boogieArrayType.getIndexType(n)), string2);
            string = String.format("((as const %s) %s)", string2, string);
            --n;
        }
        return string;
    }

    private static String getFunctionName(BoogieType boogieType, String string) {
        String string2 = boogieType.toString().replace(":", "~COL~").replace(", ", "~COM~").replace("{ ", "~LC~").replace(" }", "~RC~").replace("]", "~RB~").replace("[", "~LB~");
        return "~const~array~" + string2 + string;
    }
}

