/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.parser;

import de.uni_freiburg.informatik.ultimate.cdt.CommentParser;
import de.uni_freiburg.informatik.ultimate.cdt.FunctionLineVisitor;
import de.uni_freiburg.informatik.ultimate.cdt.decorator.ASTDecorator;
import de.uni_freiburg.informatik.ultimate.cdt.decorator.DecoratedUnit;
import de.uni_freiburg.informatik.ultimate.cdt.decorator.DecoratorNode;
import de.uni_freiburg.informatik.ultimate.cdt.parser.IncludeSorter;
import de.uni_freiburg.informatik.ultimate.cdt.parser.MultiparseSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.parser.UltimateCdtExternalSettingsProvider;
import de.uni_freiburg.informatik.ultimate.cdt.parser.preferences.PreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.WrapperNode;
import de.uni_freiburg.informatik.ultimate.core.lib.util.LoggerOutputStream;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ASTPrinter;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CDTParser
implements ISource {
    private final String mCdtPProjectHierachyFlag;
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private final String[] mFileTypes = new String[]{".c", ".i", ".h", ".inl"};
    private ILogger mLogger;
    private List<String> mFileNames;
    private IUltimateServiceProvider mServices;
    private IProject mProject;

    public CDTParser() {
        this.mCdtPProjectHierachyFlag = "FLAG" + UUID.randomUUID().toString().substring(0, 10).replace("-", "");
    }

    public void init() {
        this.mFileNames = new ArrayList<String>();
    }

    public String getPluginName() {
        return "CDTParser";
    }

    public String getPluginID() {
        return "CDTParser";
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    private boolean parseable(File file) {
        String[] stringArray = this.getFileTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (file.getName().endsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IElement parseAST(File[] fileArray) throws Exception {
        Collection<IASTTranslationUnit> collection = this.computeASTsFromFilesViaCdt(fileArray);
        MultiparseSymbolTable multiparseSymbolTable = new MultiparseSymbolTable(this.mLogger, this.mCdtPProjectHierachyFlag, fileArray.length == 1);
        for (IASTTranslationUnit object2 : collection) {
            this.mLogger.info((Object)("Scanning " + this.normalizeCdtFilename(object2.getFilePath())));
            this.dumpAST(object2, ASTPrinter::print, "all AST nodes");
            this.dumpAST(object2, ASTPrinter::printProblems, "problem AST nodes");
            object2.accept((ASTVisitor)multiparseSymbolTable);
        }
        if (this.mLogger.isDebugEnabled()) {
            multiparseSymbolTable.printMappings();
        }
        ASTDecorator aSTDecorator = this.decorateTranslationUnits(multiparseSymbolTable, collection);
        aSTDecorator.setSymbolTable(multiparseSymbolTable);
        return new WrapperNode(null, (Object)aSTDecorator);
    }

    public void dumpAST(IASTTranslationUnit iASTTranslationUnit, BiConsumer<IASTNode, PrintStream> biConsumer, String string) {
        if (this.mLogger.isDebugEnabled()) {
            String string2 = this.normalizeCdtFilename(iASTTranslationUnit.getFilePath());
            LoggerOutputStream loggerOutputStream = new LoggerOutputStream(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
            PrintStream printStream = new PrintStream((OutputStream)loggerOutputStream);
            this.mLogger.debug((Object)("======== BEGIN dump AST [" + string + "] of translation unit for " + string2));
            biConsumer.accept((IASTNode)iASTTranslationUnit, printStream);
            printStream.flush();
            this.mLogger.debug((Object)("======== END dump AST [" + string + "] of translation unit for " + string2));
            printStream.close();
        }
    }

    public static String normalizeCdtFilename(String string, String string2) {
        String string3 = string + File.separator + "src" + File.separator;
        int n = string2.indexOf(string3);
        if (n < 0) {
            return string2;
        }
        return string2.substring(n + string3.length());
    }

    private String normalizeCdtFilename(String string) {
        return CDTParser.normalizeCdtFilename(this.mCdtPProjectHierachyFlag, string);
    }

    private ASTDecorator decorateTranslationUnits(MultiparseSymbolTable multiparseSymbolTable, Collection<IASTTranslationUnit> collection) {
        ASTDecorator aSTDecorator = new ASTDecorator();
        IncludeSorter includeSorter = new IncludeSorter(this.mLogger, collection, multiparseSymbolTable);
        for (IASTTranslationUnit iASTTranslationUnit : includeSorter.getResult()) {
            FunctionLineVisitor functionLineVisitor = new FunctionLineVisitor();
            iASTTranslationUnit.accept((ASTVisitor)functionLineVisitor);
            CommentParser commentParser = new CommentParser(iASTTranslationUnit.getComments(), functionLineVisitor.getLineRange(), this.mLogger, this.mServices);
            List<ACSLNode> list = commentParser.processComments();
            aSTDecorator.provideAcslASTs(list);
            DecoratorNode decoratorNode = aSTDecorator.mapASTs((IASTNode)iASTTranslationUnit);
            DecoratedUnit decoratedUnit = new DecoratedUnit(decoratorNode, iASTTranslationUnit);
            aSTDecorator.addDecoratedUnit(decoratedUnit);
        }
        return aSTDecorator;
    }

    private ICProject createCompleteCdtProject(File[] fileArray) throws CoreException {
        File file;
        this.mProject = this.createConfiguredEmptyCdtProject();
        ISourceEntry iSourceEntry = CoreModel.newSourceEntry((IPath)this.mProject.getFullPath());
        IFolder iFolder = this.mProject.getFolder(iSourceEntry.getPath());
        iFolder.create(8192, true, NULL_MONITOR);
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray2[n2];
            CDTParser.addLinkToFolder(iFolder, file);
            ++n2;
        }
        file = CoreModel.getDefault().create(this.mProject);
        file.setRawPathEntries(new IPathEntry[]{iSourceEntry}, NULL_MONITOR);
        String string = this.mServices.getPreferenceProvider("CDTParser").getString("Please specify include paths that will be parsed with the given C-File");
        String[] stringArray = string.split(";");
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string2 = stringArray[n4];
            if (new File(string2).exists()) {
                File[] fileArray3;
                this.mLogger.info((Object)("Adding includes from " + string2 + " as file "));
                File[] fileArray4 = fileArray3 = new File(string2).listFiles();
                int n5 = fileArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    File file2 = fileArray4[n6];
                    CDTParser.addLinkToFolder(iFolder, file2);
                    ++n6;
                }
            }
            ++n4;
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        if (this.mLogger.isDebugEnabled()) {
            this.printLanguageSettingsEntries((ICProject)file);
        }
        return file;
    }

    private void printLanguageSettingsEntries(ICProject iCProject) throws CModelException {
        ICProjectDescriptionManager iCProjectDescriptionManager = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription iCProjectDescription = iCProjectDescriptionManager.getProjectDescription(this.mProject);
        ICConfigurationDescription iCConfigurationDescription = iCProjectDescription.getActiveConfiguration();
        this.mLogger.info((Object)"Printing language settings [<language>][<kind>][<flags>] <name>=<value>");
        ISourceRoot[] iSourceRootArray = iCProject.getAllSourceRoots();
        int n = iSourceRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRoot iSourceRoot = iSourceRootArray[n2];
            IResource iResource = iSourceRoot.getUnderlyingResource();
            if (iResource == null) {
                this.mLogger.warn("%s has no underlying resource", new Object[]{iSourceRoot.getElementName()});
            } else {
                this.mLogger.info("%s:", new Object[]{iSourceRoot.getElementName()});
                List list = LanguageSettingsManager.getLanguages((IResource)iResource, (ICConfigurationDescription)iCConfigurationDescription);
                for (String string : list) {
                    List list2 = LanguageSettingsManager.getSettingEntriesByKind((ICConfigurationDescription)iCConfigurationDescription, (IResource)iSourceRoot.getUnderlyingResource(), (String)string, (int)-1);
                    for (ICLanguageSettingEntry iCLanguageSettingEntry : list2) {
                        this.mLogger.info("[%s][%s][%s] %s=%s", new Object[]{string, LanguageSettingEntriesSerializer.kindToString((int)iCLanguageSettingEntry.getKind()), LanguageSettingEntriesSerializer.composeFlagsString((int)iCLanguageSettingEntry.getFlags()), iCLanguageSettingEntry.getName(), iCLanguageSettingEntry.getValue()});
                    }
                }
            }
            ++n2;
        }
    }

    public List<IASTTranslationUnit> getTranslationUnitsFromCdtProject(ICProject iCProject) throws CoreException {
        ArrayList<IASTTranslationUnit> arrayList = new ArrayList<IASTTranslationUnit>();
        try {
            IIndex iIndex = CCorePlugin.getIndexManager().getIndex(iCProject);
            iIndex.acquireReadLock();
            ISourceRoot[] iSourceRootArray = iCProject.getSourceRoots();
            int n = iSourceRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceRoot iSourceRoot = iSourceRootArray[n2];
                ICElement[] iCElementArray = iSourceRoot.getChildren();
                int n3 = iCElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICElement iCElement = iCElementArray[n4];
                    if (iCElement.getElementType() == 12) {
                        CDTParser.extractTranslationUnitsFromContainerTree(iIndex, (ICContainer)iCElement, arrayList);
                    } else {
                        ITranslationUnit iTranslationUnit = (ITranslationUnit)iCElement;
                        IASTTranslationUnit iASTTranslationUnit = iTranslationUnit.getAST(iIndex, 2);
                        arrayList.add(iASTTranslationUnit);
                    }
                    ++n4;
                }
                ++n2;
            }
            new IndexReadlockReleaser(iIndex).store(this.mServices.getStorage());
        }
        catch (InterruptedException | CModelException throwable) {
            throwable.printStackTrace();
        }
        return arrayList;
    }

    private static void extractTranslationUnitsFromContainerTree(IIndex iIndex, ICContainer iCContainer, List<IASTTranslationUnit> list) throws CoreException {
        ICContainer iCContainer2;
        ICContainer[] iCContainerArray = iCContainer.getCContainers();
        int n = iCContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            iCContainer2 = iCContainerArray[n2];
            CDTParser.extractTranslationUnitsFromContainerTree(iIndex, iCContainer2, list);
            ++n2;
        }
        iCContainerArray = iCContainer.getTranslationUnits();
        n = iCContainerArray.length;
        n2 = 0;
        while (n2 < n) {
            iCContainer2 = iCContainerArray[n2];
            list.add(iCContainer2.getAST(iIndex, 2));
            ++n2;
        }
    }

    private Collection<IASTTranslationUnit> computeASTsFromFilesViaCdt(File[] fileArray) throws CoreException {
        ICProject iCProject = this.createCompleteCdtProject(fileArray);
        List<IASTTranslationUnit> list = this.getTranslationUnitsFromCdtProject(iCProject);
        this.mLogger.info((Object)("Found " + list.size() + " translation units."));
        return list;
    }

    public String[] getFileTypes() {
        return this.mFileTypes;
    }

    public ModelType getOutputDefinition() {
        try {
            return new ModelType(this.getPluginID(), ModelType.Type.AST, this.mFileNames);
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)exception.getMessage());
            return null;
        }
    }

    public IPreferenceInitializer getPreferences() {
        return new PreferenceInitializer();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger("CDTParser");
    }

    public void finish() {
        if (this.mProject == null) {
            return;
        }
        try {
            IEclipsePreferences iEclipsePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
            Preferences preferences = iEclipsePreferences.node("indexer");
            preferences.removeNode();
            this.mProject.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", "pdomName"), null);
            this.mLogger.info((Object)("About to delete temporary CDT project at " + CDTParser.getFullPath(this.mProject)));
            IWorkspace iWorkspace = this.mProject.getWorkspace();
            File file = this.mProject.getLocation().removeLastSegments(1).toFile();
            iWorkspace.getRoot().delete(5, null);
            if (file.exists()) {
                file.delete();
            }
            CDTParser.waitForProjectRefreshToFinish();
            this.mLogger.info((Object)("Successfully deleted " + file.getAbsolutePath()));
        }
        catch (CoreException coreException) {
            this.mLogger.fatal((Object)"Failed to delete temporary CDT project:", (Throwable)coreException);
        }
        catch (BackingStoreException backingStoreException) {
            this.mLogger.fatal((Object)"Failed to reset indexer setting for temporary CDT project:", (Throwable)backingStoreException);
        }
    }

    private static String getFullPath(IProject iProject) {
        if (iProject == null) {
            return "NULL";
        }
        IPath iPath = iProject.getLocation();
        if (iPath == null) {
            return "UNKNOWN LOCATION";
        }
        return iPath.toOSString();
    }

    private IProject createConfiguredEmptyCdtProject() throws CoreException {
        String string = this.mCdtPProjectHierachyFlag;
        String string2 = UUID.randomUUID().toString().replace("-", "");
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(string);
        iProjectDescription.setLocation(iWorkspaceRoot.getLocation().append(string2 + File.separator + string));
        IndexerPreferences.set((IProject)iProject, (String)"indexAllFiles", (String)"org.eclipse.cdt.core.fastIndexer");
        IContentType iContentType = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cSource");
        try {
            iContentType.addFileSpec("i", 8);
        }
        catch (CoreException coreException) {
            throw new IllegalStateException("Could not add .i to C extensions.", coreException);
        }
        iProject = cCorePlugin.createCProject(iProjectDescription, iProject, NULL_MONITOR, string);
        IToolChain iToolChain = ManagedBuildManager.getExtensionToolChain((String)"cdt.managedbuild.toolchain.gnu.base");
        ICProjectDescriptionManager iCProjectDescriptionManager = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription iCProjectDescription = iCProjectDescriptionManager.getProjectDescription(iProject);
        ManagedBuildInfo managedBuildInfo = ManagedBuildManager.createBuildInfo((IResource)iProject);
        ManagedProject managedProject = new ManagedProject(iCProjectDescription);
        managedBuildInfo.setManagedProject((IManagedProject)managedProject);
        Configuration configuration = new Configuration(managedProject, iToolChain, ManagedBuildManager.calculateChildId((String)iToolChain.getId(), null), "ultimate_cdt_config");
        CConfigurationData cConfigurationData = configuration.getConfigurationData();
        iCProjectDescription.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", cConfigurationData);
        iCProjectDescriptionManager.setProjectDescription(iProject, iCProjectDescription);
        ICProjectDescriptionManager iCProjectDescriptionManager2 = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription iCProjectDescription2 = iCProjectDescriptionManager2.getProjectDescription(iProject);
        ICConfigurationDescription iCConfigurationDescription = iCProjectDescription2.getActiveConfiguration();
        UltimateCdtExternalSettingsProvider.ToolchainDependency.annotate(iProject, this.mServices, this.mLogger);
        iCConfigurationDescription.setExternalSettingsProviderIds(new String[]{"de.uni_freiburg.informatik.ultimate.cdt.parser.ultimateSettingsProviderId"});
        ILanguageSettingsProvidersKeeper iLanguageSettingsProvidersKeeper = (ILanguageSettingsProvidersKeeper)iCConfigurationDescription;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(iLanguageSettingsProvidersKeeper.getDefaultLanguageSettingsProvidersIds()));
        arrayList.add("de.uni_freiburg.informatik.ultimate.cdt.parser.GccStaticLanguageSettingsProvider");
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        iLanguageSettingsProvidersKeeper.setDefaultLanguageSettingsProvidersIds(stringArray);
        List list = LanguageSettingsManager.getWorkspaceProviders();
        ILanguageSettingsProvider iLanguageSettingsProvider2 = list.stream().filter(iLanguageSettingsProvider -> "de.uni_freiburg.informatik.ultimate.cdt.parser.GccStaticLanguageSettingsProvider".equals(iLanguageSettingsProvider.getId())).findFirst().orElseThrow();
        ArrayList<ILanguageSettingsProvider> arrayList2 = new ArrayList<ILanguageSettingsProvider>(iLanguageSettingsProvidersKeeper.getLanguageSettingProviders());
        arrayList2.add(iLanguageSettingsProvider2);
        iLanguageSettingsProvidersKeeper.setLanguageSettingProviders(arrayList2);
        iCProjectDescriptionManager2.setProjectDescription(iProject, iCProjectDescription2);
        CDTParser.waitForProjectRefreshToFinish();
        iProject.open(NULL_MONITOR);
        this.mLogger.info("Created temporary CDT project at %s", new Object[]{CDTParser.getFullPath(iProject)});
        return iProject;
    }

    public static IFile addLinkToFolder(IFolder iFolder, File file) throws CoreException {
        Path path = new Path(file.getName());
        if (path.segmentCount() > 1) {
            throw new IllegalArgumentException("File has to be a single file");
        }
        IFile iFile = iFolder.getFile((IPath)path);
        iFile.createLink(file.toURI(), 0, NULL_MONITOR);
        return iFile;
    }

    private static void waitForProjectRefreshToFinish() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, NULL_MONITOR);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, NULL_MONITOR);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, NULL_MONITOR);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, NULL_MONITOR);
        }
        catch (Exception exception) {}
    }

    private static final class IndexReadlockReleaser
    implements IStorable {
        private final IIndex mIndex;

        public IndexReadlockReleaser(IIndex iIndex) {
            this.mIndex = iIndex;
        }

        public void destroy() {
            this.mIndex.releaseReadLock();
        }

        public void store(IToolchainStorage iToolchainStorage) {
            IStorable iStorable = iToolchainStorage.putStorable(this.getClass().toString() + this.mIndex.hashCode(), (IStorable)this);
            assert (iStorable == this || iStorable == null);
        }
    }
}

