/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl;

import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public abstract class ACSLNode {
    public static final ACSLSourceLocation INVALID_LOCATION = new ACSLSourceLocation(-1, -1, -1, -1);
    private static final Pattern IDENTIFIER_REGEX = Pattern.compile("[a-zA-Z_\\$]([a-zA-Z_\\$]|[a-fA-F0-9])*");
    protected static final Map<Class<?>, Predicate<ACSLNode>> VALIDATORS = new HashMap();
    private final List<ACSLNode> mChildren = new ArrayList<ACSLNode>();
    private String mFileName;
    private ACSLSourceLocation mLocation = INVALID_LOCATION;

    static {
        Predicate<ACSLNode> predicate = aCSLNode -> {
            IdentifierExpression identifierExpression = (IdentifierExpression)aCSLNode;
            return IDENTIFIER_REGEX.matcher(identifierExpression.getIdentifier()).matches();
        };
        VALIDATORS.put(IdentifierExpression.class, predicate);
    }

    public int getStartingLineNumber() {
        return this.mLocation.getStartLine();
    }

    public int getEndingLineNumber() {
        return this.mLocation.getEndLine();
    }

    public List<ACSLNode> getOutgoingNodes() {
        return this.mChildren;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public void setFileName(String string) {
        this.mFileName = string;
    }

    public ACSLSourceLocation getLocation() {
        return this.mLocation;
    }

    public void setLocation(ACSLSourceLocation aCSLSourceLocation) {
        this.mLocation = aCSLSourceLocation;
    }

    public abstract void accept(ACSLVisitor var1);

    public abstract ACSLNode accept(ACSLTransformer var1);

    public static class ACSLSourceLocation {
        private static final char SLASH = '/';
        private final int mStartLine;
        private final int mStartColumn;
        private final int mEndLine;
        private final int mEndColumn;

        public ACSLSourceLocation(int n, int n2, int n3, int n4) {
            this.mStartLine = n;
            this.mStartColumn = n2;
            this.mEndLine = n3;
            this.mEndColumn = n4;
        }

        public int getStartLine() {
            return this.mStartLine;
        }

        public int getStartColumn() {
            return this.mStartColumn;
        }

        public int getEndLine() {
            return this.mEndLine;
        }

        public int getEndColumn() {
            return this.mEndColumn;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[').append(this.mStartLine).append('/').append(this.mStartColumn).append('-').append(this.mEndLine).append('/').append(this.mEndColumn).append(']');
            return stringBuilder.toString();
        }
    }
}

