/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolder;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;

public final class GetAcceptedWord<LETTER, PLACE>
extends UnaryNetOperation<LETTER, PLACE, IPetriNet2FiniteAutomatonStateFactory<PLACE>> {
    private final IPetriNetTransitionProvider<LETTER, PLACE> mOperand;
    private final Word<LETTER> mAcceptedWord;

    public GetAcceptedWord(AutomataLibraryServices automataLibraryServices, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNetTransitionProvider;
        this.mLogger.info((Object)this.startMessage());
        PetriNetUnfolder<LETTER, PLACE> petriNetUnfolder = new PetriNetUnfolder<LETTER, PLACE>(this.mServices, iPetriNetTransitionProvider, PetriNetUnfolder.EventOrderEnum.ERV, false, true);
        PetriNetRun petriNetRun = (PetriNetRun)petriNetUnfolder.getAcceptingRun();
        if (petriNetRun == null) {
            throw new IllegalArgumentException("unable to get word from empty language");
        }
        this.mAcceptedWord = petriNetRun.getWord();
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Found word of length " + this.mAcceptedWord.length();
    }

    @Override
    protected IPetriNetTransitionProvider<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Word<LETTER> getResult() {
        return this.mAcceptedWord;
    }

    @Override
    public boolean checkResult(IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory) throws AutomataLibraryException {
        boolean bl = new Accepts(this.mServices, this.getOperand(), this.getResult()).getResult();
        return bl;
    }
}

