/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.Clause;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HornMaxSatSolver<V>
extends AbstractMaxSatSolver<V> {
    protected Map<V, Boolean> mVariablesTemporarilySet = new HashMap<V, Boolean>();

    public HornMaxSatSolver(AutomataLibraryServices automataLibraryServices) {
        super(automataLibraryServices);
    }

    @Override
    public void addHornClause(V[] VArray, V v) {
        if (this.mDecisions > 0) {
            throw new UnsupportedOperationException("only legal before decisions were made");
        }
        assert (this.mPropagatees.isEmpty());
        Object[] objectArray = v == null ? new Object[]{} : new Object[]{v};
        Clause<Object> clause = new Clause<Object>(this, objectArray, VArray);
        if (clause.isEquivalentToTrue()) {
            ++this.mClauses;
            ++this.mTrivialClauses;
        } else {
            Pair<Object, Boolean> pair;
            ++this.mClauses;
            ++this.mCurrentLiveClauses;
            this.mMaxLiveClauses = Math.max(this.mMaxLiveClauses, this.mCurrentLiveClauses);
            if (clause.isEquivalentToFalse()) {
                this.mConjunctionEquivalentToFalse = true;
                throw new UnsupportedOperationException("clause set is equivalent to false");
            }
            Object[] objectArray2 = clause.getNegativeAtoms();
            int n = objectArray2.length;
            int n2 = 0;
            while (n2 < n) {
                pair = objectArray2[n2];
                this.mOccursNegative.addPair((Object)pair, clause);
                ++n2;
            }
            objectArray2 = clause.getPositiveAtoms();
            n = objectArray2.length;
            n2 = 0;
            while (n2 < n) {
                pair = objectArray2[n2];
                this.mOccursPositive.addPair(pair, clause);
                ++n2;
            }
            if (clause.isPseudoUnit()) {
                pair = clause.getPropagatee();
                this.mPropagatees.put(pair.getFirst(), (Boolean)pair.getSecond());
            }
            this.propagateAll();
        }
    }

    @Override
    public void addClause(V[] VArray, V[] VArray2) {
        throw new UnsupportedOperationException("General clauses are not supported by this Horn solver.");
    }

    @Override
    protected Boolean getPersistentAssignment(V v) {
        Boolean bl = (Boolean)this.mVariablesIrrevocablySet.get(v);
        assert (bl == null || !this.mVariablesTemporarilySet.containsKey(v)) : "Unsynchronized assignment data structures.";
        return bl;
    }

    @Override
    protected VariableStatus getTemporaryAssignment(V v) {
        Boolean bl = this.mVariablesTemporarilySet.get(v);
        if (bl == null) {
            return VariableStatus.UNSET;
        }
        assert (!this.mVariablesIrrevocablySet.containsKey(v)) : "Unsynchronized assignment data structures.";
        return bl != false ? VariableStatus.TRUE : VariableStatus.FALSE;
    }

    @Override
    protected void setVariable(V v, boolean bl) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("setting variable " + String.valueOf(v) + " to " + bl));
        }
        assert (this.mVariables.contains(v)) : "unknown variable";
        assert (!this.mVariablesIrrevocablySet.containsKey(v)) : "variable already set";
        Boolean bl2 = this.mVariablesTemporarilySet.put((Boolean)v, bl);
        if (bl2 != null) {
            throw new IllegalArgumentException("variable already set " + String.valueOf(v));
        }
        this.mPropagatees.remove(v);
        this.reEvaluateStatusOfAllClauses(v);
    }

    @Override
    protected void makeAssignmentPersistent() {
        this.removeMarkedClauses();
        for (Map.Entry<V, Boolean> entry : this.mVariablesTemporarilySet.entrySet()) {
            this.mVariablesIrrevocablySet.put(entry.getKey(), entry.getValue());
            this.mUnsetVariables.remove(entry.getKey());
        }
        this.mVariablesTemporarilySet = new HashMap<V, Boolean>();
    }

    @Override
    protected void decideOne() {
        ++this.mDecisions;
        Object v = this.getUnsetVariable();
        this.setVariable(v, true);
        this.propagateAll();
        if (this.mConjunctionEquivalentToFalse) {
            this.backtrack(v);
        } else {
            this.makeAssignmentPersistent();
        }
    }

    @Override
    protected void backtrack(V v) {
        ++this.mWrongDecisions;
        this.mClausesMarkedForRemoval = new LinkedHashSet();
        Set<V> set = this.mVariablesTemporarilySet.keySet();
        this.mVariablesTemporarilySet = new HashMap<V, Boolean>();
        this.mConjunctionEquivalentToFalse = false;
        this.mPropagatees = new HashMap();
        this.reEvaluateStatusOfAllClauses(set, v);
        this.setVariable(v, false);
        assert (!this.mConjunctionEquivalentToFalse) : "resetting variable did not help";
    }

    @Override
    protected void log() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Clauses: ").append(this.mClauses);
        stringBuilder.append(" (thereof " + this.mTrivialClauses + " trivial clauses)");
        stringBuilder.append(" MaxLiveClauses: ").append(this.mMaxLiveClauses);
        stringBuilder.append(" Decisions : ").append(this.mDecisions);
        stringBuilder.append(" (thereof " + this.mWrongDecisions + " wrong decisions)");
        this.mLogger.info((Object)stringBuilder.toString());
    }
}

