/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.Arrays;

class PositionAwareTermTransformer
extends NonRecursive {
    private final ArrayDeque<Term> mConverted = new ArrayDeque();

    PositionAwareTermTransformer() {
    }

    protected final void pushTerms(Term[] termArray, SubtreePosition subtreePosition) {
        int n = termArray.length - 1;
        while (n >= 0) {
            this.pushTerm(termArray[n], subtreePosition.append(n));
            --n;
        }
    }

    protected final void pushTerm(Term term, SubtreePosition subtreePosition) {
        this.enqueueWalker(new Convert(term, subtreePosition));
    }

    protected final void setResult(Term term) {
        this.mConverted.addLast(term);
    }

    protected void convert(Term term, SubtreePosition subtreePosition) {
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            this.mConverted.addLast(term);
        } else if (term instanceof ApplicationTerm) {
            this.enqueueWalker(new BuildApplicationTerm((ApplicationTerm)term, subtreePosition));
            this.pushTerms(((ApplicationTerm)term).getParameters(), subtreePosition);
        } else if (term instanceof LetTerm) {
            this.enqueueWalker(new StartLetTerm((LetTerm)term, subtreePosition));
            this.pushTerms(((LetTerm)term).getValues(), subtreePosition);
        } else if (term instanceof QuantifiedFormula) {
            this.enqueueWalker(new BuildQuantifier((QuantifiedFormula)term, subtreePosition));
            this.pushTerm(((QuantifiedFormula)term).getSubformula(), subtreePosition.append(0));
            this.beginScope();
        } else if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            this.enqueueWalker(new BuildAnnotation(annotatedTerm, subtreePosition));
            Annotation[] annotationArray = annotatedTerm.getAnnotations();
            int n = annotationArray.length - 1;
            while (n >= 0) {
                Object object = annotationArray[n].getValue();
                if (object instanceof Term) {
                    this.pushTerm((Term)object, subtreePosition.append(n));
                } else if (object instanceof Term[]) {
                    this.pushTerms((Term[])object, subtreePosition.append(n));
                }
                --n;
            }
            this.pushTerm(annotatedTerm.getSubterm(), subtreePosition.append(annotationArray.length));
        } else {
            throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
        }
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray, SubtreePosition subtreePosition) {
        ApplicationTerm applicationTerm2 = applicationTerm;
        if (termArray != applicationTerm.getParameters()) {
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            Theory theory = functionSymbol.getTheory();
            Sort[] sortArray = new Sort[termArray.length];
            int n = 0;
            while (n < termArray.length) {
                sortArray[n] = termArray[n].getSort();
                ++n;
            }
            FunctionSymbol functionSymbol2 = theory.getFunction(functionSymbol.getName(), sortArray);
            assert (functionSymbol2 != null) : "could not find an instance for the polymorphic function";
            applicationTerm2 = theory.term(functionSymbol2, termArray);
        }
        this.setResult((Term)applicationTerm2);
    }

    public void preConvertLet(LetTerm letTerm, Term[] termArray, SubtreePosition subtreePosition) {
        this.beginScope();
        this.enqueueWalker(new BuildLetTerm(letTerm, termArray, subtreePosition));
        this.pushTerm(letTerm.getSubTerm(), subtreePosition);
    }

    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        LetTerm letTerm2 = letTerm;
        if (letTerm.getValues() != termArray || letTerm.getSubTerm() != term) {
            letTerm2 = letTerm.getTheory().let(letTerm.getVariables(), termArray, term);
        }
        this.setResult((Term)letTerm2);
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        QuantifiedFormula quantifiedFormula2 = quantifiedFormula;
        if (term != quantifiedFormula.getSubformula()) {
            Theory theory = quantifiedFormula.getTheory();
            TermVariable[] termVariableArray = quantifiedFormula.getVariables();
            quantifiedFormula2 = quantifiedFormula.getQuantifier() == 0 ? theory.exists(termVariableArray, term) : theory.forall(termVariableArray, term);
        }
        this.setResult((Term)quantifiedFormula2);
    }

    public void postConvertAnnotation(AnnotatedTerm annotatedTerm, Annotation[] annotationArray, Term term) {
        Annotation[] annotationArray2 = annotatedTerm.getAnnotations();
        AnnotatedTerm annotatedTerm2 = annotatedTerm;
        if (term != annotatedTerm.getSubterm() || annotationArray != annotationArray2) {
            annotatedTerm2 = annotatedTerm.getTheory().annotatedTerm(annotationArray, term);
        }
        this.setResult((Term)annotatedTerm2);
    }

    protected void beginScope() {
    }

    protected void endScope() {
    }

    public final Term transform(Term term) {
        this.beginScope();
        this.run(new Convert(term, new SubtreePosition()));
        this.endScope();
        return this.mConverted.removeLast();
    }

    protected final Term getConverted() {
        return this.mConverted.removeLast();
    }

    protected final Term[] getConverted(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length - 1;
        while (n >= 0) {
            Term term = this.getConverted();
            if (term != termArray[n]) {
                if (termArray2 == termArray) {
                    termArray2 = (Term[])termArray.clone();
                }
                termArray2[n] = term;
            }
            --n;
        }
        return termArray2;
    }

    public void reset() {
        super.reset();
        this.mConverted.clear();
    }

    protected static class BuildAnnotation
    implements NonRecursive.Walker {
        private final AnnotatedTerm mAnnotatedTerm;
        private final SubtreePosition mPos;

        public BuildAnnotation(AnnotatedTerm annotatedTerm, SubtreePosition subtreePosition) {
            this.mAnnotatedTerm = annotatedTerm;
            this.mPos = subtreePosition;
        }

        public void walk(NonRecursive nonRecursive) {
            Annotation[] annotationArray;
            PositionAwareTermTransformer positionAwareTermTransformer = (PositionAwareTermTransformer)nonRecursive;
            Annotation[] annotationArray2 = annotationArray = this.mAnnotatedTerm.getAnnotations();
            int n = annotationArray.length - 1;
            while (n >= 0) {
                Object object = annotationArray[n].getValue();
                Object object2 = object instanceof Term ? positionAwareTermTransformer.getConverted() : (object instanceof Term[] ? positionAwareTermTransformer.getConverted((Term[])object) : object);
                if (object2 != object) {
                    if (annotationArray == annotationArray2) {
                        annotationArray2 = (Annotation[])annotationArray.clone();
                    }
                    annotationArray2[n] = new Annotation(annotationArray[n].getKey(), object2);
                }
                --n;
            }
            Term term = positionAwareTermTransformer.getConverted();
            positionAwareTermTransformer.postConvertAnnotation(this.mAnnotatedTerm, annotationArray2, term);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildApplicationTerm
    implements NonRecursive.Walker {
        private final ApplicationTerm mAppTerm;
        private final SubtreePosition mPos;

        public BuildApplicationTerm(ApplicationTerm applicationTerm, SubtreePosition subtreePosition) {
            this.mAppTerm = applicationTerm;
            this.mPos = subtreePosition;
        }

        public void walk(NonRecursive nonRecursive) {
            PositionAwareTermTransformer positionAwareTermTransformer = (PositionAwareTermTransformer)nonRecursive;
            Term[] termArray = this.mAppTerm.getParameters();
            Term[] termArray2 = positionAwareTermTransformer.getConverted(termArray);
            positionAwareTermTransformer.convertApplicationTerm(this.mAppTerm, termArray2, this.mPos);
        }

        public String toString() {
            return this.mAppTerm.getFunction().getApplicationString();
        }
    }

    protected static class BuildLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final Term[] mNewValues;
        private final SubtreePosition mPos;

        public BuildLetTerm(LetTerm letTerm, Term[] termArray, SubtreePosition subtreePosition) {
            this.mLetTerm = letTerm;
            this.mNewValues = termArray;
            this.mPos = subtreePosition;
        }

        public void walk(NonRecursive nonRecursive) {
            PositionAwareTermTransformer positionAwareTermTransformer = (PositionAwareTermTransformer)nonRecursive;
            Term term = positionAwareTermTransformer.getConverted();
            positionAwareTermTransformer.postConvertLet(this.mLetTerm, this.mNewValues, term);
            positionAwareTermTransformer.endScope();
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class BuildQuantifier
    implements NonRecursive.Walker {
        private final QuantifiedFormula mQuant;
        private final SubtreePosition mPos;

        public BuildQuantifier(QuantifiedFormula quantifiedFormula, SubtreePosition subtreePosition) {
            this.mQuant = quantifiedFormula;
            this.mPos = subtreePosition;
        }

        public void walk(NonRecursive nonRecursive) {
            PositionAwareTermTransformer positionAwareTermTransformer = (PositionAwareTermTransformer)nonRecursive;
            Term term = positionAwareTermTransformer.getConverted();
            positionAwareTermTransformer.postConvertQuantifier(this.mQuant, term);
            positionAwareTermTransformer.endScope();
        }

        public String toString() {
            return this.mQuant.getQuantifier() == 0 ? "exists" : "forall";
        }
    }

    private static class Convert
    implements NonRecursive.Walker {
        private final Term mTerm;
        private final SubtreePosition mPos;

        public Convert(Term term, SubtreePosition subtreePosition) {
            this.mTerm = term;
            this.mPos = subtreePosition;
        }

        public String toString() {
            return "Convert " + this.mTerm.toStringDirect();
        }

        public void walk(NonRecursive nonRecursive) {
            ((PositionAwareTermTransformer)nonRecursive).convert(this.mTerm, this.mPos);
        }
    }

    protected static class StartLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final SubtreePosition mPos;

        public StartLetTerm(LetTerm letTerm, SubtreePosition subtreePosition) {
            this.mLetTerm = letTerm;
            this.mPos = subtreePosition;
        }

        public void walk(NonRecursive nonRecursive) {
            PositionAwareTermTransformer positionAwareTermTransformer = (PositionAwareTermTransformer)nonRecursive;
            Term[] termArray = positionAwareTermTransformer.getConverted(this.mLetTerm.getValues());
            positionAwareTermTransformer.preConvertLet(this.mLetTerm, termArray, this.mPos);
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }
}

