/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingPathEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.AbstractEntryStorage;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.SettingsSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.IReverseOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildSystemSpecificVariableSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.PathInfo;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ProfileInfoProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BuildEntryStorage
extends AbstractEntryStorage {
    private static final int USER_ENTRIES_LEVEL = 0;
    private static final int ENV_ENTRIES_LEVEL = 1;
    private static final int DISCOVERY_ENTRIES_LEVEL = 2;
    private BuildLanguageData fLangData;
    private String fBuildDirName;

    public BuildEntryStorage(int kind, BuildLanguageData lData) {
        super(kind);
        this.fLangData = lData;
    }

    protected SettingsSet createEmptySettings() {
        SettingsSet settings = new SettingsSet(3);
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        boolean override = this.isDiscoveredEntriesOverridable();
        int readOnlyFlag = override ? 0 : 2;
        levels[0].setFlagsToClear(3);
        levels[0].setFlagsToSet(0);
        levels[0].setReadOnly(false);
        levels[0].setOverrideSupported(override);
        levels[1].setFlagsToClear(1);
        levels[1].setFlagsToSet(readOnlyFlag | 0x10);
        levels[1].setReadOnly(true);
        levels[1].setOverrideSupported(false);
        levels[2].setFlagsToClear(0);
        levels[2].setFlagsToSet(readOnlyFlag | 1 | 0x10);
        levels[2].setReadOnly(true);
        levels[2].setOverrideSupported(false);
        return settings;
    }

    private boolean isDiscoveredEntriesOverridable() {
        return this.fLangData.getUndefOptionsForKind(this.getKind()).length != 0;
    }

    private String getBuildDitName() {
        if (this.fBuildDirName == null) {
            this.fBuildDirName = this.fLangData.getConfiguration().getName();
        }
        return this.fBuildDirName;
    }

    protected void obtainEntriesFromLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                if (level == null) {
                    this.restoreDefaults();
                    break;
                }
                SettingsSet.EntryInfo[] infos = level.getInfos();
                UserEntryInfo[] userInfos = new UserEntryInfo[infos.length];
                int i = 0;
                while (i < infos.length) {
                    UserEntryInfo uei = (UserEntryInfo)infos[i].getCustomInfo();
                    if (uei == null) {
                        uei = new UserEntryInfo(infos[i].getEntry(), null, null, null);
                    }
                    userInfos[i] = uei;
                    ++i;
                }
                List context = (List)level.getContext();
                this.setUserEntries(userInfos, context);
                this.setUserUndefinedStringSet(level.containsOverrideInfo() ? level.getOverrideSet() : null);
            }
        }
    }

    private void restoreDefaults() {
        IOption option;
        ITool tool = this.fLangData.getTool();
        IOption[] iOptionArray = this.fLangData.getOptionsForKind(this.getKind());
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            option = iOptionArray[n2];
            if (option.getParent() == tool) {
                tool.removeOption(option);
            }
            ++n2;
        }
        iOptionArray = this.fLangData.getUndefOptionsForKind(this.getKind());
        n = iOptionArray.length;
        n2 = 0;
        while (n2 < n) {
            option = iOptionArray[n2];
            if (option.getParent() == tool) {
                tool.removeOption(option);
            }
            ++n2;
        }
    }

    protected void putEntriesToLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                ArrayList<EmptyEntryInfo> emptyEntryInfos = new ArrayList<EmptyEntryInfo>();
                UserEntryInfo[] userEntryInfoArray = this.getUserEntries(level.getFlags(0), true, emptyEntryInfos);
                int n = userEntryInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UserEntryInfo userEntry = userEntryInfoArray[n2];
                    level.addEntry(userEntry.fEntry, (Object)userEntry);
                    ++n2;
                }
                level.addOverrideNameSet(this.getUserUndefinedStringSet());
                if (emptyEntryInfos.size() == 0) break;
                level.setContext(emptyEntryInfos);
                break;
            }
            case 1: {
                ICLanguageSettingEntry[] envEntries = this.getEnvEntries(level.getFlags(0));
                level.addEntries(envEntries);
                break;
            }
            case 2: {
                ICLanguageSettingEntry[] discoveredEntries = this.getDiscoveredEntries(level.getFlags(0));
                level.addEntries(discoveredEntries);
            }
        }
    }

    private ICLanguageSettingEntry[] getDiscoveredEntries(int flags) {
        UserEntryInfo[] infos;
        ICLanguageSettingEntry[] entries = ProfileInfoProvider.getInstance().getEntryValues(this.fLangData, this.getKind(), flags);
        if ((entries == null || entries.length == 0) && (infos = this.getUserEntries(flags, false, null)).length != 0) {
            entries = new ICLanguageSettingEntry[infos.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = infos[i].fEntry;
                ++i;
            }
        }
        return entries;
    }

    private SupplierBasedCdtVariableSubstitutor createSubstitutor(IOption option, boolean bsVarsOnly) {
        OptionContextData ocd = new OptionContextData(option, (IBuildObject)this.fLangData.getTool());
        DefaultMacroContextInfo ci = new DefaultMacroContextInfo(2, ocd);
        return bsVarsOnly ? new BuildSystemSpecificVariableSubstitutor(ci) : new SupplierBasedCdtVariableSubstitutor((IVariableContextInfo)ci, "", " ");
    }

    private UserEntryInfo[] getUserEntries(int flags, boolean usr, List<EmptyEntryInfo> emptyValuesInfos) {
        IOption[] options = this.fLangData.getOptionsForKind(this.getKind());
        if (options.length > 0) {
            ArrayList<UserEntryInfo> entryList = new ArrayList<UserEntryInfo>();
            IOption[] iOptionArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                IOption opt = iOptionArray[n2];
                Option option = (Option)opt;
                try {
                    List list;
                    List list2 = list = usr ? (List)option.getExactValue() : option.getExactBuiltinsList();
                    if (list != null) {
                        SupplierBasedCdtVariableSubstitutor subst = this.createSubstitutor(option, false);
                        SupplierBasedCdtVariableSubstitutor bSVarsSubst = this.createSubstitutor(option, true);
                        int j = 0;
                        while (j < list.size()) {
                            OptionStringValue ve = (OptionStringValue)list.get(j);
                            OptionStringValue[] rVes = this.resolve(ve, (IOption)option, bSVarsSubst);
                            if (rVes.length == 0) {
                                if (emptyValuesInfos != null) {
                                    emptyValuesInfos.add(new EmptyEntryInfo(ve, j));
                                }
                            } else {
                                boolean isMultiple = rVes.length > 1;
                                ArrayList<UserEntryInfo> sequense = isMultiple ? new ArrayList<UserEntryInfo>(rVes.length) : null;
                                OptionStringValue[] optionStringValueArray = rVes;
                                int n3 = rVes.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    OptionStringValue rVe = optionStringValueArray[n4];
                                    ICLanguageSettingEntry entry = this.createUserEntry(option, rVe, flags, subst);
                                    entryList.add(new UserEntryInfo(entry, ve, rVe, sequense));
                                    ++n4;
                                }
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                ++n2;
            }
            return entryList.toArray(new UserEntryInfo[entryList.size()]);
        }
        return new UserEntryInfo[0];
    }

    private static String stripQuotes(String value, boolean nullIfNone) {
        if (value.indexOf(34) == 0 && value.lastIndexOf(34) == value.length() - 1 && value.length() != 1) {
            return value.substring(1, value.length() - 1);
        }
        return nullIfNone ? null : value;
    }

    private static OptionStringValue substituteValue(OptionStringValue ov, String value) {
        return new OptionStringValue(value, ov.isBuiltIn(), ov.getSourceAttachmentPath(), ov.getSourceAttachmentRootPath(), ov.getSourceAttachmentPrefixMapping());
    }

    private HashSet<String> getUserUndefinedStringSet() {
        HashSet set = null;
        IOption[] iOptionArray = this.fLangData.getUndefOptionsForKind(this.getKind());
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            List list = (List)option.getValue();
            if (list.size() != 0) {
                if (set == null) {
                    set = new HashSet();
                }
                set.addAll(list);
            }
            ++n2;
        }
        return set;
    }

    private PathInfo fromBuildToProj(PathInfo info) {
        String projPath;
        if (info.isAbsolute()) {
            return info;
        }
        Path path = new Path(info.getUnresolvedPath());
        if (path.segmentCount() != 0 && "..".equals(path.segment(0))) {
            projPath = path.removeFirstSegments(1).toString();
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getBuildDitName()).append('/').append(info.getUnresolvedPath());
            projPath = buf.toString();
        }
        return new PathInfo(projPath, info.isWorkspacePath(), info.getSubstitutor());
    }

    private PathInfo fromProjToBuild(PathInfo info) {
        String projPath;
        if (info.isAbsolute()) {
            return info;
        }
        Path path = new Path(info.getUnresolvedPath());
        if (path.segmentCount() != 0 && this.getBuildDitName().equals(path.segment(0))) {
            projPath = path.removeFirstSegments(1).toString();
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("../").append(info.getUnresolvedPath());
            projPath = buf.toString();
        }
        return new PathInfo(projPath, info.isWorkspacePath(), info.getSubstitutor());
    }

    private String[] resolve(String v, IOption option, SupplierBasedCdtVariableSubstitutor sub) {
        try {
            return CdtVariableResolver.resolveToStringList((String)v, (IVariableSubstitutor)sub);
        }
        catch (CdtVariableException e) {
            ManagedBuilderCorePlugin.log(e);
            return new String[0];
        }
    }

    private OptionStringValue[] resolve(OptionStringValue ov, IOption option, SupplierBasedCdtVariableSubstitutor sub) {
        String value = ov.getValue();
        value = BuildEntryStorage.stripQuotes(value, false);
        String[] rValues = this.resolve(value, option, sub);
        OptionStringValue[] result = new OptionStringValue[rValues.length];
        int i = 0;
        while (i < result.length) {
            result[i] = BuildEntryStorage.substituteValue(ov, BuildEntryStorage.stripQuotes(rValues[i], false));
            ++i;
        }
        return result;
    }

    private ICLanguageSettingEntry[] getEnvEntries(int flags) {
        String[] paths = null;
        int kind = this.getKind();
        switch (kind) {
            case 1: {
                IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
                paths = provider.getBuildPaths(this.fLangData.getConfiguration(), 1);
                break;
            }
            case 16: {
                IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
                paths = provider.getBuildPaths(this.fLangData.getConfiguration(), 2);
            }
        }
        if (paths != null && paths.length != 0) {
            ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[paths.length];
            int i = 0;
            while (i < paths.length) {
                entries[i] = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)paths[i].toString(), null, null, (int)flags);
                ++i;
            }
            return entries;
        }
        return new ICLanguageSettingEntry[0];
    }

    private ICLanguageSettingEntry createUserEntry(Option option, OptionStringValue optionValue, int flags, SupplierBasedCdtVariableSubstitutor subst) {
        IPath path;
        int kind = this.getKind();
        if (kind == 4) {
            String[] nv = BuildEntryStorage.macroNameValueFromValue(optionValue.getValue());
            return CDataUtil.createCMacroEntry((String)nv[0], (String)nv[1], (int)flags);
        }
        Path srcPath = null;
        Path srcRootPath = null;
        Path srcPrefixMapping = null;
        IOptionPathConverter optionPathConverter = this.fLangData.getTool().getOptionPathConverter();
        PathInfo pInfo = BuildEntryStorage.optionPathValueToEntry(optionValue.getValue(), subst);
        if (pInfo.isWorkspacePath()) {
            flags |= 8;
        } else if (optionPathConverter != null && (path = optionPathConverter.convertToPlatformLocation(pInfo.getUnresolvedPath(), option, this.fLangData.getTool())) != null) {
            pInfo = new PathInfo(path.toString(), false, subst);
        }
        if (BuildEntryStorage.getOptionType(option) != 6) {
            pInfo = this.fromBuildToProj(pInfo);
        } else {
            flags &= 0xFFFFFFF7;
            pInfo = new PathInfo(optionValue.getValue(), false, subst);
        }
        if (kind == 32) {
            String tmp = optionValue.getSourceAttachmentPath();
            if (tmp != null) {
                srcPath = new Path(tmp);
            }
            if ((tmp = optionValue.getSourceAttachmentRootPath()) != null) {
                srcRootPath = new Path(tmp);
            }
            if ((tmp = optionValue.getSourceAttachmentPrefixMapping()) != null) {
                srcPrefixMapping = new Path(tmp);
            }
        }
        return (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)pInfo.getUnresolvedPath(), null, null, (int)flags, (IPath)srcPath, srcRootPath, srcPrefixMapping);
    }

    private OptionStringValue createOptionValue(IOption option, UserEntryInfo info, SupplierBasedCdtVariableSubstitutor subst) {
        if (info.fOriginalValue != null) {
            return info.fOriginalValue;
        }
        return this.entryValueToOption(option, info.fEntry, subst);
    }

    private OptionStringValue entryValueToOption(IOption option, ICLanguageSettingEntry entry, SupplierBasedCdtVariableSubstitutor subst) {
        String optionValue = this.entryValueToOptionStringValue(option, entry, subst);
        if (entry.getKind() == 32) {
            ICLibraryFileEntry libFile = (ICLibraryFileEntry)entry;
            return new OptionStringValue(optionValue, false, BuildEntryStorage.pathToString(libFile.getSourceAttachmentPath()), BuildEntryStorage.pathToString(libFile.getSourceAttachmentRootPath()), BuildEntryStorage.pathToString(libFile.getSourceAttachmentPrefixMapping()));
        }
        return new OptionStringValue(optionValue);
    }

    private static String pathToString(IPath path) {
        return path != null ? path.toString() : null;
    }

    private String entryValueToOptionStringValue(IOption option, ICLanguageSettingEntry entry, SupplierBasedCdtVariableSubstitutor subst) {
        String result;
        boolean checkQuote = true;
        if (entry.getKind() == 4 && entry.getValue().length() > 0) {
            result = entry.getName() + '=' + entry.getValue();
        } else if (entry instanceof ICLanguageSettingPathEntry) {
            IOptionPathConverter converter = this.fLangData.getTool().getOptionPathConverter();
            if (converter instanceof IReverseOptionPathConverter) {
                result = ((IReverseOptionPathConverter)((Object)converter)).convertToOptionValue((ICSettingEntry)entry, option, this.fLangData.getTool());
                checkQuote = false;
            } else {
                ICLanguageSettingPathEntry pathEntry = (ICLanguageSettingPathEntry)entry;
                result = this.doConvertToOptionValue(option, pathEntry, subst);
            }
        } else {
            result = entry.getName();
        }
        if (checkQuote) {
            result = BuildEntryStorage.doubleQuotePath(result, false);
        }
        return result;
    }

    private String doConvertToOptionValue(IOption option, ICLanguageSettingPathEntry pathEntry, SupplierBasedCdtVariableSubstitutor subst) {
        String result;
        boolean isWsp = pathEntry.isValueWorkspacePath();
        PathInfo pInfo = new PathInfo(pathEntry.getName(), isWsp, subst);
        if (isWsp) {
            if (!pInfo.isAbsolute()) {
                IConfiguration cfg = this.fLangData.getConfiguration();
                IResource rc = cfg.getOwner();
                if (rc != null) {
                    IProject proj = rc.getProject();
                    String path = pInfo.getUnresolvedPath();
                    IPath p = proj.getFullPath().append(path);
                    result = p.toString();
                } else {
                    result = pathEntry.getName();
                }
            } else {
                result = pathEntry.getName();
            }
            result = ManagedBuildManager.fullPathToLocation(result);
        } else {
            if (BuildEntryStorage.getOptionType(option) != 6) {
                pInfo = this.fromProjToBuild(pInfo);
            }
            result = pInfo.getUnresolvedPath();
        }
        return result;
    }

    private static int getOptionType(IOption option) {
        try {
            return option.getValueType();
        }
        catch (BuildException e) {
            ManagedBuilderCorePlugin.log(e);
            return 2;
        }
    }

    private static String doubleQuotePath(String pathName, boolean nullIfNone) {
        boolean bStartsWithQuote = ((String)(pathName = ((String)pathName).trim())).indexOf(34) == 0;
        boolean bEndsWithQuote = ((String)pathName).lastIndexOf(34) == ((String)pathName).length() - 1;
        boolean quoted = false;
        int i = ((String)pathName).indexOf(32) + ((String)pathName).indexOf(92) + ((String)pathName).indexOf("${");
        if (i != -3) {
            if (!bStartsWithQuote) {
                pathName = "\"" + (String)pathName;
                quoted = true;
            }
            if (!bEndsWithQuote) {
                pathName = (String)pathName + "\"";
                quoted = true;
            }
        }
        if (quoted) {
            return pathName;
        }
        return nullIfNone ? null : pathName;
    }

    public static String[] macroNameValueFromValue(String value) {
        String[] nv = new String[2];
        int index = value.indexOf(61);
        if (index > 0) {
            nv[0] = value.substring(0, index);
            nv[1] = value.substring(index + 1);
        } else {
            nv[0] = value;
            nv[1] = "";
        }
        return nv;
    }

    private static String locationToFullPath(String path) {
        if (!(path = path.trim()).startsWith("${workspace_loc:")) {
            return null;
        }
        int index = -1;
        int depth = 1;
        int i = "${workspace_loc:".length();
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '}') {
                if (--depth < 1) {
                    index = i;
                    break;
                }
            } else if (c == '{' && path.charAt(i - 1) == '$') {
                ++depth;
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        String varName = "workspace_loc";
        String str1 = path.substring(2, index);
        Object result = null;
        if (str1.startsWith(varName)) {
            String str2 = str1.substring(varName.length());
            if (str2.length() != 0) {
                if (str2.startsWith(":")) {
                    result = str2.substring(1);
                }
            } else {
                result = "/";
            }
            if (index < path.length() - 1) {
                result = (String)result + path.substring(index + 1);
            }
        }
        return result;
    }

    private static PathInfo optionPathValueToEntry(String str, SupplierBasedCdtVariableSubstitutor subst) {
        String unresolvedStr = BuildEntryStorage.locationToFullPath(str);
        boolean isWorkspacePath = false;
        if (unresolvedStr == null) {
            unresolvedStr = str;
        } else if (!unresolvedStr.startsWith("${workspace_loc}")) {
            isWorkspacePath = true;
        }
        return new PathInfo(unresolvedStr, isWorkspacePath, subst);
    }

    private void setUserEntries(UserEntryInfo[] entries, List<EmptyEntryInfo> emptyEntryInfos) {
        int kind = this.getKind();
        IOption[] options = this.fLangData.getOptionsForKind(kind);
        if (options.length > 1) {
            ManagedBuilderCorePlugin.error("Unexpected error: Warning more than one options found for kind " + this.getKind());
        }
        if (options.length != 0) {
            OptionStringValue[] optValue;
            IOption option = options[0];
            if (entries.length != 0) {
                entries = this.combineSequenses(entries);
                entries = this.addEmptyEntries(entries, emptyEntryInfos);
                optValue = new OptionStringValue[entries.length];
                SupplierBasedCdtVariableSubstitutor subst = this.createSubstitutor(option, false);
                int i = 0;
                while (i < entries.length) {
                    optValue[i] = this.createOptionValue(option, entries[i], subst);
                    ++i;
                }
            } else {
                optValue = Option.EMPTY_LV_ARRAY;
            }
            ITool tool = this.fLangData.getTool();
            IResourceInfo rcInfo = tool.getParentResourceInfo();
            IOption newOption = ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, optValue);
            IOption[] iOptionArray = this.fLangData.getOptionsForKind(kind);
            int n = iOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOption opt = iOptionArray[n2];
                if (opt != newOption) {
                    ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, opt, new String[0]);
                }
                ++n2;
            }
        }
    }

    private UserEntryInfo[] addEmptyEntries(UserEntryInfo[] infos, List<EmptyEntryInfo> emptyEntryInfos) {
        if (emptyEntryInfos == null || emptyEntryInfos.size() == 0) {
            return infos;
        }
        LinkedList<UserEntryInfo> list = new LinkedList<UserEntryInfo>();
        list.addAll(Arrays.asList(infos));
        int i = 0;
        while (i < emptyEntryInfos.size()) {
            EmptyEntryInfo ei = emptyEntryInfos.get(i);
            int index = ei.fPosition;
            if (index > list.size()) {
                index = list.size();
            }
            list.add(index, new UserEntryInfo(null, ei.fOriginalValue, ei.fOriginalValue, null));
            ++i;
        }
        return list.toArray(new UserEntryInfo[list.size()]);
    }

    private UserEntryInfo[] combineSequenses(UserEntryInfo[] infos) {
        if (infos.length == 0) {
            return infos;
        }
        ArrayList<UserEntryInfo> list = new ArrayList<UserEntryInfo>(infos.length);
        int i = 0;
        while (i < infos.length) {
            UserEntryInfo info = infos[i];
            if (info.fSequense != null) {
                int k;
                boolean match = true;
                int seqSize = info.fSequense.size();
                if (seqSize > infos.length - i) {
                    match = false;
                } else {
                    k = 0;
                    while (k < seqSize) {
                        if (info.fSequense.get(k) != infos[i + k]) {
                            match = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (match) {
                    i = i + seqSize - 1;
                } else {
                    infos[i] = BuildEntryStorage.createDesequencedEntry(info);
                    k = i + 1;
                    while (k < infos.length) {
                        if (infos[k].fSequense == info.fSequense) {
                            infos[k] = BuildEntryStorage.createDesequencedEntry(infos[k]);
                        }
                        ++k;
                    }
                    info = infos[i];
                }
            }
            list.add(info);
            ++i;
        }
        return list.toArray(new UserEntryInfo[list.size()]);
    }

    private static UserEntryInfo createDesequencedEntry(UserEntryInfo info) {
        String v;
        OptionStringValue resolvedValue = info.fBsResolvedValue;
        if (resolvedValue != null && (v = BuildEntryStorage.doubleQuotePath(resolvedValue.getValue(), true)) != null) {
            resolvedValue = BuildEntryStorage.substituteValue(resolvedValue, v);
        }
        return new UserEntryInfo(info.fEntry, resolvedValue, resolvedValue, null);
    }

    private void setUserUndefinedStringSet(Set<String> set) {
        int kind = this.getKind();
        IOption[] options = this.fLangData.getUndefOptionsForKind(kind);
        if (options.length != 0) {
            if (set != null && set.size() == 0) {
                set = null;
            }
            String[] optValue = set != null ? set.toArray(new String[set.size()]) : new String[]{};
            IOption option = options[0];
            ITool tool = this.fLangData.getTool();
            IResourceInfo rcInfo = tool.getParentResourceInfo();
            IOption newOption = ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, optValue);
            IOption[] iOptionArray = options = this.fLangData.getUndefOptionsForKind(kind);
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                IOption opt = iOptionArray[n2];
                if (opt != newOption) {
                    ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, new String[0]);
                }
                ++n2;
            }
        }
    }

    void optionsChanged() {
    }

    private static class EmptyEntryInfo {
        private OptionStringValue fOriginalValue;
        private int fPosition;

        EmptyEntryInfo(OptionStringValue value, int position) {
            this.fOriginalValue = value;
            this.fPosition = position;
        }
    }

    private static class UserEntryInfo {
        private ICLanguageSettingEntry fEntry;
        private OptionStringValue fOriginalValue;
        private OptionStringValue fBsResolvedValue;
        private List<UserEntryInfo> fSequense;

        UserEntryInfo(ICLanguageSettingEntry entry, OptionStringValue originalValue, OptionStringValue bsResolvedValue, List<UserEntryInfo> sequense) {
            this.fEntry = entry;
            this.fOriginalValue = originalValue;
            this.fBsResolvedValue = bsResolvedValue;
            this.fSequense = sequense;
            if (sequense != null) {
                sequense.add(this);
            }
        }
    }
}

