/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Triple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.dawg.Dawg;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMCompareTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.PatternCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EMatching {
    private final QuantifierTheory mQuantTheory;
    private Deque<Triple<ICode, CCTerm[], Integer>> mTodoStack;
    private final Map<Integer, EMUndoInformation> mUndoInformation;
    private final Map<QuantLiteral, Dawg<Term, SubstitutionInfo>> mAtomSubsDawgs;
    private final Map<QuantClause, ArrayList<Triple<ICode, CCTerm[], Integer>>> mClauseCodes;
    private final Set<QuantLiteral> mEmatchingAtoms;
    private final Set<QuantLiteral> mPartialEmatchingAtoms;
    final SubstitutionInfo mEmptySubs;

    public EMatching(QuantifierTheory quantifierTheory) {
        this.mQuantTheory = quantifierTheory;
        this.mTodoStack = new ArrayDeque<Triple<ICode, CCTerm[], Integer>>();
        this.mAtomSubsDawgs = new HashMap<QuantLiteral, Dawg<Term, SubstitutionInfo>>();
        this.mClauseCodes = new HashMap<QuantClause, ArrayList<Triple<ICode, CCTerm[], Integer>>>();
        this.mUndoInformation = new LinkedHashMap<Integer, EMUndoInformation>();
        this.mEmptySubs = new SubstitutionInfo(new ArrayList<CCTerm>(), new LinkedHashMap<Term, CCTerm>());
        this.mEmatchingAtoms = new HashSet<QuantLiteral>();
        this.mPartialEmatchingAtoms = new HashSet<QuantLiteral>();
    }

    public void addClause(QuantClause quantClause) {
        assert (!this.mClauseCodes.containsKey(quantClause));
        ArrayList<Triple<ICode, CCTerm[], Integer>> arrayList = new ArrayList<Triple<ICode, CCTerm[], Integer>>();
        QuantLiteral[] quantLiteralArray = quantClause.getQuantLits();
        int n = quantLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            QuantLiteral quantLiteral = quantLiteralArray[n2];
            QuantLiteral quantLiteral2 = quantLiteral.getAtom();
            if (!quantLiteral.isArithmetical() && QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(quantLiteral2)) {
                Pair<ICode, CCTerm[]> pair;
                this.mAtomSubsDawgs.put(quantLiteral2, Dawg.createConst(quantClause.getVars().length, this.mEmptySubs));
                LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
                if (quantLiteral2 instanceof QuantEquality) {
                    pair = (QuantEquality)quantLiteral2;
                    Term term = ((QuantEquality)((Object)pair)).getLhs();
                    Term term2 = ((QuantEquality)((Object)pair)).getRhs();
                    if (!term.getSort().isNumericSort()) {
                        if (!(term instanceof TermVariable)) {
                            linkedHashSet.add(term);
                        }
                        if (!(term2 instanceof TermVariable)) {
                            linkedHashSet.add(((QuantEquality)((Object)pair)).getRhs());
                        }
                    } else {
                        Polynomial polynomial = new Polynomial(term);
                        Polynomial polynomial2 = new Polynomial(((QuantEquality)((Object)pair)).getRhs());
                        linkedHashSet.addAll(this.getSubPatterns(polynomial));
                        linkedHashSet.addAll(this.getSubPatterns(polynomial2));
                    }
                } else {
                    pair = ((QuantBoundConstraint)quantLiteral2).getAffineTerm();
                    linkedHashSet.addAll(this.getSubPatterns((Polynomial)((Object)pair)));
                }
                if (linkedHashSet.isEmpty() || !QuantUtil.containsAppTermsForEachVar(quantLiteral2)) {
                    this.mPartialEmatchingAtoms.add(quantLiteral2);
                } else {
                    this.mEmatchingAtoms.add(quantLiteral2);
                }
                if (!linkedHashSet.isEmpty()) {
                    pair = new PatternCompiler(this.mQuantTheory, quantLiteral2, linkedHashSet.toArray(new Term[linkedHashSet.size()])).compile();
                    this.addCode(pair.getFirst(), pair.getSecond(), 0);
                    arrayList.add(new Triple<ICode, CCTerm[], Integer>(pair.getFirst(), pair.getSecond(), 0));
                }
            }
            ++n2;
        }
        this.mClauseCodes.put(quantClause, arrayList);
    }

    public void removeClause(QuantClause quantClause) {
        this.mClauseCodes.remove(quantClause);
        QuantLiteral[] quantLiteralArray = quantClause.getQuantLits();
        int n = quantLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            QuantLiteral quantLiteral = quantLiteralArray[n2];
            this.mEmatchingAtoms.remove(quantLiteral.getAtom());
            this.mPartialEmatchingAtoms.remove(quantLiteral.getAtom());
            this.mAtomSubsDawgs.remove(quantLiteral.getAtom());
            ++n2;
        }
    }

    public void removeAllTriggers() {
        this.undo(-1);
    }

    public void reAddClauses(Iterable<QuantClause> iterable) {
        assert (this.mTodoStack.isEmpty() && this.mUndoInformation.isEmpty());
        for (QuantClause quantClause : iterable) {
            assert (this.mClauseCodes.containsKey(quantClause));
            for (Triple<ICode, CCTerm[], Integer> triple : this.mClauseCodes.get(quantClause)) {
                this.mTodoStack.add(triple);
            }
        }
    }

    private Collection<Term> getSubPatterns(Polynomial polynomial) {
        assert (QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(polynomial));
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
            for (Term term : map.keySet()) {
                if (term instanceof TermVariable || term.getFreeVars().length == 0) continue;
                linkedHashSet.add(term);
            }
        }
        return linkedHashSet;
    }

    public void run() {
        long l = System.nanoTime();
        while (!this.mTodoStack.isEmpty() && !this.mQuantTheory.getEngine().isTerminationRequested()) {
            Triple<ICode, CCTerm[], Integer> triple = this.mTodoStack.pop();
            triple.getFirst().execute(triple.getSecond(), triple.getThird());
        }
        this.mQuantTheory.addEMatchingTime(System.nanoTime() - l);
    }

    public void undo(int n) {
        Map.Entry<Integer, EMUndoInformation> entry;
        Iterator<Map.Entry<Integer, EMUndoInformation>> iterator = this.mUndoInformation.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if ((Integer)entry.getKey() <= n) continue;
            ((EMUndoInformation)entry.getValue()).undo();
            iterator.remove();
        }
        entry = new ArrayDeque();
        for (Triple<ICode, CCTerm[], Integer> triple : this.mTodoStack) {
            if (triple.getThird() > n) continue;
            entry.add(triple);
        }
        this.mTodoStack = entry;
    }

    public Dawg<Term, SubstitutionInfo> getSubstitutionInfos(QuantLiteral quantLiteral) {
        assert (this.mAtomSubsDawgs.containsKey(quantLiteral) && this.mAtomSubsDawgs.get(quantLiteral) != null);
        return this.mAtomSubsDawgs.get(quantLiteral);
    }

    public SubstitutionInfo getEmptySubs() {
        return this.mEmptySubs;
    }

    public QuantifierTheory getQuantTheory() {
        return this.mQuantTheory;
    }

    void addCode(ICode iCode, CCTerm[] cCTermArray, int n) {
        Triple<ICode, CCTerm[], Integer> triple = new Triple<ICode, CCTerm[], Integer>(iCode, cCTermArray, n);
        this.mTodoStack.add(triple);
    }

    void addInterestingSubstitution(QuantLiteral quantLiteral, List<CCTerm> list, Map<Term, CCTerm> map, int n) {
        long l = System.nanoTime();
        assert (this.mAtomSubsDawgs.containsKey(quantLiteral));
        Dawg<Term, SubstitutionInfo> dawg = this.mAtomSubsDawgs.get(quantLiteral);
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size());
        int n2 = 0;
        while (n2 < quantLiteral.getClause().getVars().length) {
            arrayList.add(list.get(n2) == null ? null : list.get(n2).getFlatTerm());
            ++n2;
        }
        SubstitutionInfo substitutionInfo = new SubstitutionInfo(list, map);
        dawg = dawg.insert(arrayList, substitutionInfo);
        this.mAtomSubsDawgs.put(quantLiteral, dawg);
        this.mQuantTheory.addDawgTime(System.nanoTime() - l);
        this.addUndoInformation(quantLiteral, arrayList, n);
    }

    void installCompareTrigger(CCTerm cCTerm, CCTerm cCTerm2, ICode iCode, CCTerm[] cCTermArray, int n) {
        assert (n <= this.mQuantTheory.getClausifier().getEngine().getDecideLevel());
        EMCompareTrigger eMCompareTrigger = new EMCompareTrigger(this, cCTerm, cCTerm2, iCode, cCTermArray, n);
        this.mQuantTheory.getCClosure().insertCompareTrigger(cCTerm, cCTerm2, eMCompareTrigger);
        this.addUndoInformation(eMCompareTrigger, n);
    }

    void installFindTrigger(FunctionSymbol functionSymbol, int n, ICode iCode, CCTerm[] cCTermArray, int n2) {
        EMReverseTrigger eMReverseTrigger = new EMReverseTrigger(this, iCode, functionSymbol, -1, null, cCTermArray, n, n2);
        this.mQuantTheory.getCClosure().insertReverseTrigger(functionSymbol, eMReverseTrigger);
        this.addUndoInformation(eMReverseTrigger, n2);
    }

    void installReverseTrigger(FunctionSymbol functionSymbol, CCTerm cCTerm, int n, int n2, ICode iCode, CCTerm[] cCTermArray, int n3) {
        EMReverseTrigger eMReverseTrigger = new EMReverseTrigger(this, iCode, functionSymbol, n, cCTerm, cCTermArray, n2, n3);
        this.mQuantTheory.getCClosure().insertReverseTrigger(functionSymbol, cCTerm, n, eMReverseTrigger);
        this.addUndoInformation(eMReverseTrigger, n3);
    }

    private void addUndoInformation(EMCompareTrigger eMCompareTrigger, int n) {
        EMUndoInformation eMUndoInformation = this.getUndoInformationForLevel(n);
        eMUndoInformation.mCompareTriggers.add(eMCompareTrigger);
    }

    private void addUndoInformation(EMReverseTrigger eMReverseTrigger, int n) {
        EMUndoInformation eMUndoInformation = this.getUndoInformationForLevel(n);
        eMUndoInformation.mReverseTriggers.add(eMReverseTrigger);
    }

    private void addUndoInformation(QuantLiteral quantLiteral, List<Term> list, int n) {
        EMUndoInformation eMUndoInformation = this.getUndoInformationForLevel(n);
        if (!eMUndoInformation.mLitSubs.containsKey(quantLiteral)) {
            eMUndoInformation.mLitSubs.put(quantLiteral, new ArrayList());
        }
        eMUndoInformation.mLitSubs.get(quantLiteral).add(list);
    }

    private EMUndoInformation getUndoInformationForLevel(int n) {
        if (!this.mUndoInformation.containsKey(n)) {
            this.mUndoInformation.put(n, new EMUndoInformation());
        }
        return this.mUndoInformation.get(n);
    }

    public boolean isUsingEmatching(QuantLiteral quantLiteral) {
        return this.mEmatchingAtoms.contains(quantLiteral.getAtom());
    }

    public boolean isPartiallyUsingEmatching(QuantLiteral quantLiteral) {
        return this.mPartialEmatchingAtoms.contains(quantLiteral.getAtom());
    }

    class EMUndoInformation {
        final Collection<EMCompareTrigger> mCompareTriggers = new ArrayList<EMCompareTrigger>();
        final Collection<EMReverseTrigger> mReverseTriggers = new ArrayList<EMReverseTrigger>();
        final Map<QuantLiteral, Collection<List<Term>>> mLitSubs = new LinkedHashMap<QuantLiteral, Collection<List<Term>>>();

        EMUndoInformation() {
        }

        void undo() {
            for (EMCompareTrigger object : this.mCompareTriggers) {
                EMatching.this.mQuantTheory.getCClosure().removeCompareTrigger(object);
            }
            for (EMReverseTrigger eMReverseTrigger : this.mReverseTriggers) {
                EMatching.this.mQuantTheory.getCClosure().removeReverseTrigger(eMReverseTrigger);
            }
            for (Map.Entry entry : this.mLitSubs.entrySet()) {
                Dawg<Term, SubstitutionInfo> dawg = EMatching.this.mAtomSubsDawgs.get(entry.getKey());
                for (List list : (Collection)entry.getValue()) {
                    dawg = dawg.insert(list, EMatching.this.mEmptySubs);
                }
                EMatching.this.mAtomSubsDawgs.put((QuantLiteral)entry.getKey(), dawg);
            }
        }
    }

    public class SubstitutionInfo {
        final List<CCTerm> mVarSubs;
        final Map<Term, CCTerm> mEquivalentCCTerms;

        SubstitutionInfo(List<CCTerm> list, Map<Term, CCTerm> map) {
            this.mVarSubs = list;
            this.mEquivalentCCTerms = map;
        }

        public List<CCTerm> getVarSubs() {
            return this.mVarSubs;
        }

        public Map<Term, CCTerm> getEquivalentCCTerms() {
            return this.mEquivalentCCTerms;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Variable Subs: [" + this.mVarSubs.toString());
            stringBuilder.append("]\nEquivalent CCTerms: " + this.mEquivalentCCTerms.toString());
            return stringBuilder.toString();
        }

        public int hashCode() {
            return this.mEquivalentCCTerms.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof SubstitutionInfo) {
                SubstitutionInfo substitutionInfo = (SubstitutionInfo)object;
                return this.mVarSubs.equals(substitutionInfo.getVarSubs()) && this.mEquivalentCCTerms.equals(substitutionInfo.getEquivalentCCTerms());
            }
            return false;
        }
    }
}

