/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginConnector;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.GraphNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.DropmodelType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ModelIdOnlyType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SerializeType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SubchainType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainModelType;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.ITimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainCancel;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

final class ToolchainWalker
implements IToolchainCancel {
    private static final int INITIAL_COUNTDOWN = 2;
    private boolean mToolchainCancelRequest;
    private final ILogger mLogger;
    private final Map<String, PluginConnector> mOpenPlugins;
    private final Benchmark mBench;
    private final IModelManager mModelManager;
    private final PluginFactory mPluginFactory;
    private final CountDownLatch mCountDownLatch;

    ToolchainWalker(Benchmark benchmark, IModelManager iModelManager, PluginFactory pluginFactory, ILogger iLogger) {
        assert (iLogger != null);
        this.mBench = benchmark;
        this.mModelManager = iModelManager;
        this.mLogger = iLogger;
        this.mPluginFactory = pluginFactory;
        this.mOpenPlugins = new HashMap<String, PluginConnector>();
        this.mCountDownLatch = new CountDownLatch(2);
        this.mToolchainCancelRequest = false;
    }

    IToolchain.ReturnCode walk(IToolchain<?> iToolchain, CompleteToolchainData completeToolchainData, IProgressMonitorService iProgressMonitorService, IToolchainProgressMonitor iToolchainProgressMonitor) throws Throwable {
        if (this.mCountDownLatch.getCount() != 2L) {
            throw new IllegalStateException("You cannot reuse the toolchain walker");
        }
        try {
            IToolchain.ReturnCode returnCode = this.walkUnprotected(completeToolchainData, iProgressMonitorService, iToolchainProgressMonitor);
            return returnCode;
        }
        finally {
            this.mCountDownLatch.countDown();
            iToolchainProgressMonitor.done();
        }
    }

    public CountDownLatch cancelToolchain() {
        this.mToolchainCancelRequest = true;
        return this.mCountDownLatch;
    }

    void endToolchain() {
        this.mCountDownLatch.countDown();
    }

    private IToolchain.ReturnCode walkUnprotected(CompleteToolchainData completeToolchainData, IProgressMonitorService iProgressMonitorService, IToolchainProgressMonitor iToolchainProgressMonitor) throws Throwable {
        IToolchainData<RunDefinition> iToolchainData = completeToolchainData.getToolchainData();
        int n = ((RunDefinition)iToolchainData.getRootElement()).getToolchain().getPluginOrSubchain().size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)RcpProgressMonitorWrapper.create(iToolchainProgressMonitor), (int)n);
        this.mLogger.info((Object)("Walking toolchain with " + n + " elements."));
        for (Object e : ((RunDefinition)iToolchainData.getRootElement()).getToolchain().getPluginOrSubchain()) {
            IToolchain.ReturnCode returnCode;
            if (e instanceof PluginType) {
                var10_10 = (PluginType)e;
                if (this.shouldCancel(completeToolchainData, iProgressMonitorService, iToolchainProgressMonitor, var10_10.getId())) {
                    return IToolchain.ReturnCode.Cancel;
                }
                returnCode = this.processPlugin(completeToolchainData, var10_10);
                subMonitor.worked(1);
                subMonitor.setWorkRemaining(--n);
            } else if (e instanceof SubchainType) {
                var10_10 = (SubchainType)e;
                if (this.shouldCancel(completeToolchainData, iProgressMonitorService, iToolchainProgressMonitor, var10_10.toString())) {
                    return IToolchain.ReturnCode.Cancel;
                }
                returnCode = this.processSubchain(completeToolchainData, (SubchainType)var10_10, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.worked(1);
                subMonitor.setWorkRemaining(--n);
            } else {
                if (e != null) {
                    this.mLogger.warn((Object)("Unknown toolchain element " + e.getClass().getSimpleName() + ", skipping..."));
                } else {
                    this.mLogger.warn((Object)"Toolchain element is NULL, skipping...");
                }
                returnCode = IToolchain.ReturnCode.Ok;
            }
            switch (returnCode) {
                case Error: 
                case Cancel: {
                    return returnCode;
                }
                case Ok: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown return code");
                }
            }
        }
        return IToolchain.ReturnCode.Ok;
    }

    private boolean shouldCancel(CompleteToolchainData completeToolchainData, IProgressMonitorService iProgressMonitorService, IToolchainProgressMonitor iToolchainProgressMonitor, String string) {
        if (this.mToolchainCancelRequest || iToolchainProgressMonitor.isCanceled()) {
            this.mLogger.info((Object)("Toolchain execution was canceled (user or tool) before executing " + string));
            return true;
        }
        if (!iProgressMonitorService.continueProcessing()) {
            Collection collection = ResultUtil.filterResults((Map)completeToolchainData.getServices().getResultService().getResults(), ITimeoutResult.class);
            if (collection.isEmpty()) {
                completeToolchainData.getServices().getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new TimeoutResult("de.uni_freiburg.informatik.ultimate.core", "Timeout occured before executing " + string));
            }
            this.mLogger.info((Object)("Toolchain execution was canceled (Timeout) before executing " + string));
            return true;
        }
        return false;
    }

    private IToolchain.ReturnCode processPlugin(CompleteToolchainData completeToolchainData, PluginType pluginType) {
        PluginConnector pluginConnector;
        ITool iTool = (ITool)this.mPluginFactory.createTool(pluginType.getId());
        if (iTool == null) {
            this.mLogger.error((Object)("Couldn't identify tool for plugin id " + pluginType.getId() + "!"));
            this.mToolchainCancelRequest = true;
            return IToolchain.ReturnCode.Cancel;
        }
        if (!this.mOpenPlugins.containsKey(pluginType.getId())) {
            pluginConnector = new PluginConnector(completeToolchainData.getToolchain(), this.mModelManager, iTool, completeToolchainData.getController());
            this.mOpenPlugins.put(pluginType.getId(), pluginConnector);
        } else {
            pluginConnector = this.mOpenPlugins.get(pluginType.getId());
        }
        if (this.mBench != null) {
            this.mBench.start(pluginConnector.toString());
        }
        return this.executePluginConnector(completeToolchainData, pluginType, pluginConnector);
    }

    private IToolchain.ReturnCode executePluginConnector(CompleteToolchainData completeToolchainData, PluginType pluginType, PluginConnector pluginConnector) {
        try {
            pluginConnector.run();
            IToolchain.ReturnCode returnCode = IToolchain.ReturnCode.Ok;
            return returnCode;
        }
        catch (Throwable throwable) {
            IToolchain.ReturnCode returnCode = this.handleException(completeToolchainData, pluginType, throwable);
            return returnCode;
        }
        finally {
            DropmodelType dropmodelType;
            SerializeType serializeType;
            if (this.mBench != null) {
                this.mBench.stop(pluginConnector.toString());
            }
            if ((serializeType = pluginType.getSerialize()) != null) {
                this.processSerializeStmt(completeToolchainData, serializeType);
            }
            if ((dropmodelType = pluginType.getDropmodels()) != null) {
                this.processDropmodelStmt(completeToolchainData, dropmodelType);
            }
        }
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData completeToolchainData, PluginType pluginType, ToolchainCanceledException toolchainCanceledException) {
        this.mLogger.info((Object)("Toolchain cancelled while executing plugin " + pluginType.getId() + ". Reason: " + toolchainCanceledException.getMessage()));
        String string = "Toolchain cancelled " + toolchainCanceledException.printRunningTaskMessage();
        TimeoutResult timeoutResult = new TimeoutResult(pluginType.getId(), string);
        completeToolchainData.getServices().getResultService().reportResult(pluginType.getId(), (IResult)timeoutResult);
        return IToolchain.ReturnCode.Cancel;
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData completeToolchainData, PluginType pluginType, SMTLIBException sMTLIBException) {
        this.mLogger.fatal((Object)"An unrecoverable error occured during an interaction with an SMT solver:", (Throwable)sMTLIBException);
        ToolchainWalker.reportExceptionOrError(completeToolchainData, pluginType.getId(), (Throwable)sMTLIBException);
        return IToolchain.ReturnCode.Error;
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData completeToolchainData, PluginType pluginType, ToolchainExceptionWrapper toolchainExceptionWrapper) {
        this.mLogger.fatal((Object)"A wrapped exception occured:", (Throwable)toolchainExceptionWrapper);
        return this.handleException(completeToolchainData, pluginType, toolchainExceptionWrapper.getCause());
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData completeToolchainData, PluginType pluginType, Throwable throwable) {
        if (throwable instanceof ToolchainExceptionWrapper) {
            return this.handleException(completeToolchainData, pluginType, (ToolchainExceptionWrapper)throwable);
        }
        if (throwable instanceof SMTLIBException) {
            return this.handleException(completeToolchainData, pluginType, (SMTLIBException)throwable);
        }
        if (throwable instanceof ToolchainCanceledException) {
            return this.handleException(completeToolchainData, pluginType, (ToolchainCanceledException)throwable);
        }
        return this.handleExceptionFallback(completeToolchainData, pluginType, throwable);
    }

    private IToolchain.ReturnCode handleExceptionFallback(CompleteToolchainData completeToolchainData, PluginType pluginType, Throwable throwable) {
        String string = pluginType.getId();
        this.mLogger.fatal((Object)("The Plugin " + string + " has thrown an exception:"), throwable);
        ToolchainWalker.reportExceptionOrError(completeToolchainData, string, throwable);
        return IToolchain.ReturnCode.Error;
    }

    private static void reportExceptionOrError(CompleteToolchainData completeToolchainData, String string, Throwable throwable) {
        completeToolchainData.getServices().getResultService().reportResult(string, (IResult)new ExceptionOrErrorResult(string, throwable));
    }

    private IToolchain.ReturnCode processSubchain(CompleteToolchainData completeToolchainData, SubchainType subchainType, IProgressMonitor iProgressMonitor) {
        this.mLogger.fatal((Object)"Subchain support is broken");
        return IToolchain.ReturnCode.Error;
    }

    private void processSerializeStmt(CompleteToolchainData completeToolchainData, SerializeType serializeType) {
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        if (serializeType.getParser() != null) {
            ISource[] iSourceArray = completeToolchainData.getParsers();
            int n = iSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISource toolchainModelType = iSourceArray[n2];
                ModelType modelType = this.mModelManager.getGraphTypeByGeneratorPluginId(toolchainModelType.getPluginID());
                if (modelType != null) {
                    arrayList.add(modelType);
                } else {
                    this.mLogger.warn((Object)"Parser model could not be found!");
                }
                ++n2;
            }
        }
        for (ToolchainModelType toolchainModelType : serializeType.getModel()) {
            ModelType modelType = "mostrecent".equals(toolchainModelType.getId()) ? this.mModelManager.getLastAdded() : this.mModelManager.getGraphTypeByGeneratorPluginId(toolchainModelType.getId());
            if (modelType != null) {
                arrayList.add(modelType);
                continue;
            }
            this.mLogger.warn((Object)("Model " + toolchainModelType.getId() + " could not be found!"));
        }
        for (ModelType modelType : arrayList) {
            try {
                this.mLogger.debug((Object)("Attempting to serialize model " + modelType.toString() + " ..."));
                this.mModelManager.persistAndDropExistingGraph(modelType);
                this.mLogger.debug((Object)"Persisting model succeeded.");
            }
            catch (StoreObjectException storeObjectException) {
                this.mLogger.error((Object)"An error occurred while persisting selected model", (Throwable)storeObjectException);
            }
            catch (GraphNotFoundException graphNotFoundException) {
                this.mLogger.error((Object)"Specified graph could not be found.", (Throwable)graphNotFoundException);
            }
        }
    }

    private void processDropmodelStmt(CompleteToolchainData completeToolchainData, DropmodelType dropmodelType) {
        if (dropmodelType.getParser() != null) {
            ISource[] iSourceArray = completeToolchainData.getParsers();
            int n = iSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelIdOnlyType modelIdOnlyType = iSourceArray[n2];
                ModelType modelType = this.mModelManager.getGraphTypeByGeneratorPluginId(modelIdOnlyType.getPluginID());
                this.dropModel(modelType, modelIdOnlyType.getPluginID());
                ++n2;
            }
        }
        for (ModelIdOnlyType modelIdOnlyType : dropmodelType.getModel()) {
            ModelType modelType = this.mModelManager.getGraphTypeByGeneratorPluginId(modelIdOnlyType.getId());
            this.dropModel(modelType, modelIdOnlyType.getId());
        }
    }

    private void dropModel(ModelType modelType, String string) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Attempting to drop model " + string + " ..."));
        }
        if (modelType == null || !this.mModelManager.removeItem(modelType)) {
            this.mLogger.warn((Object)("Failed to remove model " + string));
        } else if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Dropping model succeeded.");
        }
    }

    static final class CompleteToolchainData {
        private final IToolchain<RunDefinition> mToolchain;
        private final ISource[] mParsers;
        private final IController<RunDefinition> mController;

        CompleteToolchainData(IToolchain<RunDefinition> iToolchain, ISource[] iSourceArray, IController<RunDefinition> iController) {
            this.mToolchain = iToolchain;
            this.mParsers = iSourceArray;
            this.mController = iController;
        }

        IToolchain<RunDefinition> getToolchain() {
            return this.mToolchain;
        }

        IToolchainData<RunDefinition> getToolchainData() {
            return this.mToolchain.getCurrentToolchainData();
        }

        ISource[] getParsers() {
            return this.mParsers;
        }

        IController<RunDefinition> getController() {
            return this.mController;
        }

        IUltimateServiceProvider getServices() {
            return this.mToolchain.getCurrentToolchainData().getServices();
        }
    }
}

