/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.results.IFailedAnalysisResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UnprovableResult<ELEM extends IElement, TE extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithFiniteTrace<TE, E>,
IFailedAnalysisResult {
    private final Check mCheckedSpecification;
    private final List<UnprovabilityReason> mUnprovabilityReasons;
    private final IProgramExecution<TE, E> mProgramExecution;
    private final String mProgramExecutionAsString;
    private final List<ILocation> mFailurePath;

    public UnprovableResult(String string, ELEM ELEM, IBacktranslationService iBacktranslationService, IProgramExecution<TE, E> iProgramExecution) {
        this(string, ELEM, iBacktranslationService, iProgramExecution, Collections.emptyList());
    }

    public UnprovableResult(String string, ELEM ELEM, IBacktranslationService iBacktranslationService, IProgramExecution<TE, E> iProgramExecution, String string2) {
        this(string, ELEM, iBacktranslationService, iProgramExecution, Collections.singletonList(new UnprovabilityReason(Objects.requireNonNull(string2))));
    }

    public UnprovableResult(String string, ELEM ELEM, IBacktranslationService iBacktranslationService, IProgramExecution<TE, E> iProgramExecution, List<UnprovabilityReason> list) {
        super(ELEM, string);
        Check check = Check.getAnnotation(ELEM);
        this.mCheckedSpecification = check == null ? new Check(Spec.UNKNOWN) : check;
        this.mUnprovabilityReasons = Objects.requireNonNull(list);
        this.mProgramExecution = iProgramExecution;
        this.mProgramExecutionAsString = this.mProgramExecution == null ? null : iBacktranslationService.translateProgramExecution(this.mProgramExecution).toString();
        this.mFailurePath = ResultUtil.getLocationSequence(iProgramExecution);
    }

    public Check getCheckedSpecification() {
        return this.mCheckedSpecification;
    }

    public String getShortDescription() {
        return "Unable to prove that " + this.mCheckedSpecification.getPositiveMessage();
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getShortDescription());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append(this.getReasons());
        if (this.mProgramExecution != null) {
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append("Possible FailurePath: ");
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append(this.mProgramExecutionAsString);
        }
        return stringBuilder.toString();
    }

    public String getProgramExecutionAsString() {
        return this.mProgramExecutionAsString;
    }

    public List<ILocation> getFailurePath() {
        return this.mFailurePath;
    }

    public IProgramExecution<TE, E> getProgramExecution() {
        return this.mProgramExecution;
    }

    public String getReasons() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Reason: ");
        int n = 0;
        while (n < this.mUnprovabilityReasons.size()) {
            stringBuilder.append(this.mUnprovabilityReasons.get(n));
            if (n == this.mUnprovabilityReasons.size() - 1) {
                stringBuilder.append(". ");
            } else {
                stringBuilder.append(", ");
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

