/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.ModelExtractionUtils;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Cnf;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.XnfUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.ConstraintSynthesisUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractLinearInvariantPattern;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractSMTInvariantPatternProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.CFGInvariantsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.CachedTransFormulaLinearizer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ILinearInequalityInvariantPatternStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.KindOfInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearPatternWithConstantCoefficients;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearTransitionPattern;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.SuccessorConstraintIngredients;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.TransitionConstraintIngredients;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class LinearInequalityInvariantPatternProcessor
extends AbstractSMTInvariantPatternProcessor<Dnf<AbstractLinearInvariantPattern>> {
    private static final boolean ANNOTATE_TERMS_FOR_DEBUGGING = false;
    private static final String PREFIX = "lp_";
    private static final String PREFIX_SEPARATOR = "_";
    private static final String ANNOT_PREFIX = "LIIPP_Annot";
    private static final boolean ASSERT_INTEGER_COEFFICIENTS = false;
    private int mAnnotTermCounter;
    private Map<String, Term> mAnnotTerm2MotzkinTerm;
    private Map<String, Set<IcfgLocation>> mTermAnnotations2Locs;
    private Map<String, LinearInequality> mMotzkinCoefficients2LinearInequalities;
    private Map<Set<LinearInequality>, List<IcfgLocation>> mLinearInequalities2Locations;
    private Set<IcfgLocation> mLocsInUnsatCore;
    private final boolean mUseUnsatCores;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Script mSolver;
    private final ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> mStrategy;
    private final LinearTransition mPrecondition;
    private final LinearTransition mPostcondition;
    private final CachedTransFormulaLinearizer mLinearizer;
    private final Dnf<AbstractLinearInvariantPattern> mEntryInvariantPattern;
    private final Dnf<AbstractLinearInvariantPattern> mExitInvariantPattern;
    private int mPrefixCounter;
    private int mCurrentRound;
    private final int mMaxRounds;
    private final boolean mUseNonlinearConstraints;
    private final boolean mSynthesizeEntryPattern;
    private final KindOfInvariant mKindOfInvariant;
    private final SimplificationType mSimplifySatisfyingAssignment = SimplificationType.TWO_MODE;
    private Collection<TermVariable> mVarsFromUnsatCore;
    private final IcfgLocation mStartLocation;
    private final Set<IcfgLocation> mErrorLocations;
    private final boolean mUseUnderApproxAsAdditionalConstraint;
    private final boolean mUseOverApproxAsAdditionalConstraint;
    private Set<Term> mAllPatternCoefficients;
    private Set<Term> mIntegerCoefficients;
    private Map<Term, Rational> mPatternCoefficients2Values;
    private final Map<IcfgLocation, UnmodifiableTransFormula> mLoc2UnderApproximation;
    private final Map<IcfgLocation, UnmodifiableTransFormula> mLoc2OverApproximation;
    private int mDAGTreeSizeSumOfNormalConstraints;
    private int mDAGTreeSizeSumOfApproxConstraints;
    private int mMotzkinTransformationsForNormalConstraints;
    private int mMotzkinTransformationsForApproxConstraints;
    private int mMotzkinCoefficientsForNormalConstraints;
    private int mMotzkinCoefficientsForApproxConstraints;
    private int mProgramSizeConjuncts;
    private int mProgramSizeDisjuncts;
    private long mConstraintsSolvingTime;
    private long mConstraintsConstructionTime;

    public LinearInequalityInvariantPatternProcessor(IUltimateServiceProvider iUltimateServiceProvider, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, SmtFunctionsAndAxioms smtFunctionsAndAxioms, Script script, List<IcfgLocation> list, List<IcfgInternalTransition> list2, IPredicate iPredicate, IPredicate iPredicate2, IcfgLocation icfgLocation, Set<IcfgLocation> set, ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> iLinearInequalityInvariantPatternStrategy, boolean bl, boolean bl2, SmtUtils.SimplificationTechnique simplificationTechnique, Map<IcfgLocation, IPredicate> map, Map<IcfgLocation, IPredicate> map2, boolean bl3, KindOfInvariant kindOfInvariant) {
        super(iPredicateUnifier, cfgSmtToolkit);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mSolver = script;
        this.mStrategy = iLinearInequalityInvariantPatternStrategy;
        this.mStartLocation = icfgLocation;
        this.mErrorLocations = set;
        this.mSynthesizeEntryPattern = bl3;
        this.mKindOfInvariant = kindOfInvariant;
        this.mLinearizer = new CachedTransFormulaLinearizer(iUltimateServiceProvider, cfgSmtToolkit, smtFunctionsAndAxioms, simplificationTechnique);
        this.mPrecondition = this.mLinearizer.linearize(TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate, (ManagedScript)cfgSmtToolkit.getManagedScript()));
        this.mPostcondition = this.mLinearizer.linearize(TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate2, (ManagedScript)cfgSmtToolkit.getManagedScript()));
        ManagedScript managedScript = new ManagedScript(this.mServices, this.mSolver);
        this.mEntryInvariantPattern = this.convertTransFormulaToPatternsForLinearInequalities(TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate, (ManagedScript)managedScript));
        this.mExitInvariantPattern = this.convertTransFormulaToPatternsForLinearInequalities(TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate2, (ManagedScript)managedScript));
        this.mCurrentRound = 0;
        this.mMaxRounds = iLinearInequalityInvariantPatternStrategy.getMaxRounds();
        this.mUseNonlinearConstraints = bl;
        this.mUseUnsatCores = bl2;
        if (this.mUseUnsatCores) {
            this.mUseUnderApproxAsAdditionalConstraint = true;
            this.mUseOverApproxAsAdditionalConstraint = true;
        } else {
            this.mUseUnderApproxAsAdditionalConstraint = false;
            this.mUseOverApproxAsAdditionalConstraint = false;
        }
        this.mAnnotTermCounter = 0;
        this.mAnnotTerm2MotzkinTerm = new HashMap<String, Term>();
        this.mTermAnnotations2Locs = new HashMap<String, Set<IcfgLocation>>();
        this.mMotzkinCoefficients2LinearInequalities = new HashMap<String, LinearInequality>();
        this.mLinearInequalities2Locations = new HashMap<Set<LinearInequality>, List<IcfgLocation>>();
        this.mAllPatternCoefficients = null;
        this.mIntegerCoefficients = null;
        this.mPatternCoefficients2Values = null;
        this.mLoc2UnderApproximation = CFGInvariantsGenerator.convertMapToPredsToMapToUnmodTrans(map, this.mCsToolkit.getManagedScript());
        this.mLoc2OverApproximation = CFGInvariantsGenerator.convertMapToPredsToMapToUnmodTrans(map2, this.mCsToolkit.getManagedScript());
        this.resetStatistics();
    }

    @Override
    public void startRound(int n) {
        this.mSolver.echo(new QuotedObject("Round " + n));
        this.resetSettings();
        this.resetStatistics();
        this.mPrefixCounter = 0;
        this.mCurrentRound = n;
        this.mAllPatternCoefficients = new HashSet<Term>();
        this.mIntegerCoefficients = new HashSet<Term>();
        this.mLinearInequalities2Locations = new HashMap<Set<LinearInequality>, List<IcfgLocation>>();
    }

    private void resetStatistics() {
        this.mDAGTreeSizeSumOfNormalConstraints = 0;
        this.mDAGTreeSizeSumOfApproxConstraints = 0;
        this.mMotzkinTransformationsForNormalConstraints = 0;
        this.mMotzkinTransformationsForApproxConstraints = 0;
        this.mMotzkinCoefficientsForNormalConstraints = 0;
        this.mMotzkinCoefficientsForApproxConstraints = 0;
        this.mProgramSizeConjuncts = 0;
        this.mProgramSizeDisjuncts = 0;
        this.mConstraintsSolvingTime = 0L;
        this.mConstraintsConstructionTime = 0L;
    }

    private void resetSettings() {
        this.reinitializeSolver();
        this.mAnnotTermCounter = 0;
        this.mAnnotTerm2MotzkinTerm = new HashMap<String, Term>();
        this.mTermAnnotations2Locs = new HashMap<String, Set<IcfgLocation>>();
        this.mMotzkinCoefficients2LinearInequalities = new HashMap<String, LinearInequality>();
        this.mStrategy.resetSettings();
    }

    protected String newPrefix() {
        return PREFIX + this.mPrefixCounter++;
    }

    private static Dnf<LinearInequality> mapPattern(Dnf<AbstractLinearInvariantPattern> dnf, Map<IProgramVar, Term> map) {
        Dnf dnf2 = new Dnf(dnf.size());
        for (Collection collection : dnf) {
            ArrayList<LinearInequality> arrayList = new ArrayList<LinearInequality>(collection.size());
            for (AbstractLinearInvariantPattern abstractLinearInvariantPattern : collection) {
                arrayList.add(abstractLinearInvariantPattern.getLinearInequality(map));
            }
            dnf2.add(arrayList);
        }
        return dnf2;
    }

    private static Dnf<LinearInequality> mapTransitionPattern(Dnf<AbstractLinearInvariantPattern> dnf, Map<IProgramVar, Term> map, Map<IProgramVar, Term> map2) {
        Dnf dnf2 = new Dnf(dnf.size());
        for (Collection collection : dnf) {
            ArrayList<LinearInequality> arrayList = new ArrayList<LinearInequality>(collection.size());
            for (AbstractLinearInvariantPattern abstractLinearInvariantPattern : collection) {
                assert (abstractLinearInvariantPattern instanceof LinearTransitionPattern);
                LinearTransitionPattern linearTransitionPattern = (LinearTransitionPattern)abstractLinearInvariantPattern;
                arrayList.add(linearTransitionPattern.getLinearInequality(map, map2));
            }
            dnf2.add(arrayList);
        }
        return dnf2;
    }

    private static Dnf<LinearInequality> negatePatternAndConvertToDNF(IUltimateServiceProvider iUltimateServiceProvider, Dnf<LinearInequality> dnf) {
        Object object2;
        Cnf cnf = new Cnf(dnf.size());
        for (Object object2 : dnf) {
            ArrayList<LinearInequality> arrayList = new ArrayList<LinearInequality>(object2.size());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                LinearInequality linearInequality = (LinearInequality)iterator.next();
                LinearInequality linearInequality2 = new LinearInequality(linearInequality);
                linearInequality2.negate();
                arrayList.add(linearInequality2);
            }
            cnf.add(arrayList);
        }
        object2 = cnf.toDnf(iUltimateServiceProvider);
        assert (object2 != null);
        return object2;
    }

    private static Dnf<LinearInequality> mapAndNegatePattern(IUltimateServiceProvider iUltimateServiceProvider, Dnf<AbstractLinearInvariantPattern> dnf, Map<IProgramVar, Term> map) {
        Dnf<LinearInequality> dnf2 = LinearInequalityInvariantPatternProcessor.mapPattern(dnf, map);
        return LinearInequalityInvariantPatternProcessor.negatePatternAndConvertToDNF(iUltimateServiceProvider, dnf2);
    }

    @SafeVarargs
    private final Term transformNegatedConjunction(ConstraintsType constraintsType, Dnf<LinearInequality> ... analysisType) {
        Collection collection2;
        Dnf dnf;
        int n;
        AnalysisType analysisType2;
        this.mLogger.info((Object)"About to invoke motzkin:");
        if (this.mLogger.isDebugEnabled()) {
            analysisType2 = analysisType;
            int n2 = ((AnalysisType)analysisType2).length;
            n = 0;
            while (n < n2) {
                dnf = analysisType2[n];
                this.mLogger.debug((Object)("DNF to transform: " + String.valueOf(dnf)));
                ++n;
            }
        }
        dnf = XnfUtils.and((IUltimateServiceProvider)this.mServices, (Dnf[])analysisType);
        n = this.mMotzkinCoefficients2LinearInequalities.size();
        ArrayList<Term> arrayList = new ArrayList<Term>(dnf.size());
        analysisType2 = this.mUseNonlinearConstraints ? AnalysisType.NONLINEAR : (this.mKindOfInvariant == KindOfInvariant.DANGER ? AnalysisType.LINEAR_WITH_GUESSES : AnalysisType.LINEAR);
        for (Collection collection2 : dnf) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Transforming conjunct " + String.valueOf(collection2)));
            }
            MotzkinTransformation motzkinTransformation = new MotzkinTransformation(this.mServices, this.mSolver, analysisType2, false);
            motzkinTransformation.addInequalities(collection2);
            arrayList.add(motzkinTransformation.transform(new Rational[0]));
            this.mMotzkinCoefficients2LinearInequalities.putAll(motzkinTransformation.getMotzkinCoefficients2LinearInequalities());
        }
        collection2 = SmtUtils.and((Script)this.mSolver, arrayList);
        if (constraintsType == ConstraintsType.Normal) {
            this.mDAGTreeSizeSumOfNormalConstraints = (int)((long)this.mDAGTreeSizeSumOfNormalConstraints + new DAGSize().treesize((Term)collection2));
            this.mMotzkinTransformationsForNormalConstraints += dnf.size();
            this.mMotzkinCoefficientsForNormalConstraints += this.mMotzkinCoefficients2LinearInequalities.size() - n;
        } else if (constraintsType == ConstraintsType.Approximation) {
            this.mDAGTreeSizeSumOfApproxConstraints = (int)((long)this.mDAGTreeSizeSumOfApproxConstraints + new DAGSize().treesize((Term)collection2));
            this.mMotzkinTransformationsForApproxConstraints += dnf.size();
            this.mMotzkinCoefficientsForApproxConstraints += this.mMotzkinCoefficients2LinearInequalities.size() - n;
        }
        return collection2;
    }

    private Term buildImplicationTerm(LinearTransition linearTransition, Dnf<AbstractLinearInvariantPattern> dnf, IcfgLocation icfgLocation, Map<IProgramVar, Term> map) {
        Dnf<LinearInequality> dnf22;
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>(linearTransition.getOutVars());
        List list = linearTransition.getPolyhedra();
        Dnf dnf3 = new Dnf();
        for (Dnf<LinearInequality> dnf22 : list) {
            Collection<Object> collection = new ArrayList<LinearInequality>((Collection<LinearInequality>)dnf22);
            dnf3.add(collection);
        }
        dnf22 = LinearInequalityInvariantPatternProcessor.mapAndNegatePattern(this.mServices, dnf, hashMap);
        int n = 0;
        for (Collection<Object> collection : dnf22) {
            n += collection.size();
        }
        this.mLogger.info((Object)("Got an implication term with " + n + " conjuncts"));
        return this.transformNegatedConjunction(ConstraintsType.Normal, dnf3, dnf22);
    }

    private Term buildBackwardImplicationTerm(LinearTransition linearTransition, Dnf<AbstractLinearInvariantPattern> dnf, IcfgLocation icfgLocation, Map<IProgramVar, Term> map) {
        List list3;
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>(linearTransition.getOutVars());
        List list2 = linearTransition.getPolyhedra();
        Cnf cnf = new Cnf();
        for (List list3 : list2) {
            ArrayList<LinearInequality> arrayList = new ArrayList<LinearInequality>();
            for (Object object : list3) {
                LinearInequality linearInequality = new LinearInequality((LinearInequality)object);
                linearInequality.negate();
                arrayList.add(linearInequality);
            }
            cnf.add(arrayList);
        }
        list3 = cnf.toDnf(this.mServices);
        Iterator iterator = LinearInequalityInvariantPatternProcessor.mapPattern(dnf, hashMap);
        int n = 0;
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Object object;
            object = (Collection)iterator2.next();
            n += object.size();
        }
        this.mLogger.info((Object)("Got an implication term with " + n + " conjuncts"));
        return this.transformNegatedConjunction(ConstraintsType.Normal, new Dnf[]{list3, iterator});
    }

    private void completePatternVariablesMapping(Map<IProgramVar, Term> map, Set<IProgramVar> set, Map<IProgramVar, Term> map2) {
        String string = this.newPrefix() + "replace_";
        int n = 0;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Var-Map before completion: " + String.valueOf(map)));
        }
        for (IProgramVar iProgramVar : set) {
            if (map.containsKey(iProgramVar)) continue;
            if (map2.get(iProgramVar) != null) {
                map.put(iProgramVar, map2.get(iProgramVar));
                continue;
            }
            ApplicationTerm applicationTerm = SmtUtils.buildNewConstant((Script)this.mSolver, (String)(string + String.valueOf(iProgramVar) + PREFIX_SEPARATOR + n), (String)"Real");
            ++n;
            map.put(iProgramVar, (Term)applicationTerm);
            map2.put(iProgramVar, (Term)applicationTerm);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Var-Map after completion: " + String.valueOf(map)));
        }
    }

    private Term buildPredicateTerm(TransitionConstraintIngredients<Dnf<AbstractLinearInvariantPattern>> transitionConstraintIngredients, Map<IProgramVar, Term> map) {
        Object object;
        Object object2;
        Set<IProgramVar> set;
        UnmodifiableTransFormula unmodifiableTransFormula;
        Object object3;
        ArrayList<IcfgLocation> arrayList;
        ArrayList<IcfgLocation> arrayList2;
        String string;
        if (this.mLogger.isDebugEnabled()) {
            string = transitionConstraintIngredients.getTransition().toString();
            this.mLogger.debug((Object)("Building constraints for transition (" + String.valueOf(transitionConstraintIngredients.getSourceLocation()) + ", " + string.substring(0, string.indexOf("InVars")) + ", " + String.valueOf(transitionConstraintIngredients.getTargetLocation()) + ")"));
        }
        string = this.mLinearizer.linearize(transitionConstraintIngredients.getTransition());
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>(string.getInVars());
        map.putAll(hashMap);
        this.completePatternVariablesMapping(hashMap, transitionConstraintIngredients.getVariablesForSourcePattern(), map);
        HashMap<IProgramVar, Term> hashMap2 = new HashMap<IProgramVar, Term>(string.getOutVars());
        map.putAll(hashMap2);
        this.completePatternVariablesMapping(hashMap2, transitionConstraintIngredients.getVariablesForTargetPattern(), map);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of start-pattern before mapping to lin-inequalities: " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(transitionConstraintIngredients.getInvStart())));
        }
        Dnf<LinearInequality> dnf = LinearInequalityInvariantPatternProcessor.mapPattern(transitionConstraintIngredients.getInvStart(), hashMap);
        if (this.mUseUnsatCores) {
            arrayList2 = new ArrayList<IcfgLocation>();
            arrayList2.add(transitionConstraintIngredients.getSourceLocation());
            this.storeLinearInequalitiesToLocations(dnf, arrayList2);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of start-pattern after mapping to lin-inequalities: " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(dnf)));
            this.mLogger.debug((Object)("Size of end-pattern before mapping to lin-inequalities: " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(transitionConstraintIngredients.getInvEnd())));
        }
        arrayList2 = LinearInequalityInvariantPatternProcessor.mapPattern(transitionConstraintIngredients.getInvEnd(), hashMap2);
        Dnf<LinearInequality> dnf2 = LinearInequalityInvariantPatternProcessor.negatePatternAndConvertToDNF(this.mServices, arrayList2);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of end-pattern after mapping to lin-inequalities and negating: " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(dnf2)));
        }
        if (this.mUseUnsatCores) {
            arrayList = new ArrayList<IcfgLocation>();
            arrayList.add(transitionConstraintIngredients.getTargetLocation());
            this.storeLinearInequalitiesToLocations(dnf2, arrayList);
        }
        if ((arrayList = this.convertTransitionToPattern((LinearTransition)string)).size() > 1) {
            this.mProgramSizeDisjuncts += arrayList.size();
        }
        if (this.mUseUnsatCores) {
            object3 = new ArrayList();
            object3.add(transitionConstraintIngredients.getSourceLocation());
            object3.add(transitionConstraintIngredients.getTargetLocation());
            this.storeLinearInequalitiesToLocations((Dnf<LinearInequality>)arrayList, (List<IcfgLocation>)object3);
        }
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(LinearInequalityInvariantPatternProcessor.class);
        }
        if (this.mUseUnderApproxAsAdditionalConstraint && this.mCurrentRound >= 0 && !this.mErrorLocations.contains(object3 = transitionConstraintIngredients.getTargetLocation()) && this.mLoc2UnderApproximation.containsKey(object3)) {
            unmodifiableTransFormula = this.convertTransFormulaToPatternsForLinearInequalities(this.mLoc2UnderApproximation.get(object3));
            set = LinearInequalityInvariantPatternProcessor.extractVarsFromPattern(unmodifiableTransFormula);
            this.completePatternVariablesMapping(hashMap2, set, map);
            object2 = LinearInequalityInvariantPatternProcessor.mapPattern((Dnf<AbstractLinearInvariantPattern>)unmodifiableTransFormula, hashMap2);
            if (this.mUseUnsatCores) {
                object = new ArrayList<IcfgLocation>();
                object.add(object3);
                this.storeLinearInequalitiesToLocations((Dnf<LinearInequality>)object2, (List<IcfgLocation>)object);
            }
            if (this.mLogger.isDebugEnabled()) {
                object = new StringBuilder();
                LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder(object, "\nSP-" + String.valueOf(object3) + ": ", "(true)", object2);
                LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder((StringBuilder)object, "\nnegatedPattern-" + String.valueOf(object3) + ": ", "()", dnf2);
                this.printConstraintFromStringBuilder((StringBuilder)object);
            }
            object = this.mLoc2UnderApproximation.get(object3).toString();
            this.mSolver.echo(new QuotedObject("Assertion for SP: " + ((String)object).substring(0, ((String)object).indexOf("InVars"))));
            this.annotateAndAssertTermAndStoreMapping(this.transformNegatedConjunction(ConstraintsType.Approximation, new Dnf[]{object2, dnf2}), new HashSet<IcfgLocation>(Arrays.asList(object3)));
        }
        if (this.mUseOverApproxAsAdditionalConstraint && this.mCurrentRound >= 0 && !this.mErrorLocations.contains(object3 = transitionConstraintIngredients.getTargetLocation()) && this.mLoc2OverApproximation.containsKey(object3)) {
            Object object4;
            unmodifiableTransFormula = TransFormulaUtils.negate((UnmodifiableTransFormula)this.mLoc2OverApproximation.get(object3), (ManagedScript)this.mCsToolkit.getManagedScript(), (IUltimateServiceProvider)this.mServices);
            set = this.convertTransFormulaToPatternsForLinearInequalities(unmodifiableTransFormula);
            object2 = LinearInequalityInvariantPatternProcessor.extractVarsFromPattern(set);
            this.completePatternVariablesMapping((Map<IProgramVar, Term>)hashMap2, (Set<IProgramVar>)object2, map);
            object = LinearInequalityInvariantPatternProcessor.mapPattern(set, hashMap2);
            if (this.mUseUnsatCores) {
                object4 = new ArrayList<IcfgLocation>();
                object4.add(object3);
                this.storeLinearInequalitiesToLocations((Dnf<LinearInequality>)object, (List<IcfgLocation>)object4);
            }
            if (this.mLogger.isDebugEnabled()) {
                object4 = new StringBuilder();
                LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder(object4, "\nPattern-" + String.valueOf(object3) + ": ", "(true)", arrayList2);
                LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder((StringBuilder)object4, "\nnegatedWP-" + String.valueOf(object3) + ": ", "()", (Dnf<LinearInequality>)object);
                this.printConstraintFromStringBuilder((StringBuilder)object4);
            }
            object4 = this.mLoc2OverApproximation.get(object3).toString();
            this.mSolver.echo(new QuotedObject("Assertion for WP: " + ((String)object4).substring(0, ((String)object4).indexOf("InVars"))));
            this.annotateAndAssertTermAndStoreMapping(this.transformNegatedConjunction(ConstraintsType.Approximation, new Dnf[]{arrayList2, object}), new HashSet<IcfgLocation>(Arrays.asList(object3)));
        }
        if (this.mLogger.isDebugEnabled()) {
            object3 = new StringBuilder();
            LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder((StringBuilder)object3, "\nStartPattern: ", "(true)", dnf);
            LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder((StringBuilder)object3, "\nTransition: ", "(true)", arrayList);
            LinearInequalityInvariantPatternProcessor.appendConstraintToStringBuilder((StringBuilder)object3, "\nEndPattern: ", "(false)", dnf2);
            this.printConstraintFromStringBuilder((StringBuilder)object3);
        }
        this.mSolver.echo(new QuotedObject("Assertion for trans (" + String.valueOf(transitionConstraintIngredients.getSourceLocation()) + ", " + String.valueOf(transitionConstraintIngredients.getTargetLocation()) + ")"));
        return this.transformNegatedConjunction(ConstraintsType.Normal, new Dnf[]{dnf, dnf2, arrayList});
    }

    private void printConstraintFromStringBuilder(StringBuilder stringBuilder) {
        String string = stringBuilder.toString();
        string = string.replace("AND ) OR", ") OR");
        string = string.replace("OR \n", "\n");
        string = string.replace("AND \n", "\n");
        this.mLogger.debug((Object)string);
    }

    private static void appendConstraintToStringBuilder(StringBuilder stringBuilder, String string, String string2, Dnf<LinearInequality> dnf) {
        stringBuilder.append(string);
        if (dnf.isEmpty()) {
            stringBuilder.append(string2);
        } else {
            dnf.forEach(collection -> {
                stringBuilder.append("(");
                collection.forEach(linearInequality -> {
                    StringBuilder stringBuilder2 = stringBuilder.append(linearInequality.toString() + " AND ");
                });
                stringBuilder.append(") OR ");
            });
        }
    }

    private static Set<IProgramVar> extractVarsFromPattern(Dnf<AbstractLinearInvariantPattern> dnf) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (Collection collection : dnf) {
            for (AbstractLinearInvariantPattern abstractLinearInvariantPattern : collection) {
                hashSet.addAll(abstractLinearInvariantPattern.getVariables());
            }
        }
        return hashSet;
    }

    private void storeLinearInequalitiesToLocations(Dnf<LinearInequality> dnf, List<IcfgLocation> list) {
        HashSet hashSet = new HashSet(dnf.size());
        for (Collection collection : dnf) {
            hashSet.addAll(collection);
        }
        if (!dnf.isEmpty() && list.size() >= 1) {
            this.mLinearInequalities2Locations.put(hashSet, list);
        }
    }

    private void generateAndAssertTerms(Collection<SuccessorConstraintIngredients<Dnf<AbstractLinearInvariantPattern>>> collection) {
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>();
        this.mSolver.assertTerm(this.buildImplicationTerm(this.mPrecondition, this.mEntryInvariantPattern, this.mStartLocation, hashMap));
        for (IcfgLocation object : this.mErrorLocations) {
            this.mSolver.assertTerm(this.buildBackwardImplicationTerm(this.mPostcondition, this.mExitInvariantPattern, object, hashMap));
        }
        for (SuccessorConstraintIngredients successorConstraintIngredients : collection) {
            Set set = successorConstraintIngredients.buildTransitionConstraintIngredients();
            for (TransitionConstraintIngredients<Dnf<AbstractLinearInvariantPattern>> transitionConstraintIngredients : set) {
                this.mSolver.assertTerm(this.buildPredicateTerm(transitionConstraintIngredients, hashMap));
            }
        }
    }

    private void generateAndAssertDangerTerms(Collection<SuccessorConstraintIngredients<Dnf<AbstractLinearInvariantPattern>>> collection) {
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>();
        this.mSolver.assertTerm(this.buildImplicationTerm(this.mPrecondition, this.mEntryInvariantPattern, this.mStartLocation, hashMap));
        for (IcfgLocation object : this.mErrorLocations) {
            this.mSolver.assertTerm(this.buildBackwardImplicationTerm(this.mPostcondition, this.mExitInvariantPattern, object, hashMap));
        }
        for (SuccessorConstraintIngredients successorConstraintIngredients : collection) {
            IcfgEdge icfgEdge3;
            Object object4;
            Dnf dnf;
            Dnf dnf2;
            Dnf<LinearInequality> dnf3;
            LinearTransition linearTransition;
            UnmodifiableTransFormula unmodifiableTransFormula;
            UnmodifiableTransFormula unmodifiableTransFormula2;
            Dnf<AbstractLinearInvariantPattern> dnf4;
            Object object2;
            Object object3;
            Dnf dnf5 = (Dnf)successorConstraintIngredients.getInvStart();
            if (this.mErrorLocations.contains(successorConstraintIngredients.getSourceLocation())) continue;
            if (!successorConstraintIngredients.getSourceLocation().getOutgoingEdges().isEmpty()) {
                object3 = this.mSolver.term("true", new Term[0]);
                for (Map.Entry entry : successorConstraintIngredients.getEdge2TargetInv().entrySet()) {
                    object2 = entry.getKey().getTransformula();
                    dnf4 = this.mLinearizer.linearize((UnmodifiableTransFormula)object2);
                    HashMap<IProgramVar, Term> hashMap2 = new HashMap<IProgramVar, Term>(dnf4.getInVars());
                    hashMap.putAll(hashMap2);
                    this.completePatternVariablesMapping(hashMap2, successorConstraintIngredients.getVariablesForSourcePattern(), hashMap);
                    unmodifiableTransFormula2 = new HashMap(dnf4.getOutVars());
                    hashMap.putAll((Map<IProgramVar, Term>)unmodifiableTransFormula2);
                    this.completePatternVariablesMapping((Map<IProgramVar, Term>)unmodifiableTransFormula2, successorConstraintIngredients.getEdge2VariablesForTargetPattern().get(entry.getKey()), hashMap);
                    unmodifiableTransFormula = LinearInequalityInvariantPatternProcessor.mapAndNegatePattern(this.mServices, (Dnf<AbstractLinearInvariantPattern>)((Dnf)entry.getValue()), (Map<IProgramVar, Term>)unmodifiableTransFormula2);
                    linearTransition = LinearInequalityInvariantPatternProcessor.mapPattern((Dnf<AbstractLinearInvariantPattern>)dnf5, hashMap2);
                    dnf3 = this.convertTransitionToPattern((LinearTransition)dnf4);
                    dnf2 = (Dnf)successorConstraintIngredients.getEdge2Pattern().get(entry.getKey());
                    dnf = LinearInequalityInvariantPatternProcessor.mapTransitionPattern((Dnf<AbstractLinearInvariantPattern>)dnf2, hashMap2, (Map<IProgramVar, Term>)unmodifiableTransFormula2);
                    object4 = this.transformNegatedConjunction(ConstraintsType.Normal, new Dnf[]{linearTransition, dnf3, dnf, unmodifiableTransFormula});
                    object3 = SmtUtils.and((Script)this.mSolver, (Term[])new Term[]{object3, object4});
                }
                this.mLogger.debug((Object)("Asserting constraint: " + String.valueOf(object3)));
                this.mSolver.assertTerm((Term)object3);
            }
            if (this.mStartLocation.equals((Object)successorConstraintIngredients.getSourceLocation())) {
                object3 = new HashMap();
                successorConstraintIngredients.getVariablesForSourcePattern().forEach(arg_0 -> LinearInequalityInvariantPatternProcessor.lambda$2((Map)object3, arg_0));
                TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(Collections.emptyMap(), (Map)object3, true, null, true, null, true);
                transFormulaBuilder.setFormula(this.mSolver.term("true", new Term[0]));
                transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
                icfgEdge3 = transFormulaBuilder.finishConstruction(new ManagedScript(this.mServices, this.mSolver));
                object2 = this.mCsToolkit.getIcfgEdgeFactory().createInternalTransition(null, successorConstraintIngredients.getSourceLocation(), null, (UnmodifiableTransFormula)icfgEdge3);
                dnf4 = this.getPatternForTransition((IcfgEdge)object2, this.mCurrentRound);
                HashMap<IProgramVar, Term> hashMap3 = new HashMap<IProgramVar, Term>((Map<IProgramVar, Term>)object3);
                unmodifiableTransFormula2 = LinearInequalityInvariantPatternProcessor.mapTransitionPattern(dnf4, Collections.emptyMap(), hashMap3);
                unmodifiableTransFormula = LinearInequalityInvariantPatternProcessor.mapAndNegatePattern(this.mServices, (Dnf<AbstractLinearInvariantPattern>)dnf5, hashMap3);
                linearTransition = this.transformNegatedConjunction(ConstraintsType.Normal, new Dnf[]{unmodifiableTransFormula2, unmodifiableTransFormula});
                this.mLogger.debug((Object)("Asserting constraint: " + String.valueOf(linearTransition)));
                this.mSolver.assertTerm((Term)linearTransition);
            }
            object3 = new HashMap();
            for (IcfgEdge icfgEdge2 : successorConstraintIngredients.getEdge2TargetInv().keySet()) {
                object3.putAll(icfgEdge2.getTransformula().getInVars());
            }
            hashMap.putAll((Map<IProgramVar, Term>)object3);
            this.completePatternVariablesMapping((Map<IProgramVar, Term>)object3, successorConstraintIngredients.getVariablesForSourcePattern(), hashMap);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (IcfgEdge icfgEdge3 : successorConstraintIngredients.getEdge2TargetInv().keySet()) {
                dnf4 = new HashMap();
                for (Map.Entry entry : icfgEdge3.getTransformula().getInVars().entrySet()) {
                    dnf4.put((TermVariable)entry.getValue(), (TermVariable)object3.get(entry.getKey()));
                }
                UnmodifiableTransFormula unmodifiableTransFormula3 = TransFormulaUtils.substituteTermVars((TransFormula)icfgEdge3.getTransformula(), (ManagedScript)this.mCsToolkit.getManagedScript(), dnf4);
                unmodifiableTransFormula2 = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula3, (ManagedScript)this.mCsToolkit.getManagedScript(), (IUltimateServiceProvider)this.mServices);
                unmodifiableTransFormula = TransFormulaUtils.negate((UnmodifiableTransFormula)unmodifiableTransFormula2, (ManagedScript)this.mCsToolkit.getManagedScript(), (IUltimateServiceProvider)this.mServices);
                linearTransition = this.mLinearizer.linearize(unmodifiableTransFormula);
                dnf3 = this.convertTransitionToPattern(linearTransition);
                dnf2 = (Dnf)successorConstraintIngredients.getEdge2Pattern().get(icfgEdge3);
                dnf = new Dnf();
                for (Object object4 : dnf2) {
                    ArrayList<LinearInequality> arrayList2 = new ArrayList<LinearInequality>();
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        AbstractLinearInvariantPattern abstractLinearInvariantPattern = (AbstractLinearInvariantPattern)iterator.next();
                        assert (abstractLinearInvariantPattern instanceof LinearTransitionPattern);
                        LinearTransitionPattern linearTransitionPattern = (LinearTransitionPattern)abstractLinearInvariantPattern;
                        if (linearTransitionPattern.containsOutVars()) continue;
                        arrayList2.add(linearTransitionPattern.getLinearInequality((Map<IProgramVar, Term>)object3));
                    }
                    dnf.add(arrayList2);
                }
                object4 = new Dnf();
                object4.addAll(dnf3);
                object4.addAll(LinearInequalityInvariantPatternProcessor.negatePatternAndConvertToDNF(this.mServices, (Dnf<LinearInequality>)dnf));
                arrayList.add(object4);
            }
            icfgEdge3 = LinearInequalityInvariantPatternProcessor.mapPattern((Dnf<AbstractLinearInvariantPattern>)dnf5, (Map<IProgramVar, Term>)object3);
            arrayList.add(icfgEdge3);
            object2 = this.transformNegatedConjunction(ConstraintsType.Normal, arrayList.toArray(new Dnf[0]));
            this.mLogger.debug((Object)("Asserting constraint: " + String.valueOf(object2)));
            this.mSolver.assertTerm((Term)object2);
        }
    }

    private void annotateAndAssertTermAndStoreMapping(Term term, Set<IcfgLocation> set) {
        assert (term.getFreeVars().length == 0) : "Term has free vars";
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        String string = "LIIPP_Annot_" + this.mAnnotTermCounter++;
        int n = 0;
        while (n < termArray.length) {
            String string2 = string + PREFIX_SEPARATOR + n;
            this.mAnnotTerm2MotzkinTerm.put(string2, termArray[n]);
            this.mTermAnnotations2Locs.put(string2, set);
            Annotation annotation = new Annotation(":named", (Object)string2);
            Term term2 = this.mSolver.annotate(termArray[n], new Annotation[]{annotation});
            this.mSolver.assertTerm(term2);
            ++n;
        }
    }

    private void generateAndAnnotateAndAssertTerms(Collection<SuccessorConstraintIngredients<Dnf<AbstractLinearInvariantPattern>>> collection) {
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>();
        this.annotateAndAssertTermAndStoreMapping(this.buildImplicationTerm(this.mPrecondition, this.mEntryInvariantPattern, this.mStartLocation, hashMap), new HashSet<IcfgLocation>(Arrays.asList(this.mStartLocation)));
        for (IcfgLocation object : this.mErrorLocations) {
            this.annotateAndAssertTermAndStoreMapping(this.buildBackwardImplicationTerm(this.mPostcondition, this.mExitInvariantPattern, object, hashMap), new HashSet<IcfgLocation>(Arrays.asList(object)));
        }
        for (SuccessorConstraintIngredients successorConstraintIngredients : collection) {
            Set set = successorConstraintIngredients.buildTransitionConstraintIngredients();
            for (TransitionConstraintIngredients<Dnf<AbstractLinearInvariantPattern>> transitionConstraintIngredients : set) {
                HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>(Arrays.asList(transitionConstraintIngredients.getSourceLocation(), transitionConstraintIngredients.getTargetLocation()));
                this.annotateAndAssertTermAndStoreMapping(this.buildPredicateTerm(transitionConstraintIngredients, hashMap), hashSet);
            }
        }
    }

    private Set<String> getTermVariablesFromTerm(Term term) {
        HashSet<String> hashSet = new HashSet<String>();
        if (term instanceof ApplicationTerm) {
            Term[] termArray;
            if (((ApplicationTerm)term).getFunction().getName().startsWith("motzkin_")) {
                hashSet.add(((ApplicationTerm)term).getFunction().getName());
                return hashSet;
            }
            Term[] termArray2 = termArray = ((ApplicationTerm)term).getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term2 = termArray2[n2];
                hashSet.addAll(this.getTermVariablesFromTerm(term2));
                ++n2;
            }
        } else if (term instanceof AnnotatedTerm) {
            Term term3 = ((AnnotatedTerm)term).getSubterm();
            hashSet.addAll(this.getTermVariablesFromTerm(term3));
        } else if (term instanceof LetTerm) {
            Term term4 = ((LetTerm)term).getSubTerm();
            hashSet.addAll(this.getTermVariablesFromTerm(term4));
        } else {
            boolean cfr_ignored_0 = term instanceof TermVariable;
        }
        return hashSet;
    }

    public Collection<TermVariable> getVarsFromUnsatCore() {
        return this.mVarsFromUnsatCore;
    }

    public Map<LinearInequalityPatternProcessorStatistics, Object> getStatistics() {
        HashMap<LinearInequalityPatternProcessorStatistics, Object> hashMap = new HashMap<LinearInequalityPatternProcessorStatistics, Object>();
        hashMap.put(LinearInequalityPatternProcessorStatistics.ProgramSizeConjuncts, this.mProgramSizeConjuncts);
        hashMap.put(LinearInequalityPatternProcessorStatistics.ProgramSizeDisjuncts, this.mProgramSizeDisjuncts);
        hashMap.put(LinearInequalityPatternProcessorStatistics.TreesizeNormalConstraints, this.mDAGTreeSizeSumOfNormalConstraints);
        hashMap.put(LinearInequalityPatternProcessorStatistics.TreesizeApproxConstraints, this.mDAGTreeSizeSumOfApproxConstraints);
        hashMap.put(LinearInequalityPatternProcessorStatistics.MotzkinTransformationsNormalConstraints, this.mMotzkinTransformationsForNormalConstraints);
        hashMap.put(LinearInequalityPatternProcessorStatistics.MotzkinTransformationsApproxConstraints, this.mMotzkinTransformationsForApproxConstraints);
        hashMap.put(LinearInequalityPatternProcessorStatistics.MotzkinCoefficientsNormalConstraints, this.mMotzkinCoefficientsForNormalConstraints);
        hashMap.put(LinearInequalityPatternProcessorStatistics.MotzkinCoefficientsApproxConstraints, this.mMotzkinCoefficientsForApproxConstraints);
        hashMap.put(LinearInequalityPatternProcessorStatistics.ConstraintsSolvingTime, this.mConstraintsSolvingTime);
        hashMap.put(LinearInequalityPatternProcessorStatistics.ConstraintsConstructionTime, this.mConstraintsConstructionTime);
        return hashMap;
    }

    @Override
    public Script.LBool checkForValidConfiguration(Collection<SuccessorConstraintIngredients<Dnf<AbstractLinearInvariantPattern>>> collection, int n) {
        Object object;
        Object object22;
        Object object3;
        this.mLogger.info((Object)"Start generating terms.");
        long l = System.nanoTime();
        if (this.mKindOfInvariant == KindOfInvariant.SAFETY) {
            if (!this.mUseUnsatCores) {
                this.generateAndAssertTerms(collection);
            } else {
                this.generateAndAnnotateAndAssertTerms(collection);
            }
        } else {
            assert (this.mKindOfInvariant == KindOfInvariant.DANGER);
            this.generateAndAssertDangerTerms(collection);
        }
        this.mConstraintsConstructionTime = (System.nanoTime() - l) / 1000000L;
        this.mLogger.info((Object)"Terms generated, checking SAT.");
        long l2 = System.nanoTime();
        Script.LBool lBool = this.mSolver.checkSat();
        this.mConstraintsSolvingTime = (System.nanoTime() - l2) / 1000000L;
        this.mLogger.info((Object)("Check-sat result: " + String.valueOf(lBool)));
        if (lBool == Script.LBool.UNSAT && this.mUseUnsatCores) {
            object3 = this.mSolver.getUnsatCore();
            HashSet<String> object4 = new HashSet<String>();
            HashSet hashSet = new HashSet();
            Term term3 = object3;
            int n2 = ((Term[])term3).length;
            int n3 = 0;
            while (n3 < n2) {
                object22 = term3[n3];
                Term term2 = this.mAnnotTerm2MotzkinTerm.get(object22.toStringDirect());
                object4.addAll(this.getTermVariablesFromTerm(term2));
                hashSet.addAll(this.mTermAnnotations2Locs.get(object22.toStringDirect()));
                ++n3;
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("UnsatCoreAnnots: " + Arrays.toString((Object[])object3)));
                this.mLogger.debug((Object)("MotzkinVars in unsat core: " + String.valueOf(object4)));
            }
            this.mVarsFromUnsatCore = new HashSet<TermVariable>();
            for (Object object22 : object4) {
                LinearInequality linearInequality = this.mMotzkinCoefficients2LinearInequalities.get(object22);
                for (Term term3 : linearInequality.getVariables()) {
                    if (term3 instanceof TermVariable) {
                        this.mVarsFromUnsatCore.add((TermVariable)term3);
                        continue;
                    }
                    this.mLogger.warn((Object)("Linear inequality (" + String.valueOf(term3) + ")is not a TermVariable"));
                }
            }
            this.mLocsInUnsatCore = hashSet;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("LocsInUnsatCore: " + String.valueOf(hashSet)));
            }
            if (n >= 0) {
                object = hashSet.iterator();
                while (object.hasNext()) {
                    object22 = (IcfgLocation)object.next();
                    if (object22 == this.mStartLocation && !this.mSynthesizeEntryPattern || this.mErrorLocations.contains(object22)) continue;
                    this.mStrategy.changePatternSettingForLocation((IcfgLocation)object22, this.mCurrentRound, hashSet);
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug((Object)("changed setting for loc: " + String.valueOf(object22)));
                }
            }
        }
        if (lBool == Script.LBool.SAT && !this.mIntegerCoefficients.isEmpty()) {
            try {
                object3 = ModelExtractionUtils.getSimplifiedAssignment_TwoMode((Script)this.mSolver, this.mIntegerCoefficients, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices);
                for (Map.Entry entry : object3.entrySet()) {
                    object22 = (Rational)entry.getValue();
                    object = (Term)entry.getKey();
                    this.mSolver.assertTerm(this.mSolver.term("=", new Term[]{object, object22.ceil().toTerm(object.getSort())}));
                }
                return this.mSolver.checkSat();
            }
            catch (TermException termException) {
                termException.printStackTrace();
                this.mLogger.error((Object)"Getting values for integer coefficients failed.");
                return Script.LBool.UNKNOWN;
            }
        }
        return lBool;
    }

    public Set<IcfgLocation> getLocationsInUnsatCore() {
        assert (this.mLocsInUnsatCore != null) : "locations in unsat not existing";
        return this.mLocsInUnsatCore;
    }

    @Override
    public int getMaxRounds() {
        return this.mMaxRounds;
    }

    protected Term getValuatedTermForPattern(Dnf<AbstractLinearInvariantPattern> dnf) {
        assert (this.mPatternCoefficients2Values != null) : "Call method extractValuesForPatternCoefficients before applying configurations for the patterns.";
        Script script = this.mCsToolkit.getManagedScript().getScript();
        ArrayList<Term> arrayList = new ArrayList<Term>(dnf.size());
        for (Collection collection : dnf) {
            ArrayList<Term> arrayList2 = new ArrayList<Term>(collection.size());
            for (AbstractLinearInvariantPattern abstractLinearInvariantPattern : collection) {
                Term term2;
                HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>(abstractLinearInvariantPattern.getCoefficients().size());
                for (Term term2 : abstractLinearInvariantPattern.getCoefficients()) {
                    hashMap.put(term2, this.mPatternCoefficients2Values.get(term2));
                }
                term2 = abstractLinearInvariantPattern.getAffineFunction(hashMap).asTerm(script);
                Term term3 = Rational.ZERO.toTerm(term2.getSort());
                if (abstractLinearInvariantPattern.isStrict()) {
                    arrayList2.add(SmtUtils.less((Script)script, (Term)term3, (Term)term2));
                    continue;
                }
                arrayList2.add(SmtUtils.leq((Script)script, (Term)term3, (Term)term2));
            }
            arrayList.add(SmtUtils.and((Script)this.mCsToolkit.getManagedScript().getScript(), arrayList2));
        }
        return SmtUtils.or((Script)this.mCsToolkit.getManagedScript().getScript(), arrayList);
    }

    @Override
    protected TermTransformer getConfigurationTransformer() {
        throw new UnsupportedOperationException("not needed, we directly extract Term, Rational mappings");
    }

    private void reinitializeSolver() {
        this.mSolver.reset();
        this.mSolver.setOption(":produce-models", (Object)true);
        if (this.mUseUnsatCores) {
            this.mSolver.setOption(":produce-unsat-cores", (Object)true);
        }
        boolean bl = true;
        ConstraintSynthesisUtils.Linearity linearity = this.mUseNonlinearConstraints ? ConstraintSynthesisUtils.Linearity.NONLINEAR : ConstraintSynthesisUtils.Linearity.LINEAR;
        Logics logics = ConstraintSynthesisUtils.getLogic(linearity, bl);
        this.mSolver.setLogic(logics);
    }

    @Override
    public IPredicate applyConfiguration(Dnf<AbstractLinearInvariantPattern> dnf) {
        Term term = this.getValuatedTermForPattern(dnf);
        return this.mPedicateUnifier.getOrConstructPredicate(term);
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getPatternForTransition(IcfgEdge icfgEdge, int n) {
        Dnf<AbstractLinearInvariantPattern> dnf = this.mStrategy.getPatternForTransition(icfgEdge, n, this.mSolver, this.newPrefix());
        this.mIntegerCoefficients.addAll(this.mStrategy.getIntegerCoefficientsForTransition(icfgEdge));
        return dnf;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getInvariantPatternForLocation(IcfgLocation icfgLocation, int n) {
        if (this.mStartLocation.equals((Object)icfgLocation) && !this.mSynthesizeEntryPattern) {
            assert (this.mEntryInvariantPattern != null) : "call initializeEntryAndExitPattern() before this";
            return this.mEntryInvariantPattern;
        }
        if (this.mErrorLocations.contains(icfgLocation)) {
            assert (this.mExitInvariantPattern != null) : "call initializeEntryAndExitPattern() before this";
            return this.mExitInvariantPattern;
        }
        Dnf<AbstractLinearInvariantPattern> dnf = this.mStrategy.getInvariantPatternForLocation(icfgLocation, n, this.mSolver, this.newPrefix());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("InvariantPattern for Location " + String.valueOf(icfgLocation) + " is:  " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(dnf)));
        }
        this.mAllPatternCoefficients.addAll(this.mStrategy.getPatternCoefficientsForLocation(icfgLocation));
        return dnf;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getInvariantPatternForLocation(IcfgLocation icfgLocation, int n, Set<IProgramVar> set) {
        if (this.mStartLocation.equals((Object)icfgLocation) && !this.mSynthesizeEntryPattern) {
            assert (this.mEntryInvariantPattern != null) : "call initializeEntryAndExitPattern() before this";
            return this.mEntryInvariantPattern;
        }
        if (this.mErrorLocations.contains(icfgLocation)) {
            assert (this.mExitInvariantPattern != null) : "call initializeEntryAndExitPattern() before this";
            return this.mExitInvariantPattern;
        }
        Dnf<AbstractLinearInvariantPattern> dnf = this.mStrategy.getInvariantPatternForLocation(icfgLocation, n, this.mSolver, this.newPrefix(), set);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("InvariantPattern for Location " + String.valueOf(icfgLocation) + " is:  " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(dnf)));
        }
        this.mAllPatternCoefficients.addAll(this.mStrategy.getPatternCoefficientsForLocation(icfgLocation));
        return dnf;
    }

    @Override
    public Set<IProgramVar> getVariablesForInvariantPattern(IcfgLocation icfgLocation, int n) {
        if (this.mStartLocation.equals((Object)icfgLocation) && !this.mSynthesizeEntryPattern) {
            return Collections.emptySet();
        }
        if (this.mErrorLocations.contains(icfgLocation)) {
            return Collections.emptySet();
        }
        return this.mStrategy.getPatternVariablesForLocation(icfgLocation, n);
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getEntryInvariantPattern() {
        return this.mEntryInvariantPattern;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getExitInvariantPattern() {
        return this.mExitInvariantPattern;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getEmptyInvariantPattern() {
        List list = Collections.emptyList();
        return new Dnf(list);
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> addTransFormulaToEachConjunctInPattern(Dnf<AbstractLinearInvariantPattern> dnf, UnmodifiableTransFormula unmodifiableTransFormula) {
        assert (dnf != null) : "pattern must not be null";
        assert (unmodifiableTransFormula != null) : "TransFormula must  not be null";
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of pattern before adding WP: " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(dnf)));
        }
        Dnf<AbstractLinearInvariantPattern> dnf2 = this.convertTransFormulaToPatternsForLinearInequalities(unmodifiableTransFormula);
        Dnf dnf3 = new Dnf();
        for (Collection collection : dnf) {
            for (Collection collection2 : dnf2) {
                ArrayList arrayList = new ArrayList(collection);
                arrayList.addAll(collection2);
                dnf3.add(arrayList);
            }
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of pattern after adding WP: " + LinearInequalityInvariantPatternProcessor.getSizeOfPattern(dnf3)));
        }
        return dnf3;
    }

    private static <E> String getSizeOfPattern(Dnf<E> dnf) {
        int n = 0;
        int[] nArray = new int[dnf.size()];
        int n2 = 0;
        for (Collection collection : dnf) {
            n += collection.size();
            nArray[n2] = collection.size();
            ++n2;
        }
        return n2 + " disjuncts with each " + Arrays.toString(nArray) + " conjuncts (Total: " + n + " cojuncts)";
    }

    public int getTotalNumberOfConjunctsInPattern(Dnf<AbstractLinearInvariantPattern> dnf) {
        int n = 0;
        for (Collection collection : dnf) {
            n += collection.size();
        }
        return n;
    }

    private Dnf<AbstractLinearInvariantPattern> convertTransFormulaToPatternsForLinearInequalities(UnmodifiableTransFormula unmodifiableTransFormula) {
        HashMap<TermVariable, IProgramVar> hashMap = new HashMap<TermVariable, IProgramVar>();
        hashMap.putAll(unmodifiableTransFormula.getInVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        hashMap.putAll(unmodifiableTransFormula.getOutVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        List list = this.mLinearizer.linearize(unmodifiableTransFormula).getPolyhedra();
        Dnf dnf = new Dnf(list.size());
        for (List list2 : list) {
            ArrayList<Term> arrayList = new ArrayList<Term>(list.size());
            for (LinearInequality linearInequality : list2) {
                Object object2;
                HashMap<IProgramVar, AffineTerm> hashMap2 = new HashMap<IProgramVar, AffineTerm>();
                HashMap<Term, AffineTerm> hashMap3 = new HashMap<Term, AffineTerm>();
                for (Object object2 : linearInequality.getVariables()) {
                    if (hashMap.containsKey(object2)) {
                        hashMap2.put((IProgramVar)hashMap.get(object2), linearInequality.getCoefficient(object2));
                        continue;
                    }
                    hashMap3.put((Term)object2, linearInequality.getCoefficient(object2));
                }
                object2 = new LinearPatternWithConstantCoefficients(this.mSolver, hashMap2.keySet(), this.newPrefix(), linearInequality.isStrict(), hashMap2, hashMap3, linearInequality.getConstant());
                arrayList.add((Term)object2);
            }
            dnf.add(arrayList);
        }
        return dnf;
    }

    private Dnf<LinearInequality> convertTransitionToPattern(LinearTransition linearTransition) {
        List list = linearTransition.getPolyhedra();
        Dnf dnf = new Dnf();
        for (List list2 : list) {
            ArrayList arrayList = new ArrayList(list2);
            dnf.add(arrayList);
            this.mProgramSizeConjuncts += list2.size();
        }
        return dnf;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> addTransFormulaAsAdditionalDisjunctToPattern(Dnf<AbstractLinearInvariantPattern> dnf, UnmodifiableTransFormula unmodifiableTransFormula) {
        assert (dnf != null) : "pattern must not be null";
        assert (unmodifiableTransFormula != null) : "TransFormula must  not be null";
        Dnf<AbstractLinearInvariantPattern> dnf2 = this.convertTransFormulaToPatternsForLinearInequalities(unmodifiableTransFormula);
        Dnf dnf3 = new Dnf();
        dnf3.addAll(dnf);
        dnf3.addAll(dnf2);
        return dnf3;
    }

    @Override
    public void extractValuesForPatternCoefficients() {
        assert (this.mAllPatternCoefficients != null) : "mAllPatternCoefficients must not be null!";
        try {
            this.mPatternCoefficients2Values = this.mSimplifySatisfyingAssignment == SimplificationType.NO_SIMPLIFICATION ? ModelExtractionUtils.getValuation((Script)this.mSolver, this.mAllPatternCoefficients) : (this.mSimplifySatisfyingAssignment == SimplificationType.SIMPLE ? ModelExtractionUtils.getSimplifiedAssignment((Script)this.mSolver, this.mAllPatternCoefficients, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices) : ModelExtractionUtils.getSimplifiedAssignment_TwoMode((Script)this.mSolver, this.mAllPatternCoefficients, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices));
        }
        catch (TermException termException) {
            termException.printStackTrace();
            this.mLogger.error((Object)"Getting values for coefficients failed.");
        }
    }

    private static /* synthetic */ void lambda$2(Map map, IProgramVar iProgramVar) {
        TermVariable termVariable = map.put(iProgramVar, iProgramVar.getTermVariable());
    }

    public static enum ConstraintsType {
        Normal,
        Approximation;

    }

    public static enum LinearInequalityPatternProcessorStatistics {
        ProgramSizeConjuncts,
        ProgramSizeDisjuncts,
        MotzkinTransformationsNormalConstraints,
        MotzkinTransformationsApproxConstraints,
        MotzkinCoefficientsNormalConstraints,
        MotzkinCoefficientsApproxConstraints,
        TreesizeNormalConstraints,
        TreesizeApproxConstraints,
        ConstraintsSolvingTime,
        ConstraintsConstructionTime;

    }

    public static enum SimplificationType {
        NO_SIMPLIFICATION,
        SIMPLE,
        TWO_MODE;

    }
}

