/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class ISOIEC9899TC3 {
    private static final String IGNORED_SUFFIX = "Ignored suffix";
    private static final String OCT_0 = "0";
    private static final String HEX_U0X = "0X";
    private static final String HEX_L0X = "0x";
    private static final String BIN_U0X = "0B";
    private static final String BIN_L0X = "0b";
    private static final String[] SUFFIXES_FLOAT = new String[]{"f", "F", "l", "L"};
    private static final String[] SUFFIXES_INT = new String[]{"ULL", "Ull", "ull", "uLL", "llu", "llU", "LLu", "LLU", "ul", "uL", "Ul", "UL", "lu", "lU", "Lu", "LU", "ll", "LL", "u", "U", "l", "L"};

    public static List<BigInteger> parseCharacterSequence(String string) {
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        String string2 = string;
        while (!string2.equals("")) {
            Pair<BigInteger, String> pair = ISOIEC9899TC3.parseCharacterSequenceHelper(string2);
            arrayList.add((BigInteger)pair.getFirst());
            string2 = (String)pair.getSecond();
        }
        return arrayList;
    }

    public static Pair<BigInteger, String> parseCharacterSequenceHelper(String string) {
        String string2;
        int n;
        if (string.charAt(0) != '\\') {
            n = string.charAt(0);
            string2 = string.substring(1);
        } else {
            switch (string.charAt(1)) {
                case '\"': 
                case '\'': 
                case '?': 
                case '\\': {
                    n = string.charAt(1);
                    string2 = string.substring(2);
                    break;
                }
                case 'a': {
                    n = 7;
                    string2 = string.substring(2);
                    break;
                }
                case 'b': {
                    n = 8;
                    string2 = string.substring(2);
                    break;
                }
                case 'f': {
                    n = 12;
                    string2 = string.substring(2);
                    break;
                }
                case 'n': {
                    n = 10;
                    string2 = string.substring(2);
                    break;
                }
                case 'r': {
                    n = 13;
                    string2 = string.substring(2);
                    break;
                }
                case 't': {
                    n = 9;
                    string2 = string.substring(2);
                    break;
                }
                case 'v': {
                    n = 11;
                    string2 = string.substring(2);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n2 = ISOIEC9899TC3.lastsuccessiveMatchStartingFrom(1, string, ISOIEC9899TC3::isOctalDigit);
                    int n3 = n2 >= 4 ? 3 : n2;
                    String string3 = string.substring(1, n3 + 1);
                    n = Integer.valueOf(string3, 8);
                    string2 = string.substring(n3 + 1);
                    break;
                }
                case 'x': {
                    int n4 = ISOIEC9899TC3.lastsuccessiveMatchStartingFrom(2, string, ISOIEC9899TC3::isHexadecimalDigit);
                    String string4 = string.substring(2, n4 + 1);
                    n = Integer.valueOf(string4, 16);
                    string2 = string.substring(n4 + 1);
                    break;
                }
                case 'u': {
                    String string5 = string.substring(2, 6);
                    assert (string5.length() == 4);
                    n = Integer.valueOf(string5, 16);
                    string2 = string.substring(6);
                    break;
                }
                case 'U': {
                    String string6 = string.substring(2, 10);
                    assert (string6.length() == 8);
                    n = Integer.valueOf(string6, 16);
                    string2 = string.substring(10);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return new Pair((Object)BigInteger.valueOf(n), (Object)string2);
    }

    static int lastsuccessiveMatchStartingFrom(int n, String string, Predicate<Character> predicate) {
        int n2 = n;
        while (n2 < string.length()) {
            if (!predicate.test(Character.valueOf(string.charAt(n2)))) {
                return n2 - 1;
            }
            ++n2;
        }
        return string.length() - 1;
    }

    static boolean isOctalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    static boolean isHexadecimalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static List<BigInteger> convertCharacterSequenceToByteSequence(List<BigInteger> list, CACSLPreferenceInitializer.Signedness signedness) {
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        for (BigInteger bigInteger : list) {
            if (bigInteger.compareTo(BigInteger.valueOf(255L)) > 0) {
                throw new UnsupportedOperationException("multibyte characters are not supported yet");
            }
            BigInteger bigInteger2 = ISOIEC9899TC3.convertNumericalValueToByteValue(signedness, bigInteger);
            arrayList.add(bigInteger2);
        }
        return arrayList;
    }

    public static BigInteger convertNumericalValueToByteValue(CACSLPreferenceInitializer.Signedness signedness, BigInteger bigInteger) throws AssertionError {
        return switch (signedness) {
            case CACSLPreferenceInitializer.Signedness.SIGNED -> {
                if (bigInteger.compareTo(BigInteger.valueOf(127L)) <= 0) {
                    yield bigInteger;
                }
                yield bigInteger.subtract(BigInteger.valueOf(256L));
            }
            case CACSLPreferenceInitializer.Signedness.UNSIGNED -> bigInteger;
            default -> throw new MatchException(null, null);
        };
    }

    public static FloatingPointLiteral handleFloatConstant(String string, ILocation iLocation) {
        Object object = ISOIEC9899TC3.checkForFloatSuffix(string);
        String string2 = (String)object.getFirst();
        String string3 = (String)object.getSecond();
        object = ISOIEC9899TC3.getDecimalForm(string2);
        CPrimitive cPrimitive = ISOIEC9899TC3.determineTypeFromSuffix(string3);
        return new FloatingPointLiteral((BigDecimal)object, cPrimitive);
    }

    private static BigDecimal getDecimalForm(String string) {
        if (string.startsWith(HEX_L0X) || string.startsWith(HEX_U0X)) {
            Object object = string.substring(2);
            int n = 0;
            String string2 = null;
            if (((String)object).contains("p")) {
                string2 = ((String)object).substring(((String)object).indexOf(112) + 1);
                object = ((String)object).substring(0, ((String)object).indexOf(112));
            }
            if (((String)object).contains(".")) {
                object = StringUtils.stripEnd((String)object, (String)OCT_0);
                int n2 = ((String)object).indexOf(46);
                n = ((String)object).substring(n2 + 1).length();
                object = ((String)object).substring(0, n2) + ((String)object).substring(n2 + 1);
            }
            BigInteger bigInteger = new BigInteger((String)object, 16);
            BigDecimal bigDecimal = new BigDecimal(bigInteger.toString());
            if (string2 != null) {
                int n3 = Integer.parseInt(string2);
                if (n3 > 0) {
                    int n4 = 0;
                    while (n4 < n3) {
                        bigDecimal = bigDecimal.multiply(new BigDecimal("2"));
                        ++n4;
                    }
                } else if (n3 < 0) {
                    int n5 = 0;
                    while (n5 > n3) {
                        bigDecimal = bigDecimal.divide(new BigDecimal("2"));
                        --n5;
                    }
                }
            }
            if (n != 0) {
                bigDecimal = bigDecimal.divide(BigDecimal.valueOf(Math.pow(16.0, n)));
            }
            return bigDecimal;
        }
        if (string.contains("e")) {
            int n = string.indexOf(101);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            BigDecimal bigDecimal = new BigDecimal(string3);
            int n6 = Integer.parseInt(string4);
            return bigDecimal.scaleByPowerOfTen(n6);
        }
        return new BigDecimal(string);
    }

    private static CPrimitive determineTypeFromSuffix(String string) {
        CPrimitive cPrimitive;
        if (string == null || string.equals("d") || string.equals("D")) {
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
        } else if (string.equals("f") || string.equals("F")) {
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.FLOAT);
        } else if (string.equals("l") || string.equals("L")) {
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE);
        } else {
            throw new IllegalArgumentException("not a float type");
        }
        return cPrimitive;
    }

    private static Pair<String, String> checkForFloatSuffix(String string) {
        String string2;
        String[] stringArray = SUFFIXES_FLOAT;
        int n = SUFFIXES_FLOAT.length;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringArray[n2];
            if (string.endsWith(string2)) {
                String string3 = string.substring(0, string.length() - string2.length());
                String string4 = string2;
                return new Pair((Object)string3, (Object)string4);
            }
            ++n2;
        }
        string2 = string;
        Object var2_4 = null;
        return new Pair((Object)string2, var2_4);
    }

    public static RValue handleIntegerConstant(String string, ILocation iLocation, boolean bl, TypeSizes typeSizes) {
        try {
            IntegerConstant integerConstant = new IntegerConstant(string);
            CPrimitive cPrimitive = ISOIEC9899TC3.determineCType(integerConstant, typeSizes);
            Expression expression = ISOIEC9899TC3.constructLiteralForCIntegerLiteral(iLocation, bl, typeSizes, cPrimitive, integerConstant.getValue());
            return new RValue(expression, cPrimitive);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Unable to translate int! " + numberFormatException.getMessage();
            throw new IncorrectSyntaxException(iLocation, string2);
        }
    }

    public static CPrimitive determineTypeForIntegerLiteral(String string, TypeSizes typeSizes) {
        return ISOIEC9899TC3.determineCType(new IntegerConstant(string), typeSizes);
    }

    public static Expression constructLiteralForCIntegerLiteral(ILocation iLocation, boolean bl, TypeSizes typeSizes, CPrimitive cPrimitive, BigInteger bigInteger) {
        IntegerLiteral integerLiteral;
        if (bl) {
            int n = 8 * typeSizes.getSize(cPrimitive.getType());
            integerLiteral = ExpressionFactory.createBitvecLiteral((ILocation)iLocation, (BigInteger)bigInteger, (int)n);
        } else {
            integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger.toString());
        }
        return integerLiteral;
    }

    private static CPrimitive.CPrimitives[] getPossibleTypes(IntegerConstant integerConstant) {
        if (integerConstant.hasUnsignedSuffix()) {
            if (integerConstant.hasLongLongSuffix()) {
                return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.ULONGLONG};
            }
            if (integerConstant.hasLongSuffix()) {
                return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.ULONGLONG};
            }
            return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.UINT, CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.ULONGLONG};
        }
        if (integerConstant.hasLongLongSuffix()) {
            if (integerConstant.getIntegerConstantType() == IntegerConstantType.DECIMAL) {
                return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.LONGLONG};
            }
            return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.LONGLONG, CPrimitive.CPrimitives.ULONGLONG};
        }
        if (integerConstant.hasLongSuffix()) {
            if (integerConstant.getIntegerConstantType() == IntegerConstantType.DECIMAL) {
                return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.LONG, CPrimitive.CPrimitives.LONGLONG};
            }
            return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.LONG, CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.LONGLONG, CPrimitive.CPrimitives.ULONGLONG};
        }
        if (integerConstant.getIntegerConstantType() == IntegerConstantType.DECIMAL) {
            return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.INT, CPrimitive.CPrimitives.LONG, CPrimitive.CPrimitives.LONGLONG};
        }
        return new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.INT, CPrimitive.CPrimitives.UINT, CPrimitive.CPrimitives.LONG, CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.LONGLONG, CPrimitive.CPrimitives.ULONGLONG};
    }

    private static CPrimitive determineCType(IntegerConstant integerConstant, TypeSizes typeSizes) {
        CPrimitive.CPrimitives[] cPrimitivesArray;
        CPrimitive.CPrimitives[] cPrimitivesArray2 = cPrimitivesArray = ISOIEC9899TC3.getPossibleTypes(integerConstant);
        int n = cPrimitivesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPrimitive.CPrimitives cPrimitives = cPrimitivesArray2[n2];
            CPrimitive cPrimitive = new CPrimitive(cPrimitives);
            BigInteger bigInteger = typeSizes.getMaxValueOfPrimitiveType(cPrimitive);
            if (integerConstant.getValue().compareTo(bigInteger) <= 0) {
                return cPrimitive;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unable to represent " + String.valueOf(integerConstant.getValue()) + " using any of the given types. This is probably undefined or we need extended integer types. See 6.4.4.1 in the C standard");
    }

    public static class FloatingPointLiteral {
        private final BigDecimal mDecimalRepresenation;
        private final CPrimitive mCPrimitive;

        public FloatingPointLiteral(BigDecimal bigDecimal, CPrimitive cPrimitive) {
            this.mDecimalRepresenation = bigDecimal;
            this.mCPrimitive = cPrimitive;
        }

        public BigDecimal getDecimalRepresenation() {
            return this.mDecimalRepresenation;
        }

        public CPrimitive getCPrimitive() {
            return this.mCPrimitive;
        }
    }

    private static class IntegerConstant {
        private final IntegerConstantType mIntegerConstantType;
        private final String mSuffix;
        private final BigInteger mValue;

        public IntegerConstant(String string) {
            String string2;
            String string3 = string;
            String string4 = "";
            String[] stringArray = SUFFIXES_INT;
            int n = SUFFIXES_INT.length;
            int n2 = 0;
            while (n2 < n) {
                string2 = stringArray[n2];
                if (string.endsWith(string2)) {
                    string3 = string.substring(0, string.length() - string2.length());
                    string4 = string2;
                    break;
                }
                ++n2;
            }
            this.mSuffix = string4;
            if (string3.startsWith(ISOIEC9899TC3.HEX_L0X) || string3.startsWith(ISOIEC9899TC3.HEX_U0X)) {
                string2 = string3.substring(2);
                this.mIntegerConstantType = IntegerConstantType.HEXADECIMAL;
            } else if (string3.startsWith(ISOIEC9899TC3.BIN_L0X) || string3.startsWith(ISOIEC9899TC3.BIN_U0X)) {
                string2 = string3.substring(2);
                this.mIntegerConstantType = IntegerConstantType.BINARY;
            } else if (string3.startsWith(ISOIEC9899TC3.OCT_0)) {
                string2 = string3;
                this.mIntegerConstantType = IntegerConstantType.OCTAL;
            } else {
                string2 = string3;
                this.mIntegerConstantType = IntegerConstantType.DECIMAL;
            }
            this.mValue = new BigInteger(string2, this.mIntegerConstantType.getBase());
        }

        public BigInteger getValue() {
            return this.mValue;
        }

        public IntegerConstantType getIntegerConstantType() {
            return this.mIntegerConstantType;
        }

        public boolean hasUnsignedSuffix() {
            return this.mSuffix.contains("u") || this.mSuffix.contains("U");
        }

        public boolean hasLongLongSuffix() {
            return this.mSuffix.contains("ll") || this.mSuffix.contains("LL");
        }

        public boolean hasLongSuffix() {
            return !this.hasLongLongSuffix() && (this.mSuffix.contains("l") || this.mSuffix.contains("L"));
        }
    }

    public static enum IntegerConstantType {
        OCTAL(8),
        DECIMAL(10),
        HEXADECIMAL(16),
        BINARY(2);

        private final int mBase;

        private IntegerConstantType(int n2) {
            this.mBase = n2;
        }

        public int getBase() {
            return this.mBase;
        }
    }
}

