/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.core.runtime.CoreException;

public class ExecConstructorChain
implements ICPPExecution {
    private final Map<IBinding, ICPPEvaluation> ccInitializers;

    public ExecConstructorChain(Map<IBinding, ICPPEvaluation> ccInitializers) {
        this.ccInitializers = ccInitializers;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        HashMap<IBinding, ICPPEvaluation> instantiatedInitializers = new HashMap<IBinding, ICPPEvaluation>();
        for (Map.Entry<IBinding, ICPPEvaluation> initializer : this.ccInitializers.entrySet()) {
            instantiatedInitializers.put(CPPEvaluation.instantiateBinding(initializer.getKey(), context, maxDepth), initializer.getValue().instantiate(context, maxDepth));
        }
        return new ExecConstructorChain(instantiatedInitializers);
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)17);
        buffer.putInt(this.ccInitializers.size());
        for (Map.Entry<IBinding, ICPPEvaluation> ccInitializer : this.ccInitializers.entrySet()) {
            buffer.marshalBinding(ccInitializer.getKey());
            buffer.marshalEvaluation(ccInitializer.getValue(), includeValue);
        }
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        HashMap<IBinding, ICPPEvaluation> ccInitializers = new HashMap<IBinding, ICPPEvaluation>();
        int i = 0;
        while (i < len) {
            IBinding member = buffer.unmarshalBinding();
            ICPPEvaluation memberEval = buffer.unmarshalEvaluation();
            ccInitializers.put(member, memberEval);
            ++i;
        }
        return new ExecConstructorChain(ccInitializers);
    }

    public Map<IBinding, ICPPEvaluation> getConstructorChainInitializers() {
        return this.ccInitializers;
    }
}

