/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.BackwardsWorklistItem;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.FixpointEngineParameters;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IDebugHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IFixpointEngine;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ILoopDetector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.LoggingHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.SummaryMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BackwardFixpointEngine<STATE extends IAbstractState<STATE>, ACTION, VARDECL, LOC>
implements IFixpointEngine<STATE, ACTION, VARDECL, LOC> {
    private final int mMaxUnwindings;
    private final int mMaxParallelStates;
    private final ITransitionProvider<ACTION, LOC> mTransitionProvider;
    private final IAbstractStateStorage<STATE, ACTION, LOC> mStateStorage;
    private final IAbstractDomain<STATE, ACTION> mDomain;
    private final IVariableProvider<STATE, ACTION> mVarProvider;
    private final ILoopDetector<ACTION> mLoopDetector;
    private final IDebugHelper<STATE, ACTION, VARDECL, LOC> mDebugHelper;
    private final IProgressAwareTimer mTimer;
    private final ILogger mLogger;
    private AbsIntResult<STATE, ACTION, LOC> mResult;
    private final SummaryMap<STATE, ACTION, LOC> mSummaryMap;

    public BackwardFixpointEngine(FixpointEngineParameters<STATE, ACTION, VARDECL, LOC> fixpointEngineParameters) {
        if (fixpointEngineParameters == null || !fixpointEngineParameters.isValid()) {
            throw new IllegalArgumentException("invalid params");
        }
        this.mTimer = fixpointEngineParameters.getTimer();
        this.mLogger = fixpointEngineParameters.getLogger();
        this.mTransitionProvider = fixpointEngineParameters.getTransitionProvider();
        this.mStateStorage = fixpointEngineParameters.getStorage();
        this.mDomain = fixpointEngineParameters.getAbstractDomain();
        this.mVarProvider = fixpointEngineParameters.getVariableProvider();
        this.mLoopDetector = fixpointEngineParameters.getLoopDetector();
        this.mDebugHelper = fixpointEngineParameters.getDebugHelper();
        this.mMaxUnwindings = fixpointEngineParameters.getMaxUnwindings();
        this.mMaxParallelStates = fixpointEngineParameters.getMaxParallelStates();
        this.mSummaryMap = new SummaryMap(this.mTransitionProvider, this.mLogger);
    }

    @Override
    public AbsIntResult<STATE, ACTION, LOC> run(Collection<? extends LOC> collection, Script script) {
        this.mLogger.info((Object)("Starting fixpoint engine with domain " + this.mDomain.getClass().getSimpleName() + " (maxUnwinding=" + this.mMaxUnwindings + ", maxParallelStates=" + this.mMaxParallelStates + ")"));
        this.mResult = new AbsIntResult<STATE, ACTION, LOC>(script, this.mDomain, this.mTransitionProvider, this.mVarProvider);
        this.mDomain.beforeFixpointComputation(new Object[0]);
        this.calculateFixpoint(collection);
        this.mResult.saveRootStorage(this.mStateStorage);
        this.mResult.saveSummaryStorage(this.mSummaryMap);
        this.mDomain.afterFixpointComputation(this.mResult);
        return this.mResult;
    }

    private void calculateFixpoint(Collection<? extends LOC> collection) {
        ArrayDeque<BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC>> arrayDeque = new ArrayDeque<BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC>>();
        IAbstractTransformer iAbstractTransformer = this.mDomain.getPreOperator();
        IAbstractStateBinaryOperator iAbstractStateBinaryOperator = this.mDomain.getWideningOperator();
        collection.stream().flatMap(object -> this.mTransitionProvider.getPredecessorActions(object).stream()).filter(object -> !this.mTransitionProvider.isSummaryWithImplementation(object)).map(this::createInitialWorklistItem).forEach(arrayDeque::add);
        while (!arrayDeque.isEmpty()) {
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState;
            this.checkTimeout();
            BackwardsWorklistItem backwardsWorklistItem = (BackwardsWorklistItem)arrayDeque.removeFirst();
            this.mResult.getBenchmark().addIteration(backwardsWorklistItem.getAction());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageCurrentTransition(backwardsWorklistItem));
            }
            if (this.isUnnecessaryPreState(backwardsWorklistItem, disjunctiveAbstractState = this.calculateAbstractPre(backwardsWorklistItem, iAbstractTransformer))) continue;
            this.checkLoopState(backwardsWorklistItem);
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.widenIfNecessary(backwardsWorklistItem, disjunctiveAbstractState, iAbstractStateBinaryOperator);
            if (disjunctiveAbstractState2 == null) {
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)"    Skipping successors because post state is already contained");
                continue;
            }
            this.logDebugPostChanged(disjunctiveAbstractState, disjunctiveAbstractState2, "Widening");
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.savePreState(backwardsWorklistItem, disjunctiveAbstractState2);
            assert (disjunctiveAbstractState3 != null) : "Saving a state is not allowed to return null";
            this.logDebugPostChanged(disjunctiveAbstractState2, disjunctiveAbstractState3, "Merge");
            List<BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC>> list = this.createPredecessorItems(backwardsWorklistItem, disjunctiveAbstractState3);
            arrayDeque.addAll(list);
        }
    }

    private DisjunctiveAbstractState<STATE> calculateAbstractPre(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem, IAbstractTransformer<STATE, ACTION> iAbstractTransformer) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = backwardsWorklistItem.getState();
        ACTION ACTION = backwardsWorklistItem.getAction();
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = disjunctiveAbstractState.apply(iAbstractTransformer, ACTION);
        disjunctiveAbstractState2 = this.prepareScope(backwardsWorklistItem, disjunctiveAbstractState2);
        return disjunctiveAbstractState2;
    }

    private boolean isUnnecessaryPreState(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        if (disjunctiveAbstractState.isBottom()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessagePreIsBottom(disjunctiveAbstractState));
            }
            return true;
        }
        IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage = backwardsWorklistItem.getCurrentStorage();
        return this.checkSubset(iAbstractStateStorage, backwardsWorklistItem.getAction(), disjunctiveAbstractState);
    }

    private void checkLoopState(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        ACTION ACTION = backwardsWorklistItem.getAction();
        if (this.mLoopDetector.isEnteringLoop(ACTION)) {
            LOC LOC = this.mTransitionProvider.getSource(ACTION);
            int n = backwardsWorklistItem.enterLoop(LOC);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageEnterLoop(n, LOC, backwardsWorklistItem.getState()));
            }
        }
    }

    private DisjunctiveAbstractState<STATE> savePreState(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage = backwardsWorklistItem.getCurrentStorage();
        ACTION ACTION = backwardsWorklistItem.getAction();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.getLogMessageNewState(disjunctiveAbstractState));
        }
        LOC LOC = this.mTransitionProvider.getSource(ACTION);
        return iAbstractStateStorage.addAbstractState(LOC, disjunctiveAbstractState);
    }

    private BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> createInitialWorklistItem(ACTION ACTION) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = this.createFreshPrestateWithVariables(ACTION);
        return new BackwardsWorklistItem(disjunctiveAbstractState, ACTION, this.mStateStorage, this.mSummaryMap);
    }

    private DisjunctiveAbstractState<STATE> createFreshPrestateWithVariables(ACTION ACTION) {
        IAbstractState iAbstractState = this.mVarProvider.defineInitialVariables(ACTION, this.mDomain.createTopState());
        DisjunctiveAbstractState disjunctiveAbstractState = new DisjunctiveAbstractState(this.mMaxParallelStates, iAbstractState);
        return disjunctiveAbstractState;
    }

    private List<BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC>> createPredecessorItems(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        ACTION ACTION = backwardsWorklistItem.getAction();
        Collection<ACTION> collection = this.mTransitionProvider.getPredecessors(ACTION, backwardsWorklistItem.getCurrentScope());
        if (collection.isEmpty()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)new StringBuilder().append("   ").append(" No predecessors"));
            }
            return Collections.emptyList();
        }
        List<BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC>> list = collection.stream().filter(object -> !this.mTransitionProvider.isSummaryWithImplementation(object)).map(object -> new BackwardsWorklistItem(disjunctiveAbstractState, object, backwardsWorklistItem)).collect(Collectors.toList());
        if (this.mLogger.isDebugEnabled()) {
            list.stream().map(this::getLogMessageAddTransition).forEach(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
        }
        return list;
    }

    private DisjunctiveAbstractState<STATE> widenIfNecessary(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, IAbstractStateBinaryOperator<STATE> iAbstractStateBinaryOperator) {
        DisjunctiveAbstractState disjunctiveAbstractState2;
        DisjunctiveAbstractState disjunctiveAbstractState3;
        ACTION ACTION = backwardsWorklistItem.getAction();
        LOC LOC = this.mTransitionProvider.getSource(ACTION);
        Pair<Integer, DisjunctiveAbstractState<STATE>> pair = backwardsWorklistItem.getLoopPair(LOC);
        boolean bl = false;
        if (pair != null && (Integer)pair.getFirst() > this.mMaxUnwindings) {
            disjunctiveAbstractState3 = (DisjunctiveAbstractState)pair.getSecond();
        } else if (this.mTransitionProvider.isLeavingScope(ACTION)) {
            disjunctiveAbstractState3 = this.getWidenStateAtScopeEntry(backwardsWorklistItem);
            bl = true;
        } else {
            disjunctiveAbstractState3 = null;
        }
        if (disjunctiveAbstractState3 == null) {
            return disjunctiveAbstractState;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"      Applying widening op:");
            this.mLogger.debug((Object)("      Op1: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState3))));
            this.mLogger.debug((Object)("      Op2: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState))));
        }
        if (this.isFixpoint(disjunctiveAbstractState3, disjunctiveAbstractState2 = disjunctiveAbstractState3.widen(iAbstractStateBinaryOperator, disjunctiveAbstractState))) {
            if (bl) {
                backwardsWorklistItem.getCurrentStorage().scopeFixpointReached();
            }
            return null;
        }
        return disjunctiveAbstractState2;
    }

    private DisjunctiveAbstractState<STATE> prepareScope(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        ACTION ACTION = backwardsWorklistItem.getAction();
        if (this.mTransitionProvider.isEnteringScope(ACTION, backwardsWorklistItem.getCurrentScope())) {
            ACTION ACTION2 = backwardsWorklistItem.removeCurrentScope(backwardsWorklistItem.getState());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageLeaveScope(ACTION2, backwardsWorklistItem));
            }
            return disjunctiveAbstractState;
        }
        if (this.mTransitionProvider.isLeavingScope(ACTION)) {
            backwardsWorklistItem.addScope(ACTION, disjunctiveAbstractState);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageEnterScope(backwardsWorklistItem));
            }
            return disjunctiveAbstractState;
        }
        return disjunctiveAbstractState;
    }

    private DisjunctiveAbstractState<STATE> getWidenStateAtScopeEntry(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        List list;
        Object ACTION = backwardsWorklistItem.getAction();
        Deque<Pair<ACTION, DisjunctiveAbstractState<STATE>>> deque = backwardsWorklistItem.getScopeWideningStack();
        Optional<Long> optional = deque.stream().map(pair -> pair.getFirst()).filter(object -> object != null).collect(Collectors.groupingBy(object -> object, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L || entry.getKey() == ACTION).map(entry -> (Long)entry.getValue()).reduce((l, l2) -> l + l2);
        if (!optional.isPresent() || optional.get() <= (long)this.mMaxUnwindings) {
            return null;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("       Scope widening sequence for " + String.valueOf(LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider)) + " (MaxUnwindings=" + this.mMaxUnwindings + ")"));
            this.mLogger.debug((Object)"       Stack");
            ((Stream)deque.stream().sequential()).map(pair -> pair.getFirst()).map(object -> object == null ? "[G]" : LoggingHelper.getTransitionString(object, this.mTransitionProvider)).map(serializable -> "         " + String.valueOf(serializable)).forEach(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
        }
        if ((list = ((Stream)deque.stream().sequential()).filter(pair -> pair.getFirst() == ACTION).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"      Relevant stack states");
            ((Stream)list.stream().sequential()).map(pair -> "         " + String.valueOf(pair.getFirst() == null ? "[G]" : LoggingHelper.getHashCodeString(pair.getFirst())) + " " + String.valueOf(LoggingHelper.getHashCodeString(pair.getSecond())) + " " + ((DisjunctiveAbstractState)pair.getSecond()).toString()).forEach(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
        }
        int n = list.size();
        int n2 = n - 2;
        if (n - this.mMaxUnwindings < 0 || n2 < 0) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"      not enough states to widen");
            }
            return null;
        }
        DisjunctiveAbstractState disjunctiveAbstractState = (DisjunctiveAbstractState)((Pair)list.get(n2)).getSecond();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("      Selected " + String.valueOf(LoggingHelper.getHashCodeString(disjunctiveAbstractState))));
        }
        return disjunctiveAbstractState;
    }

    private boolean isFixpoint(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        if (disjunctiveAbstractState.isEqualTo(disjunctiveAbstractState2)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessageFixpointFound(disjunctiveAbstractState, disjunctiveAbstractState2));
            }
            this.mResult.getBenchmark().addFixpoint();
            return true;
        }
        return false;
    }

    private boolean checkSubset(IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        LOC LOC = this.mTransitionProvider.getSource(ACTION);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = iAbstractStateStorage.getAbstractState(LOC);
        if (disjunctiveAbstractState == disjunctiveAbstractState2 || disjunctiveAbstractState.isSubsetOf(disjunctiveAbstractState2) != IAbstractState.SubsetResult.NONE) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.getLogMessagePostIsSubsumed(disjunctiveAbstractState, disjunctiveAbstractState2));
            }
            return true;
        }
        return false;
    }

    private void checkTimeout() {
        if (!this.mTimer.continueProcessing()) {
            this.mLogger.warn((Object)"Received timeout, aborting fixpoint engine");
            throw new ToolchainCanceledException(this.getClass(), "executing abstract interpretation");
        }
    }

    private void logDebugPostChanged(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, String string) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        if (disjunctiveAbstractState == disjunctiveAbstractState2) {
            return;
        }
        this.mLogger.debug((Object)("      " + string));
        this.mLogger.debug((Object)("      Before: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState))));
        this.mLogger.debug((Object)("      After: " + String.valueOf(LoggingHelper.getStateString(disjunctiveAbstractState2))));
    }

    private String getLogMessageUnsoundPost(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, DisjunctiveAbstractState<STATE> disjunctiveAbstractState3, ACTION ACTION) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Post is unsound because the term-transformation of the following triple is not valid: {");
        stringBuilder.append(disjunctiveAbstractState.toLogString());
        stringBuilder.append("} ");
        if (disjunctiveAbstractState != disjunctiveAbstractState2) {
            stringBuilder.append("{");
            stringBuilder.append(disjunctiveAbstractState2.toLogString());
            stringBuilder.append("} ");
        }
        stringBuilder.append(this.mTransitionProvider.toLogString(ACTION));
        stringBuilder.append(" {");
        if (disjunctiveAbstractState3 != null) {
            stringBuilder.append(disjunctiveAbstractState3.toLogString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private StringBuilder getLogMessagePreIsBottom(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new StringBuilder().append("   ").append(" Skipping all successors because pre state [").append(disjunctiveAbstractState.hashCode()).append("] is bottom");
    }

    private StringBuilder getLogMessagePostIsSubsumed(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        return new StringBuilder().append("   ").append(" Skipping all successors because post state ").append((CharSequence)LoggingHelper.getStateString(disjunctiveAbstractState)).append(" is subsumed by pre-existing state ").append((CharSequence)LoggingHelper.getStateString(disjunctiveAbstractState2));
    }

    private StringBuilder getLogMessageLeaveScope(ACTION ACTION, BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        return new StringBuilder().append("   ").append(" Transition [").append(backwardsWorklistItem.getAction().hashCode()).append("] leaves scope ").append((CharSequence)LoggingHelper.getHashCodeString(ACTION)).append(" (new depth=").append(backwardsWorklistItem.getScopeStackDepth()).append("): ").append(LoggingHelper.getScopeStackString(backwardsWorklistItem.getScopeStack()));
    }

    private StringBuilder getLogMessageEnterScope(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        return new StringBuilder().append("   ").append(" Transition [").append(backwardsWorklistItem.getAction().hashCode()).append("] enters scope (new depth=").append(backwardsWorklistItem.getScopeStackDepth()).append("): ").append(LoggingHelper.getScopeStackString(backwardsWorklistItem.getScopeStack()));
    }

    private StringBuilder getLogMessageFixpointFound(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        return new StringBuilder().append("   ").append(" State [").append(disjunctiveAbstractState.hashCode()).append("] ").append(disjunctiveAbstractState.toLogString()).append(" is equal to [").append(disjunctiveAbstractState2.hashCode()).append("]");
    }

    private StringBuilder getLogMessageNewState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new StringBuilder().append("   ").append(" Adding pre state [").append(disjunctiveAbstractState.hashCode()).append("] ").append(disjunctiveAbstractState.toLogString());
    }

    private StringBuilder getLogMessageEnterLoop(int n, LOC LOC, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new StringBuilder().append("   ").append(" Entering loop ").append(LOC).append(" (").append(n).append("), saving ").append((CharSequence)LoggingHelper.getStateString(disjunctiveAbstractState));
    }

    private StringBuilder getLogMessageCurrentTransition(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = backwardsWorklistItem.getState();
        ACTION ACTION = backwardsWorklistItem.getAction();
        int n = backwardsWorklistItem.getScopeStackDepth();
        String string = disjunctiveAbstractState == null ? "NULL" : LoggingHelper.getStateString(disjunctiveAbstractState).toString();
        return LoggingHelper.getTransitionString(ACTION, this.mTransitionProvider).append(" processing for pre state ").append(string).append(" (depth=").append(n).append(")");
    }

    private StringBuilder getLogMessageAddTransition(BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        return new StringBuilder().append("   ").append(" Adding [").append(backwardsWorklistItem.getState().hashCode()).append("]").append(" --[").append(backwardsWorklistItem.getAction().hashCode()).append("]->");
    }
}

