/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.CdtASTUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.CorrectnessWitnessExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedFunctionContract;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedGhostUpdate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedLocationInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedLoopInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedWitnessInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedCorrectnessWitness;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedWitnessDeclaration;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNodeAnnotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class GraphMLCorrectnessWitnessExtractor
extends CorrectnessWitnessExtractor {
    private WitnessNode mWitnessNode;
    private final Collection<Class<?>> mLoopTypes = Arrays.asList(IASTGotoStatement.class, IASTDoStatement.class, IASTWhileStatement.class, IASTForStatement.class);
    private final Collection<Class<?>> mConditionalTypes = Arrays.asList(IASTDoStatement.class, IASTWhileStatement.class, IASTForStatement.class, IASTIfStatement.class);
    private final boolean mCheckOnlyLoopInvariants = this.mPrefs.getBoolean("Only consider loop invariants");

    public GraphMLCorrectnessWitnessExtractor(IUltimateServiceProvider iUltimateServiceProvider) {
        super(iUltimateServiceProvider);
    }

    public void setWitness(WitnessNode witnessNode) {
        this.mWitnessNode = witnessNode;
    }

    @Override
    public boolean isReady() {
        return this.mWitnessNode != null && this.mTranslationUnit != null;
    }

    @Override
    protected IExtractedCorrectnessWitness extractWitness() {
        Map<IASTNode, LabeledInvariant> map = new HashMap<IASTNode, LabeledInvariant>();
        if (this.mCheckOnlyLoopInvariants) {
            this.mLogger.info((Object)"Only extracting loop invariants from correctness witness");
        } else {
            this.mLogger.info((Object)"Extracting all invariants from correctness witness");
        }
        ArrayDeque<WitnessNode> arrayDeque = new ArrayDeque<WitnessNode>();
        HashSet<WitnessNode> hashSet = new HashSet<WitnessNode>();
        arrayDeque.add(this.mWitnessNode);
        while (!arrayDeque.isEmpty()) {
            WitnessNode witnessNode = (WitnessNode)arrayDeque.remove();
            if (!hashSet.add(witnessNode)) continue;
            arrayDeque.addAll(witnessNode.getOutgoingNodes());
            Map<IASTNode, LabeledInvariant> map2 = this.matchWitnessToAstNode(witnessNode, this.mStats);
            map = this.mergeMatchesIfNecessary(map, map2);
        }
        this.mLogger.info((Object)("Processed " + hashSet.size() + " nodes"));
        return new GraphMLExtractedCorrectnessWitness(map);
    }

    protected Map<IASTNode, LabeledInvariant> mergeMatchesIfNecessary(Map<IASTNode, LabeledInvariant> map, Map<IASTNode, LabeledInvariant> map2) {
        LabeledInvariant labeledInvariant;
        if (map == null || map.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map;
        }
        HashMap<IASTNode, LabeledInvariant> hashMap = new HashMap<IASTNode, LabeledInvariant>(map.size());
        for (Map.Entry<IASTNode, LabeledInvariant> entry : map2.entrySet()) {
            labeledInvariant = map.get(entry.getKey());
            if (labeledInvariant == null) {
                hashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            hashMap.put(entry.getKey(), this.mergeAndWarn(labeledInvariant, entry.getValue()));
        }
        for (Map.Entry<IASTNode, LabeledInvariant> entry : map.entrySet()) {
            labeledInvariant = map2.get(entry.getKey());
            if (labeledInvariant != null) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private LabeledInvariant mergeAndWarn(LabeledInvariant labeledInvariant, LabeledInvariant labeledInvariant2) {
        LabeledInvariant labeledInvariant3 = GraphMLCorrectnessWitnessExtractor.mergeInvariants(labeledInvariant, labeledInvariant2);
        this.mLogger.warn((Object)"Merging invariants");
        this.mLogger.warn((Object)("  " + labeledInvariant.toString()));
        this.mLogger.warn((Object)("  " + labeledInvariant2.toString()));
        this.mLogger.warn((Object)("  New match: " + labeledInvariant3.toString()));
        return labeledInvariant3;
    }

    private static LabeledInvariant mergeInvariants(LabeledInvariant labeledInvariant, LabeledInvariant labeledInvariant2) {
        StringBuilder stringBuilder;
        String string;
        String string2;
        if (labeledInvariant2 == null) {
            return labeledInvariant;
        }
        if (labeledInvariant.getRelatedAstNode() != labeledInvariant2.getRelatedAstNode()) {
            throw new IllegalArgumentException("Cannot merge WitnessInvariants that are matched to different nodes");
        }
        String string3 = labeledInvariant.getInvariant().getInvariant();
        if (string3.equals(string2 = labeledInvariant2.getInvariant().getInvariant())) {
            string = string3;
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            stringBuilder.append(string3);
            stringBuilder.append(')');
            stringBuilder.append("||");
            stringBuilder.append('(');
            stringBuilder.append(string2);
            stringBuilder.append(')');
            string = stringBuilder.toString();
        }
        stringBuilder = ImmutableSet.of((Set)DataStructureUtils.union(labeledInvariant.getLabels(), labeledInvariant2.getLabels()));
        ExtractedWitnessInvariant extractedWitnessInvariant = labeledInvariant.getInvariant() instanceof ExtractedLoopInvariant || labeledInvariant2.getInvariant() instanceof ExtractedLoopInvariant ? new ExtractedLoopInvariant(string, labeledInvariant.getRelatedAstNode()) : new ExtractedLocationInvariant(string, labeledInvariant.getRelatedAstNode(), ((ExtractedLocationInvariant)labeledInvariant.getInvariant()).isBefore());
        return new LabeledInvariant(extractedWitnessInvariant, (ImmutableSet<String>)stringBuilder);
    }

    private Map<IASTNode, LabeledInvariant> matchWitnessToAstNode(WitnessNode witnessNode, CorrectnessWitnessExtractor.ExtractionStatistics extractionStatistics) {
        WitnessNodeAnnotation witnessNodeAnnotation = WitnessNodeAnnotation.getAnnotation((IElement)witnessNode);
        if (witnessNodeAnnotation == null) {
            return Collections.emptyMap();
        }
        String string = witnessNodeAnnotation.getInvariant();
        if (string == null || "true".equalsIgnoreCase(string)) {
            return Collections.emptyMap();
        }
        Map<IASTNode, LabeledInvariant> map = this.matchWitnessToAstNode(witnessNode);
        if (map == null || map.isEmpty()) {
            this.mLogger.error((Object)("Could not match witness node to any AST node: " + String.valueOf(witnessNode)));
            extractionStatistics.fail();
            return Collections.emptyMap();
        }
        extractionStatistics.success();
        return map;
    }

    private Map<IASTNode, LabeledInvariant> matchWitnessToAstNode(WitnessNode witnessNode) {
        Set<DecoratedWitnessEdge> set;
        HashSet<DecoratedWitnessEdge> hashSet = new HashSet<DecoratedWitnessEdge>(GraphMLCorrectnessWitnessExtractor.convertAndFilterEdges(witnessNode.getIncomingEdges(), true));
        hashSet.addAll(GraphMLCorrectnessWitnessExtractor.convertAndFilterEdges(witnessNode.getOutgoingEdges(), false));
        if (hashSet.isEmpty()) {
            this.mLogger.error((Object)("No line numbers found for " + String.valueOf(witnessNode)));
            return null;
        }
        DecoratedWitnessNode decoratedWitnessNode = new DecoratedWitnessNode(witnessNode);
        Set<MatchedASTNode> set2 = this.matchLines(hashSet);
        boolean bl = false;
        if (!this.mCheckOnlyLoopInvariants) {
            set = GraphMLCorrectnessWitnessExtractor.getIncomingSet(hashSet);
            if (set2.stream().allMatch(matchedASTNode -> !matchedASTNode.isIncoming()) && !set.isEmpty()) {
                this.mLogger.warn((Object)("Could not match AST node to invariant before witness lines " + GraphMLCorrectnessWitnessExtractor.toStringCollection(set)));
                bl = true;
            }
        }
        set = GraphMLCorrectnessWitnessExtractor.getOutgoingSet(hashSet);
        if (set2.stream().allMatch(matchedASTNode -> matchedASTNode.isIncoming()) && !set.isEmpty()) {
            this.mLogger.warn((Object)("Could not match AST node to invariant after witness lines " + GraphMLCorrectnessWitnessExtractor.toStringCollection(set)));
            bl = true;
        }
        if (bl) {
            if (this.mIgnoreUnmatchedEntries) {
                this.mLogger.warn((Object)("  Witness node label is " + String.valueOf(decoratedWitnessNode)));
            } else {
                throw new UnsupportedOperationException("The witness entry " + decoratedWitnessNode.getInvariant() + " could not be matched.");
            }
        }
        return this.extractInvariants(decoratedWitnessNode, set2);
    }

    private Map<IASTNode, LabeledInvariant> extractInvariants(DecoratedWitnessNode decoratedWitnessNode, Set<MatchedASTNode> set) {
        this.filterScopeChanges(decoratedWitnessNode, set);
        Map<IASTNode, LabeledInvariant> map = new HashMap<IASTNode, LabeledInvariant>();
        map = this.mergeMatchesIfNecessary(map, this.extractLoopInvariants(decoratedWitnessNode, set));
        if (this.mCheckOnlyLoopInvariants) {
            this.mLogger.warn((Object)("The following possible matches for " + String.valueOf(decoratedWitnessNode) + " were ignored because we could not match them to a loop:"));
            set.stream().forEach(matchedASTNode -> this.mLogger.warn((Object)("  " + matchedASTNode.toStringSimple())));
            return map;
        }
        map = this.mergeMatchesIfNecessary(map, GraphMLCorrectnessWitnessExtractor.extractStatementInvariants(decoratedWitnessNode, set));
        return map;
    }

    private Map<IASTNode, LabeledInvariant> extractLoopInvariants(DecoratedWitnessNode decoratedWitnessNode, Set<MatchedASTNode> set) {
        Set<MatchedASTNode> set2 = this.mCheckOnlyLoopInvariants ? new HashSet<MatchedASTNode>(set) : set.stream().filter(matchedASTNode -> matchedASTNode.isLoopHead()).collect(Collectors.toSet());
        set.removeAll(set2);
        Map<IASTNode, LabeledInvariant> map = this.tryMatchLoopInvariantsDownwards(decoratedWitnessNode, set2);
        if (set2.isEmpty()) {
            return map;
        }
        if (!map.isEmpty()) {
            this.mLogger.warn((Object)"Downward matching could not match all canidates");
            return map;
        }
        this.mLogger.warn((Object)"Downward matching could not match anything");
        Map<IASTNode, LabeledInvariant> map2 = this.tryMatchLoopInvariantsUpwards(decoratedWitnessNode, set2);
        if (!set2.isEmpty()) {
            this.mLogger.warn((Object)"Could not match the following loop heads:");
            set2.stream().forEach(matchedASTNode -> this.mLogger.warn((Object)("  " + matchedASTNode.toStringSimple())));
            set.addAll(set2);
        }
        return this.mergeMatchesIfNecessary(map, map2);
    }

    private Map<IASTNode, LabeledInvariant> tryMatchLoopInvariantsDownwards(DecoratedWitnessNode decoratedWitnessNode, Set<MatchedASTNode> set) {
        HashMap<IASTNode, LabeledInvariant> hashMap = new HashMap<IASTNode, LabeledInvariant>();
        Iterator<MatchedASTNode> iterator = set.iterator();
        ImmutableSet immutableSet = ImmutableSet.of(Set.of(decoratedWitnessNode.getName()));
        while (iterator.hasNext()) {
            MatchedASTNode matchedASTNode = iterator.next();
            Set<IASTStatement> set2 = CdtASTUtils.findDesiredType(matchedASTNode.getNode(), this.mLoopTypes);
            if (set2.isEmpty()) continue;
            this.mLogger.info((Object)("Matched downward: " + matchedASTNode.toStringSimple()));
            for (IASTStatement iASTStatement : set2) {
                ExtractedLoopInvariant extractedLoopInvariant = new ExtractedLoopInvariant(decoratedWitnessNode.getInvariant(), (IASTNode)iASTStatement);
                hashMap.put((IASTNode)iASTStatement, new LabeledInvariant(extractedLoopInvariant, (ImmutableSet<String>)immutableSet));
            }
            iterator.remove();
        }
        return hashMap;
    }

    private Map<IASTNode, LabeledInvariant> tryMatchLoopInvariantsUpwards(DecoratedWitnessNode decoratedWitnessNode, Set<MatchedASTNode> set) {
        HashMap<IASTNode, LabeledInvariant> hashMap = new HashMap<IASTNode, LabeledInvariant>();
        IASTNode iASTNode = GraphMLCorrectnessWitnessExtractor.findCommonParentStatement(set);
        if (iASTNode == null) {
            return hashMap;
        }
        this.mLogger.info((Object)("Matched remaining loop heads upward to common parent of type " + iASTNode.getClass().getSimpleName()));
        IASTNode iASTNode2 = iASTNode;
        Set<Object> set2 = Collections.emptySet();
        while (iASTNode2 instanceof IASTStatement) {
            set2 = CdtASTUtils.findDesiredType(iASTNode2, this.mLoopTypes);
            if (!set2.isEmpty()) break;
            iASTNode2 = iASTNode2.getParent();
        }
        if (set2.isEmpty()) {
            return hashMap;
        }
        ImmutableSet immutableSet = ImmutableSet.of(Set.of(decoratedWitnessNode.getName()));
        for (IASTStatement iASTStatement : set2) {
            ExtractedLoopInvariant extractedLoopInvariant = new ExtractedLoopInvariant(decoratedWitnessNode.getInvariant(), (IASTNode)iASTStatement);
            hashMap.put((IASTNode)iASTStatement, new LabeledInvariant(extractedLoopInvariant, (ImmutableSet<String>)immutableSet));
        }
        set.clear();
        return hashMap;
    }

    private static Map<IASTNode, LabeledInvariant> extractStatementInvariants(DecoratedWitnessNode decoratedWitnessNode, Set<MatchedASTNode> set) {
        HashMap<IASTNode, LabeledInvariant> hashMap = new HashMap<IASTNode, LabeledInvariant>();
        ImmutableSet immutableSet = ImmutableSet.of(Set.of(decoratedWitnessNode.getName()));
        for (MatchedASTNode matchedASTNode : set) {
            ExtractedLocationInvariant extractedLocationInvariant = new ExtractedLocationInvariant(decoratedWitnessNode.getInvariant(), matchedASTNode.getNode(), !matchedASTNode.isIncoming());
            hashMap.put(matchedASTNode.getNode(), new LabeledInvariant(extractedLocationInvariant, (ImmutableSet<String>)immutableSet));
        }
        set.clear();
        return hashMap;
    }

    private Set<MatchedASTNode> matchLines(Set<DecoratedWitnessEdge> set) {
        HashSet<MatchedASTNode> hashSet = new HashSet<MatchedASTNode>();
        for (DecoratedWitnessEdge decoratedWitnessEdge : set) {
            LineMatchingVisitor lineMatchingVisitor = new LineMatchingVisitor(decoratedWitnessEdge);
            lineMatchingVisitor.run(this.mTranslationUnit);
            hashSet.addAll(lineMatchingVisitor.getMatchedNodes());
        }
        return hashSet;
    }

    private static Set<DecoratedWitnessEdge> convertAndFilterEdges(List<WitnessEdge> list, boolean bl) {
        return list.stream().map(witnessEdge -> new DecoratedWitnessEdge((WitnessEdge)witnessEdge, bl)).filter(decoratedWitnessEdge -> !decoratedWitnessEdge.hasNoLineNumber()).collect(Collectors.toSet());
    }

    private void filterScopeChanges(DecoratedWitnessNode decoratedWitnessNode, Collection<MatchedASTNode> collection) {
        Set<MatchedASTNode> set = GraphMLCorrectnessWitnessExtractor.getOutgoingSet(collection);
        Set<MatchedASTNode> set2 = GraphMLCorrectnessWitnessExtractor.getIncomingSet(collection);
        Set set3 = set.stream().map(matchedASTNode -> CdtASTUtils.findScope(matchedASTNode.getNode())).filter(iASTFunctionDefinition -> iASTFunctionDefinition != null).collect(Collectors.toSet());
        Iterator<MatchedASTNode> iterator = set2.iterator();
        while (iterator.hasNext()) {
            Optional<IASTDeclaration> optional;
            MatchedASTNode matchedASTNode2 = iterator.next();
            IASTFunctionDefinition iASTFunctionDefinition2 = CdtASTUtils.findScope(matchedASTNode2.getNode());
            if (iASTFunctionDefinition2 == null || !(optional = set3.stream().filter(arg_0 -> GraphMLCorrectnessWitnessExtractor.lambda$9((IASTDeclaration)iASTFunctionDefinition2, arg_0)).findAny()).isPresent()) continue;
            this.mLogger.warn((Object)("Removing invariant match " + String.valueOf(decoratedWitnessNode) + ": " + decoratedWitnessNode.getInvariant() + " because scopes differ: " + GraphMLCorrectnessWitnessExtractor.toLogString((IASTNode)iASTFunctionDefinition2, (IASTNode)optional.get())));
            iterator.remove();
        }
    }

    private static IASTNode findCommonParentStatement(Collection<MatchedASTNode> collection) {
        MatchedASTNode matchedASTNode3;
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty collection cannot have a parent");
        }
        if (collection.size() == 1) {
            return collection.iterator().next().getNode();
        }
        for (MatchedASTNode matchedASTNode3 : collection) {
            if (!collection.stream().allMatch(matchedASTNode2 -> matchedASTNode2 == matchedASTNode3 || CdtASTUtils.isContainedInSubtree(matchedASTNode2.getNode(), matchedASTNode3.getNode()))) continue;
            return matchedASTNode3.getNode();
        }
        matchedASTNode3 = collection.iterator().next().getNode().getParent();
        while (matchedASTNode3 != null) {
            if (!(matchedASTNode3 instanceof IASTStatement)) {
                return null;
            }
            MatchedASTNode matchedASTNode4 = matchedASTNode3;
            if (collection.stream().allMatch(arg_0 -> GraphMLCorrectnessWitnessExtractor.lambda$11((IASTNode)matchedASTNode4, arg_0))) {
                return matchedASTNode4;
            }
            matchedASTNode3 = matchedASTNode3.getParent();
        }
        return null;
    }

    private static <T extends IHasIncoming> Stream<T> getIncomingStream(Collection<T> collection) {
        return collection.stream().filter(iHasIncoming -> iHasIncoming.isIncoming());
    }

    private static <T extends IHasIncoming> Set<T> getIncomingSet(Collection<T> collection) {
        return GraphMLCorrectnessWitnessExtractor.getIncomingStream(collection).collect(Collectors.toSet());
    }

    private static <T extends IHasIncoming> Stream<T> getOutgoingStream(Collection<T> collection) {
        return collection.stream().filter(iHasIncoming -> !iHasIncoming.isIncoming());
    }

    private static <T extends IHasIncoming> Set<T> getOutgoingSet(Collection<T> collection) {
        return GraphMLCorrectnessWitnessExtractor.getOutgoingStream(collection).collect(Collectors.toSet());
    }

    private static String toLogString(IASTNode iASTNode, IASTNode iASTNode2) {
        String string = iASTNode == null ? "Global" : "L" + iASTNode.getFileLocation().getStartingLineNumber();
        String string2 = iASTNode2 == null ? "Global" : "L" + iASTNode2.getFileLocation().getStartingLineNumber();
        return "B=" + string + ", A=" + string2;
    }

    private static String toStringCollection(Collection<?> collection) {
        return GraphMLCorrectnessWitnessExtractor.toStringCollection(collection.stream());
    }

    private static String toStringCollection(Stream<?> stream) {
        return String.join((CharSequence)", ", stream.map(object -> String.valueOf(object)).collect(Collectors.toList()));
    }

    private static /* synthetic */ boolean lambda$9(IASTDeclaration iASTDeclaration, IASTDeclaration iASTDeclaration2) {
        return iASTDeclaration2 != iASTDeclaration;
    }

    private static /* synthetic */ boolean lambda$11(IASTNode iASTNode, MatchedASTNode matchedASTNode) {
        return matchedASTNode.getNode() == iASTNode || CdtASTUtils.isContainedInSubtree(matchedASTNode.getNode(), iASTNode);
    }

    private static final class DecoratedWitnessEdge
    implements IHasIncoming {
        private final WitnessEdge mEdge;
        private final WitnessEdgeAnnotation mAnnotation;
        private final boolean mIsIncoming;
        private final AtomicTraceElement.StepInfo mConditional;

        public DecoratedWitnessEdge(WitnessEdge witnessEdge, boolean bl) {
            this.mIsIncoming = bl;
            this.mEdge = witnessEdge;
            this.mAnnotation = WitnessEdgeAnnotation.getAnnotation((IElement)witnessEdge);
            this.mConditional = DecoratedWitnessEdge.getConditionalFromAnnotation(this.mAnnotation);
        }

        private static AtomicTraceElement.StepInfo getConditionalFromAnnotation(WitnessEdgeAnnotation witnessEdgeAnnotation) {
            if (witnessEdgeAnnotation == null || witnessEdgeAnnotation.getCondition() == null) {
                return AtomicTraceElement.StepInfo.NONE;
            }
            if (witnessEdgeAnnotation.getCondition().booleanValue()) {
                return AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE;
            }
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE;
        }

        public AtomicTraceElement.StepInfo getConditional() {
            return this.mConditional;
        }

        public boolean hasNoLineNumber() {
            return this.getLineNumber() == -1;
        }

        @Override
        public boolean isIncoming() {
            return this.mIsIncoming;
        }

        public int getLineNumber() {
            if (this.mIsIncoming) {
                return this.mEdge.getLocation().getEndLine();
            }
            return this.mEdge.getLocation().getStartLine();
        }

        public boolean isEnteringLoop() {
            if (this.mAnnotation == null) {
                return false;
            }
            Boolean bl = this.mAnnotation.getEnterLoopHead();
            return bl != null && bl != false;
        }

        public String toString() {
            return this.mEdge.toString() + " (inc=" + this.isIncoming() + ", isEnteringLoop=" + this.isEnteringLoop() + ")";
        }
    }

    private static final class DecoratedWitnessNode {
        private final WitnessNode mNode;
        private final WitnessNodeAnnotation mAnnotation;

        public DecoratedWitnessNode(WitnessNode witnessNode) {
            this.mNode = witnessNode;
            this.mAnnotation = WitnessNodeAnnotation.getAnnotation((IElement)witnessNode);
        }

        public String getName() {
            return this.mNode.getName();
        }

        public String getInvariant() {
            return this.mAnnotation.getInvariant();
        }

        public String toString() {
            return this.mNode.toString();
        }
    }

    private static final class GraphMLExtractedCorrectnessWitness
    implements IExtractedCorrectnessWitness {
        private final Map<IASTNode, LabeledInvariant> mInvariants;
        private final Set<ImmutableSet<String>> mNodeLabelsOfAddedWitnesses = new HashSet<ImmutableSet<String>>();

        private GraphMLExtractedCorrectnessWitness(Map<IASTNode, LabeledInvariant> map) {
            this.mInvariants = map;
        }

        @Override
        public Set<ExtractedWitnessInvariant> getInvariants(IASTNode iASTNode) {
            LabeledInvariant labeledInvariant = this.mInvariants.get(iASTNode);
            if (labeledInvariant == null || !this.mNodeLabelsOfAddedWitnesses.add(labeledInvariant.getLabels())) {
                return Set.of();
            }
            return Set.of(labeledInvariant.getInvariant());
        }

        @Override
        public Set<ExtractedFunctionContract> getFunctionContracts(IASTNode iASTNode) {
            return Set.of();
        }

        @Override
        public List<ExtractedGhostUpdate> getGhostUpdates(IASTNode iASTNode) {
            return List.of();
        }

        @Override
        public Set<IExtractedWitnessDeclaration> getGlobalDeclarations() {
            return Set.of();
        }

        @Override
        public List<String> printAllEntries() {
            return this.mInvariants.values().stream().map(labeledInvariant -> labeledInvariant.getInvariant().toString()).collect(Collectors.toList());
        }
    }

    private static interface IHasIncoming {
        public boolean isIncoming();
    }

    private static final class LabeledInvariant {
        private final ExtractedWitnessInvariant mInvariant;
        private final ImmutableSet<String> mLabels;

        public LabeledInvariant(ExtractedWitnessInvariant extractedWitnessInvariant, ImmutableSet<String> immutableSet) {
            this.mInvariant = extractedWitnessInvariant;
            this.mLabels = immutableSet;
        }

        public ExtractedWitnessInvariant getInvariant() {
            return this.mInvariant;
        }

        public IASTNode getRelatedAstNode() {
            return this.mInvariant.getRelatedAstNode();
        }

        public ImmutableSet<String> getLabels() {
            return this.mLabels;
        }
    }

    private final class LineMatchingVisitor
    extends ASTGenericVisitor {
        private final DecoratedWitnessEdge mEdge;
        private final Set<MatchedASTNode> mMatchedNodes;
        private final Predicate<IASTNode> mFunMatch;

        public LineMatchingVisitor(DecoratedWitnessEdge decoratedWitnessEdge) {
            super(true);
            this.mEdge = decoratedWitnessEdge;
            this.mMatchedNodes = new HashSet<MatchedASTNode>();
            this.mFunMatch = this.determineMatcher(this.mEdge);
        }

        private Predicate<IASTNode> determineMatcher(DecoratedWitnessEdge decoratedWitnessEdge) {
            return switch (decoratedWitnessEdge.getConditional()) {
                case AtomicTraceElement.StepInfo.NONE -> this::matchNonConditional;
                case AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE -> iASTNode -> this.matchConditional(false, (IASTNode)iASTNode);
                case AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE -> iASTNode -> this.matchConditional(true, (IASTNode)iASTNode);
                case AtomicTraceElement.StepInfo.PROC_CALL, AtomicTraceElement.StepInfo.PROC_RETURN, AtomicTraceElement.StepInfo.ARG_EVAL, AtomicTraceElement.StepInfo.EXPR_EVAL, AtomicTraceElement.StepInfo.FUNC_CALL, AtomicTraceElement.StepInfo.FORK, AtomicTraceElement.StepInfo.JOIN -> throw new UnsupportedOperationException("This conditional case was not yet considered: " + String.valueOf(decoratedWitnessEdge.getConditional()));
                default -> throw new MatchException(null, null);
            };
        }

        public void run(IASTTranslationUnit iASTTranslationUnit) {
            iASTTranslationUnit.accept((ASTVisitor)this);
        }

        private Set<MatchedASTNode> getMatchedNodes() {
            return this.mMatchedNodes;
        }

        protected int genericVisit(IASTNode iASTNode) {
            if (this.mFunMatch.test(iASTNode)) {
                return 1;
            }
            return 3;
        }

        private boolean matchConditional(boolean bl, IASTNode iASTNode) {
            Set<IASTStatement> set;
            IASTStatement iASTStatement;
            if (!this.matchLineNumber(iASTNode)) {
                return false;
            }
            if (!(iASTNode instanceof IASTStatement)) {
                iASTStatement = CdtASTUtils.getEnclosingStatement(iASTNode);
                if (iASTStatement == null) {
                    return false;
                }
            } else {
                iASTStatement = (IASTStatement)iASTNode;
            }
            if ((set = CdtASTUtils.isBranchingStatement(iASTStatement) ? Collections.singleton(iASTStatement) : CdtASTUtils.findDesiredType(iASTNode.getParent(), GraphMLCorrectnessWitnessExtractor.this.mConditionalTypes)).isEmpty()) {
                return false;
            }
            if (set.size() > 1) {
                GraphMLCorrectnessWitnessExtractor.this.mLogger.warn((Object)"Possible match is too ambiguous");
                return false;
            }
            IASTStatement iASTStatement2 = CdtASTUtils.findBranchingSuccessorStatement(bl, set.iterator().next());
            if (iASTStatement2 == null) {
                return false;
            }
            this.mMatchedNodes.add(new MatchedASTNode((IASTNode)iASTStatement2, this.mEdge));
            return true;
        }

        private boolean matchNonConditional(IASTNode iASTNode) {
            if (this.matchLineNumber(iASTNode)) {
                this.mMatchedNodes.add(new MatchedASTNode(iASTNode, this.mEdge));
                return true;
            }
            return false;
        }

        private boolean matchLineNumber(IASTNode iASTNode) {
            IASTFileLocation iASTFileLocation = iASTNode.getFileLocation();
            if (iASTFileLocation == null) {
                return false;
            }
            return this.mEdge.getLineNumber() == iASTFileLocation.getEndingLineNumber() && this.mEdge.isIncoming() || this.mEdge.getLineNumber() == iASTFileLocation.getStartingLineNumber() && !this.mEdge.isIncoming();
        }
    }

    private static final class MatchedASTNode
    implements IHasIncoming {
        private final IASTNode mNode;
        private final DecoratedWitnessEdge mEdge;

        private MatchedASTNode(IASTNode iASTNode, DecoratedWitnessEdge decoratedWitnessEdge) {
            this.mNode = iASTNode;
            this.mEdge = decoratedWitnessEdge;
        }

        private IASTNode getNode() {
            return this.mNode;
        }

        @Override
        public boolean isIncoming() {
            return this.mEdge.isIncoming();
        }

        public boolean isLoopHead() {
            return this.mEdge.isEnteringLoop() && this.isIncoming();
        }

        public String toString() {
            return this.toStringSimple() + " " + this.mNode.getRawSignature();
        }

        public String toStringSimple() {
            return "Node: " + this.getLineNumberString() + " Edge: " + String.valueOf(this.mEdge);
        }

        private String getLineNumberString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[L");
            stringBuilder.append(this.mNode.getFileLocation().getStartingLineNumber());
            if (this.mNode.getFileLocation().getStartingLineNumber() != this.mNode.getFileLocation().getEndingLineNumber()) {
                stringBuilder.append('-');
                stringBuilder.append(this.mNode.getFileLocation().getEndingLineNumber());
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

