/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfClosure<T>
implements Closure<T>,
Serializable {
    static final long serialVersionUID = 3518477308466486130L;
    private final Predicate<? super T> iPredicate;
    private final Closure<? super T> iTrueClosure;
    private final Closure<? super T> iFalseClosure;

    public static <T> Closure<T> getInstance(Predicate<? super T> predicate, Closure<? super T> trueClosure, Closure<? super T> falseClosure) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        if (trueClosure == null || falseClosure == null) {
            throw new IllegalArgumentException("Closures must not be null");
        }
        return new IfClosure<T>(predicate, trueClosure, falseClosure);
    }

    public IfClosure(Predicate<? super T> predicate, Closure<? super T> trueClosure, Closure<? super T> falseClosure) {
        this.iPredicate = predicate;
        this.iTrueClosure = trueClosure;
        this.iFalseClosure = falseClosure;
    }

    @Override
    public void execute(T input) {
        if (this.iPredicate.evaluate(input)) {
            this.iTrueClosure.execute(input);
        } else {
            this.iFalseClosure.execute(input);
        }
    }

    public Predicate<? super T> getPredicate() {
        return this.iPredicate;
    }

    public Closure<? super T> getTrueClosure() {
        return this.iTrueClosure;
    }

    public Closure<? super T> getFalseClosure() {
        return this.iFalseClosure;
    }
}

