/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.ArrayList;
import java.util.List;

public class StatementExtractor
extends RCFGEdgeVisitor {
    private final ILogger mLogger;
    private List<Statement> mStatements;
    private boolean mHasSummary;

    public StatementExtractor(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public List<Statement> process(CodeBlock codeBlock) {
        this.mStatements = new ArrayList<Statement>();
        this.mHasSummary = false;
        this.visit(codeBlock);
        if (this.mHasSummary) {
            this.mLogger.debug((Object)(String.valueOf(codeBlock) + " contains summaries, skipping..."));
            return new ArrayList<Statement>();
        }
        return this.mStatements;
    }

    public boolean hasSummary() {
        return this.mHasSummary;
    }

    protected void visit(ParallelComposition parallelComposition) {
        throw new UnsupportedOperationException("Cannot merge ParallelComposition");
    }

    protected void visit(StatementSequence statementSequence) {
        this.mStatements.addAll(statementSequence.getStatements());
        super.visit(statementSequence);
    }

    protected void visit(Summary summary) {
        this.mHasSummary = true;
        super.visit(summary);
    }
}

