/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.AnnotationToProofTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LAAnnotation
implements IAnnotation {
    private final Map<Literal, Rational> mCoefficients = new HashMap<Literal, Rational>();
    private final Map<LAAnnotation, Rational> mAuxAnnotations = new HashMap<LAAnnotation, Rational>();
    private LinVar mLinvar;
    private InfinitesimalNumber mBound;
    private boolean mIsUpper;

    public LAAnnotation() {
    }

    public LAAnnotation(LAReason lAReason) {
        this();
        this.mLinvar = lAReason.getVar();
        this.mBound = lAReason.getBound();
        this.mIsUpper = lAReason.isUpper();
    }

    public Map<Literal, Rational> getCoefficients() {
        return this.mCoefficients;
    }

    public Map<LAAnnotation, Rational> getAuxAnnotations() {
        return this.mAuxAnnotations;
    }

    public void addFarkas(LAAnnotation lAAnnotation, Rational rational) {
        Rational rational2 = this.mAuxAnnotations.get(lAAnnotation);
        if (rational2 == null) {
            rational2 = Rational.ZERO;
        }
        assert (rational2.signum() * rational.signum() >= 0);
        rational2 = rational2.add(rational);
        this.mAuxAnnotations.put(lAAnnotation, rational2);
    }

    public void addFarkas(Literal literal, Rational rational) {
        Rational rational2 = this.mCoefficients.get(literal);
        if (rational2 == null) {
            rational2 = Rational.ZERO;
        }
        assert (literal.getAtom() instanceof LAEquality || rational2.signum() * rational.signum() >= 0);
        if ((rational2 = rational2.add(rational)) == Rational.ZERO) {
            this.mCoefficients.remove(literal);
        } else {
            this.mCoefficients.put(literal, rational2);
        }
    }

    MutableAffineTerm addLiterals() {
        Object object;
        Rational rational;
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        for (Map.Entry<Literal, Rational> entry : this.mCoefficients.entrySet()) {
            DPLLAtom dPLLAtom;
            rational = entry.getValue();
            object = entry.getKey();
            if (((Literal)object).getAtom() instanceof BoundConstraint) {
                dPLLAtom = (BoundConstraint)((Literal)object).getAtom();
                InfinitesimalNumber infinitesimalNumber = ((BoundConstraint)dPLLAtom).getBound();
                assert (rational.signum() > 0 == (dPLLAtom != object));
                if (dPLLAtom == object) {
                    infinitesimalNumber = ((BoundConstraint)dPLLAtom).getInverseBound();
                }
                mutableAffineTerm.add(rational, ((BoundConstraint)dPLLAtom).getVar());
                mutableAffineTerm.add(infinitesimalNumber.mul(rational.negate()));
                continue;
            }
            dPLLAtom = (LAEquality)((Literal)object).getAtom();
            if (dPLLAtom == object) {
                assert (rational.abs().equals((Object)Rational.ONE));
                mutableAffineTerm.add(((LAEquality)dPLLAtom).getVar().getEpsilon());
                continue;
            }
            mutableAffineTerm.add(rational, ((LAEquality)dPLLAtom).getVar());
            mutableAffineTerm.add(((LAEquality)dPLLAtom).getBound().mul(rational.negate()));
        }
        for (Map.Entry<Object, Rational> entry : this.mAuxAnnotations.entrySet()) {
            rational = entry.getValue();
            object = (LAAnnotation)entry.getKey();
            assert (rational.signum() > 0 == ((LAAnnotation)object).mIsUpper);
            mutableAffineTerm.add(rational, ((LAAnnotation)object).mLinvar);
            mutableAffineTerm.add(((LAAnnotation)object).mBound.mul(rational.negate()));
        }
        return mutableAffineTerm;
    }

    public String toString() {
        return this.mCoefficients.toString() + this.mAuxAnnotations.toString();
    }

    @Override
    public Term toTerm(Clause clause, ProofRules proofRules) {
        assert (this.mCoefficients != null);
        return new AnnotationToProofTerm().convert(this, proofRules);
    }

    public int hashCode() {
        return this.mLinvar == null ? 0 : HashUtils.hashJenkins((int)this.mBound.hashCode(), (Object)this.mLinvar);
    }

    public LinVar getLinVar() {
        return this.mLinvar;
    }

    public InfinitesimalNumber getBound() {
        return this.mBound;
    }

    public boolean isUpper() {
        return this.mIsUpper;
    }

    private void collect(HashSet<Literal> hashSet, HashSet<LAAnnotation> hashSet2) {
        if (hashSet2.add(this)) {
            hashSet.addAll(this.mCoefficients.keySet());
            for (LAAnnotation lAAnnotation : this.mAuxAnnotations.keySet()) {
                lAAnnotation.collect(hashSet, hashSet2);
            }
        }
    }

    public Literal[] collectLiterals() {
        HashSet<Literal> hashSet = new HashSet<Literal>();
        this.collect(hashSet, new HashSet<LAAnnotation>());
        return hashSet.toArray(new Literal[hashSet.size()]);
    }
}

