/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.mso;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.mso.MSODAlphabetSymbol;
import de.uni_freiburg.informatik.ultimate.mso.MSODStringFactory;
import de.uni_freiburg.informatik.ultimate.mso.MSODUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class MSODFormulaOperations {
    public Map<Term, List<Integer>> wordToNumbers(NestedWord<MSODAlphabetSymbol> nestedWord, int n) {
        HashMap<Term, List<Integer>> hashMap = new HashMap<Term, List<Integer>>();
        int n2 = 0;
        while (n2 < nestedWord.length()) {
            int n3 = this.indexToInteger(n2 + n);
            MSODAlphabetSymbol mSODAlphabetSymbol = (MSODAlphabetSymbol)nestedWord.getSymbol(n2);
            for (Map.Entry<Term, Boolean> entry : mSODAlphabetSymbol.getMap().entrySet()) {
                hashMap.putIfAbsent(entry.getKey(), new ArrayList());
                if (!entry.getValue().booleanValue()) continue;
                if (n3 < 0) {
                    ((List)hashMap.get(entry.getKey())).add(0, n3);
                    continue;
                }
                ((List)hashMap.get(entry.getKey())).add(n3);
            }
            ++n2;
        }
        return hashMap;
    }

    public static Term stemResult(Script script, Term term, List<Integer> list) {
        if (term.getSort().equals(SmtSortUtils.getIntSort((Script)script))) {
            assert (list.size() == 1) : "Int variable must have exactly one value.";
            return MSODUtils.intConstant(script, list.get(0));
        }
        Term term2 = script.term("false", new Term[0]);
        TermVariable termVariable = term.getTheory().createTermVariable("x", SmtSortUtils.getIntSort((Script)script));
        Integer n = null;
        int n2 = 0;
        while (n2 < list.size()) {
            if (n2 + 1 < list.size() && list.get(n2) == list.get(n2 + 1) - 1) {
                if (n == null) {
                    n = list.get(n2);
                }
            } else if (n == null) {
                var7_7 = SmtUtils.binaryEquality((Script)script, (Term)termVariable, (Term)MSODUtils.intConstant(script, list.get(n2)));
                term2 = SmtUtils.or((Script)script, (Term[])new Term[]{term2, var7_7});
            } else {
                var7_7 = SmtUtils.geq((Script)script, (Term)termVariable, (Term)MSODUtils.intConstant(script, n));
                Term term3 = SmtUtils.leq((Script)script, (Term)termVariable, (Term)MSODUtils.intConstant(script, list.get(n2)));
                term2 = SmtUtils.or((Script)script, (Term[])new Term[]{term2, SmtUtils.and((Script)script, (Term[])new Term[]{var7_7, term3})});
                n = null;
            }
            ++n2;
        }
        return term2;
    }

    public static Term loopResultPartial(Script script, Term term, List<Integer> list, Integer n, int n2) {
        Term term2;
        Term term3 = script.term("false", new Term[0]);
        TermVariable termVariable = term.getTheory().createTermVariable("x", SmtSortUtils.getIntSort((Script)script));
        Integer n3 = null;
        int n4 = 0;
        while (n4 < list.size()) {
            if (n4 + 1 < list.size() && list.get(n4) == list.get(n4 + 1) - 1) {
                if (n3 == null) {
                    n3 = list.get(n4);
                }
            } else {
                term2 = SmtUtils.mod((Script)script, (Term)termVariable, (Term)MSODUtils.intConstant(script, n2));
                if (n3 == null) {
                    var10_11 = MSODUtils.intConstant(script, list.get(n4) % n2);
                    var11_12 = SmtUtils.binaryEquality((Script)script, (Term)term2, (Term)var10_11);
                    term3 = SmtUtils.or((Script)script, (Term[])new Term[]{term3, var11_12});
                } else {
                    var10_11 = SmtUtils.geq((Script)script, (Term)term2, (Term)MSODUtils.intConstant(script, n3 % n2));
                    var11_12 = SmtUtils.leq((Script)script, (Term)term2, (Term)MSODUtils.intConstant(script, list.get(n4) % n2));
                    term3 = SmtUtils.or((Script)script, (Term[])new Term[]{term3, SmtUtils.and((Script)script, (Term[])new Term[]{var10_11, var11_12})});
                    n3 = null;
                }
            }
            ++n4;
        }
        Term term4 = MSODUtils.intConstant(script, n);
        term2 = n < 0 ? SmtUtils.leq((Script)script, (Term)termVariable, (Term)term4) : SmtUtils.geq((Script)script, (Term)termVariable, (Term)term4);
        return SmtUtils.and((Script)script, (Term[])new Term[]{term3, term2});
    }

    public static Term loopResult(Script script, Term term, List<Integer> list, Pair<Integer, Integer> pair, int n) {
        Integer n22;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Integer n22 : list) {
            if (n22 < 0) {
                arrayList.add(n22);
                continue;
            }
            arrayList2.add(n22);
        }
        n22 = MSODFormulaOperations.loopResultPartial(script, term, arrayList, (Integer)pair.getFirst(), n);
        Term term2 = MSODFormulaOperations.loopResultPartial(script, term, arrayList2, (Integer)pair.getSecond(), n);
        return SmtUtils.or((Script)script, (Term[])new Term[]{n22, term2});
    }

    public static NestedWordAutomaton<MSODAlphabetSymbol, String> emptyAutomaton(AutomataLibraryServices automataLibraryServices) {
        return new NestedWordAutomaton(automataLibraryServices, new VpAlphabet(new HashSet()), (IEmptyStackStateFactory)new MSODStringFactory());
    }

    public static NestedWordAutomaton<MSODAlphabetSymbol, String> trueAutomaton(AutomataLibraryServices automataLibraryServices) {
        NestedWordAutomaton<MSODAlphabetSymbol, String> nestedWordAutomaton = MSODFormulaOperations.emptyAutomaton(automataLibraryServices);
        MSODAlphabetSymbol mSODAlphabetSymbol = new MSODAlphabetSymbol();
        nestedWordAutomaton.getAlphabet().add(mSODAlphabetSymbol);
        nestedWordAutomaton.addState(true, true, (Object)"init");
        nestedWordAutomaton.addInternalTransition((Object)"init", (Object)mSODAlphabetSymbol, (Object)"init");
        return nestedWordAutomaton;
    }

    public static NestedWordAutomaton<MSODAlphabetSymbol, String> falseAutomaton(AutomataLibraryServices automataLibraryServices) {
        NestedWordAutomaton<MSODAlphabetSymbol, String> nestedWordAutomaton = MSODFormulaOperations.emptyAutomaton(automataLibraryServices);
        MSODAlphabetSymbol mSODAlphabetSymbol = new MSODAlphabetSymbol();
        nestedWordAutomaton.getAlphabet().add(mSODAlphabetSymbol);
        nestedWordAutomaton.addState(true, false, (Object)"init");
        nestedWordAutomaton.addInternalTransition((Object)"init", (Object)mSODAlphabetSymbol, (Object)"init");
        return nestedWordAutomaton;
    }

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> strictIneqAutomaton(AutomataLibraryServices var1, Term var2, Rational var3);

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> strictIneqAutomaton(AutomataLibraryServices var1, Term var2, Term var3, Rational var4) throws AutomataLibraryException;

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> strictNegIneqAutomaton(AutomataLibraryServices var1, Term var2, Rational var3);

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> strictSubsetAutomaton(AutomataLibraryServices var1, Term var2, Term var3);

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> subsetAutomaton(AutomataLibraryServices var1, Term var2, Term var3);

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> elementAutomaton(AutomataLibraryServices var1, Term var2, Rational var3, Term var4) throws AutomataLibraryException;

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> constElementAutomaton(AutomataLibraryServices var1, Rational var2, Term var3);

    public abstract int indexToInteger(int var1);

    public abstract Pair<Integer, Integer> stemBounds(int var1);
}

