/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ILoiPredicateStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MapBasedStorage
implements ILoiPredicateStorage {
    private final ILogger mLogger;
    private final Map<IcfgLocation, IPredicate> mPredsForLocs = new HashMap<IcfgLocation, IPredicate>();

    public MapBasedStorage(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    @Override
    public void storePredicate(IcfgLocation icfgLocation, IPredicate iPredicate) {
        this.logBeforeRegisterLoi(icfgLocation, iPredicate);
        IPredicate iPredicate2 = this.mPredsForLocs.put(icfgLocation, iPredicate);
        if (iPredicate2 != null) {
            throw new IllegalStateException("Tried to register predicate for LOI which already had a predicate.");
        }
    }

    private void logBeforeRegisterLoi(IcfgLocation icfgLocation, IPredicate iPredicate) {
        this.mLogger.debug("LOI %s received the predicate %s", new Object[]{icfgLocation, iPredicate});
    }

    public Map<IcfgLocation, IPredicate> getMap() {
        return this.mPredsForLocs;
    }

    public Map<IcfgLocation, IPredicate> addDefaultsAndGetMap(Collection<IcfgLocation> collection, IPredicate iPredicate) {
        collection.forEach(icfgLocation -> {
            IPredicate iPredicate2 = this.mPredsForLocs.putIfAbsent((IcfgLocation)icfgLocation, iPredicate);
        });
        return this.mPredsForLocs;
    }

    public IPredicate getSingletonOrDefault(IPredicate iPredicate) {
        if (this.mPredsForLocs.isEmpty()) {
            return iPredicate;
        }
        if (this.mPredsForLocs.size() == 1) {
            return this.mPredsForLocs.values().iterator().next();
        }
        throw new IllegalStateException("Excepted single value but found " + String.valueOf(this.mPredsForLocs));
    }
}

