/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IWorklistItem;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.WorklistItem;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Deque;
import java.util.stream.Stream;

public final class LoggingHelper {
    private LoggingHelper() {
    }

    public static <STATE extends IAbstractState<STATE>> StringBuilder getStateString(STATE STATE) {
        if (STATE == null) {
            return new StringBuilder("__");
        }
        return LoggingHelper.addHashCodeString(new StringBuilder(), STATE).append(' ').append(STATE.toLogString());
    }

    public static <ACTION> StringBuilder getTransitionString(ACTION ACTION, ITransitionProvider<ACTION, ?> iTransitionProvider) {
        return LoggingHelper.addHashCodeString(new StringBuilder(), ACTION).append(' ').append(iTransitionProvider.toLogString(ACTION));
    }

    public static StringBuilder getHashCodeString(Object object) {
        return LoggingHelper.addHashCodeString(new StringBuilder(), object);
    }

    public static StringBuilder addHashCodeString(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            return stringBuilder.append("[?]");
        }
        return stringBuilder.append('[').append(object.hashCode()).append(']');
    }

    public static <ACTION, STORE extends IAbstractStateStorage<?, ACTION, ?>> String getScopeStackString(Deque<Pair<ACTION, STORE>> deque) {
        return ((Stream)deque.stream().sequential()).map(pair -> pair.getFirst()).map(object -> object == null ? "[G]" : LoggingHelper.getHashCodeString(object).toString()).reduce((string, string2) -> string + string2).orElseThrow(AssertionError::new);
    }

    public static String getPrecedessorSequence(WorklistItem<?, ?, ?, ?> worklistItem) {
        if (worklistItem == null) {
            return "???";
        }
        StringBuilder stringBuilder = new StringBuilder();
        IWorklistItem iWorklistItem = worklistItem;
        while (iWorklistItem.getPredecessor() != null) {
            stringBuilder.append(iWorklistItem.toExtendedString()).append(CoreUtil.getPlatformLineSeparator());
            iWorklistItem = iWorklistItem.getPredecessor();
        }
        return stringBuilder.toString();
    }
}

