/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementFKV;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.BuchiIntersect;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.DifferencePairwiseOnDemand;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.RemoveDeadBuchi;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementFkvStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiCegarLoopBenchmarkGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.RankVarConstructor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.AbstractBuchiCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.Marking2MLPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import java.util.stream.Collectors;

public class BuchiPetriNetCegarLoop<L extends IIcfgTransition<?>>
extends AbstractBuchiCegarLoop<L, IPetriNet<L, IPredicate>> {
    private final Marking2MLPredicate mMarking2MLPredicate;

    public BuchiPetriNetCegarLoop(IIcfg<?> iIcfg, RankVarConstructor rankVarConstructor, PredicateFactory predicateFactory, TAPreferences tAPreferences, IUltimateServiceProvider iUltimateServiceProvider, Class<L> clazz, IPetriNet<L, IPredicate> iPetriNet, BuchiCegarLoopBenchmarkGenerator buchiCegarLoopBenchmarkGenerator) {
        super(iIcfg, rankVarConstructor, predicateFactory, tAPreferences, iUltimateServiceProvider, clazz, iPetriNet, buchiCegarLoopBenchmarkGenerator);
        this.mMarking2MLPredicate = new Marking2MLPredicate(predicateFactory);
    }

    @Override
    protected boolean isAbstractionEmpty(IPetriNet<L, IPredicate> iPetriNet) throws AutomataLibraryException {
        BuchiIsEmpty buchiIsEmpty = new BuchiIsEmpty(new AutomataLibraryServices(this.mServices), iPetriNet, this.mPref.eventOrder(), this.mPref.cutOffRequiresSameTransition(), true);
        PetriNetLassoRun petriNetLassoRun = buchiIsEmpty.getRun();
        if (petriNetLassoRun == null) {
            return true;
        }
        this.mCounterexample = new NestedLassoRun(this.constructNestedLassoRun(petriNetLassoRun.getStem()), this.constructNestedLassoRun(petriNetLassoRun.getLoop()));
        return false;
    }

    private NestedRun<L, IPredicate> constructNestedLassoRun(PetriNetRun<L, IPredicate> petriNetRun) {
        return new NestedRun(NestedWord.nestedWord((Word)petriNetRun.getWord()), petriNetRun.getStateSequence().stream().map(this.mMarking2MLPredicate::markingToPredicate).collect(Collectors.toList()));
    }

    @Override
    protected IPetriNet<L, IPredicate> refineFinite(IPetriNet<L, IPredicate> iPetriNet, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider) throws AutomataLibraryException {
        try {
            return new DifferencePairwiseOnDemand(new AutomataLibraryServices(this.mServices), iPetriNet, iNwaOutgoingLetterAndTransitionProvider).getResult();
        }
        catch (AutomataOperationCanceledException | PetriNetNot1SafeException throwable) {
            throw new AutomataLibraryException(this.getClass(), throwable.toString());
        }
    }

    @Override
    protected IPetriNet<L, IPredicate> refineBuchi(IPetriNet<L, IPredicate> iPetriNet, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider) throws AutomataLibraryException {
        PowersetDeterminizer powersetDeterminizer = new PowersetDeterminizer(iNwaOutgoingLetterAndTransitionProvider, this.mUseDoubleDeckers, (IDeterminizeStateFactory)this.mDefaultStateFactory);
        BuchiComplementFKV buchiComplementFKV = new BuchiComplementFKV(new AutomataLibraryServices(this.mServices), (IBuchiComplementFkvStateFactory)this.mDefaultStateFactory, iNwaOutgoingLetterAndTransitionProvider, (IStateDeterminizer)powersetDeterminizer);
        this.mBenchmarkGenerator.reportHighestRank(buchiComplementFKV.getHighestRank());
        BuchiIntersect buchiIntersect = new BuchiIntersect(new AutomataLibraryServices(this.mServices), (IBlackWhiteStateFactory)this.mDefaultStateFactory, iPetriNet, (INestedWordAutomaton)buchiComplementFKV.getResult());
        return buchiIntersect.getResult();
    }

    @Override
    protected IPetriNet<L, IPredicate> reduceAbstractionSize(IPetriNet<L, IPredicate> iPetriNet, TraceAbstractionPreferenceInitializer.Minimization minimization) throws AutomataOperationCanceledException {
        try {
            return new RemoveDeadBuchi(new AutomataLibraryServices(this.mServices), iPetriNet, null).getResult();
        }
        catch (AutomataOperationCanceledException | PetriNetNot1SafeException throwable) {
            this.mLogger.warn((Object)("Unhandled " + String.valueOf(throwable) + "occured during abstraction size reduction. Continuing with non-reduced net"));
            return iPetriNet;
        }
    }
}

