/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.IcfgCompositionFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AutomataDefinitionInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IWitnessTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionStarter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IcfgCopyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.WitnessModelToAutomatonTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.WitnessUtils;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AbstractNestedwordAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataTestFileAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.EpsilonNestedwordAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.NestedwordAutomatonAST;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import java.util.ArrayList;
import java.util.List;

public class TraceAbstractionObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final List<IIcfg<?>> mIcfgs;
    private IElement mRootOfNewModel;
    private IWitnessTransformer<IcfgEdge> mTransformer;
    private final List<AutomataTestFileAST> mAutomataTestFileAsts;
    private boolean mLastModel;
    private ModelType mCurrentGraphType;

    public TraceAbstractionObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mLastModel = false;
        this.mIcfgs = new ArrayList();
        this.mAutomataTestFileAsts = new ArrayList<AutomataTestFileAST>();
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof IIcfg) {
            this.mIcfgs.add((IIcfg)iElement);
        }
        if (this.mCurrentGraphType.getType() == ModelType.Type.VIOLATION_WITNESS && (iElement instanceof WitnessNode || iElement instanceof Witness)) {
            if (this.mTransformer != null) {
                throw new UnsupportedOperationException("Found multiple violation witnesses");
            }
            if (iElement instanceof WitnessNode) {
                this.mLogger.warn((Object)"Found a witness automaton. I will only consider traces that are accepted by the witness automaton");
                INestedWordAutomaton<WitnessEdge, WitnessNode> iNestedWordAutomaton = new WitnessModelToAutomatonTransformer((WitnessNode)iElement, this.mServices).getResult();
                this.mTransformer = (iNwaOutgoingLetterAndTransitionProvider, predicateFactory) -> WitnessUtils.constructGraphMLWitnessProduct(this.mServices, iNwaOutgoingLetterAndTransitionProvider, (INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode>)iNestedWordAutomaton, predicateFactory, this.mLogger, WitnessUtils.Property.NON_REACHABILITY);
            }
            if (iElement instanceof Witness) {
                this.mLogger.warn((Object)"Found a witness in the YAML format. I will only consider traces that are accepted by the witness");
                this.mTransformer = (iNwaOutgoingLetterAndTransitionProvider, predicateFactory) -> WitnessUtils.constructYamlWitnessProduct(this.mServices, iNwaOutgoingLetterAndTransitionProvider, (Witness)iElement, predicateFactory, this.mLogger, WitnessUtils.Property.NON_REACHABILITY);
            }
        }
        if (iElement instanceof AutomataTestFileAST) {
            this.mAutomataTestFileAsts.add((AutomataTestFileAST)iElement);
        }
        return false;
    }

    public void finish() {
        if (!this.mLastModel) {
            return;
        }
        if (this.mIcfgs.isEmpty()) {
            throw new IllegalArgumentException("No ICFG present, Trace Abstraction cannot run");
        }
        IIcfg iIcfg3 = this.mIcfgs.stream().filter(iIcfg -> IcfgLocation.class.isAssignableFrom(iIcfg.getLocationClass())).reduce((iIcfg, iIcfg2) -> iIcfg2).orElseThrow(UnsupportedOperationException::new);
        if (iIcfg3 == null) {
            throw new UnsupportedOperationException("TraceAbstraction needs an RCFG");
        }
        this.mLogger.info((Object)("Analyzing ICFG " + iIcfg3.getIdentifier()));
        List<INestedWordAutomaton<String, String>> list = this.constructRawNestedWordAutomata(this.mAutomataTestFileAsts);
        TraceAbstractionStarter<IcfgEdge> traceAbstractionStarter = new TraceAbstractionStarter<IcfgEdge>(this.mServices, (IIcfg<IcfgLocation>)iIcfg3, this.mTransformer, list, () -> new IcfgCompositionFactory(this.mServices, iIcfg3.getCfgSmtToolkit()), new IcfgCopyFactory(this.mServices, iIcfg3.getCfgSmtToolkit()), IcfgEdge.class);
        this.mRootOfNewModel = traceAbstractionStarter.getRootOfNewModel();
    }

    private List<INestedWordAutomaton<String, String>> constructRawNestedWordAutomata(List<AutomataTestFileAST> list) {
        ArrayList<INestedWordAutomaton<String, String>> arrayList = new ArrayList<INestedWordAutomaton<String, String>>();
        for (AutomataTestFileAST automataTestFileAST : list) {
            List list2 = automataTestFileAST.getAutomataDefinitions().getListOfAutomataDefinitions();
            for (AutomatonAST automatonAST : list2) {
                NestedWordAutomaton nestedWordAutomaton;
                if (automatonAST instanceof NestedwordAutomatonAST) {
                    nestedWordAutomaton = AutomataDefinitionInterpreter.constructNestedWordAutomaton((AbstractNestedwordAutomatonAST)((NestedwordAutomatonAST)automatonAST), (IUltimateServiceProvider)this.mServices);
                    arrayList.add((INestedWordAutomaton<String, String>)nestedWordAutomaton);
                    continue;
                }
                if (automatonAST instanceof EpsilonNestedwordAutomatonAST) {
                    nestedWordAutomaton = AutomataDefinitionInterpreter.constructEpsilonNestedWordAutomaton((EpsilonNestedwordAutomatonAST)((EpsilonNestedwordAutomatonAST)automatonAST), (IUltimateServiceProvider)this.mServices);
                    arrayList.add((INestedWordAutomaton<String, String>)nestedWordAutomaton);
                    continue;
                }
                throw new UnsupportedOperationException("Reading " + automatonAST.getClass().getSimpleName() + " not yet supported");
            }
        }
        return arrayList;
    }

    public IElement getRootOfNewModel() {
        return this.mRootOfNewModel;
    }

    public void init(ModelType modelType, int n, int n2) {
        this.mCurrentGraphType = modelType;
        if (n == n2 - 1) {
            this.mLastModel = true;
        }
    }

    public boolean performedChanges() {
        return false;
    }
}

