/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslatedACSLValue;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSL2BoogieBacktranslator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BacktranslationPointer2D
implements CACSL2BoogieBacktranslator.IBacktranslationPointer {
    private final CACSL2BoogieBacktranslator mBacktranslator;

    public BacktranslationPointer2D(CACSL2BoogieBacktranslator cACSL2BoogieBacktranslator) {
        this.mBacktranslator = cACSL2BoogieBacktranslator;
    }

    @Override
    public List<Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>>> collectAllPointers(List<Pair<Expression, Collection<Expression>>> list) {
        ArrayList<Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>>> arrayList = new ArrayList<Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>>>();
        Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>> pair = this.extractTemporaryPointerExpression(list);
        while (pair != null) {
            arrayList.add(pair);
            pair = this.extractTemporaryPointerExpression(list);
        }
        return arrayList;
    }

    private Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>> extractTemporaryPointerExpression(List<Pair<Expression, Collection<Expression>>> list) {
        int n = list.size() - 1;
        while (n >= 0) {
            Pair<Expression, Collection<Expression>> pair = list.get(n);
            PointerVariable2D pointerVariable2D = PointerVariable2D.fromBaseExpression((Expression)pair.getFirst());
            if (pointerVariable2D != null) {
                int n2 = list.size() - 1;
                while (n2 >= 0) {
                    Pair<Expression, Collection<Expression>> pair2 = list.get(n2);
                    if (pointerVariable2D.isMatchingPointerOffset((Expression)pair2.getFirst())) {
                        if (((Collection)pair.getSecond()).size() != 1 || ((Collection)pair2.getSecond()).size() != 1) {
                            this.mBacktranslator.reportUnfinishedBacktranslation("Pointers with multiple values");
                        }
                        Expression expression = (Expression)DataStructureUtils.getOneAndOnly((Iterable)((Iterable)pair.getSecond()), (String)"pointer base");
                        Expression expression2 = (Expression)DataStructureUtils.getOneAndOnly((Iterable)((Iterable)pair2.getSecond()), (String)"pointer offset");
                        PointerValue2D pointerValue2D = new PointerValue2D(expression, expression2);
                        list.remove(pair);
                        list.remove(pair2);
                        ArrayList<PointerValue2D> arrayList = new ArrayList<PointerValue2D>();
                        arrayList.add(pointerValue2D);
                        return new Pair((Object)pointerVariable2D.toExpression(), arrayList);
                    }
                    --n2;
                }
            }
            --n;
        }
        return null;
    }

    @Override
    public BacktranslatedACSLValue translatePointer(CACSL2BoogieBacktranslator.IPointerValue iPointerValue) {
        assert (iPointerValue instanceof PointerValue2D) : "pointer must be a PointerValue2D";
        PointerValue2D pointerValue2D = (PointerValue2D)iPointerValue;
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.mBacktranslator.translateExpression(pointerValue2D.base());
        if (!backtranslatedExpression.range().isSingleton()) {
            this.mBacktranslator.reportUnfinishedBacktranslation("Pointer with non-unique base value");
            return null;
        }
        BigInteger bigInteger = backtranslatedExpression.range().getMinValue();
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2 = this.mBacktranslator.translateExpression(pointerValue2D.offset());
        if (!backtranslatedExpression2.range().isSingleton()) {
            this.mBacktranslator.reportUnfinishedBacktranslation("Pointer with non-unique base value");
            return null;
        }
        BigInteger bigInteger2 = backtranslatedExpression2.range().getMinValue();
        return new BacktranslatedACSLValue.FakePointer2D(bigInteger, bigInteger2);
    }

    private record PointerValue2D(Expression base, Expression offset) implements CACSL2BoogieBacktranslator.IPointerValue
    {
    }

    private record PointerVariable2D(ILocation loc, IdentifierExpression rawPointer, boolean isOld) {
        static PointerVariable2D fromBaseExpression(Expression expression) {
            PointerVariable2D pointerVariable2D;
            UnaryExpression unaryExpression;
            IdentifierExpression identifierExpression;
            if (expression instanceof IdentifierExpression && (identifierExpression = (IdentifierExpression)expression).getIdentifier().endsWith("base")) {
                String string = identifierExpression.getIdentifier();
                String string2 = string.substring(0, string.length() - "base".length() - 1);
                IdentifierExpression identifierExpression2 = new IdentifierExpression(identifierExpression.getLoc(), identifierExpression.getType(), string2, identifierExpression.getDeclarationInformation());
                return new PointerVariable2D(identifierExpression2.getLoc(), identifierExpression2, false);
            }
            if (expression instanceof UnaryExpression && (unaryExpression = (UnaryExpression)expression).getOperator() == UnaryExpression.Operator.OLD && (pointerVariable2D = PointerVariable2D.fromBaseExpression(unaryExpression.getExpr())) != null) {
                return new PointerVariable2D(unaryExpression.getLoc(), pointerVariable2D.rawPointer(), true);
            }
            return null;
        }

        boolean isMatchingPointerOffset(Expression expression) {
            if (this.isOld() && expression instanceof UnaryExpression) {
                UnaryExpression unaryExpression = (UnaryExpression)expression;
                return unaryExpression.getOperator() == UnaryExpression.Operator.OLD && this.asNonOld().isMatchingPointerOffset(unaryExpression.getExpr());
            }
            if (!this.isOld() && expression instanceof IdentifierExpression) {
                IdentifierExpression identifierExpression = (IdentifierExpression)expression;
                String string = identifierExpression.getIdentifier();
                return string.startsWith(this.rawPointer().getIdentifier()) && string.endsWith("offset");
            }
            return false;
        }

        Expression toExpression() {
            if (this.isOld) {
                return new UnaryExpression(this.loc, UnaryExpression.Operator.OLD, (Expression)this.rawPointer);
            }
            return this.rawPointer;
        }

        PointerVariable2D asNonOld() {
            return new PointerVariable2D(this.rawPointer.getLoc(), this.rawPointer, false);
        }
    }
}

