/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class DoubleDeckerVisitor<LETTER, STATE> {
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    protected INestedWordAutomaton<LETTER, STATE> mTraversedNwa;
    protected boolean mRemoveDeadEnds;
    protected boolean mRemoveNonLiveStates;
    protected boolean mComputePredecessorDoubleDeckers = true;
    private final Map<STATE, Map<STATE, ReachFinal>> mMarkedUp2Down = new HashMap<STATE, Map<STATE, ReachFinal>>();
    private final List<DoubleDecker<STATE>> mWorklist = new LinkedList<DoubleDecker<STATE>>();
    private final Map<STATE, Map<STATE, STATE>> mCallReturnSummary = new HashMap<STATE, Map<STATE, STATE>>();
    private long mDeadEndRemovalTime;
    private Set<STATE> mDeadEnds;

    public DoubleDeckerVisitor(AutomataLibraryServices automataLibraryServices) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
    }

    public Object getResult() {
        return this.mTraversedNwa;
    }

    private final boolean wasMarked(DoubleDecker<STATE> doubleDecker) {
        Map<STATE, ReachFinal> map = this.mMarkedUp2Down.get(doubleDecker.getUp());
        if (map == null) {
            return false;
        }
        return map.containsKey(doubleDecker.getDown());
    }

    private final void mark(DoubleDecker<STATE> doubleDecker) {
        Map<STATE, ReachFinal> map = this.mMarkedUp2Down.get(doubleDecker.getUp());
        if (map == null) {
            map = new HashMap<STATE, ReachFinal>();
            this.mMarkedUp2Down.put(doubleDecker.getUp(), map);
        }
        map.put(doubleDecker.getDown(), ReachFinal.UNKNOWN);
    }

    private final void enqueueAndMark(DoubleDecker<STATE> doubleDecker) {
        if (!this.wasMarked(doubleDecker)) {
            this.mark(doubleDecker);
            this.mWorklist.add(doubleDecker);
        }
    }

    private final void addSummary(STATE STATE, STATE STATE2, STATE STATE3) {
        Map<STATE, STATE> map = this.mCallReturnSummary.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, STATE>();
            this.mCallReturnSummary.put(STATE, map);
        }
        map.put(STATE2, STATE3);
        this.enqueueSummarySuccs(STATE, STATE2, STATE3);
    }

    private final void enqueueSummarySuccs(STATE STATE, STATE STATE2, STATE STATE3) {
        for (STATE STATE4 : this.mMarkedUp2Down.get(STATE).keySet()) {
            DoubleDecker<STATE> doubleDecker = new DoubleDecker<STATE>(STATE4, STATE2);
            this.enqueueAndMark(doubleDecker);
        }
    }

    private final Set<STATE> getKnownDownStates(STATE STATE) {
        Set<STATE> set = this.mMarkedUp2Down.get(STATE).keySet();
        if (set == null) {
            return new HashSet(0);
        }
        return set;
    }

    public Map<STATE, Map<STATE, ReachFinal>> getUp2DownMapping() {
        return Collections.unmodifiableMap(this.mMarkedUp2Down);
    }

    protected final void traverseDoubleDeckerGraph() throws AutomataOperationCanceledException {
        Object object;
        Collection<STATE> collection = this.getInitialStates();
        for (Object object2 : collection) {
            object = new DoubleDecker(this.mTraversedNwa.getEmptyStackState(), object2);
            this.enqueueAndMark((DoubleDecker<STATE>)object);
        }
        while (!this.mWorklist.isEmpty()) {
            DoubleDecker<Object> doubleDecker;
            Map.Entry<STATE, STATE> entry;
            Map<STATE, STATE> map;
            Object object2;
            object2 = this.mWorklist.remove(0);
            Collection<STATE> collection2 = this.visitAndGetInternalSuccessors((DoubleDecker<STATE>)object2);
            Object object3 = collection2.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                map = new DoubleDecker<Object>(((DoubleDecker)object2).getDown(), object);
                this.enqueueAndMark((DoubleDecker<STATE>)((Object)map));
            }
            object = this.visitAndGetCallSuccessors((DoubleDecker<STATE>)object2);
            map = object.iterator();
            while (map.hasNext()) {
                object3 = map.next();
                entry = new DoubleDecker<Object>(((DoubleDecker)object2).getUp(), object3);
                this.enqueueAndMark((DoubleDecker<STATE>)((Object)entry));
            }
            object3 = this.visitAndGetReturnSuccessors((DoubleDecker<STATE>)object2);
            entry = object3.iterator();
            while (entry.hasNext()) {
                map = entry.next();
                this.addSummary(((DoubleDecker)object2).getDown(), map, ((DoubleDecker)object2).getUp());
                for (Iterator<Map.Entry<Object, Object>> iterator : this.getKnownDownStates(((DoubleDecker)object2).getDown())) {
                    doubleDecker = new DoubleDecker<Map<STATE, STATE>>(iterator, map);
                    this.enqueueAndMark(doubleDecker);
                }
            }
            if (this.mCallReturnSummary.containsKey(((DoubleDecker)object2).getUp())) {
                Iterator<Map.Entry<Object, Object>> iterator;
                map = this.mCallReturnSummary.get(((DoubleDecker)object2).getUp());
                iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Iterator iterator2 = entry.getKey();
                    doubleDecker = new DoubleDecker(((DoubleDecker)object2).getDown(), iterator2);
                    this.enqueueAndMark(doubleDecker);
                }
            }
            if (this.mServices.getProgressAwareTimer() == null || this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Before removal of dead ends " + this.mTraversedNwa.sizeInformation()));
        }
        if (this.mRemoveDeadEnds && this.mRemoveNonLiveStates) {
            throw new IllegalArgumentException("RemoveDeadEnds and RemoveNonLiveStates is set");
        }
        this.mDeadEnds = this.computeDeadEnds();
        if (this.mRemoveDeadEnds) {
            this.removeDeadEnds();
            if (this.mTraversedNwa.getInitialStates().isEmpty()) assert (this.mTraversedNwa.getStates().isEmpty());
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)("After removal of dead ends " + this.mTraversedNwa.sizeInformation()));
            }
        }
        if (this.mRemoveNonLiveStates) {
            this.removeNonLiveStates();
            if (this.mTraversedNwa.getInitialStates().isEmpty()) assert (this.mTraversedNwa.getStates().isEmpty());
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)("After removal of nonLiveStates " + this.mTraversedNwa.sizeInformation()));
            }
        }
    }

    protected abstract Collection<STATE> getInitialStates();

    protected abstract Collection<STATE> visitAndGetInternalSuccessors(DoubleDecker<STATE> var1);

    protected abstract Collection<STATE> visitAndGetCallSuccessors(DoubleDecker<STATE> var1);

    protected abstract Collection<STATE> visitAndGetReturnSuccessors(DoubleDecker<STATE> var1);

    private void enqueueInternalPred(STATE STATE, Collection<STATE> collection, DoubleDeckerWorkList doubleDeckerWorkList) {
        for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.mTraversedNwa.internalPredecessors(STATE)) {
            STATE STATE2 = incomingInternalTransition.getPred();
            for (STATE STATE3 : collection) {
                ReachFinal reachFinal = this.mMarkedUp2Down.get(STATE2).get(STATE3);
                if (reachFinal == ReachFinal.UNKNOWN) {
                    doubleDeckerWorkList.add(STATE2, STATE3);
                    continue;
                }
                assert (reachFinal == null || reachFinal == ReachFinal.AT_LEAST_ONCE);
            }
        }
    }

    private void enqueueCallPred(STATE STATE, Collection<STATE> collection, DoubleDeckerWorkList doubleDeckerWorkList) {
        for (IncomingCallTransition<LETTER, STATE> incomingCallTransition : this.mTraversedNwa.callPredecessors(STATE)) {
            STATE STATE2 = incomingCallTransition.getPred();
            for (STATE STATE3 : this.mMarkedUp2Down.get(STATE2).keySet()) {
                ReachFinal reachFinal = this.mMarkedUp2Down.get(STATE2).get(STATE3);
                if (reachFinal == ReachFinal.UNKNOWN) {
                    doubleDeckerWorkList.add(STATE2, STATE3);
                    continue;
                }
                assert (reachFinal == null || reachFinal == ReachFinal.AT_LEAST_ONCE);
            }
        }
    }

    private void enqueueReturnPred(STATE STATE, Collection<STATE> collection, DoubleDeckerWorkList doubleDeckerWorkList, DoubleDeckerWorkList doubleDeckerWorkList2) {
        for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mTraversedNwa.returnPredecessors(STATE)) {
            STATE STATE22;
            STATE STATE3 = incomingReturnTransition.getHierPred();
            boolean bl = false;
            for (STATE STATE22 : collection) {
                ReachFinal reachFinal = this.mMarkedUp2Down.get(STATE3).get(STATE22);
                if (reachFinal == null) continue;
                bl = true;
                if (reachFinal == ReachFinal.UNKNOWN) {
                    doubleDeckerWorkList.add(STATE3, STATE22);
                    continue;
                }
                assert (reachFinal == ReachFinal.AT_LEAST_ONCE);
            }
            STATE22 = incomingReturnTransition.getLinPred();
            if (!bl) continue;
            Object object = this.mMarkedUp2Down.get(STATE22).get(STATE3);
            if (object == ReachFinal.UNKNOWN) {
                doubleDeckerWorkList2.add(STATE22, STATE3);
                continue;
            }
            assert (object == ReachFinal.AT_LEAST_ONCE);
        }
    }

    private final Set<STATE> computeDeadEnds() {
        Iterator<Object> iterator;
        Iterator iterator2;
        Iterator<Object> iterator3;
        ArrayList<Object> arrayList2;
        Map<STATE, ReachFinal> map;
        Object object2;
        HashSet<STATE> hashSet = new HashSet<STATE>(this.mTraversedNwa.getStates());
        DoubleDeckerWorkList doubleDeckerWorkList = new DoubleDeckerWorkList();
        DoubleDeckerWorkList doubleDeckerWorkList2 = new DoubleDeckerWorkList();
        for (Object object2 : this.mTraversedNwa.getFinalStates()) {
            map = this.mMarkedUp2Down.get(object2);
            if (map == null) {
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("Unreachable final state: " + String.valueOf(object2)));
                continue;
            }
            for (ArrayList<Object> arrayList2 : this.mMarkedUp2Down.get(object2).keySet()) {
                doubleDeckerWorkList.add(object2, arrayList2);
            }
        }
        while (!doubleDeckerWorkList.isEmpty()) {
            object2 = doubleDeckerWorkList.removeUpAndItsDowns();
            assert (object2.size() == 1);
            iterator3 = object2.keySet().iterator().next();
            hashSet.remove(iterator3);
            map = (Set)object2.get(iterator3);
            arrayList2 = new ArrayList();
            iterator2 = map.iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                if (this.mMarkedUp2Down.get(iterator3).get(iterator) == ReachFinal.UNKNOWN) {
                    arrayList2.add(iterator);
                } else assert (this.mMarkedUp2Down.get(iterator3).get(iterator) == ReachFinal.AT_LEAST_ONCE);
                this.mMarkedUp2Down.get(iterator3).put(iterator, ReachFinal.AT_LEAST_ONCE);
            }
            if (arrayList2.isEmpty()) continue;
            this.enqueueInternalPred(iterator3, arrayList2, doubleDeckerWorkList);
            this.enqueueCallPred(iterator3, arrayList2, doubleDeckerWorkList);
            this.enqueueReturnPred(iterator3, arrayList2, doubleDeckerWorkList, doubleDeckerWorkList2);
        }
        while (!doubleDeckerWorkList2.isEmpty()) {
            object2 = doubleDeckerWorkList2.removeUpAndItsDowns();
            assert (object2.size() == 1);
            iterator3 = object2.keySet().iterator().next();
            hashSet.remove(iterator3);
            map = (Set)object2.get(iterator3);
            arrayList2 = new ArrayList();
            iterator2 = map.iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                if (this.mMarkedUp2Down.get(iterator3).get(iterator) == ReachFinal.UNKNOWN) {
                    arrayList2.add(iterator);
                }
                this.mMarkedUp2Down.get(iterator3).put(iterator, ReachFinal.AT_LEAST_ONCE);
            }
            if (arrayList2.isEmpty()) continue;
            this.enqueueInternalPred(iterator3, arrayList2, doubleDeckerWorkList2);
            this.enqueueReturnPred(iterator3, arrayList2, doubleDeckerWorkList2, doubleDeckerWorkList2);
        }
        return hashSet;
    }

    public final boolean removeDeadEnds() throws AutomataOperationCanceledException {
        long l = System.currentTimeMillis();
        HashSet hashSet = new HashSet();
        for (Object object : this.mTraversedNwa.getInitialStates()) {
            if (this.mDeadEnds.contains(object) || this.mMarkedUp2Down.get(object).get(this.mTraversedNwa.getEmptyStackState()) == ReachFinal.AT_LEAST_ONCE) continue;
            assert (this.mMarkedUp2Down.get(object).get(this.mTraversedNwa.getEmptyStackState()) == ReachFinal.UNKNOWN);
            hashSet.add(object);
        }
        for (Object object : hashSet) {
            ((NestedWordAutomaton)this.mTraversedNwa).makeStateNonIntial(object);
            if (!this.mLogger.isWarnEnabled()) continue;
            this.mLogger.warn((Object)("The following state is not final any more: " + String.valueOf(object)));
        }
        for (Object object : this.mDeadEnds) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            ((NestedWordAutomaton)this.mTraversedNwa).removeState(object);
        }
        boolean bl = !this.mDeadEnds.isEmpty();
        this.mDeadEnds = null;
        this.mDeadEndRemovalTime += System.currentTimeMillis() - l;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("After removal of dead ends " + this.mTraversedNwa.sizeInformation()));
        }
        return bl;
    }

    private Set<STATE> computeState2CallSuccs(STATE STATE) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        if (STATE != this.mTraversedNwa.getEmptyStackState()) {
            for (OutgoingCallTransition outgoingCallTransition : this.mTraversedNwa.callSuccessors(STATE)) {
                hashSet.add(outgoingCallTransition.getSucc());
            }
        }
        return hashSet;
    }

    private boolean hasSuccessors(STATE STATE) {
        if (this.mTraversedNwa.internalSuccessors(STATE).iterator().hasNext()) {
            return true;
        }
        if (this.mTraversedNwa.callSuccessors(STATE).iterator().hasNext()) {
            return true;
        }
        return this.mTraversedNwa.returnSuccessors(STATE).iterator().hasNext();
    }

    private final boolean removeAcceptingStatesWithoutSuccessors() {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (STATE STATE : this.mTraversedNwa.getFinalStates()) {
            if (this.hasSuccessors(STATE)) continue;
            arrayList.add(STATE);
        }
        boolean bl = !arrayList.isEmpty();
        for (Iterator<Object> iterator : arrayList) {
            ((NestedWordAutomaton)this.mTraversedNwa).removeState(iterator);
        }
        return bl;
    }

    public final void removeNonLiveStates() throws AutomataOperationCanceledException {
        do {
            if (this.mDeadEnds == null) {
                this.mDeadEnds = this.computeDeadEnds();
            }
            boolean bl = this.removeDeadEnds();
            this.resetReachabilityInformation();
        } while (bl |= this.removeAcceptingStatesWithoutSuccessors());
    }

    private void resetReachabilityInformation() {
        for (STATE STATE : this.mTraversedNwa.getStates()) {
            Map<STATE, ReachFinal> map = this.mMarkedUp2Down.get(STATE);
            for (STATE STATE2 : map.keySet()) {
                map.put(STATE2, ReachFinal.UNKNOWN);
            }
        }
    }

    public long getDeadEndRemovalTime() {
        return this.mDeadEndRemovalTime;
    }

    public Iterable<IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE>> getRemovedUpDownEntry() {
        return () -> new RemovedUpDownEntryIterator();
    }

    private Set<DoubleDecker<STATE>> removedDoubleDeckersOldMethod() {
        HashSet<DoubleDecker<STATE>> hashSet = new HashSet<DoubleDecker<STATE>>();
        for (Map.Entry<STATE, Map<STATE, ReachFinal>> entry : this.mMarkedUp2Down.entrySet()) {
            STATE STATE = entry.getKey();
            for (Map.Entry<STATE, ReachFinal> entry2 : entry.getValue().entrySet()) {
                if (entry2.getValue() != ReachFinal.UNKNOWN) continue;
                STATE STATE2 = entry2.getKey();
                hashSet.add(new DoubleDecker<STATE>(STATE2, STATE));
            }
        }
        return hashSet;
    }

    private Set<DoubleDecker<STATE>> removedDoubleDeckersViaIterator() {
        HashSet<DoubleDecker<STATE>> hashSet = new HashSet<DoubleDecker<STATE>>();
        for (IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE> upDownEntry : this.getRemovedUpDownEntry()) {
            hashSet.add(new DoubleDecker<STATE>(upDownEntry.getDown(), upDownEntry.getUp()));
        }
        return hashSet;
    }

    private class DoubleDeckerSet {
        private final Map<STATE, Set<STATE>> mUp2down = new HashMap();

        private DoubleDeckerSet() {
        }

        public void add(STATE STATE, STATE STATE2) {
            Set set = this.mUp2down.get(STATE);
            if (set == null) {
                set = new HashSet();
                this.mUp2down.put(STATE, set);
            }
            set.add(STATE2);
        }

        public void addAll(Collection<DoubleDecker<STATE>> collection) {
            for (DoubleDecker doubleDecker : collection) {
                this.add(doubleDecker.getUp(), doubleDecker.getDown());
            }
        }

        public Map<STATE, Set<STATE>> getUp2DownMap() {
            return this.mUp2down;
        }
    }

    private class DoubleDeckerWorkList {
        private final Map<STATE, Set<STATE>> mUp2down = new HashMap();

        public void add(STATE STATE, STATE STATE2) {
            Set set = this.mUp2down.get(STATE);
            if (set == null) {
                set = new HashSet();
                this.mUp2down.put(STATE, set);
            }
            set.add(STATE2);
        }

        public void add(STATE STATE, Collection<STATE> collection) {
            Set set = this.mUp2down.get(STATE);
            if (set == null) {
                set = new HashSet();
                this.mUp2down.put(STATE, set);
            }
            set.addAll(collection);
        }

        public boolean isEmpty() {
            return this.mUp2down.isEmpty();
        }

        public Map<STATE, Set<STATE>> removeUpAndItsDowns() {
            Object STATE = this.mUp2down.keySet().iterator().next();
            Map map = Collections.singletonMap(STATE, this.mUp2down.remove(STATE));
            return map;
        }
    }

    public static enum ReachFinal {
        UNKNOWN,
        AT_LEAST_ONCE;

    }

    private class RemovedUpDownEntryIterator
    implements Iterator<IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE>> {
        private final Iterator<STATE> mUpIterator;
        private STATE mUp;
        private Iterator<STATE> mDownIterator;
        private STATE mDown;
        private boolean mHasNext = true;

        public RemovedUpDownEntryIterator() {
            this.mUpIterator = DoubleDeckerVisitor.this.getUp2DownMapping().keySet().iterator();
            if (this.mUpIterator.hasNext()) {
                this.mUp = this.mUpIterator.next();
                this.mDownIterator = DoubleDeckerVisitor.this.getUp2DownMapping().get(this.mUp).keySet().iterator();
            } else {
                this.mHasNext = false;
            }
            this.computeNextElement();
        }

        private void computeNextElement() {
            this.mDown = null;
            while (this.mDown == null && this.mHasNext) {
                if (this.mDownIterator.hasNext()) {
                    Object STATE = this.mDownIterator.next();
                    ReachFinal reachFinal = DoubleDeckerVisitor.this.getUp2DownMapping().get(this.mUp).get(STATE);
                    if (reachFinal == ReachFinal.UNKNOWN) {
                        this.mDown = STATE;
                        continue;
                    }
                    assert (reachFinal == ReachFinal.AT_LEAST_ONCE);
                    continue;
                }
                if (this.mUpIterator.hasNext()) {
                    this.mUp = this.mUpIterator.next();
                    this.mDownIterator = DoubleDeckerVisitor.this.getUp2DownMapping().get(this.mUp).keySet().iterator();
                    continue;
                }
                this.mHasNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE> next() {
            Object STATE;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Set set = this.computeState2CallSuccs(this.mDown);
            if (set.size() > 1) {
                throw new UnsupportedOperationException("State has more than one call successor");
            }
            if (set.size() == 1) {
                STATE = set.iterator().next();
            } else {
                STATE = null;
                assert (this.mDown == DoubleDeckerVisitor.this.mTraversedNwa.getEmptyStackState());
            }
            IOpWithDelayedDeadEndRemoval.UpDownEntry<Object> upDownEntry = new IOpWithDelayedDeadEndRemoval.UpDownEntry<Object>(this.mUp, this.mDown, STATE);
            this.computeNextElement();
            return upDownEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Set<STATE> computeState2CallSuccs(STATE STATE) {
            HashSet hashSet = new HashSet();
            if (STATE != DoubleDeckerVisitor.this.mTraversedNwa.getEmptyStackState()) {
                for (OutgoingCallTransition outgoingCallTransition : DoubleDeckerVisitor.this.mTraversedNwa.callSuccessors(STATE)) {
                    hashSet.add(outgoingCallTransition.getSucc());
                }
            }
            return hashSet;
        }
    }
}

