/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DataTypeTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final CClosure mCClosure;
    private final Theory mTheory;
    private final ArrayDeque<CCEquality> mPendingEqualities = new ArrayDeque();
    private final ArrayDeque<DataTypeLemma> mPendingLemmas = new ArrayDeque();
    private final LinkedHashMap<String, DataType.Constructor> mSelectorMap = new LinkedHashMap();
    private final ScopedArrayList<CCAppTerm> mRecheckOnBacktrack = new ScopedArrayList();
    private final LinkedHashMap<CCEquality, DataTypeLemma> mEqualityReasons = new LinkedHashMap();

    public DataTypeTheory(Clausifier clausifier, Theory theory, CClosure cClosure) {
        this.mClausifier = clausifier;
        this.mCClosure = cClosure;
        this.mTheory = theory;
    }

    public void addPendingLemma(DataTypeLemma dataTypeLemma) {
        this.mPendingLemmas.add(dataTypeLemma);
    }

    private Clause processPendingLemmas() {
        for (DataTypeLemma dataTypeLemma : this.mPendingLemmas) {
            SymmetricPair<CCTerm> symmetricPair = dataTypeLemma.getMainEquality();
            if (symmetricPair == null) {
                return this.computeClause(null, dataTypeLemma);
            }
            if (symmetricPair.getFirst().mRepStar == symmetricPair.getSecond().mRepStar) continue;
            CCEquality cCEquality = this.mCClosure.createEquality(symmetricPair.getFirst(), symmetricPair.getSecond(), false);
            if (cCEquality == null) {
                return this.computeClause(null, dataTypeLemma);
            }
            if (cCEquality.getDecideStatus() == cCEquality.negate()) {
                return this.computeClause(cCEquality, dataTypeLemma);
            }
            this.mPendingEqualities.add(cCEquality);
            this.mEqualityReasons.put(cCEquality, dataTypeLemma);
        }
        this.mPendingLemmas.clear();
        return null;
    }

    @Override
    public Clause startCheck() {
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (literal instanceof CCEquality) {
            CCEquality cCEquality = (CCEquality)literal;
            this.computeInjectiveDisjointLemmas(cCEquality.getLhs(), cCEquality.getRhs());
        }
        return this.processPendingLemmas();
    }

    private void computeInjectiveDisjointLemmas(CCTerm cCTerm, CCTerm cCTerm2) {
        if (DataTypeTheory.isConstructorApp(cCTerm.mFlatTerm) && DataTypeTheory.isConstructorApp(cCTerm2.mFlatTerm)) {
            ApplicationTerm applicationTerm = (ApplicationTerm)cCTerm.getFlatTerm();
            ApplicationTerm applicationTerm2 = (ApplicationTerm)cCTerm2.getFlatTerm();
            SymmetricPair[] symmetricPairArray = new SymmetricPair[]{new SymmetricPair<CCTerm>(cCTerm, cCTerm2)};
            if (applicationTerm.getFunction() == applicationTerm2.getFunction()) {
                int n = 0;
                while (n < applicationTerm.getParameters().length) {
                    CCTerm cCTerm3 = this.mClausifier.getCCTerm(applicationTerm.getParameters()[n]);
                    CCTerm cCTerm4 = this.mClausifier.getCCTerm(applicationTerm2.getParameters()[n]);
                    if (cCTerm4.mRepStar != cCTerm3.mRepStar) {
                        SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCTerm3, cCTerm4);
                        this.addPendingLemma(new DataTypeLemma(CCAnnotation.RuleKind.DT_INJECTIVE, symmetricPair, symmetricPairArray, cCTerm, cCTerm2));
                    }
                    ++n;
                }
            } else {
                this.addPendingLemma(new DataTypeLemma(CCAnnotation.RuleKind.DT_DISJOINT, symmetricPairArray, cCTerm, cCTerm2));
            }
        }
    }

    @Override
    public void backtrackLiteral(Literal literal) {
    }

    @Override
    public Clause checkpoint() {
        Object object;
        CCTerm cCTerm;
        Clause clause = this.processPendingLemmas();
        if (clause != null) {
            return clause;
        }
        CCTerm cCTerm2 = this.mClausifier.getCCTerm((Term)this.mTheory.mTrue);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (CCTerm object22 : cCTerm2.getRepresentative().mMembers) {
            if (!(object22 instanceof CCAppTerm) || !(object22.mFlatTerm instanceof ApplicationTerm)) continue;
            ApplicationTerm applicationTerm = (ApplicationTerm)object22.mFlatTerm;
            Iterator iterator = (CCAppTerm)object22;
            if (applicationTerm.getFunction().getName() != "is") continue;
            cCTerm = ((CCAppTerm)((Object)iterator)).getArg().getRepresentative();
            if (!linkedHashMap.containsKey(cCTerm)) {
                linkedHashMap.put(cCTerm, iterator);
                this.addConstructorLemma((CCAppTerm)((Object)iterator));
                continue;
            }
            object = (CCAppTerm)linkedHashMap.get(cCTerm);
            if (((CCAppTerm)object).getFunc() == ((CCAppTerm)((Object)iterator)).getFunc()) continue;
            ArrayList<SymmetricPair<CCTerm>> arrayList = new ArrayList<SymmetricPair<CCTerm>>();
            arrayList.add(new SymmetricPair<CCTerm>((CCTerm)object, cCTerm2));
            arrayList.add(new SymmetricPair<CCTerm>((CCTerm)((Object)iterator), cCTerm2));
            if (((CCAppTerm)object).getArg() != ((CCAppTerm)((Object)iterator)).getArg()) {
                arrayList.add(new SymmetricPair<CCTerm>(((CCAppTerm)object).getArg(), ((CCAppTerm)((Object)iterator)).getArg()));
            }
            Term[] termArray = new Term[]{((CCAppTerm)object).mFlatTerm, ((CCAppTerm)((Object)iterator)).mFlatTerm};
            DataTypeLemma dataTypeLemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_UNIQUE, arrayList.toArray(new SymmetricPair[arrayList.size()]), termArray);
            this.mClausifier.getLogger().debug("Conflict: Rule 9");
            return this.computeClause(null, dataTypeLemma);
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        CCTerm cCTerm3 = this.mClausifier.getCCTerm((Term)this.mTheory.mFalse);
        for (CCTerm cCTerm4 : cCTerm3.getRepresentative().mMembers) {
            if (!(cCTerm4.mFlatTerm instanceof ApplicationTerm) || !((ApplicationTerm)cCTerm4.mFlatTerm).getFunction().getName().equals("is")) continue;
            linkedHashMap2.putIfAbsent(((CCAppTerm)cCTerm4).mArg.mRepStar, new LinkedHashSet());
            ((LinkedHashSet)linkedHashMap2.get(((CCAppTerm)cCTerm4).mArg.mRepStar)).add(cCTerm4);
        }
        for (CCTerm cCTerm5 : linkedHashMap2.keySet()) {
            Object object2;
            Object object32;
            cCTerm = (DataType)cCTerm5.mFlatTerm.getSort().getSortSymbol();
            if (((LinkedHashSet)linkedHashMap2.get(cCTerm5)).size() < cCTerm.getConstructors().length) continue;
            object = new LinkedHashMap();
            for (Object object32 : (LinkedHashSet)linkedHashMap2.get(cCTerm5)) {
                ((HashMap)object).put(((ApplicationTerm)((CCTerm)object32).mFlatTerm).getFunction().getIndices()[0], object32);
            }
            if (((HashMap)object).size() != cCTerm.getConstructors().length) continue;
            object32 = new ArrayList();
            Term[] termArray = new Term[cCTerm.getConstructors().length];
            int n = 0;
            CCTerm cCTerm6 = null;
            DataType.Constructor[] constructorArray = cCTerm.getConstructors();
            int n2 = constructorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object2 = constructorArray[n3];
                CCTerm cCTerm7 = (CCTerm)((LinkedHashMap)object).get(object2.getName());
                termArray[n++] = cCTerm7.mFlatTerm;
                CCTerm cCTerm8 = ((CCAppTerm)cCTerm7).mArg;
                ((ArrayList)object32).add(new SymmetricPair<Object>(cCTerm7, cCTerm3));
                if (cCTerm6 == null) {
                    cCTerm6 = cCTerm8;
                } else if (cCTerm6 != cCTerm8) {
                    ((ArrayList)object32).add(new SymmetricPair<CCTerm>(cCTerm6, cCTerm8));
                }
                ++n3;
            }
            object2 = new DataTypeLemma(CCAnnotation.RuleKind.DT_CASES, ((ArrayList)object32).toArray(new SymmetricPair[((ArrayList)object32).size()]), termArray);
            this.mClausifier.getLogger().debug("Conflict: Rule 6");
            return this.computeClause(null, (DataTypeLemma)object2);
        }
        return this.processPendingLemmas();
    }

    private Clause checkDTCycles() {
        HashSet<CCTerm> hashSet = new HashSet<CCTerm>();
        ArrayDeque<CCTerm> arrayDeque = new ArrayDeque<CCTerm>();
        HashSet<CCTerm> hashSet2 = new HashSet<CCTerm>();
        ArrayDeque<CCTerm> arrayDeque2 = new ArrayDeque<CCTerm>();
        HashMap<CCTerm, CCAppTerm> hashMap = new HashMap<CCTerm, CCAppTerm>();
        for (CCTerm cCTerm : this.mCClosure.mAllTerms) {
            if (cCTerm.mFlatTerm == null || !cCTerm.mFlatTerm.getSort().getSortSymbol().isDatatype()) continue;
            arrayDeque2.push(cCTerm);
            while (!arrayDeque2.isEmpty()) {
                CCTerm cCTerm2 = (CCTerm)arrayDeque2.pop();
                CCTerm cCTerm3 = cCTerm2.getRepresentative();
                if (hashSet.contains(cCTerm3)) {
                    if (arrayDeque.peek() == cCTerm2) {
                        arrayDeque.pop();
                        hashSet2.remove(cCTerm3);
                        continue;
                    }
                    assert (!hashSet2.contains(cCTerm3));
                    continue;
                }
                List<CCTerm> list = this.getAllDataTypeChildren(cCTerm3, hashMap);
                if (!list.isEmpty()) {
                    arrayDeque.push(cCTerm2);
                    hashSet2.add(cCTerm3);
                    arrayDeque2.push(cCTerm2);
                    for (CCTerm cCTerm4 : list) {
                        if (hashSet2.contains(cCTerm4.getRepresentative())) {
                            return this.buildCycleConflict(cCTerm4, arrayDeque, hashMap);
                        }
                        arrayDeque2.push(cCTerm4);
                    }
                }
                hashSet.add(cCTerm3);
            }
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        Object object;
        Object object2;
        ApplicationTerm applicationTerm;
        CCTerm cCTerm;
        Object object3;
        SimpleListable simpleListable2;
        ArrayList<CCTerm> arrayList = new ArrayList<CCTerm>();
        for (SimpleListable simpleListable2 : this.mCClosure.mAllTerms) {
            if (simpleListable2 != simpleListable2.mRep || simpleListable2.mFlatTerm == null || !simpleListable2.mFlatTerm.getSort().getSortSymbol().isDatatype()) continue;
            arrayList.add((CCTerm)simpleListable2);
        }
        for (SimpleListable simpleListable2 : arrayList) {
            this.createIsApplications((CCTerm)simpleListable2);
        }
        simpleListable2 = this.checkDTCycles();
        if (simpleListable2 != null) {
            return simpleListable2;
        }
        if (!this.mPendingLemmas.isEmpty()) {
            return this.processPendingLemmas();
        }
        for (CCTerm cCTerm2 : this.mCClosure.mAllTerms) {
            if (cCTerm2.getRepresentative() != cCTerm2) continue;
            for (CCTerm cCTerm3 : cCTerm2.mMembers) {
                if (!DataTypeTheory.isConstructorApp(cCTerm3.mFlatTerm)) continue;
                object3 = (ApplicationTerm)cCTerm3.mFlatTerm;
                assert (cCTerm2.getSharedTerm() != null);
                if (cCTerm3 == cCTerm2.getSharedTerm()) continue;
                cCTerm = cCTerm2.getSharedTerm();
                applicationTerm = (ApplicationTerm)cCTerm.mFlatTerm;
                if (((ApplicationTerm)cCTerm3.mFlatTerm).getFunction() != ((ApplicationTerm)cCTerm.mFlatTerm).getFunction()) {
                    this.mCClosure.getLogger().error("Unpropagated equality on different conses");
                    this.computeInjectiveDisjointLemmas(cCTerm, cCTerm3);
                    continue;
                }
                int n = 0;
                while (n < object3.getParameters().length) {
                    object2 = this.mClausifier.getCCTerm(applicationTerm.getParameters()[n]);
                    object = this.mClausifier.getCCTerm(object3.getParameters()[n]);
                    if (object.mRepStar != object2.mRepStar) {
                        this.mCClosure.getLogger().error("Unpropagated constructor argument equality");
                        this.computeInjectiveDisjointLemmas(cCTerm, cCTerm3);
                    }
                    ++n;
                }
            }
        }
        for (CCTerm cCTerm4 : this.mCClosure.mAllTerms) {
            Object object4;
            SymmetricPair[] symmetricPairArray;
            SymmetricPair[] symmetricPairArray2;
            CCTerm cCTerm3;
            if (!(cCTerm4.getFlatTerm() instanceof ApplicationTerm)) continue;
            cCTerm3 = (ApplicationTerm)cCTerm4.getFlatTerm();
            FunctionSymbol functionSymbol = cCTerm3.getFunction();
            if (!cCTerm3.getFunction().isSelector() && !cCTerm3.getFunction().getName().equals("is") || (cCTerm = ((CCTerm)(object3 = ((CCAppTerm)cCTerm4).getArg())).getRepresentative().getSharedTerm()) == null) continue;
            applicationTerm = (ApplicationTerm)cCTerm.getFlatTerm();
            DataType dataType = (DataType)applicationTerm.getSort().getSortSymbol();
            object2 = dataType.getConstructor(applicationTerm.getFunction().getName());
            if (cCTerm3.getFunction().getName().equals("is")) {
                object = functionSymbol.getIndices()[0].equals(object2.getName()) ? this.mClausifier.getTheory().mTrue : this.mClausifier.getTheory().mFalse;
                CCTerm cCTerm5 = this.mClausifier.getCCTerm((Term)object);
                if (cCTerm4.getRepresentative() == cCTerm5.getRepresentative()) continue;
                this.mCClosure.getLogger().error("Unpropagated is of constructor");
                symmetricPairArray2 = new SymmetricPair[]{new SymmetricPair<Object>(cCTerm, object3)};
                symmetricPairArray = new SymmetricPair(cCTerm4, cCTerm5);
                object4 = new DataTypeLemma(CCAnnotation.RuleKind.DT_TESTER, (SymmetricPair<CCTerm>)symmetricPairArray, symmetricPairArray2, cCTerm);
                this.addPendingLemma((DataTypeLemma)object4);
                continue;
            }
            if (!cCTerm3.getFunction().isSelector()) continue;
            object = object2.getSelectors();
            int n = 0;
            while (n < ((ApplicationTerm)object).length) {
                if (object[n].equals(cCTerm3.getFunction().getName())) {
                    symmetricPairArray2 = this.mClausifier.getCCTerm(applicationTerm.getParameters()[n]);
                    if (cCTerm4.getRepresentative() != symmetricPairArray2.getRepresentative()) {
                        this.mCClosure.getLogger().error("Unpropagated selector of constructor");
                        symmetricPairArray = new SymmetricPair[]{new SymmetricPair<Object>(cCTerm, object3)};
                        object4 = new SymmetricPair<SymmetricPair[]>((SymmetricPair[])cCTerm4, symmetricPairArray2);
                        DataTypeLemma dataTypeLemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_PROJECT, (SymmetricPair<CCTerm>)object4, symmetricPairArray, cCTerm);
                        this.addPendingLemma(dataTypeLemma);
                    }
                }
                ++n;
            }
        }
        return this.processPendingLemmas();
    }

    private Map<FunctionSymbol, CCAppTerm> getSelectorsAndTesters(CCTerm cCTerm) {
        assert (cCTerm == cCTerm.getRepresentative());
        LinkedHashMap<FunctionSymbol, CCAppTerm> linkedHashMap = new LinkedHashMap<FunctionSymbol, CCAppTerm>();
        CCParentInfo cCParentInfo = cCTerm.mCCPars;
        while (cCParentInfo != null) {
            if (cCParentInfo.mCCParents != null && !cCParentInfo.mCCParents.isEmpty()) {
                FunctionSymbol functionSymbol;
                CCAppTerm cCAppTerm = cCParentInfo.mCCParents.iterator().next().getData();
                if (cCAppTerm.mFlatTerm instanceof ApplicationTerm && ((functionSymbol = ((ApplicationTerm)cCAppTerm.mFlatTerm).getFunction()).isSelector() || functionSymbol.getName().equals("is"))) {
                    linkedHashMap.put(functionSymbol, cCAppTerm);
                }
            }
            cCParentInfo = cCParentInfo.mNext;
        }
        return linkedHashMap;
    }

    private List<CCTerm> getAllDataTypeChildren(CCTerm cCTerm, Map<CCTerm, CCAppTerm> map) {
        Object object;
        ArrayList<CCTerm> arrayList = new ArrayList<CCTerm>();
        CCTerm cCTerm2 = cCTerm.getRepresentative();
        CCTerm cCTerm3 = cCTerm2.getSharedTerm();
        if (cCTerm3 != null) {
            CCTerm cCTerm4 = cCTerm3;
            while (cCTerm4 instanceof CCAppTerm) {
                CCAppTerm cCAppTerm = (CCAppTerm)cCTerm4;
                CCTerm cCTerm5 = cCAppTerm.getArg();
                if (cCTerm5.getFlatTerm().getSort().getSortSymbol().isDatatype()) {
                    arrayList.add(cCTerm5);
                }
                cCTerm4 = cCAppTerm.getFunc();
            }
            return arrayList;
        }
        DataType dataType = (DataType)cCTerm2.mFlatTerm.getSort().getSortSymbol();
        CCTerm cCTerm6 = this.mClausifier.getCCTerm((Term)this.mTheory.mTrue).mRepStar;
        LinkedHashSet<CCAppTerm> linkedHashSet = new LinkedHashSet<CCAppTerm>();
        FunctionSymbol object2 = null;
        LinkedHashSet<FunctionSymbol> linkedHashSet2 = new LinkedHashSet<FunctionSymbol>();
        for (Map.Entry<FunctionSymbol, CCAppTerm> entry : this.getSelectorsAndTesters(cCTerm2).entrySet()) {
            FunctionSymbol functionSymbol = entry.getKey();
            if (functionSymbol.isSelector()) {
                if (!functionSymbol.getReturnSort().getSortSymbol().isDatatype()) continue;
                linkedHashSet.add((CCAppTerm)entry.getValue());
                continue;
            }
            object = (CCAppTerm)entry.getValue();
            if (((CCTerm)object).getRepresentative() == cCTerm6) {
                assert (object2 == null);
                object2 = functionSymbol;
                map.put(cCTerm2, (CCAppTerm)object);
                continue;
            }
            linkedHashSet2.add(functionSymbol);
        }
        if (object2 != null) {
            entry = dataType.getConstructor(object2.getIndices()[0]);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList(entry.getSelectors()));
            for (CCAppTerm cCAppTerm : linkedHashSet) {
                if (!hashSet.contains(((ApplicationTerm)cCAppTerm.mFlatTerm).getFunction().getName())) continue;
                arrayList.add(cCAppTerm);
            }
        } else {
            entry = new HashSet();
            for (FunctionSymbol functionSymbol : linkedHashSet2) {
                object = dataType.getConstructor(functionSymbol.getIndices()[0]);
                entry.addAll(Arrays.asList(object.getSelectors()));
            }
            for (CCAppTerm cCAppTerm : linkedHashSet) {
                if (entry.contains(((ApplicationTerm)cCAppTerm.mFlatTerm).getFunction().getName())) continue;
                arrayList.add(cCAppTerm);
            }
        }
        return arrayList;
    }

    private Clause buildCycleConflict(CCTerm cCTerm, Deque<CCTerm> deque, Map<CCTerm, CCAppTerm> map) {
        Object object;
        ArrayList<SymmetricPair<CCTerm>> arrayList = new ArrayList<SymmetricPair<CCTerm>>();
        ArrayDeque<CCTerm> arrayDeque = new ArrayDeque<CCTerm>();
        CCTerm cCTerm2 = this.mClausifier.getCCTerm((Term)this.mTheory.mTrue);
        CCTerm cCTerm3 = cCTerm.mRepStar;
        CCTerm cCTerm4 = cCTerm;
        arrayDeque.addFirst(cCTerm);
        while (true) {
            CCTerm cCTerm5;
            if ((cCTerm5 = ((CCTerm)(object = deque.pop())).getRepresentative().getSharedTerm()) == null) {
                cCTerm5 = ((CCAppTerm)cCTerm4).getArg();
                ApplicationTerm applicationTerm = (ApplicationTerm)cCTerm4.getFlatTerm();
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                DataType.Constructor constructor = this.getConstructor(functionSymbol);
                Term term = this.mTheory.term(this.mTheory.getFunctionWithResult("is", new String[]{constructor.getName()}, null, new Sort[]{functionSymbol.getParameterSorts()[0]}), new Term[]{cCTerm5.getFlatTerm()});
                CCTerm cCTerm6 = this.mClausifier.getCCTerm(term);
                if (cCTerm6 == null) {
                    this.mClausifier.createCCTerm(term, SourceAnnotation.EMPTY_SOURCE_ANNOT);
                    return null;
                }
                assert (cCTerm6.getRepresentative() == cCTerm2.getRepresentative());
                arrayList.add(new SymmetricPair<CCTerm>(cCTerm6, cCTerm2));
            }
            arrayDeque.addFirst(cCTerm5);
            assert (((CCTerm)object).getRepresentative() == cCTerm5.getRepresentative());
            if (((CCTerm)object).getRepresentative() == cCTerm3) {
                arrayDeque.addFirst(cCTerm);
                if (cCTerm == cCTerm5) break;
                arrayList.add(new SymmetricPair<CCTerm>(cCTerm, cCTerm5));
                break;
            }
            arrayDeque.addFirst((CCTerm)object);
            if (object != cCTerm5) {
                arrayList.add(new SymmetricPair<CCTerm>((CCTerm)object, cCTerm5));
            }
            cCTerm4 = object;
        }
        object = new DataTypeLemma(CCAnnotation.RuleKind.DT_CYCLE, arrayList.toArray(new SymmetricPair[arrayList.size()]), arrayDeque.toArray(new CCTerm[arrayDeque.size()]));
        this.mClausifier.getLogger().debug("Found Cycle: %s", arrayDeque);
        return this.computeClause(null, (DataTypeLemma)object);
    }

    public Clause computeClause(CCEquality cCEquality, DataTypeLemma dataTypeLemma) {
        boolean bl = this.mClausifier.getEngine().isProofGenerationEnabled();
        CongruencePath congruencePath = new CongruencePath(this.mCClosure);
        return congruencePath.computeDTLemma(cCEquality, dataTypeLemma, bl);
    }

    @Override
    public Literal getPropagatedLiteral() {
        if (!this.mPendingEqualities.isEmpty()) {
            return this.mPendingEqualities.poll();
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        CCEquality cCEquality = (CCEquality)literal;
        return this.computeClause(cCEquality, this.mEqualityReasons.get(cCEquality));
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    @Override
    public void printStatistics(LogProxy logProxy) {
    }

    @Override
    public void dumpModel(LogProxy logProxy) {
    }

    @Override
    public void increasedDecideLevel(int n) {
    }

    @Override
    public void decreasedDecideLevel(int n) {
    }

    public void addRecheckOnBacktrack(CCAppTerm cCAppTerm) {
        this.mRecheckOnBacktrack.add(cCAppTerm);
    }

    @Override
    public void backtrackStart() {
        this.mPendingLemmas.clear();
        this.mPendingEqualities.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void recheckTrigger() {
        Iterator iterator = this.mRecheckOnBacktrack.iterator();
        while (iterator.hasNext()) {
            void var8_12;
            Object object;
            Object object2;
            Object object3;
            CCTerm symmetricPairArray2 = null;
            ApplicationTerm applicationTerm = null;
            CCAppTerm cCAppTerm = (CCAppTerm)iterator.next();
            ApplicationTerm applicationTerm2 = (ApplicationTerm)cCAppTerm.mFlatTerm;
            FunctionSymbol functionSymbol = applicationTerm2.getFunction();
            CCTerm cCTerm = cCAppTerm.getArg();
            assert (functionSymbol.isSelector() || functionSymbol.getName().equals("is"));
            for (CCTerm cCTerm2 : cCTerm.getRepresentative().mMembers) {
                if (!(cCTerm2.mFlatTerm instanceof ApplicationTerm) || !((ApplicationTerm)cCTerm2.mFlatTerm).getFunction().isConstructor()) continue;
                symmetricPairArray2 = cCTerm2;
                applicationTerm = (ApplicationTerm)cCTerm2.mFlatTerm;
                break;
            }
            if (applicationTerm == null) {
                iterator.remove();
                continue;
            }
            if (cCTerm != symmetricPairArray2) {
                SymmetricPair[] symmetricPairArray = new SymmetricPair[]{new SymmetricPair<Object>(cCTerm, symmetricPairArray2)};
            } else {
                SymmetricPair[] symmetricPairArray = new SymmetricPair[]{};
            }
            if (functionSymbol.isSelector()) {
                object3 = functionSymbol.getName();
                object2 = this.getConstructor(functionSymbol);
                assert (object2.getName().equals(applicationTerm.getFunction().getName()));
                int n = 0;
                while (n < object2.getSelectors().length) {
                    if (((String)object3).equals(object2.getSelectors()[n])) {
                        object = this.mClausifier.getCCTerm(applicationTerm.getParameters()[n]);
                        if (((CCTerm)object).mRepStar != cCAppTerm.mRepStar) {
                            SymmetricPair<Object> symmetricPair = new SymmetricPair<Object>(cCAppTerm, object);
                            DataTypeLemma dataTypeLemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_PROJECT, (SymmetricPair<CCTerm>)symmetricPair, (SymmetricPair<CCTerm>[])var8_12, symmetricPairArray2);
                            this.addPendingLemma(dataTypeLemma);
                        }
                    }
                    ++n;
                }
                continue;
            }
            object3 = functionSymbol.getIndices()[0].equals(applicationTerm.getFunction().getName()) ? this.mClausifier.getTheory().mTrue : this.mClausifier.getTheory().mFalse;
            object2 = this.mClausifier.getCCTerm((Term)object3);
            if (object2.mRepStar == cCAppTerm.mRepStar) continue;
            SymmetricPair<DataType.Constructor> symmetricPair = new SymmetricPair<DataType.Constructor>((DataType.Constructor)cCAppTerm, (DataType.Constructor)object2);
            object = new DataTypeLemma(CCAnnotation.RuleKind.DT_TESTER, (SymmetricPair<CCTerm>)symmetricPair, (SymmetricPair<CCTerm>[])var8_12, symmetricPairArray2);
            this.addPendingLemma((DataTypeLemma)object);
        }
    }

    @Override
    public Clause backtrackComplete() {
        this.recheckTrigger();
        return this.processPendingLemmas();
    }

    @Override
    public void backtrackAll() {
    }

    @Override
    public void restart(int n) {
    }

    @Override
    public void removeAtom(DPLLAtom dPLLAtom) {
    }

    @Override
    public void push() {
        this.mRecheckOnBacktrack.beginScope();
    }

    @Override
    public void pop() {
        this.mPendingLemmas.clear();
        this.mPendingEqualities.clear();
        this.mRecheckOnBacktrack.endScope();
        this.recheckTrigger();
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":DT"};
    }

    private void addConstructorLemma(CCAppTerm cCAppTerm) {
        CCTerm cCTerm = cCAppTerm.mArg;
        if (cCTerm.getRepresentative().getSharedTerm() != null) {
            return;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)cCAppTerm.mFlatTerm;
        String string = applicationTerm.getFunction().getIndices()[0];
        Term term = cCTerm.mFlatTerm;
        DataType dataType = (DataType)term.getSort().getSortSymbol();
        DataType.Constructor constructor = dataType.getConstructor(string);
        if (this.checkMissingInfiniteSelector(cCTerm, constructor)) {
            return;
        }
        Term[] termArray = new Term[constructor.getSelectors().length];
        int n = 0;
        while (n < termArray.length) {
            termArray[n] = this.mTheory.term(constructor.getSelectors()[n], new Term[]{term});
            ++n;
        }
        Sort sort = constructor.needsReturnOverload() ? term.getSort() : null;
        Term term2 = this.mTheory.term(string, null, sort, termArray);
        CCTerm cCTerm2 = this.mClausifier.createCCTerm(term2, SourceAnnotation.EMPTY_SOURCE_ANNOT);
        SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCTerm, cCTerm2);
        DataTypeLemma dataTypeLemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_CONSTRUCTOR, symmetricPair, new SymmetricPair[]{new SymmetricPair<CCTerm>(cCAppTerm, this.mClausifier.getCCTerm((Term)this.mTheory.mTrue))});
        this.mClausifier.getLogger().debug("New DT_CONSTRUCTOR lemma for %s", term);
        this.addPendingLemma(dataTypeLemma);
    }

    private boolean checkMissingInfiniteSelector(CCTerm cCTerm, DataType.Constructor constructor) {
        Sort sort = cCTerm.mFlatTerm.getSort();
        int n = 0;
        while (n < constructor.getArgumentSorts().length) {
            FunctionSymbol functionSymbol;
            if (this.mClausifier.isStablyInfinite(constructor.getArgumentSorts()[n].mapSort(sort.getArguments())) && this.mCClosure.getAllFuncAppsForArg(functionSymbol = this.mTheory.getFunction(constructor.getSelectors()[n], new Sort[]{sort}), cCTerm, 0).isEmpty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void createIsApplications(CCTerm cCTerm) {
        SortSymbol sortSymbol = cCTerm.mFlatTerm.getSort().getSortSymbol();
        if (cCTerm.getSharedTerm() != null) {
            return;
        }
        DataType.Constructor[] constructorArray = ((DataType)sortSymbol).getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Constructor constructor = constructorArray[n2];
            if (!this.checkMissingInfiniteSelector(cCTerm, constructor)) {
                FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("is", new String[]{constructor.getName()}, null, new Sort[]{cCTerm.getFlatTerm().getSort()});
                Term term = this.mTheory.term(functionSymbol, new Term[]{cCTerm.mFlatTerm});
                if (this.mClausifier.getCCTerm(term) == null) {
                    this.mClausifier.createCCTerm(term, SourceAnnotation.EMPTY_SOURCE_ANNOT);
                }
            }
            ++n2;
        }
    }

    private DataType.Constructor getConstructor(FunctionSymbol functionSymbol) {
        assert (functionSymbol.isSelector()) : "Not a selector";
        String string = functionSymbol.getName();
        DataType.Constructor constructor = this.mSelectorMap.get(string);
        if (constructor != null) {
            return constructor;
        }
        DataType.Constructor[] constructorArray = ((DataType)functionSymbol.getParameterSorts()[0].getSortSymbol()).getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Constructor constructor2 = constructorArray[n2];
            if (Arrays.asList(constructor2.getSelectors()).contains(string)) {
                this.mSelectorMap.put(string, constructor2);
                return constructor2;
            }
            ++n2;
        }
        throw new AssertionError((Object)("No constructor for selector " + String.valueOf(functionSymbol)));
    }

    private static boolean isConstructorApp(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().isConstructor();
    }

    private Term createUniqueValue(ModelBuilder modelBuilder, FunctionSymbol functionSymbol, Term[] termArray) {
        boolean bl = false;
        int n = 0;
        while (n < termArray.length) {
            if (termArray[n] == null) {
                Sort sort = functionSymbol.getParameterSorts()[n];
                if (this.mClausifier.isStablyInfinite(sort) && !bl) {
                    termArray[n] = modelBuilder.getModel().extendFresh(sort);
                    bl = true;
                } else {
                    termArray[n] = modelBuilder.getModel().getSomeValue(sort);
                }
            }
            ++n;
        }
        return this.mTheory.term(functionSymbol, termArray);
    }

    public void fillInModel(ModelBuilder modelBuilder, List<Sort> list, LinkedHashMap<Sort, List<CCTerm>> linkedHashMap) {
        CCTerm cCTerm;
        Object object;
        Object object2;
        Term[] termArray;
        Collection<CCTerm> collection;
        LinkedHashMap<CCTerm, ConstrTerm> linkedHashMap2 = new LinkedHashMap<CCTerm, ConstrTerm>();
        for (Sort object32 : list) {
            assert (object32.getSortSymbol().isDatatype());
            collection = linkedHashMap.get(object32);
            if (collection == null) continue;
            for (CCTerm cCTerm2 : collection) {
                Object object3;
                termArray = cCTerm2.getSharedTerm();
                if (termArray != null) {
                    object2 = ((ApplicationTerm)termArray.getFlatTerm()).getFunction();
                    object = new CCTerm[object2.getParameterSorts().length];
                    int n = object2.getParameterSorts().length - 1;
                    while (n >= 0) {
                        object3 = (CCAppTerm)termArray;
                        object[n] = ((CCAppTerm)object3).getArg();
                        termArray = ((CCAppTerm)object3).getFunc();
                        --n;
                    }
                    linkedHashMap2.put(cCTerm2, new ConstrTerm((FunctionSymbol)object2, (CCTerm[])object));
                    continue;
                }
                object2 = this.getSelectorsAndTesters(cCTerm2);
                object = this.findConstructorFromTester(cCTerm2, (Map<FunctionSymbol, CCAppTerm>)object2, modelBuilder);
                String[] stringArray = object.getSelectors();
                object3 = new Sort[stringArray.length];
                CCTerm[] cCTermArray = new CCTerm[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    cCTerm = this.mTheory.getFunction(stringArray[n], new Sort[]{object32});
                    object3[n] = cCTerm.getReturnSort();
                    cCTermArray[n] = (CCTerm)object2.get(cCTerm);
                    ++n;
                }
                Sort term = object.needsReturnOverload() ? object32 : null;
                cCTerm = this.mTheory.getFunctionWithResult(object.getName(), null, term, (Sort[])object3);
                linkedHashMap2.put(cCTerm2, new ConstrTerm((FunctionSymbol)cCTerm, cCTermArray));
            }
        }
        ArrayDeque arrayDeque = new ArrayDeque(linkedHashMap2.keySet());
        ArrayDeque arrayDeque2 = new ArrayDeque();
        collection = new HashSet();
        while (!arrayDeque.isEmpty()) {
            ArrayDeque<Object> arrayDeque3 = new ArrayDeque<Object>();
            Object object4 = null;
            termArray = null;
            ((HashSet)collection).clear();
            while (!arrayDeque.isEmpty()) {
                object2 = (CCTerm)arrayDeque.removeLast();
                if (modelBuilder.getModelValue((CCTerm)object2) != null) continue;
                if (!((HashSet)collection).add((CCTerm)((FunctionSymbol)object2))) {
                    arrayDeque3.addAll(arrayDeque2);
                    arrayDeque2.clear();
                    continue;
                }
                object = (ConstrTerm)linkedHashMap2.get(object2);
                Term[] termArray2 = new Term[object.mArguments.length];
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                while (n < termArray2.length) {
                    cCTerm = object.mArguments[n];
                    if (cCTerm != null) {
                        cCTerm = cCTerm.getRepresentative();
                        termArray2[n] = modelBuilder.getModelValue(cCTerm);
                        if (termArray2[n] == null) {
                            assert (linkedHashMap2.containsKey(cCTerm));
                            arrayDeque2.add(object2);
                            arrayDeque.addLast(cCTerm);
                            bl = true;
                            break;
                        }
                    } else {
                        bl2 = true;
                    }
                    ++n;
                }
                if (bl) continue;
                if (bl2) {
                    arrayDeque3.addAll(arrayDeque2);
                    if (object4 == null) {
                        object4 = object2;
                        termArray = termArray2;
                    } else {
                        arrayDeque3.add(object2);
                    }
                    arrayDeque2.clear();
                    continue;
                }
                Term term = this.mTheory.term(object.mConstr, termArray2);
                modelBuilder.setModelValue((CCTerm)object2, term);
                if (arrayDeque2.isEmpty()) continue;
                cCTerm = (CCTerm)arrayDeque2.removeLast();
                ((HashSet)collection).remove(cCTerm);
                arrayDeque.addLast(cCTerm);
            }
            if (object4 != null) {
                object2 = (ConstrTerm)linkedHashMap2.get(object4);
                object = this.createUniqueValue(modelBuilder, ((ConstrTerm)object2).mConstr, termArray);
                modelBuilder.setModelValue((CCTerm)object4, (Term)object);
                arrayDeque.addAll(arrayDeque3);
                continue;
            }
            assert (arrayDeque3.isEmpty());
        }
    }

    private DataType.Constructor findConstructorFromTester(CCTerm cCTerm, Map<FunctionSymbol, CCAppTerm> map, ModelBuilder modelBuilder) {
        Sort sort = cCTerm.getFlatTerm().getSort();
        DataType dataType = (DataType)sort.getSortSymbol();
        DataType.Constructor constructor = null;
        DataType.Constructor[] constructorArray = dataType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Constructor constructor2 = constructorArray[n2];
            FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("is", new String[]{constructor2.getName()}, null, new Sort[]{sort});
            CCAppTerm cCAppTerm = map.get(functionSymbol);
            if (cCAppTerm == null) {
                if (constructor == null) {
                    constructor = constructor2;
                }
            } else if (modelBuilder.getModelValue(cCAppTerm.getRepresentative()) == this.mTheory.mTrue) {
                return constructor2;
            }
            ++n2;
        }
        assert (constructor != null) : "Unpropagated dt_cases lemma";
        return constructor;
    }

    private class ConstrTerm {
        FunctionSymbol mConstr;
        CCTerm[] mArguments;

        public ConstrTerm(FunctionSymbol functionSymbol, CCTerm[] cCTermArray) {
            this.mConstr = functionSymbol;
            this.mArguments = cCTermArray;
        }
    }
}

