/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonCoreBooleanSubTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Collections;
import java.util.Set;

public class IteRemover
extends NonCoreBooleanSubTermTransformer {
    private final ManagedScript mScript;

    public IteRemover(ManagedScript managedScript) {
        this.mScript = managedScript;
    }

    @Override
    protected Term transformNonCoreBooleanSubterm(Term term) {
        assert (SmtSortUtils.isBoolSort(term.getSort()));
        Term term2 = term;
        Set<ApplicationTerm> set = SmtUtils.extractApplicationTerms("ite", term2, false);
        while (!set.isEmpty()) {
            term2 = this.removeIteTerm(term2, set.iterator().next());
            set = SmtUtils.extractApplicationTerms("ite", term2, false);
        }
        assert (this.doesNotContainIteTerm(term2)) : "not all ite terms were removed";
        assert (term == term2 || Util.checkSat((Script)this.mScript.getScript(), (Term)this.mScript.getScript().term("distinct", new Term[]{term, term2})) != Script.LBool.SAT);
        return term2;
    }

    private boolean doesNotContainIteTerm(Term term) {
        return SmtUtils.extractApplicationTerms("ite", term, false).isEmpty();
    }

    private Term removeIteTerm(Term term, ApplicationTerm applicationTerm) {
        assert (applicationTerm.getFunction().getName().equals("ite"));
        assert (applicationTerm.getParameters().length == 3);
        Term term2 = applicationTerm.getParameters()[0];
        Term term3 = applicationTerm.getParameters()[1];
        Term term4 = applicationTerm.getParameters()[2];
        Term term5 = Collections.singletonMap(applicationTerm, term3);
        Term term6 = Substitution.apply(this.mScript, term5, term);
        Term term7 = Collections.singletonMap(applicationTerm, term4);
        term5 = Substitution.apply(this.mScript, term7, term);
        term7 = SmtUtils.or(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), term2, term6), SmtUtils.and(this.mScript.getScript(), SmtUtils.not(this.mScript.getScript(), term2), term5));
        return term7;
    }
}

