/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import java.util.List;
import java.util.function.Predicate;

public final class Completeness
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Completeness.class);
    String[] completeBehaviors;
    String[] disjointBehaviors;

    public Completeness() {
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Completeness: " + String.valueOf(this);
    }

    public Completeness(String[] stringArray, String[] stringArray2) {
        this.completeBehaviors = stringArray;
        this.disjointBehaviors = stringArray2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Completeness: " + String.valueOf(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Completeness").append('[');
        if (this.completeBehaviors == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.completeBehaviors.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.completeBehaviors[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.disjointBehaviors == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.disjointBehaviors.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.disjointBehaviors[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String[] getCompleteBehaviors() {
        return this.completeBehaviors;
    }

    public void setCompleteBehaviors(String[] stringArray) {
        this.completeBehaviors = stringArray;
    }

    public String[] getDisjointBehaviors() {
        return this.disjointBehaviors;
    }

    public void setDisjointBehaviors(String[] stringArray) {
        this.disjointBehaviors = stringArray;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        aCSLVisitor.visit(this);
    }

    @Override
    public Completeness accept(ACSLTransformer aCSLTransformer) {
        Completeness completeness = aCSLTransformer.transform(this);
        if (completeness != this) {
            return completeness;
        }
        return this;
    }
}

