/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Scriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ScriptorWithGetInterpolants
extends Scriptor {
    private final IInterpolationAdapter mInterpolationAdapter;

    public ScriptorWithGetInterpolants(String string, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ExternalInterpolator externalInterpolator, String string2, String string3) throws IOException {
        super(string, iLogger, iUltimateServiceProvider, string2, string3);
        this.mInterpolationAdapter = this.createAdapter(externalInterpolator);
    }

    private IInterpolationAdapter createAdapter(ExternalInterpolator externalInterpolator) {
        switch (externalInterpolator) {
            case IZ3: {
                return new Z3Interpolation();
            }
            case MATHSAT: {
                return new MathsatInterpolation();
            }
            case PRINCESS: 
            case SMTINTERPOL: {
                return new SmtInterpolInterpolation();
            }
        }
        throw new AssertionError((Object)("Unknown ExternalInterpolator: " + String.valueOf((Object)externalInterpolator)));
    }

    public Term[] getInterpolants(Term[] termArray) throws SMTLIBException {
        return this.mInterpolationAdapter.getInterpolants(termArray);
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException {
        return this.mInterpolationAdapter.getInterpolants(termArray, nArray);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        return this.mInterpolationAdapter.assertTerm(term);
    }

    private Executor getExecutor() {
        return this.mExecutor;
    }

    private static String buildInterpolationCommand(String string, Term[] termArray) {
        StringBuilder stringBuilder = new StringBuilder();
        PrintTerm printTerm = new PrintTerm();
        stringBuilder.append(string);
        String string2 = "";
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            stringBuilder.append(string2);
            printTerm.append((Appendable)stringBuilder, term);
            string2 = " ";
            ++n2;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static String buildInterpolationCommand(String string, Term[] termArray, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        PrintTerm printTerm = new PrintTerm();
        stringBuilder.append(string);
        printTerm.append((Appendable)stringBuilder, termArray[0]);
        int n = 1;
        while (n < termArray.length) {
            int n2 = nArray[n - 1];
            while (nArray[n] < n2) {
                stringBuilder.append(')');
                n2 = nArray[n2 - 1];
            }
            stringBuilder.append(' ');
            if (nArray[n] == n) {
                stringBuilder.append('(');
            }
            printTerm.append((Appendable)stringBuilder, termArray[n]);
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static enum ExternalInterpolator {
        IZ3,
        PRINCESS,
        SMTINTERPOL,
        MATHSAT;

    }

    private static interface IInterpolationAdapter {
        public Term[] getInterpolants(Term[] var1) throws SMTLIBException, UnsupportedOperationException;

        public Term[] getInterpolants(Term[] var1, int[] var2) throws SMTLIBException, UnsupportedOperationException;

        public Script.LBool assertTerm(Term var1) throws SMTLIBException;
    }

    private final class MathsatInterpolation
    implements IInterpolationAdapter {
        private static final String CMD = "(get-interpolant (";

        private MathsatInterpolation() {
        }

        @Override
        public Term[] getInterpolants(Term[] termArray) throws SMTLIBException {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                List<Term> list = this.flatten(term);
                arrayList.addAll(list);
                this.sendInterpolationCommand(arrayList.toArray(new Term[arrayList.size()]));
                arrayList2.addAll(Arrays.asList(this.readInterpolants()));
                ++n2;
            }
            return arrayList2.toArray(new Term[arrayList2.size()]);
        }

        @Override
        public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        public Script.LBool assertTerm(Term term) throws SMTLIBException {
            Term term2 = this.convertAnnotationNamedToInterpolationGroup(term);
            return ScriptorWithGetInterpolants.super.assertTerm(term2);
        }

        private Term convertAnnotationNamedToInterpolationGroup(Term term) {
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                Annotation[] annotationArray = annotatedTerm.getAnnotations();
                Annotation[] annotationArray2 = new Annotation[annotationArray.length];
                boolean bl = false;
                int n = 0;
                while (n < annotationArray.length) {
                    Annotation annotation = annotationArray[n];
                    if (":named".equals(annotation.getKey())) {
                        bl = true;
                        annotationArray2[n] = new Annotation(":interpolation-group", annotation.getValue());
                    } else {
                        annotationArray2[n] = annotation;
                    }
                    ++n;
                }
                if (bl) {
                    return ScriptorWithGetInterpolants.this.annotate(annotatedTerm.getSubterm(), annotationArray2);
                }
            }
            return term;
        }

        private void sendInterpolationCommand(Term[] termArray) {
            StringBuilder stringBuilder = new StringBuilder();
            PrintTerm printTerm = new PrintTerm();
            stringBuilder.append(CMD);
            String string = "";
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                stringBuilder.append(string);
                printTerm.append((Appendable)stringBuilder, term);
                string = " ";
                ++n2;
            }
            stringBuilder.append("))");
            ScriptorWithGetInterpolants.this.getExecutor().input(stringBuilder.toString());
        }

        private void sendInterpolationCommand(Term[] termArray, int[] nArray) {
            String string = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, termArray, nArray);
            ScriptorWithGetInterpolants.this.getExecutor().input(string);
        }

        private Term readInterpolants() {
            return ScriptorWithGetInterpolants.this.mExecutor.parseTerm();
        }

        private List<Term> flatten(Term term) {
            ApplicationTerm applicationTerm;
            if (term instanceof ApplicationTerm && "and".equals((applicationTerm = (ApplicationTerm)term).getFunction().getName())) {
                return Arrays.asList(applicationTerm.getParameters());
            }
            return Collections.singletonList(term);
        }
    }

    private final class SmtInterpolInterpolation
    implements IInterpolationAdapter {
        private static final String CMD = "(get-interpolants ";

        private SmtInterpolInterpolation() {
        }

        @Override
        public Term[] getInterpolants(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
            this.sendInterpolationCommand(termArray);
            return this.readInterpolants();
        }

        @Override
        public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException {
            this.sendInterpolationCommand(termArray, nArray);
            return this.readInterpolants();
        }

        @Override
        public Script.LBool assertTerm(Term term) throws SMTLIBException {
            return ScriptorWithGetInterpolants.super.assertTerm(term);
        }

        private void sendInterpolationCommand(Term[] termArray) {
            String string = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, termArray);
            ScriptorWithGetInterpolants.this.getExecutor().input(string);
        }

        private void sendInterpolationCommand(Term[] termArray, int[] nArray) {
            String string = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, termArray, nArray);
            ScriptorWithGetInterpolants.this.getExecutor().input(string);
        }

        private Term[] readInterpolants() {
            return ScriptorWithGetInterpolants.this.mExecutor.parseGetAssertionsResult();
        }
    }

    private final class Z3Interpolation
    implements IInterpolationAdapter {
        private static final String CMD = "(get-interpolant ";

        private Z3Interpolation() {
        }

        @Override
        public Term[] getInterpolants(Term[] termArray) throws SMTLIBException {
            this.sendInterpolationCommand(termArray);
            return this.readInterpolants();
        }

        @Override
        public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException {
            this.sendInterpolationCommand(termArray, nArray);
            return this.readInterpolants();
        }

        @Override
        public Script.LBool assertTerm(Term term) throws SMTLIBException {
            return ScriptorWithGetInterpolants.super.assertTerm(term);
        }

        private void sendInterpolationCommand(Term[] termArray) {
            String string = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, termArray);
            ScriptorWithGetInterpolants.this.getExecutor().input(string);
        }

        private void sendInterpolationCommand(Term[] termArray, int[] nArray) {
            String string = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, termArray, nArray);
            ScriptorWithGetInterpolants.this.getExecutor().input(string);
        }

        private Term[] readInterpolants() {
            return ScriptorWithGetInterpolants.this.mExecutor.parseInterpolants();
        }
    }
}

