/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IBooleanArrayHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarationInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemoryModelDeclarationsHandler {
    private final Map<MemoryModelDeclarations, MemoryModelDeclarationInfo> declarationInfos = new LinkedHashMap<MemoryModelDeclarations, MemoryModelDeclarationInfo>();
    private final ITypeHandler mTypeHandler;
    private final IBooleanArrayHelper mBooleanArrayHelper;
    private final CPrimitive mRWLockCounterType;

    public MemoryModelDeclarationsHandler(ITypeHandler iTypeHandler, IBooleanArrayHelper iBooleanArrayHelper, CPrimitive cPrimitive) {
        this.mTypeHandler = iTypeHandler;
        this.mBooleanArrayHelper = iBooleanArrayHelper;
        this.mRWLockCounterType = cPrimitive;
    }

    public MemoryModelDeclarationInfo memoryModelDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations) {
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = this.declarationInfos.get((Object)memoryModelDeclarations);
        if (memoryModelDeclarationInfo == null) {
            throw new AssertionError((Object)("Call requireMemoryStructureFeature first for key: " + String.valueOf((Object)memoryModelDeclarations)));
        }
        return memoryModelDeclarationInfo;
    }

    public void createMemoryModelDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations) {
        this.declarationInfos.putIfAbsent(memoryModelDeclarations, this.constructMemoryStructureDeclarationInfo(memoryModelDeclarations));
    }

    private MemoryModelDeclarationInfo constructMemoryStructureDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations) {
        switch (memoryModelDeclarations) {
            case ULTIMATE_DATA_RACE_MEMORY: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(this.mBooleanArrayHelper.constructBoolReplacementType())));
            }
            case ULTIMATE_HEAP_ALLOCATIONS: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForPointerComponents());
            }
            case ULTIMATE_INITIAL_ALLOCATIONS: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForPointerComponents());
            }
            case ULTIMATE_LENGTH: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogieTypeForPointerComponents()}, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT()));
            }
            case ULTIMATE_PTHREADS_FORK_COUNT: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForCType(this.mTypeHandler.getThreadIdType()));
            }
            case ULTIMATE_PTHREADS_MUTEX: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(this.mBooleanArrayHelper.constructBoolReplacementType())));
            }
            case ULTIMATE_PTHREADS_RWLOCK: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(this.mRWLockCounterType)));
            }
            case ULTIMATE_STACK_ALLOCATIONS: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForPointerComponents());
            }
            case ULTIMATE_STACK_HEAP_BARRIER: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForPointerComponents());
            }
            case ULTIMATE_VALID: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogieTypeForPointerComponents()}, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(this.mBooleanArrayHelper.constructBoolReplacementType())));
            }
        }
        return new MemoryModelDeclarationInfo(memoryModelDeclarations);
    }
}

