/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryStructure;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class MemoryStructureBase
implements IMemoryStructure {
    protected static final String READ_PROCEDURE_PREFIX = "read~";
    protected static final String WRITE_PROCEDURE_PREFIX = "write~";
    protected static final String UNCHECKED_PREFIX = "unchecked~";
    protected static final String INIT_INFIX = "init~";
    protected final ITypeHandler mTypeHandler;
    protected final TypeSizes mTypeSizes;
    private final HeapDataArray mPointerArray;

    public MemoryStructureBase(TypeSizes typeSizes, ITypeHandler iTypeHandler) {
        this.mTypeSizes = typeSizes;
        this.mTypeHandler = iTypeHandler;
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        this.mPointerArray = new HeapDataArray("$Pointer$", iTypeHandler.constructPointerType(cACSLLocation), iTypeHandler.getBoogiePointerType(), iTypeHandler.getBoogiePointerType(), this.bytesizeOfStoredPointerComponents());
    }

    @Override
    public final String getReadProcedureName(CPrimitive.CPrimitives cPrimitives) {
        return READ_PROCEDURE_PREFIX + this.getProcedureSuffix(cPrimitives);
    }

    @Override
    public final String getUncheckedReadProcedureName(CPrimitive.CPrimitives cPrimitives) {
        return "read~unchecked~" + this.getProcedureSuffix(cPrimitives);
    }

    @Override
    public final String getWriteProcedureName(CPrimitive.CPrimitives cPrimitives) {
        return WRITE_PROCEDURE_PREFIX + this.getProcedureSuffix(cPrimitives);
    }

    @Override
    public final String getUncheckedWriteProcedureName(CPrimitive.CPrimitives cPrimitives) {
        return "write~unchecked~" + this.getProcedureSuffix(cPrimitives);
    }

    @Override
    public final String getInitWriteProcedureName(CPrimitive.CPrimitives cPrimitives) {
        return "write~init~" + this.getProcedureSuffix(cPrimitives);
    }

    @Override
    public final String getReadPointerProcedureName() {
        HeapDataArray heapDataArray = this.mPointerArray;
        return READ_PROCEDURE_PREFIX + heapDataArray.getName();
    }

    @Override
    public final String getUncheckedReadPointerProcedureName() {
        HeapDataArray heapDataArray = this.mPointerArray;
        return "read~unchecked~" + heapDataArray.getName();
    }

    @Override
    public final String getWritePointerProcedureName() {
        HeapDataArray heapDataArray = this.mPointerArray;
        return WRITE_PROCEDURE_PREFIX + heapDataArray.getName();
    }

    @Override
    public final String getUncheckedWritePointerProcedureName() {
        HeapDataArray heapDataArray = this.mPointerArray;
        return "write~unchecked~" + heapDataArray.getName();
    }

    @Override
    public final String getInitPointerProcedureName() {
        HeapDataArray heapDataArray = this.mPointerArray;
        return "write~init~" + heapDataArray.getName();
    }

    @Override
    public final HeapDataArray getPointerHeapArray() {
        return this.mPointerArray;
    }

    @Override
    public final Collection<HeapDataArray> getDataHeapArrays(RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        HashSet<HeapDataArray> hashSet = new HashSet<HeapDataArray>();
        if (requiredMemoryModelFeatures.isPointerOnHeapRequired()) {
            hashSet.add(this.getPointerHeapArray());
        }
        for (CPrimitive.CPrimitives cPrimitives : requiredMemoryModelFeatures.getDataOnHeapRequired()) {
            hashSet.add(this.getDataHeapArray(cPrimitives));
        }
        return hashSet;
    }

    @Override
    public final List<ReadWriteDefinition> getReadWriteDefinitionForHeapDataArray(HeapDataArray heapDataArray, RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        if (heapDataArray == this.mPointerArray) {
            if (requiredMemoryModelFeatures.isPointerOnHeapRequired()) {
                return Collections.singletonList(new ReadWriteDefinition(this.getPointerHeapArray().getName(), this.bytesizeOfStoredPointerComponents(), this.getPointerHeapArray().getASTType(), new CPointer(new CPrimitive(CPrimitive.CPrimitives.INT)), requiredMemoryModelFeatures.isPointerUncheckedWriteRequired(), requiredMemoryModelFeatures.isPointerInitRequired()));
            }
            return Collections.emptyList();
        }
        return this.getReadWriteDefinitionForNonPointerHeapDataArray(heapDataArray, requiredMemoryModelFeatures);
    }

    protected abstract int bytesizeOfStoredPointerComponents();

    protected abstract String getProcedureSuffix(CPrimitive.CPrimitives var1);

    protected abstract List<ReadWriteDefinition> getReadWriteDefinitionForNonPointerHeapDataArray(HeapDataArray var1, RequiredMemoryModelFeatures var2);

    public static class ReadWriteDefinition {
        private final String mProcedureSuffix;
        private final int mBytesize;
        private final ASTType mASTType;
        private final boolean mAlsoUncheckedWrite;
        private final boolean mAlsoInit;
        private final ICType mRepresentativeType;

        public ReadWriteDefinition(String string, int n, ASTType aSTType, ICType iCType, boolean bl, boolean bl2) {
            this.mProcedureSuffix = string;
            this.mBytesize = n;
            this.mASTType = aSTType;
            this.mRepresentativeType = iCType;
            this.mAlsoUncheckedWrite = bl;
            this.mAlsoInit = bl2;
        }

        public String getReadProcedureName() {
            return MemoryStructureBase.READ_PROCEDURE_PREFIX + this.mProcedureSuffix;
        }

        public String getWriteProcedureName() {
            return MemoryStructureBase.WRITE_PROCEDURE_PREFIX + this.mProcedureSuffix;
        }

        public String getUncheckedWriteProcedureName() {
            return "write~unchecked~" + this.mProcedureSuffix;
        }

        public String getInitWriteProcedureName() {
            return "write~init~" + this.mProcedureSuffix;
        }

        public boolean alsoUncheckedWrite() {
            return this.mAlsoUncheckedWrite;
        }

        public boolean alsoInit() {
            return this.mAlsoInit;
        }

        public int getBytesize() {
            return this.mBytesize;
        }

        public ASTType getASTType() {
            return this.mASTType;
        }

        public ICType getRepresentativeType() {
            return this.mRepresentativeType;
        }

        public String toString() {
            return "ReadWriteDefinition [mProcedureSuffix=" + this.mProcedureSuffix + ", mBytesize=" + this.mBytesize + ", mASTType=" + String.valueOf(this.mASTType) + ", mRepresentativeType=" + String.valueOf(this.mRepresentativeType) + ", mAlsoUncheckedWrite=" + this.mAlsoUncheckedWrite + ", mAlsoInit=" + this.mAlsoInit + "]";
        }
    }
}

