/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.boogie;

import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;

public class CompleteBoogieVar {
    private static final long serialVersionUID = -7848336493120723097L;
    private final String mIdentifier;
    private final String mProcedure;
    private final IBoogieType mIType;
    private final boolean mOldvar;
    private final int mHashCode;

    public CompleteBoogieVar(String string, String string2, IBoogieType iBoogieType) {
        this.mIdentifier = string;
        this.mProcedure = string2;
        this.mIType = iBoogieType;
        this.mOldvar = false;
        this.mHashCode = this.computeHashCode();
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public String getProcedure() {
        return this.mProcedure;
    }

    public IBoogieType getIType() {
        return this.mIType;
    }

    public boolean isGlobal() {
        return this.mProcedure == null;
    }

    public boolean isOldvar() {
        return this.mOldvar;
    }

    public String getGloballyUniqueId() {
        if (this.isGlobal()) {
            if (this.isOldvar()) {
                return "old(" + this.mIdentifier + ")";
            }
            return this.mIdentifier;
        }
        return this.mProcedure + "_" + this.mIdentifier;
    }

    public String toString() {
        return this.getGloballyUniqueId();
    }

    private int computeHashCode() {
        int n = 1;
        n = 31 * n + (this.mIdentifier == null ? 0 : this.mIdentifier.hashCode());
        n = 31 * n + (this.mOldvar ? 1231 : 1237);
        n = 31 * n + (this.mProcedure == null ? 0 : this.mProcedure.hashCode());
        return n;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompleteBoogieVar completeBoogieVar = (CompleteBoogieVar)object;
        if (this.mIdentifier == null ? completeBoogieVar.mIdentifier != null : !this.mIdentifier.equals(completeBoogieVar.mIdentifier)) {
            return false;
        }
        if (this.mOldvar != completeBoogieVar.mOldvar) {
            return false;
        }
        return !(this.mProcedure == null ? completeBoogieVar.mProcedure != null : !this.mProcedure.equals(completeBoogieVar.mProcedure));
    }
}

