/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IServiceFactoryFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;

public class GenericServiceProvider
implements IStorable {
    private static final String KEY = "GenericServiceProvider";
    private final IServiceFactoryFactory mFactory;

    public GenericServiceProvider(IServiceFactoryFactory iServiceFactoryFactory) {
        this.mFactory = iServiceFactoryFactory;
    }

    static <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(ToolchainStorage toolchainStorage, Class<K> clazz) {
        assert (toolchainStorage != null);
        IStorable iStorable = toolchainStorage.getStorable(clazz.getName());
        if (iStorable != null) {
            return (T)((IService)iStorable);
        }
        GenericServiceProvider genericServiceProvider = (GenericServiceProvider)toolchainStorage.getStorable(KEY);
        IService iService = (IService)genericServiceProvider.mFactory.createService(clazz, toolchainStorage, toolchainStorage);
        if (iService != null) {
            toolchainStorage.putStorable(clazz.getName(), (IStorable)iService);
        }
        return (T)iService;
    }

    public static String getServiceKey() {
        return KEY;
    }

    public void destroy() {
    }
}

