/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic.simplification;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.logic.simplification.PushPopChecker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class SimplifyDDA
extends NonRecursive {
    HashMap<Term, TermInfo> mTermInfos;
    Term mResult;
    protected final Script mScript;
    final Term mTrue;
    final Term mFalse;
    protected final boolean mSimplifyRepeatedly;
    protected boolean mInconsistencyOfContextDetected;

    public SimplifyDDA(Script script) {
        this(script, true);
    }

    public SimplifyDDA(Script script, boolean bl) {
        this.mScript = script;
        this.mTrue = this.mScript.term("true", new Term[0]);
        this.mFalse = this.mScript.term("false", new Term[0]);
        this.mSimplifyRepeatedly = bl;
    }

    public Script.LBool checkEquivalence(Term term, Term term2) {
        Term term3 = this.mScript.term("=", term, term2);
        String string = null;
        try {
            string = (String)this.mScript.getOption(":check-type");
            this.mScript.setOption(":check-type", "FULL");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        Script.LBool lBool = Util.checkSat(this.mScript, Util.not(this.mScript, term3));
        if (string != null) {
            this.mScript.setOption(":check-type", string);
        }
        return lBool;
    }

    protected Redundancy getRedundancy(Term term) {
        if (this.mInconsistencyOfContextDetected) {
            return Redundancy.NON_CONSTRAINING;
        }
        Script.LBool lBool = Util.checkSat(this.mScript, Util.not(this.mScript, term));
        if (lBool == Script.LBool.UNSAT) {
            return Redundancy.NON_CONSTRAINING;
        }
        Script.LBool lBool2 = Util.checkSat(this.mScript, term);
        if (lBool2 == Script.LBool.UNSAT) {
            return Redundancy.NON_RELAXING;
        }
        return Redundancy.NOT_REDUNDANT;
    }

    private static Term termVariable2constant(Script script, TermVariable termVariable) {
        String string = termVariable.getName() + "_const_" + termVariable.hashCode();
        Sort[] sortArray = new Sort[]{};
        Sort sort = termVariable.getSort();
        script.declareFun(string, sortArray, sort);
        Term term = script.term(string, new Term[0]);
        return term;
    }

    public Term simplifyOnce(Term term) {
        this.mInconsistencyOfContextDetected = false;
        this.mTermInfos = new HashMap();
        this.run(new TermCounter(term));
        this.run(new ContextCollector(false, term, new ArrayDeque<Term>()));
        this.run(new PrepareSimplifier(false, term));
        this.run(new Simplifier(false, term));
        Term term2 = this.popResult();
        this.mTermInfos = null;
        return term2;
    }

    public Term getSimplifiedTerm(Term term) throws SMTLIBException {
        if (!"Bool".equals(term.getSort().getName())) {
            return term;
        }
        int n = 0;
        assert ((n = PushPopChecker.currentLevel(this.mScript)) >= -1);
        Term term2 = term;
        this.mScript.echo(new QuotedObject("Begin Simplifier"));
        this.mScript.push(1);
        final TermVariable[] termVariableArray = term2.getFreeVars();
        final Term[] termArray = new Term[termVariableArray.length];
        int n2 = 0;
        while (n2 < termVariableArray.length) {
            termArray[n2] = SimplifyDDA.termVariable2constant(this.mScript, termVariableArray[n2]);
            ++n2;
        }
        term2 = this.mScript.let(termVariableArray, termArray, term2);
        term2 = new FormulaUnLet().unlet(term2);
        Term term3 = this.simplifyOnce(term2);
        if (this.mSimplifyRepeatedly) {
            while (term3 != term2) {
                term2 = term3;
                term3 = this.simplifyOnce(term2);
            }
        } else {
            term2 = term3;
        }
        term2 = new TermTransformer(){

            @Override
            public void convert(Term term) {
                int n = 0;
                while (n < termVariableArray.length) {
                    if (term == termArray[n]) {
                        term = termVariableArray[n];
                    }
                    ++n;
                }
                super.convert(term);
            }
        }.transform(term2);
        this.mScript.pop(1);
        assert (this.checkEquivalence(term, term2) != Script.LBool.SAT) : "Simplification unsound?";
        this.mScript.echo(new QuotedObject("End Simplifier"));
        assert (PushPopChecker.atLevel(this.mScript, n));
        return term2;
    }

    private Term negateSibling(Term term, String string, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = string == "or" || string == "=>" && n == n2 - 1;
        if (bl) {
            return Util.not(this.mScript, term);
        }
        return term;
    }

    void pushContext(Term ... termArray) {
        this.mScript.push(1);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            Script.LBool lBool = this.mScript.assertTerm(term);
            if (lBool == Script.LBool.UNSAT) {
                this.mInconsistencyOfContextDetected = true;
                return;
            }
            ++n2;
        }
    }

    void popContext() {
        this.mInconsistencyOfContextDetected = false;
        this.mScript.pop(1);
    }

    void setResult(boolean bl, Term term) {
        if (bl) {
            term = Util.not(this.mScript, term);
        }
        assert (this.mResult == null);
        this.mResult = term;
    }

    Term popResult() {
        Term term = this.mResult;
        this.mResult = null;
        return term;
    }

    private static class ContextCollector
    implements NonRecursive.Walker {
        final boolean mNegated;
        final Term mTerm;
        ArrayDeque<Term> mContext;
        int mParamCtr;

        public ContextCollector(boolean bl, Term term, ArrayDeque<Term> arrayDeque) {
            while (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getName() != "not") break;
                term = applicationTerm.getParameters()[0];
                bl ^= true;
            }
            this.mNegated = bl;
            this.mTerm = term;
            this.mContext = arrayDeque;
            this.mParamCtr = 0;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            SimplifyDDA simplifyDDA = (SimplifyDDA)nonRecursive;
            if (this.mParamCtr > 0) {
                this.walkNextParameter(simplifyDDA);
                return;
            }
            TermInfo termInfo = simplifyDDA.mTermInfos.get(this.mTerm);
            assert (termInfo != null);
            ++termInfo.mSeen;
            assert (termInfo.mSeen <= termInfo.mNumPredecessors);
            if (termInfo.mNumPredecessors > 1) {
                if (termInfo.mContext == null) {
                    termInfo.mContext = this.mContext.toArray(new Term[this.mContext.size()]);
                } else {
                    HashSet<Term> hashSet = new HashSet<Term>(termInfo.mContext.length);
                    hashSet.addAll(Arrays.asList(termInfo.mContext));
                    ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>(termInfo.mContext.length);
                    for (Term term : this.mContext) {
                        if (!hashSet.contains(term)) continue;
                        arrayDeque.add(term);
                    }
                    this.mContext = arrayDeque;
                    termInfo.mContext = arrayDeque.toArray(new Term[arrayDeque.size()]);
                }
                if (termInfo.mSeen < termInfo.mNumPredecessors) {
                    return;
                }
            }
            if (this.mTerm instanceof ApplicationTerm) {
                this.walkNextParameter(simplifyDDA);
            }
        }

        public void walkNextParameter(SimplifyDDA simplifyDDA) {
            ApplicationTerm applicationTerm = (ApplicationTerm)this.mTerm;
            String string = applicationTerm.getFunction().getName();
            Term[] termArray = applicationTerm.getParameters();
            if (string == "ite") {
                Term term = termArray[0];
                if (this.mParamCtr == 0) {
                    simplifyDDA.enqueueWalker(this);
                    simplifyDDA.enqueueWalker(new ContextCollector(false, term, this.mContext));
                } else if (this.mParamCtr == 1) {
                    this.mContext.push(term);
                    simplifyDDA.enqueueWalker(this);
                    simplifyDDA.enqueueWalker(new ContextCollector(this.mNegated, termArray[1], this.mContext));
                } else if (this.mParamCtr == 2) {
                    this.mContext.pop();
                    this.mContext.push(Util.not(simplifyDDA.mScript, term));
                    simplifyDDA.enqueueWalker(this);
                    simplifyDDA.enqueueWalker(new ContextCollector(this.mNegated, termArray[2], this.mContext));
                } else if (this.mParamCtr == 3) {
                    this.mContext.pop();
                }
                ++this.mParamCtr;
            } else if (string == "and" || string == "or" || string == "=>") {
                if (this.mParamCtr == 0) {
                    int n = termArray.length - 1;
                    while (n > 0) {
                        Term term = simplifyDDA.negateSibling(termArray[n], string, n, termArray.length);
                        this.mContext.push(term);
                        --n;
                    }
                    simplifyDDA.enqueueWalker(this);
                    simplifyDDA.enqueueWalker(new ContextCollector(this.mNegated, termArray[this.mParamCtr], this.mContext));
                } else if (this.mParamCtr < termArray.length) {
                    this.mContext.pop();
                    simplifyDDA.enqueueWalker(this);
                    simplifyDDA.enqueueWalker(new ContextCollector(this.mNegated, termArray[this.mParamCtr], this.mContext));
                }
                ++this.mParamCtr;
            }
        }
    }

    private static class PrepareSimplifier
    implements NonRecursive.Walker {
        final Term mTerm;

        public PrepareSimplifier(boolean bl, Term term) {
            while (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getName() != "not") break;
                term = applicationTerm.getParameters()[0];
            }
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            SimplifyDDA simplifyDDA = (SimplifyDDA)nonRecursive;
            TermInfo termInfo = simplifyDDA.mTermInfos.get(this.mTerm);
            if (termInfo.mPrepared++ > 0) {
                return;
            }
            if (termInfo.mNumPredecessors > 1) {
                nonRecursive.enqueueWalker(new StoreSimplified(this.mTerm));
                nonRecursive.enqueueWalker(new Simplifier(false, this.mTerm, termInfo.mContext));
            }
            if (this.mTerm instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)this.mTerm;
                String string = applicationTerm.getFunction().getName();
                Term[] termArray = applicationTerm.getParameters();
                if (string == "ite" || string == "and" || string == "or" || string == "=>") {
                    int n = 0;
                    while (n < termArray.length) {
                        nonRecursive.enqueueWalker(new PrepareSimplifier(false, termArray[n]));
                        ++n;
                    }
                }
            }
        }

        public String toString() {
            return "PrepareSimplifier[" + String.valueOf(this.mTerm) + "]";
        }
    }

    public static enum Redundancy {
        NON_RELAXING,
        NON_CONSTRAINING,
        NOT_REDUNDANT;

    }

    private static class Simplifier
    implements NonRecursive.Walker {
        final boolean mNegated;
        final Term mTerm;
        final Term[] mContext;
        int mParamCtr;
        Term[] mSimplifiedParams;

        public Simplifier(boolean bl, Term term, Term[] termArray) {
            while (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getName() != "not") break;
                term = applicationTerm.getParameters()[0];
                bl ^= true;
            }
            this.mNegated = bl;
            this.mTerm = term;
            this.mContext = termArray;
            this.mParamCtr = 0;
        }

        public Simplifier(boolean bl, Term term) {
            while (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getName() != "not") break;
                term = applicationTerm.getParameters()[0];
                bl ^= true;
            }
            this.mNegated = bl;
            this.mTerm = term;
            this.mContext = null;
            this.mParamCtr = 0;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            Object object;
            Object object2;
            SimplifyDDA simplifyDDA = (SimplifyDDA)nonRecursive;
            if (this.mParamCtr > 0) {
                this.walkParam(simplifyDDA);
                return;
            }
            if (this.mContext == null) {
                object2 = simplifyDDA.getRedundancy(this.mTerm);
                if (object2 != Redundancy.NOT_REDUNDANT) {
                    if (object2 == Redundancy.NON_RELAXING) {
                        simplifyDDA.setResult(this.mNegated, simplifyDDA.mFalse);
                    } else {
                        simplifyDDA.setResult(this.mNegated, simplifyDDA.mTrue);
                    }
                    return;
                }
                object = simplifyDDA.mTermInfos.get(this.mTerm);
                if (((TermInfo)object).mNumPredecessors > 1) {
                    assert (((TermInfo)object).mSimplified != null);
                    simplifyDDA.setResult(this.mNegated, ((TermInfo)object).mSimplified);
                    return;
                }
            }
            if (this.mContext != null) {
                simplifyDDA.pushContext(this.mContext);
                object2 = simplifyDDA.getRedundancy(this.mTerm);
                if (object2 != Redundancy.NOT_REDUNDANT) {
                    if (object2 == Redundancy.NON_RELAXING) {
                        simplifyDDA.setResult(this.mNegated, simplifyDDA.mFalse);
                    } else {
                        simplifyDDA.setResult(this.mNegated, simplifyDDA.mTrue);
                    }
                    simplifyDDA.popContext();
                    return;
                }
            }
            if (this.mTerm instanceof ApplicationTerm) {
                object2 = (ApplicationTerm)this.mTerm;
                object = ((ApplicationTerm)object2).getFunction().getName();
                Term[] termArray = ((ApplicationTerm)object2).getParameters();
                if (object == "ite" || object == "and" || object == "or" || object == "=>") {
                    this.mSimplifiedParams = new Term[termArray.length];
                    this.walkParam(simplifyDDA);
                    return;
                }
            }
            simplifyDDA.setResult(this.mNegated, this.mTerm);
            if (this.mContext != null) {
                simplifyDDA.popContext();
            }
        }

        /*
         * Unable to fully structure code
         */
        private void walkParam(SimplifyDDA var1_1) {
            block31: {
                block32: {
                    block30: {
                        var2_2 = (ApplicationTerm)this.mTerm;
                        var3_3 = var2_2.getFunction().getName();
                        var4_4 = var2_2.getParameters();
                        if (this.mParamCtr > 0) {
                            this.mSimplifiedParams[this.mParamCtr - 1] = var1_1.popResult();
                        }
                        if (var3_3 != "ite") break block30;
                        switch (this.mParamCtr++) {
                            case 0: {
                                var1_1.enqueueWalker(this);
                                var1_1.enqueueWalker(new Simplifier(false, var4_4[0]));
                                break block31;
                            }
                            case 1: {
                                if (this.mSimplifiedParams[0] == var1_1.mFalse) ** GOTO lbl18
                                var1_1.enqueueWalker(this);
                                var1_1.pushContext(new Term[]{this.mSimplifiedParams[0]});
                                var1_1.enqueueWalker(new Simplifier(this.mNegated, var4_4[1]));
                                break block31;
lbl18:
                                // 1 sources

                                this.mSimplifiedParams[this.mParamCtr - 1] = var1_1.mFalse;
                                ++this.mParamCtr;
                            }
                            case 2: {
                                if (this.mSimplifiedParams[0] != var1_1.mFalse) {
                                    var1_1.popContext();
                                }
                                if (this.mSimplifiedParams[0] == var1_1.mTrue) ** GOTO lbl28
                                var1_1.enqueueWalker(this);
                                var1_1.pushContext(new Term[]{Util.not(var1_1.mScript, this.mSimplifiedParams[0])});
                                var1_1.enqueueWalker(new Simplifier(this.mNegated, var4_4[2]));
                                break block31;
lbl28:
                                // 1 sources

                                this.mSimplifiedParams[this.mParamCtr - 1] = var1_1.mFalse;
                                ++this.mParamCtr;
                            }
                            case 3: {
                                if (this.mSimplifiedParams[0] != var1_1.mTrue) {
                                    var1_1.popContext();
                                }
                                var5_5 = Util.ite(var1_1.mScript, this.mSimplifiedParams[0], this.mSimplifiedParams[1], this.mSimplifiedParams[2]);
                                var1_1.setResult(false, var5_5);
                                if (this.mContext != null) {
                                    var1_1.popContext();
                                }
                                break block31;
                            }
                            default: {
                                throw new InternalError("BUG!");
                            }
                        }
                    }
                    if (!Simplifier.$assertionsDisabled && var3_3 != "and" && var3_3 != "or" && var3_3 != "=>") {
                        throw new AssertionError();
                    }
                    if (this.mParamCtr != var4_4.length) break block32;
                    var1_1.popContext();
                    var5_6 = new ArrayList<Term>();
                    var6_9 = null;
                    var7_12 = 0;
                    while (var7_12 < this.mSimplifiedParams.length) {
                        block34: {
                            block33: {
                                var8_15 = this.mSimplifiedParams[var7_12];
                                if (var8_15 != var1_1.mTrue) break block33;
                                if (var3_3 == "and" || var3_3 == "=>" && var7_12 < this.mSimplifiedParams.length - 1) break block34;
                                if (var3_3 == "or" || var3_3 == "=>" && var7_12 == this.mSimplifiedParams.length - 1) {
                                    var6_9 = var1_1.mTrue;
                                    break;
                                }
                                ** GOTO lbl-1000
                            }
                            if (var8_15 == var1_1.mFalse) {
                                if (var3_3 != "or") {
                                    if (var3_3 == "and") {
                                        var6_9 = var1_1.mFalse;
                                        break;
                                    }
                                    if (var3_3 == "=>" && var7_12 < this.mSimplifiedParams.length - 1) {
                                        var6_9 = var1_1.mTrue;
                                        break;
                                    } else {
                                        ** GOTO lbl-1000
                                    }
                                }
                            } else lbl-1000:
                            // 4 sources

                            {
                                var5_6.add(var8_15);
                            }
                        }
                        ++var7_12;
                    }
                    if (var6_9 == null) {
                        if (var5_6.isEmpty()) {
                            var6_9 = var3_3 == "and" ? var1_1.mTrue : var1_1.mFalse;
                        } else if (var5_6.size() == 1) {
                            var6_9 = (Term)var5_6.get(0);
                        } else {
                            var7_13 = var5_6.toArray(new Term[var5_6.size()]);
                            var6_9 = var1_1.mScript.term(var3_3, var7_13);
                        }
                    }
                    var1_1.setResult(this.mNegated, var6_9);
                    if (this.mContext != null) {
                        var1_1.popContext();
                    }
                    return;
                }
                if (this.mParamCtr == 0) {
                    var1_1.pushContext(new Term[0]);
                    var5_7 = var4_4.length - 1;
                    while (var5_7 >= 1) {
                        var6_10 = var1_1.negateSibling(var4_4[var5_7], var3_3, var5_7, var4_4.length);
                        var1_1.pushContext(new Term[]{var6_10});
                        --var5_7;
                    }
                } else {
                    var1_1.popContext();
                    var5_8 = 0;
                    while (var5_8 < this.mParamCtr) {
                        var6_11 = var1_1.negateSibling(this.mSimplifiedParams[var5_8], var3_3, var5_8, var4_4.length);
                        var7_14 = var1_1.mScript.assertTerm(var6_11);
                        if (var7_14 == Script.LBool.UNSAT) {
                            var1_1.mInconsistencyOfContextDetected = true;
                            break;
                        }
                        ++var5_8;
                    }
                }
                var1_1.enqueueWalker(this);
                var1_1.enqueueWalker(new Simplifier(false, var4_4[this.mParamCtr]));
                ++this.mParamCtr;
            }
        }

        public String toString() {
            return "Simplifier[" + String.valueOf(this.mTerm) + ", param: " + this.mParamCtr + "]";
        }
    }

    private static class StoreSimplified
    implements NonRecursive.Walker {
        Term mTerm;

        public StoreSimplified(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            SimplifyDDA simplifyDDA = (SimplifyDDA)nonRecursive;
            TermInfo termInfo = simplifyDDA.mTermInfos.get(this.mTerm);
            termInfo.mSimplified = simplifyDDA.popResult();
        }

        public String toString() {
            return "StoreSimplified[" + String.valueOf(this.mTerm) + "]";
        }
    }

    private static class TermCounter
    implements NonRecursive.Walker {
        protected Term mTerm;

        public TermCounter(Term term) {
            while (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getName() != "not") break;
                term = applicationTerm.getParameters()[0];
            }
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            SimplifyDDA simplifyDDA = (SimplifyDDA)nonRecursive;
            TermInfo termInfo = simplifyDDA.mTermInfos.get(this.mTerm);
            if (termInfo == null) {
                ApplicationTerm applicationTerm;
                String string;
                termInfo = new TermInfo();
                simplifyDDA.mTermInfos.put(this.mTerm, termInfo);
                if (this.mTerm instanceof ApplicationTerm && ((string = (applicationTerm = (ApplicationTerm)this.mTerm).getFunction().getName()) == "ite" || string == "and" || string == "or" || string == "=>")) {
                    Term[] termArray = applicationTerm.getParameters();
                    int n = termArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Term term = termArray[n2];
                        nonRecursive.enqueueWalker(new TermCounter(term));
                        ++n2;
                    }
                }
            }
            ++termInfo.mNumPredecessors;
        }
    }

    private static class TermInfo {
        int mNumPredecessors;
        int mSeen;
        int mPrepared;
        Term[] mContext;
        Term mSimplified;

        private TermInfo() {
        }

        public String toString() {
            return "TermInfo[" + this.mNumPredecessors + "," + this.mSeen + "," + this.mPrepared + (String)(this.mContext == null ? "" : ",context:" + Arrays.toString(this.mContext)) + (String)(this.mSimplified == null ? "" : "->" + String.valueOf(this.mSimplified)) + "]";
        }
    }
}

