/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgTransitionProvider
implements ITransitionProvider<IcfgEdge, IcfgLocation> {
    private final IIcfg<?> mIcfg;

    public IcfgTransitionProvider(IIcfg<?> iIcfg) {
        this.mIcfg = iIcfg;
    }

    @Override
    public Collection<IcfgEdge> getSuccessors(IcfgEdge icfgEdge, IcfgEdge icfgEdge3) {
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
        if (icfgLocation == null) {
            return Collections.emptyList();
        }
        return icfgLocation.getOutgoingEdges().stream().filter(icfgEdge2 -> !(icfgEdge2 instanceof IReturnAction) || this.isLeavingScope((IcfgEdge)icfgEdge2, icfgEdge3)).collect(Collectors.toSet());
    }

    @Override
    public Collection<IcfgEdge> getPredecessors(IcfgEdge icfgEdge, IcfgEdge icfgEdge3) {
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getSource();
        if (icfgLocation == null) {
            return Collections.emptyList();
        }
        return icfgLocation.getIncomingEdges().stream().filter(icfgEdge2 -> !(icfgEdge2 instanceof ICallAction) || this.isEnteringScope((IcfgEdge)icfgEdge2, icfgEdge3)).collect(Collectors.toSet());
    }

    @Override
    public String toLogString(IcfgEdge icfgEdge) {
        return icfgEdge.toString();
    }

    @Override
    public boolean isEnteringScope(IcfgEdge icfgEdge) {
        return icfgEdge instanceof IIcfgCallTransition;
    }

    @Override
    public boolean isLeavingScope(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        assert (icfgEdge != null);
        if (icfgEdge instanceof IIcfgReturnTransition) {
            return RcfgUtils.isAllowedReturn((IIcfgReturnTransition)icfgEdge, icfgEdge2);
        }
        return false;
    }

    @Override
    public boolean isEnteringScope(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        if (icfgEdge instanceof IIcfgCallTransition && icfgEdge2 instanceof IIcfgReturnTransition) {
            IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)icfgEdge;
            IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)icfgEdge2;
            return iIcfgReturnTransition.getCorrespondingCall().equals(iIcfgCallTransition);
        }
        return false;
    }

    @Override
    public boolean isLeavingScope(IcfgEdge icfgEdge) {
        return icfgEdge instanceof IIcfgReturnTransition;
    }

    @Override
    public IcfgLocation getSource(IcfgEdge icfgEdge) {
        return (IcfgLocation)icfgEdge.getSource();
    }

    @Override
    public IcfgLocation getTarget(IcfgEdge icfgEdge) {
        return (IcfgLocation)icfgEdge.getTarget();
    }

    @Override
    public Collection<IcfgEdge> getSuccessorActions(IcfgLocation icfgLocation) {
        return icfgLocation.getOutgoingEdges().stream().collect(Collectors.toList());
    }

    @Override
    public Collection<IcfgEdge> getPredecessorActions(IcfgLocation icfgLocation) {
        return icfgLocation.getIncomingEdges().stream().collect(Collectors.toList());
    }

    @Override
    public boolean isSummaryForCall(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        if (icfgEdge instanceof CodeBlock && icfgEdge2 instanceof CodeBlock) {
            return RcfgUtils.isSummaryForCall(icfgEdge, icfgEdge2);
        }
        return false;
    }

    @Override
    public boolean isSummaryWithImplementation(IcfgEdge icfgEdge) {
        return RcfgUtils.isSummaryWithImplementation(icfgEdge);
    }

    @Override
    public String getProcedureName(IcfgEdge icfgEdge) {
        if (icfgEdge == null) {
            return null;
        }
        if (icfgEdge instanceof Summary) {
            Summary summary = (Summary)icfgEdge;
            return summary.getCallStatement().getMethodName();
        }
        return icfgEdge.getSucceedingProcedure();
    }

    @Override
    public IcfgEdge getSummaryForCall(IcfgEdge icfgEdge) {
        if (!(icfgEdge instanceof ICallAction)) {
            throw new IllegalArgumentException("call is not a Call");
        }
        return ((IcfgLocation)icfgEdge.getSource()).getOutgoingEdges().stream().filter(icfgEdge2 -> this.isSummaryForCall((IcfgEdge)icfgEdge2, icfgEdge)).findFirst().orElse(null);
    }

    @Override
    public boolean isErrorLocation(IcfgLocation icfgLocation) {
        String string = icfgLocation.getProcedure();
        Set set = (Set)this.mIcfg.getProcedureErrorNodes().get(string);
        if (set == null) {
            return false;
        }
        return set.contains(icfgLocation);
    }
}

