/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ExpressionTransformer {
    private BigInteger mConstant = BigInteger.ZERO;
    private HashMap<String, BigInteger> mCoefficients = new HashMap();
    private final HashMap<String, Expression> mIdentifiers = new HashMap();
    private boolean mIsLinear = true;
    private boolean mHasNormalForm = false;

    private ExpressionTransformer() {
    }

    public static Expression transform(Expression expression) {
        if (expression instanceof UnaryExpression) {
            return new ExpressionTransformer().transformUnary((UnaryExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            return new ExpressionTransformer().transformBinary((BinaryExpression)expression);
        }
        return expression;
    }

    private Expression transformUnary(UnaryExpression unaryExpression) {
        if (unaryExpression.getOperator() == UnaryExpression.Operator.LOGICNEG) {
            if (unaryExpression.getExpr() instanceof BinaryExpression) {
                Expression expression;
                BinaryExpression.Operator operator;
                BinaryExpression binaryExpression = (BinaryExpression)unaryExpression.getExpr();
                Expression expression2 = binaryExpression.getLeft();
                Expression expression3 = binaryExpression.getRight();
                ILocation iLocation = binaryExpression.getLocation();
                switch (binaryExpression.getOperator()) {
                    case COMPEQ: {
                        operator = BinaryExpression.Operator.COMPNEQ;
                        break;
                    }
                    case COMPNEQ: {
                        operator = BinaryExpression.Operator.COMPEQ;
                        break;
                    }
                    case COMPGEQ: {
                        operator = BinaryExpression.Operator.COMPLT;
                        break;
                    }
                    case COMPGT: {
                        operator = BinaryExpression.Operator.COMPLEQ;
                        break;
                    }
                    case COMPLEQ: {
                        operator = BinaryExpression.Operator.COMPGT;
                        break;
                    }
                    case COMPLT: {
                        operator = BinaryExpression.Operator.COMPGEQ;
                        break;
                    }
                    case LOGICAND: {
                        operator = BinaryExpression.Operator.LOGICOR;
                        expression2 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression2);
                        expression3 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression3);
                        break;
                    }
                    case LOGICOR: {
                        operator = BinaryExpression.Operator.LOGICAND;
                        expression2 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression2);
                        expression3 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression3);
                        break;
                    }
                    case LOGICIMPLIES: {
                        operator = BinaryExpression.Operator.LOGICAND;
                        expression3 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression3);
                        break;
                    }
                    case LOGICIFF: {
                        operator = BinaryExpression.Operator.LOGICOR;
                        expression = expression2;
                        UnaryExpression unaryExpression2 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression3);
                        UnaryExpression unaryExpression3 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression2);
                        Expression expression4 = expression3;
                        expression2 = new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, expression, (Expression)unaryExpression2);
                        expression3 = new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, (Expression)unaryExpression3, expression4);
                        break;
                    }
                    default: {
                        return unaryExpression;
                    }
                }
                expression = new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, operator, expression2, expression3);
                return ExpressionTransformer.transform(expression);
            }
            if (unaryExpression.getExpr() instanceof UnaryExpression) {
                UnaryExpression unaryExpression4 = (UnaryExpression)unaryExpression.getExpr();
                if (unaryExpression4.getOperator() == UnaryExpression.Operator.LOGICNEG) {
                    return ExpressionTransformer.transform(unaryExpression4.getExpr());
                }
            } else {
                return unaryExpression;
            }
        }
        return this.atomicTransform((Expression)unaryExpression);
    }

    private Expression transformBinary(BinaryExpression binaryExpression) {
        Expression expression;
        Expression expression2;
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        Expression expression3 = binaryExpression.getLeft();
        Expression expression4 = binaryExpression.getRight();
        BinaryExpression.Operator operator2 = operator;
        ILocation iLocation = binaryExpression.getLocation();
        switch (binaryExpression.getOperator()) {
            case LOGICAND: 
            case LOGICOR: {
                expression2 = ExpressionTransformer.transform(binaryExpression.getLeft());
                expression = ExpressionTransformer.transform(binaryExpression.getRight());
                break;
            }
            case LOGICIMPLIES: {
                operator2 = BinaryExpression.Operator.LOGICOR;
                expression2 = ExpressionTransformer.transform((Expression)new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, binaryExpression.getLeft()));
                expression = ExpressionTransformer.transform(binaryExpression.getRight());
                break;
            }
            case LOGICIFF: {
                operator2 = BinaryExpression.Operator.LOGICOR;
                expression2 = ExpressionTransformer.transform((Expression)new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, binaryExpression.getLeft(), binaryExpression.getRight()));
                UnaryExpression unaryExpression = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, binaryExpression.getLeft());
                UnaryExpression unaryExpression2 = new UnaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, binaryExpression.getRight());
                expression = ExpressionTransformer.transform((Expression)new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, (Expression)unaryExpression, (Expression)unaryExpression2));
                break;
            }
            case COMPNEQ: {
                BoogiePrimitiveType boogiePrimitiveType;
                BoogiePrimitiveType boogiePrimitiveType2;
                BoogiePrimitiveType boogiePrimitiveType3;
                if (ExpressionTransformer.isPrimitive(binaryExpression) && ExpressionTransformer.isOfType(-1, boogiePrimitiveType3 = (BoogiePrimitiveType)binaryExpression.getType(), boogiePrimitiveType2 = (BoogiePrimitiveType)binaryExpression.getLeft().getType(), boogiePrimitiveType = (BoogiePrimitiveType)binaryExpression.getRight().getType())) {
                    UnaryExpression unaryExpression = new UnaryExpression(binaryExpression.getLoc(), (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, binaryExpression.getRight());
                    return new BinaryExpression(binaryExpression.getLoc(), (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.COMPEQ, binaryExpression.getLeft(), (Expression)unaryExpression);
                }
            }
            case COMPEQ: {
                BoogiePrimitiveType boogiePrimitiveType3 = iBoogieType -> {
                    Expression expression = ExpressionTransformer.transform(binaryExpression.getLeft());
                    Expression expression2 = ExpressionTransformer.transform(binaryExpression.getRight());
                    return new Triple((Object)expression, (Object)expression2, (Object)true);
                };
                BoogiePrimitiveType boogiePrimitiveType2 = iBoogieType -> new Triple((Object)this.atomicTransform((Expression)binaryExpression), null, (Object)false);
                BoogiePrimitiveType boogiePrimitiveType = iBoogieType -> new Triple((Object)binaryExpression, null, (Object)false);
                Triple triple = (Triple)TypeUtils.applyTypeFunction(boogiePrimitiveType2, boogiePrimitiveType, boogiePrimitiveType3, boogiePrimitiveType, binaryExpression.getLeft().getType());
                if (((Boolean)triple.getThird()).booleanValue()) {
                    expression2 = (Expression)triple.getFirst();
                    expression = (Expression)triple.getSecond();
                    break;
                }
                return (Expression)triple.getFirst();
            }
            default: {
                return this.atomicTransform((Expression)binaryExpression);
            }
        }
        if (operator2 == operator && expression2 == expression3 && expression == expression4) {
            return binaryExpression;
        }
        return new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, operator2, expression2, expression);
    }

    private static boolean isOfType(int n, BoogiePrimitiveType ... boogiePrimitiveTypeArray) {
        if (boogiePrimitiveTypeArray == null || boogiePrimitiveTypeArray.length == 0) {
            return false;
        }
        return Arrays.stream(boogiePrimitiveTypeArray).allMatch(boogiePrimitiveType -> boogiePrimitiveType.getTypeCode() == n);
    }

    private static boolean isPrimitive(BinaryExpression binaryExpression) {
        return binaryExpression.getType() instanceof BoogiePrimitiveType && binaryExpression.getLeft().getType() instanceof BoogiePrimitiveType && binaryExpression.getRight().getType() instanceof BoogiePrimitiveType;
    }

    private Expression atomicTransform(Expression expression) {
        BinaryExpression.Operator operator;
        this.process(expression);
        if (!this.mIsLinear || this.mHasNormalForm) {
            return expression;
        }
        ILocation iLocation = expression.getLocation();
        IntegerLiteral integerLiteral = null;
        for (Map.Entry<String, BigInteger> operator22 : this.mCoefficients.entrySet()) {
            IntegerLiteral integerLiteral2;
            Expression expression2 = this.mIdentifiers.get(operator22.getKey());
            if (integerLiteral == null) {
                if (operator22.getValue().equals(BigInteger.ONE)) {
                    integerLiteral = expression2;
                    continue;
                }
                if (operator22.getValue().abs().equals(BigInteger.ONE)) {
                    integerLiteral = new UnaryExpression(iLocation, expression2.getType(), UnaryExpression.Operator.ARITHNEGATIVE, expression2);
                    continue;
                }
                integerLiteral2 = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, operator22.getValue().toString());
                integerLiteral = new BinaryExpression(iLocation, expression2.getType(), BinaryExpression.Operator.ARITHMUL, (Expression)integerLiteral2, expression2);
                continue;
            }
            integerLiteral2 = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, operator22.getValue().abs().toString());
            BinaryExpression binaryExpression = new BinaryExpression(iLocation, expression2.getType(), BinaryExpression.Operator.ARITHMUL, (Expression)integerLiteral2, expression2);
            BinaryExpression.Operator operator2 = operator22.getValue().signum() > 0 ? BinaryExpression.Operator.ARITHPLUS : BinaryExpression.Operator.ARITHMINUS;
            integerLiteral = operator22.getValue().abs().equals(BigInteger.ONE) ? new BinaryExpression(iLocation, expression2.getType(), operator2, (Expression)integerLiteral, expression2) : new BinaryExpression(iLocation, binaryExpression.getType(), operator2, (Expression)integerLiteral, (Expression)binaryExpression);
        }
        if (integerLiteral == null) {
            integerLiteral = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, this.mConstant.toString());
        } else if (this.mConstant.signum() != 0) {
            IntegerLiteral integerLiteral3 = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, this.mConstant.abs().toString());
            operator = this.mConstant.signum() > 0 ? BinaryExpression.Operator.ARITHPLUS : BinaryExpression.Operator.ARITHMINUS;
            integerLiteral = new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_INT, operator, (Expression)integerLiteral, (Expression)integerLiteral3);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression.Operator operator3 = ((BinaryExpression)expression).getOperator();
            switch (operator3) {
                case COMPLT: 
                case COMPGT: 
                case COMPLEQ: 
                case COMPGEQ: 
                case COMPEQ: 
                case COMPNEQ: {
                    if (integerLiteral instanceof BinaryExpression && this.mConstant.signum() != 0) {
                        operator = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, this.mConstant.negate().toString());
                        integerLiteral = new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_INT, operator3, ((BinaryExpression)integerLiteral).getLeft(), (Expression)operator);
                        break;
                    }
                    integerLiteral = new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_INT, operator3, (Expression)integerLiteral, (Expression)new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, "0"));
                    break;
                }
            }
        }
        return integerLiteral;
    }

    private void process(Expression expression) {
        if (expression instanceof IntegerLiteral) {
            String string = ((IntegerLiteral)expression).getValue();
            this.mConstant = new BigInteger(string);
            this.mHasNormalForm = true;
        } else if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            this.mCoefficients.put(identifierExpression.getIdentifier(), BigInteger.ONE);
            this.mIdentifiers.put(identifierExpression.getIdentifier(), (Expression)identifierExpression);
            this.mHasNormalForm = true;
        } else if (expression instanceof UnaryExpression) {
            this.processUnary((UnaryExpression)expression);
        } else if (expression instanceof BinaryExpression) {
            this.processBinary((BinaryExpression)expression);
        } else {
            this.mIsLinear = false;
        }
    }

    private void processUnary(UnaryExpression unaryExpression) {
        if (unaryExpression.getOperator() == UnaryExpression.Operator.OLD) {
            if (!(unaryExpression.getExpr() instanceof IdentifierExpression)) {
                throw new UnsupportedOperationException("We do not support old expressions atm, only old variables");
            }
            String string = BoogiePrettyPrinter.print((Expression)unaryExpression);
            this.mCoefficients.put(string, BigInteger.ONE);
            this.mIdentifiers.put(string, (Expression)unaryExpression);
            this.mHasNormalForm = true;
            return;
        }
        if (unaryExpression.getOperator() != UnaryExpression.Operator.ARITHNEGATIVE) {
            return;
        }
        ExpressionTransformer expressionTransformer = new ExpressionTransformer();
        expressionTransformer.process(unaryExpression.getExpr());
        this.mIdentifiers.putAll(expressionTransformer.mIdentifiers);
        if (expressionTransformer.mIsLinear) {
            this.mConstant = expressionTransformer.mConstant.negate();
            for (Map.Entry<String, BigInteger> entry : expressionTransformer.mCoefficients.entrySet()) {
                this.mCoefficients.put(entry.getKey(), entry.getValue().negate());
            }
            if (expressionTransformer.mHasNormalForm && (expressionTransformer.mCoefficients.isEmpty() && expressionTransformer.mConstant.signum() > 0 || expressionTransformer.mCoefficients.size() == 1 && expressionTransformer.mConstant.signum() == 0)) {
                this.mHasNormalForm = true;
            }
        } else {
            this.mIsLinear = false;
        }
    }

    private void processBinary(BinaryExpression binaryExpression) {
        ExpressionTransformer expressionTransformer = new ExpressionTransformer();
        expressionTransformer.process(binaryExpression.getLeft());
        if (!expressionTransformer.mIsLinear) {
            this.mIsLinear = false;
            return;
        }
        ExpressionTransformer expressionTransformer2 = new ExpressionTransformer();
        expressionTransformer2.process(binaryExpression.getRight());
        if (!expressionTransformer2.mIsLinear) {
            this.mIsLinear = false;
            return;
        }
        this.mIdentifiers.putAll(expressionTransformer.mIdentifiers);
        this.mIdentifiers.putAll(expressionTransformer2.mIdentifiers);
        boolean bl = expressionTransformer.mCoefficients.isEmpty();
        boolean bl2 = expressionTransformer2.mCoefficients.isEmpty();
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        block0 : switch (operator) {
            case COMPLT: 
            case COMPGT: 
            case COMPLEQ: 
            case COMPGEQ: 
            case COMPEQ: 
            case COMPNEQ: 
            case ARITHMINUS: {
                this.mConstant = expressionTransformer.mConstant.subtract(expressionTransformer2.mConstant);
                for (Map.Entry<String, BigInteger> object : expressionTransformer.mCoefficients.entrySet()) {
                    BigInteger bigInteger = expressionTransformer2.mCoefficients.get(object.getKey());
                    if (bigInteger == null) {
                        this.mCoefficients.put(object.getKey(), object.getValue());
                        continue;
                    }
                    BigInteger bigInteger2 = object.getValue().subtract(bigInteger);
                    if (bigInteger2.signum() == 0) continue;
                    this.mCoefficients.put(object.getKey(), bigInteger2);
                }
                for (Map.Entry<String, BigInteger> entry : expressionTransformer2.mCoefficients.entrySet()) {
                    if (expressionTransformer.mCoefficients.containsKey(entry.getKey())) continue;
                    this.mCoefficients.put(entry.getKey(), entry.getValue().negate());
                }
                if (!expressionTransformer.mHasNormalForm || !expressionTransformer2.mHasNormalForm) break;
                if (expressionTransformer.mConstant.signum() == 0 && expressionTransformer2.mCoefficients.isEmpty()) {
                    this.mHasNormalForm = true;
                    break;
                }
                if (expressionTransformer2.mConstant.signum() == 0 && expressionTransformer.mCoefficients.isEmpty()) {
                    this.mHasNormalForm = true;
                    break;
                }
                if (operator != BinaryExpression.Operator.ARITHMINUS || expressionTransformer.mConstant.signum() != 0 || expressionTransformer2.mConstant.signum() != 0) break;
                this.mHasNormalForm = true;
                for (String entry : expressionTransformer.mCoefficients.keySet()) {
                    if (!expressionTransformer2.mCoefficients.containsKey(entry)) continue;
                    this.mHasNormalForm = false;
                    break block0;
                }
                break;
            }
            case ARITHPLUS: {
                this.mConstant = expressionTransformer.mConstant.add(expressionTransformer2.mConstant);
                for (Map.Entry<String, BigInteger> entry : expressionTransformer.mCoefficients.entrySet()) {
                    BigInteger bigInteger = expressionTransformer2.mCoefficients.get(entry.getKey());
                    if (bigInteger == null) {
                        this.mCoefficients.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    BigInteger bigInteger3 = entry.getValue().add(bigInteger);
                    if (bigInteger3.signum() == 0) continue;
                    this.mCoefficients.put(entry.getKey(), bigInteger3);
                }
                for (Map.Entry<String, BigInteger> entry : expressionTransformer2.mCoefficients.entrySet()) {
                    if (expressionTransformer.mCoefficients.containsKey(entry.getKey())) continue;
                    this.mCoefficients.put(entry.getKey(), entry.getValue());
                }
                if (!expressionTransformer.mHasNormalForm || !expressionTransformer2.mHasNormalForm) break;
                if (expressionTransformer.mConstant.signum() == 0 && expressionTransformer2.mCoefficients.isEmpty()) {
                    this.mHasNormalForm = true;
                    break;
                }
                if (expressionTransformer2.mConstant.signum() == 0 && expressionTransformer.mCoefficients.isEmpty()) {
                    this.mHasNormalForm = true;
                    break;
                }
                if (expressionTransformer.mConstant.signum() != 0 || expressionTransformer2.mConstant.signum() != 0) break;
                this.mHasNormalForm = true;
                for (String string : expressionTransformer.mCoefficients.keySet()) {
                    if (!expressionTransformer2.mCoefficients.containsKey(string)) continue;
                    this.mHasNormalForm = false;
                    break block0;
                }
                break;
            }
            case ARITHMUL: {
                if (bl && bl2) {
                    this.mConstant = expressionTransformer.mConstant.multiply(expressionTransformer2.mConstant);
                    break;
                }
                if (bl) {
                    if (expressionTransformer.mConstant.signum() == 0) {
                        return;
                    }
                    this.mConstant = expressionTransformer.mConstant.multiply(expressionTransformer2.mConstant);
                    for (Map.Entry<String, BigInteger> entry : expressionTransformer2.mCoefficients.entrySet()) {
                        this.mCoefficients.put(entry.getKey(), entry.getValue().multiply(expressionTransformer.mConstant));
                    }
                    if (!expressionTransformer.mHasNormalForm || !expressionTransformer2.mHasNormalForm || expressionTransformer2.mCoefficients.size() != 1) break;
                    this.mHasNormalForm = true;
                    break;
                }
                if (bl2) {
                    if (expressionTransformer2.mConstant.signum() == 0) {
                        return;
                    }
                    this.mConstant = expressionTransformer.mConstant.multiply(expressionTransformer2.mConstant);
                    for (Map.Entry<String, BigInteger> entry : expressionTransformer.mCoefficients.entrySet()) {
                        this.mCoefficients.put(entry.getKey(), entry.getValue().multiply(expressionTransformer2.mConstant));
                    }
                    if (!expressionTransformer.mHasNormalForm || !expressionTransformer2.mHasNormalForm || expressionTransformer.mCoefficients.size() != 1) break;
                    this.mHasNormalForm = true;
                    break;
                }
                this.mIsLinear = false;
                break;
            }
            case ARITHMOD: {
                if (bl && bl2 && expressionTransformer2.mConstant.signum() != 0) {
                    this.mConstant = expressionTransformer.mConstant.mod(expressionTransformer2.mConstant.abs());
                    break;
                }
                if (bl2 && expressionTransformer2.mConstant.abs().equals(BigInteger.ONE)) break;
                this.mIsLinear = false;
                break;
            }
            case ARITHDIV: {
                if (bl && bl2 && expressionTransformer2.mConstant.signum() != 0) {
                    this.mConstant = expressionTransformer.mConstant.divide(expressionTransformer2.mConstant);
                    if (expressionTransformer.mConstant.signum() >= 0) break;
                    if (expressionTransformer2.mConstant.signum() > 0) {
                        this.mConstant = this.mConstant.subtract(BigInteger.ONE);
                        break;
                    }
                    this.mConstant = this.mConstant.add(BigInteger.ONE);
                    break;
                }
                if (bl2 && expressionTransformer2.mConstant.equals(BigInteger.ONE)) {
                    this.mConstant = expressionTransformer.mConstant;
                    this.mCoefficients = expressionTransformer.mCoefficients;
                    break;
                }
                if (bl2 && expressionTransformer2.mConstant.abs().equals(BigInteger.ONE)) {
                    this.mConstant = expressionTransformer.mConstant.negate();
                    for (Map.Entry<String, BigInteger> entry : expressionTransformer.mCoefficients.entrySet()) {
                        this.mCoefficients.put(entry.getKey(), entry.getValue().negate());
                    }
                    break;
                }
                this.mIsLinear = false;
                break;
            }
            default: {
                this.mIsLinear = false;
            }
        }
    }
}

