/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ModelTranslationContainer;
import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.List;

public class BacktranslationService
implements IStorable,
IBacktranslationService {
    private static final String sKey = "BacktranslationService";
    private ModelTranslationContainer mTranslatorSequence = new ModelTranslationContainer();

    public <STE, TTE, SE, TE, SVL, TVL, LOC> void addTranslator(ITranslator<STE, TTE, SE, TE, SVL, TVL, LOC> iTranslator) {
        this.mTranslatorSequence.addTranslator(iTranslator);
    }

    public <SE, TE> TE translateExpression(SE SE, Class<SE> clazz) {
        return this.mTranslatorSequence.translateExpression(SE, clazz);
    }

    public <STE> List<?> translateTrace(List<STE> list, Class<STE> clazz) {
        return this.mTranslatorSequence.translateTrace(list, clazz);
    }

    public <STE, SE> IProgramExecution<?, ?> translateProgramExecution(IProgramExecution<STE, SE> iProgramExecution) {
        return this.mTranslatorSequence.translateProgramExecution(iProgramExecution);
    }

    public <STE, SE> IBacktranslationService.Lasso<IProgramExecution<?, ?>> translateLassoProgramExecution(IBacktranslationService.Lasso<IProgramExecution<STE, SE>> lasso) {
        return this.mTranslatorSequence.translateLassoProgramExecution(lasso);
    }

    public <SE> IProgramExecution.ProgramState<?> translateProgramState(IProgramExecution.ProgramState<SE> programState) {
        return this.mTranslatorSequence.translateProgramState(programState);
    }

    public <SE> String translateProgramStateToString(IProgramExecution.ProgramState<SE> programState) {
        return this.mTranslatorSequence.translateProgramStateToString(programState);
    }

    public <STE, SE> IBacktranslatedCFG<?, ?> translateCFG(IBacktranslatedCFG<?, STE> iBacktranslatedCFG) {
        return this.mTranslatorSequence.translateCFG(iBacktranslatedCFG);
    }

    public <TE, SE, CTX> ProcedureContract<TE, ? extends TE> translateProcedureContract(ProcedureContract<SE, ? extends SE> procedureContract, CTX CTX, Class<SE> clazz) {
        return this.mTranslatorSequence.translateProcedureContract(procedureContract, CTX, clazz);
    }

    public <SE, TE, CTX> TE translateExpressionWithContext(SE SE, CTX CTX, Class<SE> clazz) {
        return this.mTranslatorSequence.translateExpressionWithContext(SE, CTX, clazz);
    }

    public <STE> List<String> translateTraceToHumanReadableString(List<STE> list, Class<STE> clazz) {
        return this.mTranslatorSequence.translateTraceToHumanReadableString(list, clazz);
    }

    public <TE> String targetExpressionToString(TE TE) {
        return this.mTranslatorSequence.targetExpressionToString(TE);
    }

    public IBacktranslationService getTranslationServiceCopy() {
        return this.mTranslatorSequence.getTranslationServiceCopy();
    }

    static IBacktranslationService getService(IToolchainStorage iToolchainStorage) {
        assert (iToolchainStorage != null);
        IStorable iStorable = iToolchainStorage.getStorable(sKey);
        if (iStorable == null) {
            iStorable = new BacktranslationService();
            iToolchainStorage.putStorable(sKey, iStorable);
        }
        return (IBacktranslationService)iStorable;
    }

    public String toString() {
        return this.mTranslatorSequence.toString();
    }

    public void destroy() {
        this.mTranslatorSequence = null;
    }
}

