/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class CongruenceClosureSmtUtils {
    public static <NODE extends IEqNodeIdentifier<NODE>> Term congruenceClosureToTerm(Script script, CongruenceClosure<NODE> congruenceClosure, Term term) {
        return SmtUtils.and((Script)script, CongruenceClosureSmtUtils.congruenceClosureToCube(script, congruenceClosure, term));
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> List<Term> congruenceClosureToCube(Script script, CongruenceClosure<NODE> congruenceClosure, Term term) {
        if (congruenceClosure.isInconsistent()) {
            return Collections.singletonList(script.term("false", new Term[0]));
        }
        List list = congruenceClosure.getSupportingElementEqualities().entrySet().stream().map(entry -> SmtUtils.binaryEquality((Script)script, (Term)((IEqNodeIdentifier)entry.getKey()).getTerm(), (Term)((IEqNodeIdentifier)entry.getValue()).getTerm())).collect(Collectors.toList());
        List list2 = congruenceClosure.getElementDisequalities().getSetOfPairs().stream().map(entry -> SmtUtils.distinct((Script)script, (Term)((IEqNodeIdentifier)entry.getKey()).getTerm(), (Term)((IEqNodeIdentifier)entry.getValue()).getTerm())).collect(Collectors.toList());
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        arrayList.add(term);
        for (Map.Entry entry2 : congruenceClosure.getLiteralSetConstraints().getConstraints().entrySet()) {
            arrayList.add(CongruenceClosureSmtUtils.literalSetConstraintToTerm(script, (SetConstraintConjunction)entry2.getValue()));
        }
        return arrayList;
    }

    private static <NODE extends IEqNodeIdentifier<NODE>> Term literalSetConstraintToTerm(Script script, SetConstraintConjunction<NODE> setConstraintConjunction) {
        HashSet<Term> hashSet = new HashSet<Term>();
        for (Set set : setConstraintConjunction.getElementSets()) {
            HashSet<Term> hashSet2 = new HashSet<Term>();
            for (IEqNodeIdentifier iEqNodeIdentifier : set) {
                hashSet2.add(SmtUtils.binaryEquality((Script)script, (Term)((IEqNodeIdentifier)setConstraintConjunction.getConstrainedElement()).getTerm(), (Term)iEqNodeIdentifier.getTerm()));
            }
            hashSet.add(SmtUtils.or((Script)script, hashSet2));
        }
        return SmtUtils.and((Script)script, hashSet);
    }

    public static List<Term> createDisequalityTermsForNonTheoryLiterals(Script script, Set<Term> set) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        BiPredicate<Term, Term> biPredicate = (term, term2) -> term != term2 && (!(term instanceof ConstantTerm) || !(term2 instanceof ConstantTerm)) && term.getSort().getRealSort() == term2.getSort().getRealSort();
        for (Map.Entry entry : CrossProducts.binarySelectiveCrossProduct(set, (boolean)false, biPredicate)) {
            arrayList.add(script.term("not", new Term[]{SmtUtils.binaryEquality((Script)script, (Term)((Term)entry.getKey()), (Term)((Term)entry.getValue()))}));
        }
        return arrayList;
    }
}

