/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import java.util.function.Predicate;

public class BoogieIcfgLocation
extends IcfgLocation {
    private static final long serialVersionUID = 1L;
    private final BoogieASTNode mBoogieASTNode;
    @Visualizable
    private final boolean mIsErrorLocation;

    public BoogieIcfgLocation(DebugIdentifier debugIdentifier, String string, boolean bl, BoogieASTNode boogieASTNode) {
        this(debugIdentifier, string, bl, boogieASTNode, iAnnotations -> true);
    }

    public BoogieIcfgLocation(DebugIdentifier debugIdentifier, String string, boolean bl, BoogieASTNode boogieASTNode, Predicate<IAnnotations> predicate) {
        super(debugIdentifier, string);
        this.mIsErrorLocation = bl;
        this.mBoogieASTNode = boogieASTNode;
        ModelUtils.copyAnnotationsFiltered((IElement)boogieASTNode, (IElement)this, predicate);
        ILocation iLocation = BoogieIcfgLocation.getLocationFromASTNode(boogieASTNode);
        if (iLocation != null) {
            iLocation.annotate((IElement)this);
        }
    }

    private static ILocation getLocationFromASTNode(BoogieASTNode boogieASTNode) {
        Object object;
        if (boogieASTNode instanceof Statement) {
            Statement statement = (Statement)boogieASTNode;
            object = statement.getLocation();
        } else if (boogieASTNode instanceof Specification) {
            Specification specification = (Specification)boogieASTNode;
            object = specification.getLocation();
        } else {
            object = boogieASTNode instanceof Procedure ? boogieASTNode.getLocation() : null;
        }
        return object;
    }

    public boolean isErrorLocation() {
        return this.mIsErrorLocation;
    }

    public BoogieASTNode getBoogieASTNode() {
        return this.mBoogieASTNode;
    }

    public String getBoogieASTNodeType() {
        if (this.mBoogieASTNode instanceof AssertStatement) {
            return "AssertStatement";
        }
        if (this.mBoogieASTNode instanceof CallStatement) {
            return "RequiresSpecification";
        }
        if (this.mBoogieASTNode instanceof EnsuresSpecification) {
            return "EnsuresSpecification";
        }
        throw new UnsupportedOperationException();
    }
}

