/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting.datastructures;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.ConjunctiveCounterFormula;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.ConjunctiveTransition;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CountingAutomatonDataStructure<LETTER, STATE>
implements IAutomaton<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final Set<LETTER> mAlphabet;
    private final LinkedHashSet<STATE> mStates;
    private final Set<String> mCounters;
    private final Map<STATE, Set<ConjunctiveCounterFormula>> mInitialConditions = new HashMap<STATE, Set<ConjunctiveCounterFormula>>();
    private final Map<STATE, Set<ConjunctiveCounterFormula>> mAcceptingConditions = new HashMap<STATE, Set<ConjunctiveCounterFormula>>();
    private final Map<STATE, List<ConjunctiveTransition<LETTER, STATE>>> mOutgoingTransitions = new HashMap<STATE, List<ConjunctiveTransition<LETTER, STATE>>>();

    public CountingAutomatonDataStructure(AutomataLibraryServices automataLibraryServices, Set<LETTER> set, Set<String> set2) {
        this.mServices = automataLibraryServices;
        this.mAlphabet = set;
        this.mCounters = set2;
        this.mStates = new LinkedHashSet();
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return Collections.unmodifiableSet(this.mAlphabet);
    }

    public Set<STATE> getStates() {
        return Collections.unmodifiableSet(this.mStates);
    }

    public Set<String> getCounters() {
        return Collections.unmodifiableSet(this.mCounters);
    }

    public Map<STATE, Set<ConjunctiveCounterFormula>> getInitialConditions() {
        return Collections.unmodifiableMap(this.mInitialConditions);
    }

    public Map<STATE, Set<ConjunctiveCounterFormula>> getAcceptingConditions() {
        return Collections.unmodifiableMap(this.mAcceptingConditions);
    }

    public boolean addState(STATE STATE, Set<ConjunctiveCounterFormula> set, Set<ConjunctiveCounterFormula> set2) {
        this.mInitialConditions.put(STATE, set);
        this.mAcceptingConditions.put(STATE, set2);
        return this.mStates.add(STATE);
    }

    public void addOutgoingTransition(ConjunctiveTransition<LETTER, STATE> conjunctiveTransition) {
        List<ConjunctiveTransition<LETTER, STATE>> list = this.mOutgoingTransitions.get(conjunctiveTransition.getPredecessor());
        if (list == null) {
            list = new ArrayList<ConjunctiveTransition<LETTER, STATE>>();
            this.mOutgoingTransitions.put(conjunctiveTransition.getPredecessor(), list);
        }
        list.add(conjunctiveTransition);
    }

    public List<ConjunctiveTransition<LETTER, STATE>> getOutgoingTransitions(STATE STATE) {
        List<ConjunctiveTransition<LETTER, STATE>> list = this.mOutgoingTransitions.get(STATE);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return this.mStates.size() + " states.";
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        throw new UnsupportedOperationException("cannot transform to ultimate model");
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "ca", this);
    }
}

