/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ReflectionUtil {
    private static final ExposedSecurityManager EXPOSED_SECURITY_MANAGER = new ExposedSecurityManager();

    private ReflectionUtil() {
    }

    public static Class<?> getCallerClass(int n) {
        return EXPOSED_SECURITY_MANAGER.getCallerClass(n + 1);
    }

    public static String getCallerMethodName(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length < n) {
            return stackTraceElementArray[stackTraceElementArray.length - 1].getMethodName();
        }
        return stackTraceElementArray[n].getMethodName();
    }

    public static String getCallerSignature(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray.length < n ? stackTraceElementArray[stackTraceElementArray.length - 1] : stackTraceElementArray[n];
        return String.format("[L%4s] %s.%s", stackTraceElement.getLineNumber(), ReflectionUtil.getCallerClass(n).getName(), stackTraceElement.getMethodName());
    }

    public static String getCallerSignatureFiltered(Set<Class<?>> set) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = 2;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            Class<?> clazz = ReflectionUtil.getCallerClass(n);
            if (!set.contains(clazz)) {
                return String.format("[L%4s] %s.%s", stackTraceElement.getLineNumber(), stackTraceElement.getClassName(), stackTraceElement.getMethodName());
            }
            ++n;
        }
        return null;
    }

    public static void supplyCallStackStrings(Consumer<String> consumer) {
        StackTraceElement[] stackTraceElementArray;
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
            consumer.accept(String.format("[L%-4s] %30.30s %s", stackTraceElement.getLineNumber(), ReflectionUtil.truncateFromLeft(stackTraceElement.getClassName(), 30), stackTraceElement.getMethodName()));
            ++n2;
        }
    }

    private static String truncateFromLeft(String string, int n) {
        return string.length() > n ? string.substring(string.length() - n) : string;
    }

    public static <T> Set<Class<? extends T>> getClassesImplementingInterfaceFromFolder(Class<T> clazz3) {
        if (clazz3 == null || !clazz3.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(clazz3) + " does not represent a Java interface");
        }
        return ReflectionUtil.getClassesFromFolder(clazz3).stream().filter(clazz -> !ReflectionUtil.isAbstractClass(clazz)).filter(clazz2 -> ReflectionUtil.isClassImplementingInterface(clazz2, clazz3)).collect(Collectors.toSet());
    }

    public static <T> Set<Class<? extends T>> getClassesFromFolder(Class<T> clazz) {
        return ReflectionUtil.getClassesFromFolder(clazz, ReflectionUtil.createBundleResourceConverter());
    }

    public static <T> Set<Class<? extends T>> getClassesFromFolder(Class<T> clazz, UrlConverter urlConverter) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        HashSet<Class<T>> hashSet = new HashSet<Class<T>>();
        String string = clazz.getPackage().getName();
        Collection<File> collection = ReflectionUtil.getFolderContentsFromClass(clazz, urlConverter);
        if (collection == null) {
            return Collections.emptySet();
        }
        List<ClassLoader> list = ReflectionUtil.getClassLoaders(clazz);
        for (File file : collection) {
            Class<?> clazz2;
            if (!file.getName().endsWith(".class") || (clazz2 = ReflectionUtil.getClassFromFile(string, file, list)) == null) continue;
            hashSet.add(clazz2);
        }
        return hashSet;
    }

    public static <T> T instantiateClass(Class<T> clazz, Object ... objectArray) {
        ConstructorAndRemainingParameters<T> constructorAndRemainingParameters = ReflectionUtil.getConstructorsForClass(clazz, objectArray);
        return constructorAndRemainingParameters.instantiate();
    }

    public static <T> Supplier<T> getInstanceSupplier(Class<T> clazz, Object ... objectArray) {
        ConstructorAndRemainingParameters constructorAndRemainingParameters = ReflectionUtil.getConstructorsForClass(clazz, objectArray);
        return () -> constructorAndRemainingParameters.instantiate();
    }

    public static boolean isAbstractClass(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isClassImplementingInterface(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null || !clazz2.isInterface()) {
            throw new IllegalArgumentException("interfaceClazz does not represent an interface");
        }
        Class<?> clazz3 = clazz;
        while (clazz3 != null) {
            Class<?>[] classArray;
            Class<?>[] classArray2 = classArray = clazz3.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz4 = classArray2[n2];
                if (clazz4.equals(clazz2)) {
                    return true;
                }
                ++n2;
            }
            clazz3 = clazz3.getSuperclass();
        }
        return false;
    }

    public static boolean isSubclassOfClass(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            throw new IllegalArgumentException("superClazz is null");
        }
        if (Modifier.isFinal(clazz2.getModifiers())) {
            return false;
        }
        if (clazz == null) {
            return true;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static File getClassFolder(Class<?> clazz, UrlConverter urlConverter) {
        String string = clazz.getPackage().getName();
        ClassLoader classLoader = ReflectionUtil.getClassLoader(clazz);
        URL uRL = classLoader.getResource(string);
        return ReflectionUtil.tryConvertUrlToFile(classLoader, uRL, urlConverter);
    }

    public static List<Field> instanceFields(Class<? extends Object> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        while (clazz.getSuperclass() != null) {
            Arrays.stream(clazz.getDeclaredFields()).filter(ReflectionUtil::isIncluded).forEach(arrayList::add);
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    public static List<Field> instanceFields(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = object.getClass();
        return ReflectionUtil.instanceFields(clazz);
    }

    public static Map<String, Field> instanceName2Fields(Class<? extends Object> clazz) {
        return ReflectionUtil.instanceFields(clazz).stream().collect(Collectors.toMap(Field::getName, field -> field));
    }

    public static Map<String, Field> instanceName2Fields(Object object) {
        if (object == null) {
            return Collections.emptyMap();
        }
        Class<?> clazz = object.getClass();
        return ReflectionUtil.instanceName2Fields(clazz);
    }

    public static String instanceFieldsToString(Object object) {
        if (object == null) {
            return "NULL";
        }
        List<Field> list = ReflectionUtil.instanceFields(object);
        return list.stream().filter(field -> !field.getName().startsWith("$")).filter(field -> !ReflectionUtil.isExcluded(field)).map(field -> ReflectionUtil.fieldToString(object, field)).collect(Collectors.joining(", "));
    }

    private static boolean isExcluded(Field field) {
        Reflected reflected = field.getAnnotation(Reflected.class);
        return reflected != null && reflected.excluded();
    }

    private static boolean isIncluded(Field field) {
        return !ReflectionUtil.isExcluded(field);
    }

    public static String fieldPrettyName(Field field) {
        Reflected reflected = field.getAnnotation(Reflected.class);
        if (reflected != null && !"".equals(reflected.prettyName())) {
            return reflected.prettyName();
        }
        return field.getName();
    }

    public static String fieldToString(Object object, Field field) {
        String string;
        try {
            field.setAccessible(true);
            string = String.valueOf(field.get(object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "IArE";
        }
        catch (IllegalAccessException illegalAccessException) {
            string = "IAcE";
        }
        return String.format("%s=%s", ReflectionUtil.fieldPrettyName(field), string);
    }

    public static Object access(Object object, Field field) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
    }

    public static String printableStackTrace() {
        return Arrays.toString(Thread.currentThread().getStackTrace());
    }

    private static UrlConverter createBundleResourceConverter() {
        try {
            List<ClassLoader> list = ReflectionUtil.getClassLoaders(ReflectionUtil.class);
            for (ClassLoader classLoader : list) {
                Class<?> clazz = ReflectionUtil.getClassFromQualifiedName("de.uni_freiburg.informatik.ultimate.core.util.RcpUtils", classLoader);
                if (clazz == null) continue;
                Method method = clazz.getMethod("getBundleProtocolResolver", new Class[0]);
                return (UrlConverter)method.invoke(null, new Object[0]);
            }
            throw new ReflectionUtilException("Could not extract Class<?> from qualified name de.uni_freiburg.informatik.ultimate.core.util.RcpUtils");
        }
        catch (ReflectionUtilException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    private static <T> ConstructorAndRemainingParameters<T> getConstructorsForClass(Class<T> clazz, Object ... objectArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        try {
            Object[] objectArray2;
            Object object;
            Object object2;
            Object object3;
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray.length == 0) {
                throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because it has no constructors");
            }
            if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                object3 = clazz.getEnclosingClass();
                ConstructorAndRemainingParameters<?> constructorAndRemainingParameters = ReflectionUtil.getConstructorsForClass(object3, objectArray);
                object2 = constructorAndRemainingParameters.instantiate();
                object = constructorAndRemainingParameters.mUnusedParameters;
                if (object == null || ((Object[])object).length == 0) {
                    objectArray2 = new Object[]{object2};
                } else {
                    objectArray2 = new Object[((Object[])object).length + 1];
                    objectArray2[0] = object2;
                    System.arraycopy(object, 0, objectArray2, 1, ((Object)object).length);
                }
            } else {
                objectArray2 = objectArray;
            }
            object3 = Arrays.stream(constructorArray).filter(constructor -> constructor.getParameterCount() <= objectArray2.length).collect(Collectors.toList());
            if (object3.isEmpty()) {
                throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because there is no constructor that takes " + objectArray2.length + " arguments");
            }
            int n = -1;
            object2 = null;
            Object[] objectArray3 = object3.iterator();
            while (objectArray3.hasNext()) {
                object = (Constructor)objectArray3.next();
                Parameter[] parameterArray = ((Executable)object).getParameters();
                int n2 = 0;
                Parameter[] parameterArray2 = parameterArray;
                int n3 = parameterArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> clazz2;
                    Class<?> clazz3;
                    Parameter parameter = parameterArray2[n4];
                    Class<?> clazz4 = parameter.getType();
                    if ((objectArray2[n2] != null || clazz4.isPrimitive()) && !(clazz3 = ReflectionUtil.toWrapperClazz(clazz4)).isAssignableFrom(clazz2 = objectArray2[n2].getClass())) {
                        n2 = -1;
                        break;
                    }
                    ++n2;
                    ++n4;
                }
                if (n2 <= n) continue;
                n = n2;
                object2 = object;
            }
            if (object2 == null) {
                throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because I did not find a valid constructor");
            }
            object = new Object[n];
            objectArray3 = new Object[objectArray2.length - n];
            System.arraycopy(objectArray2, 0, object, 0, n);
            System.arraycopy(objectArray2, n, objectArray3, 0, objectArray2.length - n);
            return new ConstructorAndRemainingParameters<T>(object2, clazz, (Object[])object, objectArray3);
        }
        catch (SecurityException securityException) {
            throw new ReflectionUtilException("Cannot instantiate class " + clazz.toString() + " because I am not allowed to access it", securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError("Cannot instantiate class " + clazz.toString() + " because the parameters do not match", illegalArgumentException);
        }
    }

    private static Collection<File> getFilesFromDirectoryResource(ClassLoader classLoader, URL uRL, UrlConverter urlConverter) {
        File file = ReflectionUtil.tryConvertUrlToFile(classLoader, uRL, urlConverter);
        if (file == null) {
            return Collections.emptyList();
        }
        return CoreUtil.flattenDirectories(Collections.singleton(file));
    }

    private static File tryConvertUrlToFile(ClassLoader classLoader, URL uRL, UrlConverter urlConverter) {
        String string = uRL.getProtocol();
        if ("file".equals(string)) {
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        if (!"bundleresource".equals(string)) {
            throw new UnsupportedOperationException("unknown protocol " + string);
        }
        if (urlConverter == null) {
            throw new AssertionError((Object)"Someone supplied a bundleresource resource but we do not have a converter -- check if this deployable is built correctly (maybe de.uni_freiburg.informatik.ultimate.core is missing?)");
        }
        try {
            URL uRL2 = urlConverter.convert(uRL);
            return new File(uRL2.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Class<?> getClassFromFile(String string, File file, Collection<ClassLoader> collection) {
        String string2 = ReflectionUtil.getQualifiedNameFromFile(string, file);
        if (collection.isEmpty()) {
            return ReflectionUtil.getClassFromQualifiedName(string2);
        }
        for (ClassLoader classLoader : collection) {
            Class<?> clazz = ReflectionUtil.getClassFromQualifiedName(string2, classLoader);
            if (clazz == null) continue;
            return clazz;
        }
        throw new ReflectionUtilException("Could not extract Class<?> from qualified name " + string2);
    }

    private static Class<?> getClassFromQualifiedName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionUtilException("Could not extract Class<?> from qualified name " + string, classNotFoundException);
        }
    }

    private static Class<?> getClassFromQualifiedName(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static String getQualifiedNameFromFile(String string, File file) {
        assert (file != null);
        assert (file.getName().endsWith(".class"));
        String string2 = file.getAbsolutePath();
        String string3 = string2.substring(0, string2.length() - 6);
        String string4 = ReflectionUtil.getPathFromPackageName(string);
        int n = string3.indexOf(string4);
        assert (n != -1);
        return string3.substring(n).replace(File.separatorChar, '.');
    }

    private static String getPathFromPackageName(String string) {
        return string.replace(".", File.separator);
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
            while (classLoader != null && classLoader.getParent() != null) {
                classLoader = classLoader.getParent();
            }
        }
        return classLoader;
    }

    private static List<ClassLoader> getClassLoaders(Class<?> clazz) {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        ClassLoader classLoader = clazz.getClassLoader();
        while (classLoader != null) {
            arrayList.add(classLoader);
            classLoader = classLoader.getParent();
        }
        classLoader = ClassLoader.getSystemClassLoader();
        while (classLoader != null) {
            arrayList.add(classLoader);
            classLoader = classLoader.getParent();
        }
        return arrayList;
    }

    private static Collection<File> getFolderContentsFromClass(Class<?> clazz, UrlConverter urlConverter) {
        Enumeration<URL> enumeration;
        if (clazz == null) {
            return null;
        }
        ClassLoader classLoader = ReflectionUtil.getClassLoader(clazz);
        if (classLoader == null) {
            return Collections.emptyList();
        }
        String string = clazz.getPackage().getName();
        String string2 = ReflectionUtil.getPathFromPackageName(string);
        try {
            enumeration = classLoader.getResources(string2);
        }
        catch (IOException iOException) {
            throw new ReflectionUtilException("Classloader " + classLoader.toString() + " could not load resource " + string2, iOException);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            arrayList.addAll(ReflectionUtil.getFilesFromDirectoryResource(classLoader, uRL, urlConverter));
        }
        return arrayList;
    }

    private static Class<?> toWrapperClazz(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        throw new UnsupportedOperationException("Not yet implemented: wrapper for " + String.valueOf(clazz));
    }

    private static final class ConstructorAndRemainingParameters<T> {
        private final Constructor<T> mConstructor;
        private final Class<T> mClazz;
        private final Object[] mMatchedParameters;
        private final Object[] mUnusedParameters;

        private ConstructorAndRemainingParameters(Constructor<T> constructor, Class<T> clazz, Object[] objectArray, Object[] objectArray2) {
            this.mConstructor = constructor;
            this.mClazz = clazz;
            this.mMatchedParameters = objectArray;
            this.mUnusedParameters = objectArray2;
        }

        public T instantiate() {
            assert (this.mConstructor.getParameterCount() == this.mMatchedParameters.length) : "Wrong length";
            try {
                return this.mConstructor.newInstance(this.mMatchedParameters);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException exception) {
                throw new ReflectionUtilException("Cannot instantiate class " + this.mClazz.toString() + " because I am not allowed to access it", exception);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError("Cannot instantiate class " + this.mClazz.toString() + " because the parameters do not match", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ReflectionUtilException("Cannot instantiate class " + this.mClazz.toString() + " because the constructor threw an exception", invocationTargetException);
            }
        }
    }

    private static final class ExposedSecurityManager
    extends SecurityManager {
        private ExposedSecurityManager() {
        }

        public Class<?> getCallerClass(int n) {
            return this.getClassContext()[n];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Reflected {
        public boolean excluded() default false;

        public String prettyName() default "";
    }

    private static final class ReflectionUtilException
    extends RuntimeException {
        private static final long serialVersionUID = -5821955867584671607L;

        public ReflectionUtilException(String string) {
            super(string);
        }

        public ReflectionUtilException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    @FunctionalInterface
    public static interface UrlConverter {
        public URL convert(URL var1) throws IOException;
    }
}

