/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.LinkedHashMap;

public class FunctionDeclarations {
    private final LinkedHashMap<String, FunctionDeclaration> mDeclaredFunctions = new LinkedHashMap();
    private final ITypeHandler mTypeHandler;
    public static final String BUILTIN_IDENTIFIER = "builtin";
    public static final String SMTDEFINED_IDENTIFIER = "smtdefined";
    public static final String OVERAPPROX_IDENTIFIER = "overapproximation";
    public static final String INDEX_IDENTIFIER = "indices";
    private boolean mIsFinished;

    public FunctionDeclarations(ITypeHandler iTypeHandler) {
        this.mTypeHandler = iTypeHandler;
    }

    public void declareFunction(ILocation iLocation, String string, Attribute[] attributeArray, boolean bl, CPrimitive cPrimitive, CPrimitive ... cPrimitiveArray) {
        if (this.mIsFinished) {
            throw new AssertionError();
        }
        Object object = bl ? new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, "bool") : this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
        ASTType[] aSTTypeArray = new ASTType[cPrimitiveArray.length];
        int n = 0;
        while (n < cPrimitiveArray.length) {
            aSTTypeArray[n] = this.mTypeHandler.cType2AstType(iLocation, cPrimitiveArray[n]);
            ++n;
        }
        this.declareFunction(iLocation, string, attributeArray, (ASTType)object, aSTTypeArray);
    }

    public FunctionDeclaration declareFunction(ILocation iLocation, String string, Attribute[] attributeArray, ASTType aSTType, ASTType ... aSTTypeArray) {
        if (this.mIsFinished) {
            throw new AssertionError();
        }
        if (!string.startsWith("~")) {
            throw new IllegalArgumentException("Our convention says that user defined functions start with tilde");
        }
        VarList[] varListArray = new VarList[aSTTypeArray.length];
        int n = 0;
        while (n < aSTTypeArray.length) {
            varListArray[n] = new VarList(iLocation, new String[]{FunctionDeclarations.constructNameForFunctionInParam(n)}, aSTTypeArray[n]);
            ++n;
        }
        VarList varList = new VarList(iLocation, new String[]{FunctionDeclarations.constructNameForFunctionOutParam()}, aSTType);
        FunctionDeclaration functionDeclaration = new FunctionDeclaration(iLocation, attributeArray, string, new String[0], varListArray, varList);
        this.mDeclaredFunctions.put(string, functionDeclaration);
        return functionDeclaration;
    }

    public static String constructNameForFunctionOutParam() {
        return "out";
    }

    public static String constructNameForFunctionInParam(int n) {
        return "in" + n;
    }

    public LinkedHashMap<String, FunctionDeclaration> getDeclaredFunctions() {
        if (this.mIsFinished) {
            throw new AssertionError((Object)"since the map is modifiable we do not allow this query once this class is finished");
        }
        return this.mDeclaredFunctions;
    }

    public boolean checkParameters(CPrimitive ... cPrimitiveArray) {
        CPrimitive.CPrimitives cPrimitives = cPrimitiveArray[0].getType();
        CPrimitive[] cPrimitiveArray2 = cPrimitiveArray;
        int n = cPrimitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPrimitive cPrimitive = cPrimitiveArray2[n2];
            if (!cPrimitive.getType().equals((Object)cPrimitives)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void finish() {
        this.mIsFinished = true;
    }
}

