/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;

public class BoogieStructType
extends BoogieType {
    private static final long serialVersionUID = -1467920629539012234L;
    private final boolean isFinite;
    private final String[] fNames;
    private final BoogieType[] fTypes;
    private final BoogieType realType;

    BoogieStructType(String[] stringArray, BoogieType[] boogieTypeArray) {
        assert (stringArray.length == boogieTypeArray.length);
        this.fNames = stringArray;
        this.fTypes = boogieTypeArray;
        boolean bl = false;
        boolean bl2 = true;
        BoogieType[] boogieTypeArray2 = new BoogieType[this.getFieldCount()];
        int n = 0;
        while (n < this.getFieldCount()) {
            boogieTypeArray2[n] = boogieTypeArray[n].getUnderlyingType();
            if (boogieTypeArray2[n] != boogieTypeArray[n]) {
                bl = true;
            }
            if (bl2 && boogieTypeArray[n].isFinite()) {
                bl2 = false;
            }
            ++n;
        }
        this.realType = bl ? BoogieStructType.createStructType(stringArray, boogieTypeArray2) : this;
        this.isFinite = bl2;
    }

    @Override
    protected BoogieType substitutePlaceholders(int n, BoogieType[] boogieTypeArray) {
        if (this.getFieldCount() == 0) {
            return this;
        }
        BoogieType[] boogieTypeArray2 = new BoogieType[this.getFieldCount()];
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.getFieldCount()) {
            boogieTypeArray2[n2] = this.fTypes[n2].substitutePlaceholders(n, boogieTypeArray);
            if (boogieTypeArray2[n2] != this.fTypes[n2]) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return this;
        }
        return BoogieStructType.createStructType(this.fNames, boogieTypeArray2);
    }

    @Override
    protected BoogieType incrementPlaceholders(int n, int n2) {
        if (this.getFieldCount() == 0) {
            return this;
        }
        BoogieType[] boogieTypeArray = new BoogieType[this.getFieldCount()];
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.getFieldCount()) {
            boogieTypeArray[n3] = this.fTypes[n3].incrementPlaceholders(n, n2);
            if (boogieTypeArray[n3] != this.fTypes[n3]) {
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            return this;
        }
        return BoogieStructType.createStructType(this.fNames, this.fTypes);
    }

    @Override
    public BoogieType getUnderlyingType() {
        return this.realType;
    }

    @Override
    protected boolean unify(int n, BoogieType boogieType, BoogieType[] boogieTypeArray) {
        if (!(boogieType instanceof BoogieStructType)) {
            return false;
        }
        BoogieStructType boogieStructType = (BoogieStructType)boogieType;
        if (this.isFinite() != boogieStructType.isFinite()) {
            return false;
        }
        String[] stringArray = this.fNames;
        int n2 = this.fNames.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (!this.getFieldType(string).unify(n, boogieStructType.getFieldType(string), boogieTypeArray)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    @Override
    protected boolean hasPlaceholder(int n, int n2) {
        BoogieType[] boogieTypeArray = this.fTypes;
        int n3 = this.fTypes.length;
        int n4 = 0;
        while (n4 < n3) {
            BoogieType boogieType = boogieTypeArray[n4];
            if (boogieType.hasPlaceholder(n, n2)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    @Override
    protected boolean isUnifiableTo(int n, BoogieType boogieType, ArrayList<BoogieType> arrayList) {
        if (this == boogieType || boogieType == TYPE_ERROR) {
            return true;
        }
        if (!(boogieType instanceof BoogieStructType)) {
            return false;
        }
        BoogieStructType boogieStructType = (BoogieStructType)boogieType;
        if (this.isFinite() != boogieStructType.isFinite()) {
            return false;
        }
        String[] stringArray = this.fNames;
        int n2 = this.fNames.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (!this.getFieldType(string).isUnifiableTo(n, boogieStructType.getFieldType(string), arrayList)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public int getFieldCount() {
        return this.fNames.length;
    }

    public BoogieType getFieldType(String string) {
        int n = Arrays.asList(this.fNames).indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("Field '" + string + "' not in struct!");
        }
        return this.fTypes[n];
    }

    public BoogieType getFieldType(int n) {
        return this.fTypes[n];
    }

    public String[] getFieldIds() {
        return (String[])this.fNames.clone();
    }

    public BoogieType[] getFieldTypes() {
        return (BoogieType[])this.fTypes.clone();
    }

    @Override
    protected String toString(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("(");
        }
        stringBuilder.append("{ ");
        String string = "";
        int n2 = 0;
        while (n2 < this.getFieldCount()) {
            stringBuilder.append(string);
            stringBuilder.append(this.fNames[n2]).append(":");
            stringBuilder.append(this.fTypes[n2].toString(n + 1, false));
            string = ", ";
            ++n2;
        }
        stringBuilder.append(" }");
        if (bl) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    protected ASTType toASTType(ILocation iLocation, int n) {
        VarList[] varListArray = new VarList[this.fNames.length];
        int n2 = 0;
        while (n2 < this.fNames.length) {
            varListArray[n2] = new VarList(iLocation, new String[]{this.fNames[n2]}, this.fTypes[n2].toASTType(iLocation, n));
            ++n2;
        }
        return new StructType(iLocation, this, varListArray);
    }

    @Override
    public boolean isFinite() {
        if (this.realType != this) {
            return this.realType.isFinite();
        }
        return this.isFinite;
    }
}

