/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Totalize;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.Collection;
import java.util.HashSet;

public class Complement<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    protected final ITreeAutomatonBU<LETTER, STATE> mResult;
    private final Collection<LETTER> mAlphabet = new HashSet<LETTER>();

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> Complement(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        try {
            this.mTreeAutomaton = new Totalize<LETTER, STATE>(this.mServices, SF, iTreeAutomatonBU).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            automataOperationCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "complementing tree automaton"));
            throw automataOperationCanceledException;
        }
        this.mResult = this.computeResult((IMergeStateFactory<STATE> & ISinkStateFactory<STATE>)SF);
    }

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> Complement(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, Collection<LETTER> collection) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mAlphabet.addAll(collection);
        try {
            this.mTreeAutomaton = new Totalize<LETTER, STATE>(this.mServices, SF, iTreeAutomatonBU, collection).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            automataOperationCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "complementing tree automaton"));
            throw automataOperationCanceledException;
        }
        this.mResult = this.computeResult((IMergeStateFactory<STATE> & ISinkStateFactory<STATE>)SF);
    }

    @Override
    public String startMessage() {
        return "Starting complementing";
    }

    @Override
    public String exitMessage() {
        return "Exiting complementing";
    }

    private <F extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> ITreeAutomatonBU<LETTER, STATE> computeResult(F f) {
        this.mTreeAutomaton.complementFinals();
        return this.mTreeAutomaton;
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

