/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DualJunctionDer
extends DualJunctionQuantifierElimination {
    private static final boolean DO_OLD_DIV_CAPTURE_CHECK = false;
    private final boolean mExpensiveEliminations;

    public DualJunctionDer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        super(managedScript, iUltimateServiceProvider);
        this.mExpensiveEliminations = bl;
    }

    @Override
    public String getName() {
        return "destructive equality resolution";
    }

    @Override
    public String getAcronym() {
        return "DER";
    }

    public boolean areExpensiveEliminationsAllowed() {
        return this.mExpensiveEliminations;
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        IDerHelper[] iDerHelperArray = this.mExpensiveEliminations ? new IDerHelper[]{new DerHelperMcsbr(IntricateOperations.AUXILIARY_VARIABLES)} : new IDerHelper[]{new DerHelperSbr(), new DerHelperMcsbr(IntricateOperations.ADDITIONAL_DUAL_JUNCTS)};
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryExhaustivelyToEliminate(eliminationTask, iDerHelperArray);
        return eliminationResult;
    }

    public DualJunctionQuantifierElimination.EliminationResult tryExhaustivelyToEliminate(EliminationTask eliminationTask, IDerHelper<?> ... iDerHelperArray) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult;
        EliminationTask eliminationTask2 = eliminationTask;
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        while ((eliminationResult = this.tryToEliminateOne(eliminationTask2, iDerHelperArray)) != null) {
            linkedHashSet.addAll(eliminationResult.getNewEliminatees());
            eliminationTask2 = eliminationResult.getEliminationTask();
            if (linkedHashSet.isEmpty() && !QuantifierUtils.isCorrespondingFiniteJunction(eliminationTask2.getQuantifier(), eliminationResult.getEliminationTask().getTerm())) continue;
        }
        if (eliminationTask2 == eliminationTask) {
            return null;
        }
        return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask2, linkedHashSet);
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(EliminationTask eliminationTask, IDerHelper<?> ... iDerHelperArray) {
        IDerHelper<?>[] iDerHelperArray2 = iDerHelperArray;
        int n = iDerHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDerHelper<?> iDerHelper = iDerHelperArray2[n2];
            DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryExhaustivelyToEliminate(iDerHelper, eliminationTask);
            if (eliminationResult != null) {
                return eliminationResult;
            }
            ++n2;
        }
        return null;
    }

    public DualJunctionQuantifierElimination.EliminationResult tryExhaustivelyToEliminate(IDerHelper<?> iDerHelper, EliminationTask eliminationTask) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult;
        EliminationTask eliminationTask2 = eliminationTask;
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        while ((eliminationResult = this.tryToEliminateOne(iDerHelper, eliminationTask2)) != null) {
            linkedHashSet.addAll(eliminationResult.getNewEliminatees());
            eliminationTask2 = eliminationResult.getEliminationTask();
            if (linkedHashSet.isEmpty() && !QuantifierUtils.isCorrespondingFiniteJunction(eliminationTask2.getQuantifier(), eliminationResult.getEliminationTask().getTerm())) continue;
        }
        if (eliminationTask2 == eliminationTask) {
            return null;
        }
        return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask2, linkedHashSet);
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(IDerHelper<?> iDerHelper, EliminationTask eliminationTask) {
        for (TermVariable termVariable : eliminationTask.getEliminatees()) {
            DualJunctionQuantifierElimination.EliminationResult eliminationResult = iDerHelper.tryToEliminateSbr(this.mMgdScript, termVariable, eliminationTask);
            if (eliminationResult == null) continue;
            return eliminationResult;
        }
        return null;
    }

    private static Term doSubstitutions(ManagedScript managedScript, int n, List<Term> list, SolvedBinaryRelation solvedBinaryRelation, List<Term> list2) {
        Term term2;
        Map<Term, Term> map = Collections.singletonMap(solvedBinaryRelation.getLeftHandSide(), solvedBinaryRelation.getRightHandSide());
        for (Term term2 : list) {
            Term term3 = Substitution.apply(managedScript, map, term2);
            assert (UltimateNormalFormUtils.respectsUltimateNormalForm(term3)) : "Term not in UltimateNormalForm";
            list2.add(term3);
        }
        term2 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, list2);
        return term2;
    }

    private static boolean eachCaseHasDerRelationSymbol(MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation, int n) {
        for (Case case_ : multiCaseSolvedBinaryRelation.getCases()) {
            if (case_.getSolvedBinaryRelation() == null || QuantifierUtils.isDerRelationSymbol(n, case_.getSolvedBinaryRelation().getRelationSymbol())) continue;
            return false;
        }
        return true;
    }

    public static SolvedBinaryRelation tryPlr(Script script, int n, TermVariable termVariable, Term term) {
        Term term2;
        if (DualJunctionDer.isSimilarModuloNegation((Term)termVariable, term)) {
            term2 = QuantifierUtils.negateIfUniversal(script, n, script.term("true", new Term[0]));
        } else if (DualJunctionDer.isDistinctModuloNegation((Term)termVariable, term)) {
            term2 = QuantifierUtils.negateIfUniversal(script, n, script.term("false", new Term[0]));
        } else {
            return null;
        }
        RelationSymbol relationSymbol = QuantifierUtils.getDerOperator(n);
        return new SolvedBinaryRelation((Term)termVariable, term2, relationSymbol, new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
    }

    public static boolean isSimilarModuloNegation(Term term, Term term2) {
        if (term2.equals(term)) {
            return true;
        }
        Term term3 = SmtUtils.unzipNot(term2);
        if (term3 != null) {
            return DualJunctionDer.isDistinctModuloNegation(term, term3);
        }
        return false;
    }

    public static boolean isDistinctModuloNegation(Term term, Term term2) {
        Term term3 = SmtUtils.unzipNot(term2);
        if (term3 != null) {
            return DualJunctionDer.isSimilarModuloNegation(term, term3);
        }
        return false;
    }

    private static <E> List<E> toListAllButOne(E[] EArray, int n) {
        assert (n >= 0 && n < EArray.length);
        ArrayList<E> arrayList = new ArrayList<E>(EArray.length - 1);
        int n2 = 0;
        while (n2 < EArray.length) {
            if (n2 != n) {
                arrayList.add(EArray[n2]);
            }
            ++n2;
        }
        return arrayList;
    }

    private static class DerHelperMcsbr
    extends IDerHelper<MultiCaseSolvedBinaryRelation> {
        private final IntricateOperations mIntricateOperations;

        public DerHelperMcsbr(IntricateOperations intricateOperations) {
            this.mIntricateOperations = intricateOperations;
        }

        @Override
        public MultiCaseSolvedBinaryRelation solveForSubject(ManagedScript managedScript, int n, TermVariable termVariable, Term term, Set<TermVariable> set) {
            PolynomialRelation polynomialRelation = PolynomialRelation.of(managedScript.getScript(), term);
            if (polynomialRelation == null) {
                return null;
            }
            boolean bl = this.mIntricateOperations == IntricateOperations.AUXILIARY_VARIABLES || this.mIntricateOperations == IntricateOperations.CASE_DISTINCTION;
            MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation = polynomialRelation.solveForSubject(managedScript, (Term)termVariable, MultiCaseSolvedBinaryRelation.Xnf.fromQuantifier(n), set, bl);
            if (multiCaseSolvedBinaryRelation == null) {
                return null;
            }
            switch (this.mIntricateOperations) {
                case NONE: {
                    throw new AssertionError();
                }
                case ADDITIONAL_DUAL_JUNCTS: {
                    if (multiCaseSolvedBinaryRelation.getCases().size() <= 1 && multiCaseSolvedBinaryRelation.getAuxiliaryVariables().isEmpty()) break;
                    return null;
                }
                case AUXILIARY_VARIABLES: {
                    if (multiCaseSolvedBinaryRelation.getCases().size() <= 1) break;
                    return null;
                }
                case CASE_DISTINCTION: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknon value " + String.valueOf((Object)this.mIntricateOperations)));
                }
            }
            if (DualJunctionDer.eachCaseHasDerRelationSymbol(multiCaseSolvedBinaryRelation, n)) {
                return multiCaseSolvedBinaryRelation;
            }
            return null;
        }

        @Override
        protected DualJunctionQuantifierElimination.EliminationResult applyReplacement(ManagedScript managedScript, EliminationTask eliminationTask, List<Term> list, MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation) {
            Case case_2;
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Case case_2 : multiCaseSolvedBinaryRelation.getCases()) {
                SupportingTerm supportingTerm2;
                ArrayList<Term> arrayList2 = new ArrayList<Term>();
                for (SupportingTerm supportingTerm2 : case_2.getSupportingTerms()) {
                    arrayList2.add(supportingTerm2.getTerm());
                }
                if (case_2.getSolvedBinaryRelation() != null) {
                    supportingTerm2 = DualJunctionDer.doSubstitutions(managedScript, eliminationTask.getQuantifier(), list, case_2.getSolvedBinaryRelation(), arrayList2);
                } else {
                    arrayList2.addAll(list);
                    supportingTerm2 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), arrayList2);
                }
                arrayList.add((Term)supportingTerm2);
            }
            case_2 = QuantifierUtils.applyCorrespondingFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), arrayList);
            return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask.update((Term)case_2), multiCaseSolvedBinaryRelation.getAuxiliaryVariables());
        }
    }

    public static class DerHelperSbr
    extends IDerHelper<SolvedBinaryRelation> {
        @Override
        public SolvedBinaryRelation solveForSubject(ManagedScript managedScript, int n, TermVariable termVariable, Term term, Set<TermVariable> set) {
            ITermProvider iTermProvider;
            Object object;
            if (SmtSortUtils.isBoolSort(termVariable.getSort()) && SmtSortUtils.isBoolSort(term.getSort()) && (object = DualJunctionDer.tryPlr(managedScript.getScript(), n, termVariable, term)) != null) {
                return object;
            }
            object = BinaryEqualityRelation.convert(term);
            if (object != null && QuantifierUtils.isDerRelationSymbol(n, ((BinaryRelation)object).getRelationSymbol()) && (iTermProvider = ((BinaryRelation)object).solveForSubject(managedScript.getScript(), (Term)termVariable)) != null) {
                return iTermProvider;
            }
            iTermProvider = PolynomialRelation.of(managedScript.getScript(), term);
            if (iTermProvider == null) {
                return null;
            }
            SolvedBinaryRelation solvedBinaryRelation = iTermProvider.solveForSubject(managedScript.getScript(), (Term)termVariable);
            if (solvedBinaryRelation == null) {
                return null;
            }
            if (SolveForSubjectUtils.isVariableDivCaptured(solvedBinaryRelation, set)) {
                throw new AssertionError((Object)"cannot divCaputure with simple solveForSubject");
            }
            if (QuantifierUtils.isDerRelationSymbol(n, solvedBinaryRelation.getRelationSymbol())) {
                return solvedBinaryRelation;
            }
            return null;
        }

        @Override
        protected DualJunctionQuantifierElimination.EliminationResult applyReplacement(ManagedScript managedScript, EliminationTask eliminationTask, List<Term> list, SolvedBinaryRelation solvedBinaryRelation) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            Term term = DualJunctionDer.doSubstitutions(managedScript, eliminationTask.getQuantifier(), list, solvedBinaryRelation, arrayList);
            return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask.update(term), Collections.emptySet());
        }
    }

    private static abstract class IDerHelper<SR> {
        private IDerHelper() {
        }

        public Pair<Integer, SR> findBestReplacementSbr(ManagedScript managedScript, int n, TermVariable termVariable, Term[] termArray, Set<TermVariable> set) {
            int n2 = 0;
            while (n2 < termArray.length) {
                SR SR;
                if (Arrays.asList(termArray[n2].getFreeVars()).contains(termVariable) && (SR = this.solveForSubject(managedScript, n, termVariable, termArray[n2], set)) != null) {
                    return new Pair((Object)n2, SR);
                }
                ++n2;
            }
            return null;
        }

        protected abstract SR solveForSubject(ManagedScript var1, int var2, TermVariable var3, Term var4, Set<TermVariable> var5);

        private DualJunctionQuantifierElimination.EliminationResult tryToEliminateSbr(ManagedScript managedScript, TermVariable termVariable, EliminationTask eliminationTask) {
            Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
            HashSet<TermVariable> hashSet = new HashSet<TermVariable>(eliminationTask.getEliminatees());
            hashSet.addAll(eliminationTask.getContext().getBoundByAncestors());
            Pair<Integer, SR> pair = this.findBestReplacementSbr(managedScript, eliminationTask.getQuantifier(), termVariable, termArray, hashSet);
            if (pair == null) {
                return null;
            }
            List<Term> list = DualJunctionDer.toListAllButOne(termArray, (Integer)pair.getFirst());
            return this.applyReplacement(managedScript, eliminationTask, list, pair.getSecond());
        }

        protected abstract DualJunctionQuantifierElimination.EliminationResult applyReplacement(ManagedScript var1, EliminationTask var2, List<Term> var3, SR var4);
    }

    public static enum IntricateOperations {
        NONE,
        ADDITIONAL_DUAL_JUNCTS,
        AUXILIARY_VARIABLES,
        CASE_DISTINCTION;

    }
}

