/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SetConstraintConjunction<ELEM extends ICongruenceClosureElement<ELEM>> {
    private ELEM mConstrainedElement;
    final CCLiteralSetConstraints<ELEM> mSurroundingCCSetConstraints;
    private final SetConstraintManager<ELEM> mSetConstraintManager;
    private Set<SetConstraint<ELEM>> mSetConstraints;
    private final SetConstraint<ELEM> mScWithOnlyLiterals;
    private boolean mIsInconsistent;

    public SetConstraintConjunction(boolean bl) {
        assert (bl) : "use other constructor in this case!!";
        this.mConstrainedElement = null;
        this.mIsInconsistent = true;
        this.mSetConstraints = null;
        this.mSurroundingCCSetConstraints = null;
        this.mScWithOnlyLiterals = null;
        this.mSetConstraintManager = null;
        assert (this.sanityCheck());
    }

    public SetConstraintConjunction(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, ELEM ELEM, Collection<SetConstraint<ELEM>> collection) {
        this.mConstrainedElement = ELEM;
        this.mSurroundingCCSetConstraints = cCLiteralSetConstraints;
        this.mSetConstraintManager = cCLiteralSetConstraints.getCongruenceClosure().getManager().getSetConstraintManager();
        ArrayList<SetConstraint<ELEM>> arrayList = new ArrayList<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : collection) {
            if (!setConstraint.hasOnlyLiterals()) continue;
            arrayList.add(setConstraint);
        }
        assert (arrayList.size() < 2);
        this.mScWithOnlyLiterals = arrayList.size() == 1 ? (SetConstraint)arrayList.iterator().next() : null;
        this.mSetConstraints = Collections.unmodifiableSet(new HashSet<SetConstraint<ELEM>>(collection));
        assert (this.sanityCheck());
    }

    public SetConstraintConjunction(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, SetConstraintConjunction<ELEM> setConstraintConjunction) {
        this.mSurroundingCCSetConstraints = cCLiteralSetConstraints;
        this.mConstrainedElement = setConstraintConjunction.mConstrainedElement;
        this.mSetConstraintManager = setConstraintConjunction.mSetConstraintManager;
        this.mSetConstraints = Collections.unmodifiableSet(new HashSet<SetConstraint<ELEM>>(setConstraintConjunction.getSetConstraints()));
        this.mScWithOnlyLiterals = setConstraintConjunction.mScWithOnlyLiterals;
        assert (this.sanityCheck());
    }

    public void projectAway(ELEM ELEM) {
        assert (!ELEM.equals(this.mConstrainedElement));
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : this.mSetConstraints) {
            if (setConstraint.containsElement(ELEM)) continue;
            hashSet.add(setConstraint);
        }
        this.mSetConstraints = hashSet;
    }

    private Set<ELEM> getSingletonValues() {
        return this.mSetConstraintManager.getSingletonValues(this.mSetConstraints);
    }

    public boolean isTautological() {
        if (this.mIsInconsistent) {
            return false;
        }
        return this.mSetConstraints.isEmpty();
    }

    public boolean isInconsistent() {
        assert (!this.mIsInconsistent || this.mSetConstraints == null);
        if (this.mIsInconsistent) {
            return true;
        }
        for (SetConstraint<ELEM> setConstraint : this.mSetConstraints) {
            if (!setConstraint.isInconsistent()) continue;
            return true;
        }
        return false;
    }

    public CongruenceClosure<ELEM> getCongruenceClosure() {
        return this.mSurroundingCCSetConstraints.getCongruenceClosure();
    }

    public ELEM getConstrainedElement() {
        assert (this.mConstrainedElement != null);
        return this.mConstrainedElement;
    }

    CcManager<ELEM> getCcManager() {
        return this.mSurroundingCCSetConstraints.getCongruenceClosure().getManager();
    }

    public Set<ELEM> getAllRhsElements() {
        HashSet<ELEM> hashSet = new HashSet<ELEM>();
        for (SetConstraint<ELEM> setConstraint : this.mSetConstraints) {
            hashSet.addAll(setConstraint.getElementSet());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<Set<ELEM>> getElementSets() {
        HashSet<Set<ELEM>> hashSet = new HashSet<Set<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : this.mSetConstraints) {
            hashSet.add(setConstraint.getElementSet());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String toString() {
        if (this.mIsInconsistent) {
            return "SetCc: False";
        }
        return "SetConstraintConjunction [ConstrainedElement=" + String.valueOf(this.mConstrainedElement) + ", mSetConstraints=" + String.valueOf(this.mSetConstraints) + "]";
    }

    public boolean hasOnlyLiterals() {
        return this.mScWithOnlyLiterals != null;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean hasOnlyLiterals(Collection<SetConstraint<ELEM>> collection) {
        for (SetConstraint<ELEM> setConstraint : collection) {
            if (!setConstraint.hasOnlyLiterals()) continue;
            return true;
        }
        return false;
    }

    public Set<ELEM> getLiterals() {
        assert (this.mScWithOnlyLiterals.getNonLiterals().isEmpty());
        return this.mScWithOnlyLiterals.getLiterals();
    }

    public void expandVariableToLiterals(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, ELEM ELEM, Set<ELEM> set) {
        assert (!ELEM.isLiteral());
        assert (this.getCongruenceClosure().isRepresentative(ELEM));
        boolean bl = false;
        for (SetConstraint<ELEM> setConstraint : this.mSetConstraints) {
            bl |= setConstraint.expandVariableToLiterals(ELEM, set);
        }
        if (bl) {
            this.mSetConstraints = this.mSurroundingCCSetConstraints.getCongruenceClosure().getManager().normalizeSetConstraintConjunction(cCLiteralSetConstraints, this.mSetConstraints);
        }
    }

    public void resetConstrainedElement(ELEM ELEM) {
        this.mConstrainedElement = ELEM;
    }

    public Set<SetConstraint<ELEM>> getSetConstraints() {
        return Collections.unmodifiableSet(this.mSetConstraints);
    }

    public boolean sanityCheck() {
        if (this.mIsInconsistent) {
            if (this.mSurroundingCCSetConstraints == null) {
                return true;
            }
            if (!this.mSetConstraints.stream().anyMatch(setConstraint -> setConstraint.isInconsistent())) {
                assert (false);
                return false;
            }
        }
        if (!this.getSingletonValues().isEmpty()) {
            assert (false);
            return false;
        }
        for (SetConstraint<ELEM> setConstraint2 : this.mSetConstraints) {
            if (setConstraint2.sanityCheck()) continue;
            assert (false);
            return false;
        }
        if (this.mSurroundingCCSetConstraints.getCongruenceClosure() != null) {
            for (SetConstraint<ELEM> setConstraint2 : this.mSetConstraints) {
                for (ICongruenceClosureElement object : setConstraint2.getElementSet()) {
                    if (this.mSurroundingCCSetConstraints.getCongruenceClosure().isRepresentative(object)) continue;
                    assert (false);
                    return false;
                }
            }
        }
        for (SetConstraint<ELEM> setConstraint2 : this.mSetConstraints) {
            for (SetConstraint setConstraint3 : this.mSetConstraints) {
                if (setConstraint2 == setConstraint3 || !this.mSetConstraintManager.isStrongerThan(setConstraint2, setConstraint3)) continue;
                assert (false);
                return false;
            }
        }
        for (SetConstraint<ELEM> setConstraint2 : this.mSetConstraints) {
            if (!setConstraint2.containsElement(this.mConstrainedElement)) continue;
            assert (false) : "we have a constraint of the form x in {x, ...}, which is tautological, but SetConstraintConjunction should be normalized";
            return false;
        }
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean sanityCheck(Set<SetConstraint<ELEM>> set) {
        if (set == null) {
            return true;
        }
        if (set.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }
}

