/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.StringRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.Tree;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.TreeSymbolAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TreeAST
extends AtsASTNode {
    private static final long serialVersionUID = -401784715104105435L;
    private final TreeSymbolAST mSymbol;
    private final List<TreeAST> mArguments;

    public TreeAST(ILocation iLocation, TreeSymbolAST treeSymbolAST) {
        super(iLocation);
        this.mSymbol = treeSymbolAST;
        this.mArguments = Collections.emptyList();
        this.setType(Tree.class);
    }

    public TreeAST(ILocation iLocation, TreeSymbolAST treeSymbolAST, List<TreeAST> list) {
        super(iLocation);
        this.mSymbol = treeSymbolAST;
        this.mArguments = list;
        this.setType(Tree.class);
    }

    public TreeSymbolAST getSymbol() {
        return this.mSymbol;
    }

    public List<TreeAST> getArguments() {
        return this.mArguments;
    }

    public Tree<StringRankedLetter> getTree() {
        List list = this.mArguments.stream().map(treeAST -> treeAST.getTree()).collect(Collectors.toList());
        return new Tree((IRankedLetter)new StringRankedLetter(this.mSymbol.toString(), list.size()), list);
    }

    @Override
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mSymbol.toString());
        if (!this.mArguments.isEmpty()) {
            stringBuilder.append("(");
        }
        String string = "";
        for (TreeAST treeAST : this.mArguments) {
            stringBuilder.append(string);
            stringBuilder.append(treeAST.getAsString());
            string = ", ";
        }
        if (!this.mArguments.isEmpty()) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

